/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.struc;

import chemaxon.marvin.modelling.debug.VerbosePrinter;
import chemaxon.marvin.modelling.mm.ForceField;

public class WishGroup {
    private int[][] ctab = null;
    private int[][] btab = null;
    private double[] desLen = null;
    private int[][] bat = null;
    private int[][] desAnglA = null;
    private double[] desAnglV = null;

    public WishGroup(int[][] bat, int[][] ctab, int[][] btab, int[][] cssr, ForceField ff, VerbosePrinter vp) {
        if (vp != null) {
            vp.print("Construct WishGroup");
        }
        this.bat = bat;
        this.ctab = ctab;
        this.btab = btab;
        this.assignMMLengths(ff, bat, vp);
    }

    private void assignMMLengths(ForceField ff, int[][] bat, VerbosePrinter vp) {
        if (vp != null) {
            vp.print("Assign bond lengths");
        }
        int b = bat[0].length;
        this.desLen = new double[b];
        for (int i = 0; i < b; ++i) {
            double dlen;
            int a1 = bat[0][i];
            int a2 = bat[1][i];
            this.desLen[i] = dlen = ff.getEqulibriumBondLength(a1, a2);
            if (vp == null) continue;
            vp.print("Bond #" + i + " (" + a1 + "-" + a2 + "): " + dlen);
        }
    }

    public double[] getBlen() {
        return this.desLen;
    }
}

