/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.util;

import java.util.BitSet;

public class IntSet {
    int size = -1;
    BitSet bitset = null;
    int weight = 0;
    int[] items = null;

    void create(int size) {
        this.bitset = new BitSet(size);
        this.size = size;
        this.items = new int[size];
        this.weight = 0;
    }

    public IntSet(int size) {
        this.create(size);
    }

    public IntSet(int[] a) {
        this(a.length, a);
    }

    public IntSet(int size, int[] a) {
        this.create(size);
        for (int i = 0; i < a.length; ++i) {
            this.add(a[i]);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntSet)) {
            return false;
        }
        IntSet is = (IntSet)o;
        if (this.getWeight() != is.getWeight()) {
            return false;
        }
        for (int i = 0; i < this.getWeight(); ++i) {
            if (is.contains(this.get(i))) continue;
            return false;
        }
        return true;
    }

    public void removeAll() {
        this.create(this.size);
    }

    void ensure(int n) {
        if (this.weight + n < this.size) {
            return;
        }
        int newsize = this.weight + 1;
        int[] newitems = new int[newsize];
        System.arraycopy(this.items, 0, newitems, 0, this.weight);
        this.size = newsize;
        this.items = newitems;
    }

    public int add(int item) {
        if (!this.bitset.get(item)) {
            this.ensure(1);
            this.bitset.set(item);
            this.items[this.weight++] = item;
        }
        return this.weight;
    }

    public int add(int[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.add(items[i]);
        }
        return this.weight;
    }

    public boolean contains(int item) {
        return this.bitset.get(item);
    }

    public boolean contains(int[] items) {
        for (int i = 0; i < items.length; ++i) {
            if (this.contains(items[i])) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(int[] items) {
        for (int i = 0; i < items.length; ++i) {
            if (!this.contains(items[i])) continue;
            return true;
        }
        return false;
    }

    public int get(int index) {
        if (index >= this.weight || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.items[index];
    }

    public int clear(int item) {
        if (this.bitset.get(item)) {
            for (int i = 0; i < this.weight; ++i) {
                if (this.items[i] != item) continue;
                this.items[i] = this.items[this.weight - 1];
            }
            --this.weight;
            this.bitset.clear(item);
        }
        return this.weight;
    }

    public int removeLast() {
        --this.weight;
        this.bitset.clear(this.items[this.weight]);
        return this.items[this.weight];
    }

    public int getWeight() {
        return this.weight;
    }

    public int[] get() {
        int[] ret = new int[this.weight];
        System.arraycopy(this.items, 0, ret, 0, this.weight);
        return ret;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("{");
        for (int i = 0; i < this.getWeight(); ++i) {
            if (i > 0) {
                b.append(", ");
            } else {
                b.append(' ');
            }
            b.append(this.get(i));
        }
        b.append(" }");
        return b.toString();
    }
}

