/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.util;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.modelling.util.MoleculeEncapsulator;
import chemaxon.marvin.modelling.util.StringConversionUtility;
import chemaxon.struc.Molecule;
import java.util.StringTokenizer;

public class MoleculeWithExtraProperties
extends Molecule
implements MoleculeEncapsulator {
    public static final String ENCAPSULATOR = "MoleculeEncapsulator";
    private final String encapsulatorName = this.getClass().getName();

    public MoleculeWithExtraProperties(Molecule m) {
        Molecule mol = m.cloneMolecule();
        try {
            MolImporter.importMol(mol.toFormat("mrv"), (Molecule)this);
        }
        catch (MolFormatException e) {
            e.printStackTrace();
        }
    }

    public MoleculeWithExtraProperties(String s) {
        StringTokenizer st = new StringTokenizer(s, "\n");
        String data = StringConversionUtility.getStringBlock(st);
        try {
            MolImporter.importMol(data, (Molecule)this);
        }
        catch (MolFormatException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        String output = "{\n";
        output = output + this.toFormat("mrv");
        output = output + "\n}";
        return output;
    }

    @Override
    public Molecule getMoleculeWithExtraProperties() {
        Molecule mol = this.cloneMolecule();
        return mol;
    }

    public Molecule getMolecule() {
        Molecule mol = this.cloneMolecule();
        return mol;
    }

    @Override
    public void setProperty(String key, Object o) {
    }
}

