/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.util;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.U;
import java.util.BitSet;

public class NodeGroups {
    int[] nodeToGroup;
    int groupCount = 0;
    int[][] groupToNodes;

    public NodeGroups(int[] labels) {
        int i;
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("new NodeGroups()", U.sel(labels));
        }
        this.nodeToGroup = new int[labels.length];
        int[] tmp = new int[this.nodeToGroup.length];
        boolean found = true;
        this.groupCount = 0;
        while (found) {
            found = false;
            int lab = 0;
            for (int i2 = 0; i2 < labels.length; ++i2) {
                if (U.contains(tmp, this.groupCount, labels[i2])) continue;
                if (found) {
                    if (lab <= labels[i2]) continue;
                    lab = labels[i2];
                    continue;
                }
                lab = labels[i2];
                found = true;
            }
            if (!found) continue;
            tmp[this.groupCount++] = lab;
        }
        for (i = 0; i < labels.length; ++i) {
            found = false;
            for (int j = 0; j < this.groupCount; ++j) {
                if (tmp[j] != labels[i]) continue;
                found = true;
                this.nodeToGroup[i] = j;
                break;
            }
            if (found) continue;
            throw new UnsupportedOperationException("Internal error in NodeGroups.");
        }
        for (i = 0; i < this.groupCount; ++i) {
            tmp[i] = 0;
        }
        for (i = 0; i < this.nodeToGroup.length; ++i) {
            int n = this.nodeToGroup[i];
            tmp[n] = tmp[n] + 1;
        }
        this.groupToNodes = new int[this.groupCount][];
        for (i = 0; i < this.groupCount; ++i) {
            this.groupToNodes[i] = new int[tmp[i]];
            tmp[i] = 0;
        }
        i = 0;
        while (i < this.nodeToGroup.length) {
            int g;
            int n = g = this.nodeToGroup[i];
            int n2 = tmp[n];
            tmp[n] = n2 + 1;
            this.groupToNodes[g][n2] = i++;
        }
    }

    public void placeApplet(myMolecule m) {
        this.placeApplet(m, "EQgroups");
    }

    public void placeApplet(myMolecule m, String btnlabel) {
        debugPrintout debug = CleanArgs.getDebug();
        if (debug == null) {
            return;
        }
        if (m.a != this.nodeToGroup.length) {
            debug.println("ERROR! node count mismatch");
            return;
        }
        String[] desc = new String[this.groupToNodes.length];
        for (int i = 0; i < desc.length; ++i) {
            desc[i] = "group[ " + i + " ]";
        }
        m.placeApplets(btnlabel, U.sel(this.groupToNodes), desc);
    }

    public boolean closedToLists(int[][] lists) {
        for (int i = 0; i < lists.length; ++i) {
            if (this.closedToList(lists[i])) continue;
            return false;
        }
        return true;
    }

    public boolean closedToList(int[] list) {
        int i;
        BitSet b = new BitSet(this.nodeToGroup.length);
        for (i = 0; i < list.length; ++i) {
            b.set(list[i]);
        }
        for (i = 0; i < list.length; ++i) {
            if (!b.get(list[i])) continue;
            int igroup = this.nodeToGroup[list[i]];
            for (int j = 0; j < this.groupToNodes[igroup].length; ++j) {
                int n = this.groupToNodes[igroup][j];
                if (!b.get(n)) {
                    return false;
                }
                b.clear(n);
            }
        }
        return true;
    }

    public boolean closedToList(int group, int[] list) {
        BitSet b = new BitSet(this.nodeToGroup.length);
        for (int i = 0; i < list.length; ++i) {
            b.set(list[i]);
        }
        for (int j = 0; j < this.groupToNodes[group].length; ++j) {
            int n = this.groupToNodes[group][j];
            if (b.get(n)) continue;
            return false;
        }
        return true;
    }

    public int getGroupCount() {
        return this.groupToNodes.length;
    }

    public int[] getGroup(int group) {
        return this.groupToNodes[group];
    }

    public int getGroupForAtom(int atom) {
        return this.nodeToGroup[atom];
    }
}

