/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.util;

import chemaxon.marvin.modelling.TextUtils;
import java.util.BitSet;
import java.util.Vector;

public class U {
    public static final int COMPARE_DIFFERENT = 1;
    public static final int COMPARE_HASCOMMON = 2;
    public static final int COMPARE_EQUALS = 3;
    public static final int COMPARE_A1_HOLDS_A2 = 4;

    public static String calcClassShortName(Object o) {
        String n = o.getClass().getName();
        int i = Math.max(n.lastIndexOf(36), n.lastIndexOf(46));
        if (i >= 0) {
            n = n.substring(i + 1);
        }
        return n;
    }

    public static void fill(int[] a, int n) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = n;
        }
    }

    public static void change(int[] a, int from, int to) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != from) continue;
            a[i] = to;
        }
    }

    public static void copyTo(int[] to, int[] from) {
        if (to == null && from == null) {
            return;
        }
        if (to.length != from.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < from.length; ++i) {
            to[i] = from[i];
        }
    }

    public static void copyTo(double[] to, double[] from) {
        if (to == null && from == null) {
            return;
        }
        if (to.length != from.length) {
            throw new IndexOutOfBoundsException("Incorrect dimension");
        }
        for (int i = 0; i < from.length; ++i) {
            to[i] = from[i];
        }
    }

    public static void copyTo(double[][] from, double[][] to) {
        U.copyTo(from, to, null);
    }

    public static void copyTo(double[][] from, double[][] to, int[] perm) {
        if (to == null && from == null && perm == null) {
            return;
        }
        if (to.length != from.length) {
            throw new IndexOutOfBoundsException("Incorrect parameter length");
        }
        int n = perm == null ? from.length : perm.length;
        for (int i = 0; i < n; ++i) {
            int fi = perm == null ? i : perm[i];
            U.copyTo(to[i], from[fi]);
        }
    }

    public static void copyToFirstItems(double[][] from, double[][] to) {
        int n = Math.min(from.length, to.length);
        for (int i = 0; i < n; ++i) {
            if (from[i].length != to[i].length) {
                throw new IndexOutOfBoundsException("Incorrect parameter length");
            }
            U.copyTo(to[i], from[i]);
        }
    }

    public static int cardinality(BitSet b) {
        if (b == null) {
            return 0;
        }
        int ret = 0;
        for (int i = 0; i < b.size(); ++i) {
            if (!b.get(i)) continue;
            ++ret;
        }
        return ret;
    }

    public static <E> E removeAllButFirst(Vector<E> v) {
        if (v == null || v.size() == 0) {
            return null;
        }
        E first = v.firstElement();
        v.clear();
        v.add(first);
        return first;
    }

    public static int[] getSetBits(BitSet b) {
        int[] ret = new int[U.cardinality(b)];
        int p = 0;
        for (int i = 0; i < b.length(); ++i) {
            if (!b.get(i)) continue;
            ret[p++] = i;
        }
        return ret;
    }

    public static int firstClearBit(BitSet b, int fromIndex) {
        int ret = fromIndex;
        while (b.get(ret)) {
            ++ret;
        }
        return ret;
    }

    public static int firstClearBit(BitSet b) {
        return U.firstClearBit(b, 0);
    }

    public static void replaceAll(int[] array, int from, int to) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != from) continue;
            array[i] = to;
        }
    }

    public static int[] and(int[] a, int[] b) {
        if (a == null || b == null) {
            return null;
        }
        BitSet ba = U.genBitSet(a);
        BitSet bb = U.genBitSet(b);
        ba.and(bb);
        return U.collectSets(ba);
    }

    public static int[] or(int[] a, int[] b) {
        if (a == null || b == null) {
            return null;
        }
        BitSet ba = U.genBitSet(a);
        BitSet bb = U.genBitSet(b);
        ba.or(bb);
        return U.collectSets(ba);
    }

    public static BitSet genBitSet(int[] a) {
        if (a == null) {
            return null;
        }
        BitSet ret = new BitSet(a.length);
        for (int i = 0; i < a.length; ++i) {
            ret.set(a[i]);
        }
        return ret;
    }

    public static boolean isAllSet(BitSet b, int[] a) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (b.get(a[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnySet(BitSet b, int[] a) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!b.get(a[i])) continue;
            return true;
        }
        return false;
    }

    public static void set(BitSet b, int[] a) {
        if (a == null) {
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            b.set(a[i]);
        }
    }

    public static int[] collectSets(BitSet b) {
        if (b == null) {
            return null;
        }
        int[] ret = new int[U.cardinality(b)];
        int p = 0;
        for (int i = 0; i < b.size(); ++i) {
            if (!b.get(i)) continue;
            ret[p++] = i;
        }
        return ret;
    }

    public static int[] clone(int[] p) {
        if (p == null) {
            return null;
        }
        return (int[])p.clone();
    }

    public static int[][] clone(int[][] p) {
        if (p == null) {
            return null;
        }
        int[][] ret = new int[p.length][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = U.clone(p[i]);
        }
        return ret;
    }

    public static double[][] splitTo3D(double[] v) {
        if (v.length % 3 != 0) {
            throw new UnsupportedOperationException();
        }
        double[][] ret = new double[v.length / 3][3];
        int k = 0;
        for (int i = 0; i < ret.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                ret[i][j] = v[k++];
            }
        }
        return ret;
    }

    public static double[] clone(double[] p) {
        if (p == null) {
            return null;
        }
        return (double[])p.clone();
    }

    public static double[][] clone(double[][] p) {
        if (p == null) {
            return null;
        }
        double[][] ret = new double[p.length][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = U.clone(p[i]);
        }
        return ret;
    }

    public static double[][][] clone(double[][][] p) {
        if (p == null) {
            return null;
        }
        double[][][] ret = new double[p.length][][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = U.clone(p[i]);
        }
        return ret;
    }

    public static boolean equals(int[] a, int[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isDoubleOK(double d) {
        return !Double.isInfinite(d) && !Double.isNaN(d);
    }

    public static boolean isDoubleOK(double[] d) {
        for (int i = 0; i < d.length; ++i) {
            if (U.isDoubleOK(d[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isDoubleOK(double[][] d) {
        for (int i = 0; i < d.length; ++i) {
            for (int j = 0; j < d[i].length; ++j) {
                if (U.isDoubleOK(d[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(int[][] a, int[][] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (U.equals(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(int[] arr, int arrLen, int a) {
        if (arr == null) {
            return false;
        }
        for (int i = 0; i < arrLen; ++i) {
            if (arr[i] != a) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] arr, int a) {
        if (arr == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != a) continue;
            return true;
        }
        return false;
    }

    public static int compare(int[] a1, int[] a2) {
        boolean commonFound = false;
        boolean allMatch = true;
        for (int i = 0; i < a2.length; ++i) {
            boolean c = U.contains(a1, a2[i]);
            if (c) {
                commonFound = true;
            } else {
                allMatch = false;
            }
            if (!allMatch && commonFound) break;
        }
        if (!commonFound) {
            return 1;
        }
        if (allMatch) {
            if (a1.length == a2.length) {
                return 3;
            }
            return 4;
        }
        return 2;
    }

    public static String sel(BitSet b) {
        return U.sel(U.collectSets(b));
    }

    public static int indexOf(int[] a, int n) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasCommon(int[] a) {
        if (a == null || a.length < 2) {
            return false;
        }
        for (int i = 1; i < a.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (a[i] != a[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasCommon(BitSet b, int[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (!b.get(a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllFromA(BitSet b, int[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (b.get(a[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasCommon(int[] a1, int[] a2) {
        if (a1 == null || a2 == null) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            for (int j = 0; j < a2.length; ++j) {
                if (a1[i] != a2[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static int[] append(int[] arr, int a) {
        if (arr == null) {
            return new int[]{a};
        }
        int[] ret = new int[arr.length + 1];
        for (int i = 0; i < arr.length; ++i) {
            ret[i] = arr[i];
        }
        ret[arr.length] = a;
        return ret;
    }

    public static int[] append(int[] a, int[] b, int[] c) {
        int i;
        if (a == null && b == null && c == null) {
            return null;
        }
        int l = 0;
        if (a != null) {
            l += a.length;
        }
        if (b != null) {
            l += b.length;
        }
        if (c != null) {
            l += c.length;
        }
        int[] ret = new int[l];
        l = 0;
        if (a != null) {
            for (i = 0; i < a.length; ++i) {
                ret[l++] = a[i];
            }
        }
        if (b != null) {
            for (i = 0; i < b.length; ++i) {
                ret[l++] = b[i];
            }
        }
        if (c != null) {
            for (i = 0; i < c.length; ++i) {
                ret[l++] = c[i];
            }
        }
        return ret;
    }

    public static int[] appendUnique(int[] a, int[] b) {
        int i;
        if (a == null) {
            return (int[])a.clone();
        }
        if (b == null) {
            return (int[])b.clone();
        }
        int n = a.length;
        for (int i2 = 0; i2 < b.length; ++i2) {
            if (U.contains(a, b[i2])) continue;
            ++n;
        }
        int[] ret = new int[n];
        n = 0;
        for (i = 0; i < a.length; ++i) {
            ret[n++] = a[i];
        }
        for (i = 0; i < b.length; ++i) {
            if (U.contains(a, b[i])) continue;
            ret[n++] = b[i];
        }
        return ret;
    }

    public static int[] removeByValue(int[] from, int value) {
        if (!U.contains(from, value)) {
            return from;
        }
        int n = 0;
        for (int i = 0; i < from.length; ++i) {
            if (from[i] == value) continue;
            ++n;
        }
        int[] ret = new int[n];
        n = 0;
        for (int i = 0; i < from.length; ++i) {
            if (from[i] == value) continue;
            ret[n++] = from[i];
        }
        return ret;
    }

    public static int[] remove(int[] from, int[] removeds) {
        int i;
        if (from == null) {
            return null;
        }
        if (removeds == null) {
            return (int[])from.clone();
        }
        BitSet b = new BitSet();
        for (i = 0; i < from.length; ++i) {
            b.set(from[i]);
        }
        for (i = 0; i < removeds.length; ++i) {
            b.clear(removeds[i]);
        }
        return U.collectSets(b);
    }

    public static int[] appendUnique(int[] a, int b) {
        if (!U.contains(a, b)) {
            return U.append(a, b);
        }
        return (int[])a.clone();
    }

    public static int[] append(int[] a, int[] b) {
        int i;
        int n = (a == null ? 0 : a.length) + (b == null ? 0 : b.length);
        int[] ret = new int[n];
        n = 0;
        if (a != null) {
            for (i = 0; i < a.length; ++i) {
                ret[n++] = a[i];
            }
        }
        if (b != null) {
            for (i = 0; i < b.length; ++i) {
                ret[n++] = b[i];
            }
        }
        return ret;
    }

    public static String selEqual(int[] from, int value) {
        String ret = "";
        int values = 0;
        for (int i = 0; i < from.length; ++i) {
            if (from[i] != value) continue;
            if (values > 0) {
                ret = ret + ",";
            }
            ret = ret + i;
            ++values;
        }
        return ret;
    }

    public static int[] getEqual(int[] from, int value) {
        int ct = 0;
        for (int i = 0; i < from.length; ++i) {
            if (from[i] != value) continue;
            ++ct;
        }
        int[] ret = new int[ct];
        ct = 0;
        for (int i = 0; i < from.length; ++i) {
            if (from[i] != value) continue;
            ret[ct++] = i;
        }
        return ret;
    }

    public static BitSet createSets(int[] a, int initialCap) {
        BitSet ret = new BitSet(initialCap);
        if (a != null) {
            for (int i = 0; i < a.length; ++i) {
                ret.set(a[i]);
            }
        }
        return ret;
    }

    public static String selNonEqual(int[] from, int value) {
        String ret = "";
        int values = 0;
        for (int i = 0; i < from.length; ++i) {
            if (from[i] == value) continue;
            if (values > 0) {
                ret = ret + ",";
            }
            ret = ret + i;
            ++values;
        }
        return ret;
    }

    public static String sel(String[] s) {
        if (s == null || s.length == 0) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            if (i != 0) {
                b.append(",");
            }
            b.append(s[i]);
        }
        return b.toString();
    }

    public static String sel(int[] from) {
        if (from == null || from.length == 0) {
            return null;
        }
        String ret = "";
        int values = 0;
        if (from != null) {
            for (int i = 0; i < from.length; ++i) {
                if (values > 0) {
                    ret = ret + ",";
                }
                ret = ret + from[i];
                ++values;
            }
        }
        return ret;
    }

    public static String sel(int[] from, int w) {
        if (from == null || from.length == 0) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < from.length; ++i) {
            if (i > 0) {
                ret.append(',');
            }
            String fi = "" + from[i];
            for (int j = fi.length(); j < w; ++j) {
                ret.append(' ');
            }
            ret.append(fi);
        }
        return ret.toString();
    }

    public static String sel(double[] from) {
        if (from == null || from.length == 0) {
            return null;
        }
        String ret = "";
        int values = 0;
        if (from != null) {
            for (int i = 0; i < from.length; ++i) {
                if (values > 0) {
                    ret = ret + ",";
                }
                ret = ret + TextUtils.formatNumber(from[i]);
                ++values;
            }
        }
        return ret;
    }

    public static String[] sel(int[][] from) {
        if (from == null || from.length == 0) {
            return null;
        }
        String[] ret = new String[from.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = U.sel(from[i]);
        }
        return ret;
    }

    public static String toString(int[][] a) {
        if (a == null || a.length == 0) {
            return null;
        }
        String ret = "";
        for (int i = 0; i < a.length; ++i) {
            if (i != 0) {
                ret = ret + " ";
            }
            ret = ret + i + ":{";
            ret = ret + U.sel(a[i]);
            ret = ret + "}";
        }
        return ret;
    }

    public static String toString(double[][] a) {
        if (a == null || a.length == 0) {
            return null;
        }
        String ret = "";
        for (int i = 0; i < a.length; ++i) {
            if (i != 0) {
                ret = ret + " ";
            }
            ret = ret + i + ":{";
            ret = ret + U.sel(a[i]);
            ret = ret + "}";
        }
        return ret;
    }

    public static String selLessOrEqual(int[] from, int value) {
        String ret = "";
        int values = 0;
        for (int i = 0; i < from.length; ++i) {
            if (from[i] > value) continue;
            if (values > 0) {
                ret = ret + ",";
            }
            ret = ret + i;
            ++values;
        }
        return ret;
    }

    public static String selTrue(boolean[] from) {
        String ret = "";
        int values = 0;
        for (int i = 0; i < from.length; ++i) {
            if (!from[i]) continue;
            if (values > 0) {
                ret = ret + ",";
            }
            ret = ret + i;
            ++values;
        }
        return ret;
    }

    public static int[] permutate(int[] original, int[] permV) {
        if (original == null) {
            return null;
        }
        int[] ret = new int[original.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = permV[original[i]];
        }
        return ret;
    }

    public static int[] genInverse(int[] a, int n) {
        int i;
        int[] ret = new int[n];
        for (i = 0; i < n; ++i) {
            ret[i] = -1;
        }
        for (i = 0; i < a.length; ++i) {
            ret[a[i]] = i;
        }
        return ret;
    }

    public static int[] genInverse(int[] a) {
        return U.genInverse(a, a.length);
    }

    public static int[] gen(int n) {
        int[] ret = new int[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    public static int sum(int[] a) {
        int ret = 0;
        for (int i = 0; i < a.length; ++i) {
            ret += a[i];
        }
        return ret;
    }

    public static double sum(double[] a) {
        double ret = 0.0;
        for (int i = 0; i < a.length; ++i) {
            ret += a[i];
        }
        return ret;
    }

    public static int firstMaxIndex(double[] a) {
        if (a == null || a.length == 0) {
            return -1;
        }
        int ret = 0;
        for (int i = 1; i < a.length; ++i) {
            if (!(a[ret] < a[i])) continue;
            ret = i;
        }
        return ret;
    }

    public static double max(double[] a) {
        double ret = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (!(a[i] > ret)) continue;
            ret = a[i];
        }
        return ret;
    }

    public static double min(double[] a) {
        double ret = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (!(a[i] < ret)) continue;
            ret = a[i];
        }
        return ret;
    }

    public static double avg(double[] a) {
        return U.sum(a) / (double)a.length;
    }

    public static int max(int[] a) {
        int ret = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (ret >= a[i]) continue;
            ret = a[i];
        }
        return ret;
    }

    public static double maxAbs(double[][] a) {
        double ret = 0.0;
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                if (!(Math.abs(a[i][j]) > ret)) continue;
                ret = Math.abs(a[i][j]);
            }
        }
        return ret;
    }

    public static double maxAbs(double[][][] a) {
        double ret = 0.0;
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                for (int k = 0; k < a[i][j].length; ++k) {
                    if (!(Math.abs(a[i][j][k]) > ret)) continue;
                    ret = Math.abs(a[i][j][k]);
                }
            }
        }
        return ret;
    }

    public static double maxDiff(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new UnsupportedOperationException();
        }
        double ret = 0.0;
        for (int i = 0; i < a.length; ++i) {
            ret = Math.max(ret, Math.abs(a[i] - b[i]));
        }
        return ret;
    }

    public static int max(int[][] a) {
        int i;
        int ret = 0;
        for (i = 0; i < a.length; ++i) {
            if (i != a.length - 1 && (a[i] == null || a[i].length <= 0)) continue;
            ret = U.max(a[i]);
            break;
        }
        for (i = 1; i < a.length; ++i) {
            int m;
            if (a[i] == null || a[i].length == 0 || (m = U.max(a[i])) <= ret) continue;
            ret = m;
        }
        return ret;
    }

    public static int count(int[] array, int item) {
        int ret = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != item) continue;
            ++ret;
        }
        return ret;
    }

    public static int count(byte[] array, byte item) {
        int ret = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != item) continue;
            ++ret;
        }
        return ret;
    }

    public static int countDifferent(int[] array, int item) {
        int ret = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == item) continue;
            ++ret;
        }
        return ret;
    }

    public static int countLengths(int[][] a) {
        int ret = 0;
        for (int i = 0; i < a.length; ++i) {
            ret += a[i].length;
        }
        return ret;
    }

    public static int[] getLengths(int[][] a) {
        int[] ret = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i].length;
        }
        return ret;
    }

    public static int[] genInverse(int[] a, int[] b) {
        int[] ret = new int[b.length];
        for (int i = 0; i < b.length; ++i) {
            for (int j = 0; j < a.length; ++j) {
                if (a[j] != b[i]) continue;
                ret[i] = j;
            }
        }
        return ret;
    }

    public static int[] genInverseFromLookup(int[] inverseLookup, int[] source) {
        if (source == null) {
            return null;
        }
        int[] ret = new int[source.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = inverseLookup[source[i]];
        }
        return ret;
    }
}

