/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules;

import chemaxon.core.calculations.BondClassifier;
import chemaxon.core.calculations.SSSR;
import chemaxon.core.util.BondTable;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.modules.AutoMapperException;
import chemaxon.marvin.modules.MCS;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import java.util.Arrays;

public class AutoMapper
extends MarvinModule {
    public static final int ORPHANS = 1;
    public static final int COMPLETE = 2;
    public static final int DAYLIGHT = 3;
    public static final int CHANGING = 4;
    public static final int UNKNOWN = 16;
    public static final int UNMAPPED = 17;
    public static final int EITHER = 18;
    public static final int CHEMAXON = 4;
    public static final int MATCHING = 3;
    public static final int DEFAULT_MAPPING_STYLE = 4;
    public static final int FASTEST = 1;
    public static final int STANDARD = 2;
    public static final int BEST = 3;
    public static final int DEFAULT_MAPPING_STRATEGY = 2;
    public static final double DEFAULT_COMPLEXITY_THRESHOLD = 1.0E30;
    public static final long DEFAULT_STEP_LIMIT = 80000L;
    public static final int STOP_UNKONW = 1;
    public static final int STOP_FOUND = 2;
    public static final int STOP_STEPLIMIT = 3;
    public static final int STOP_NOTFOUND = 4;
    public static final int STOP_TIMELIMIT = 5;
    public static final int STOP_BADARGSINMODFUNC = 6;
    private static final int MAX_FRAGMENT_ATOM_EXP = 10;
    private static final int MAX_FRAGMENT_ATOM = 1024;
    private static final int MAX_FRAGMENT = 10;
    private static final int MAX_MAP_STORED = 10;
    private static final int MAX_MAP_INDEX = 1023;
    private static final int[] LOG = new int[]{-1, 0, 1, -1, 2, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9};
    private RxnMolecule reaction = null;
    private int mappingStyle = 4;
    private int mappingStrategy = 2;
    private boolean ignoreH = false;
    private RxnMoleculeAtomIterator iterator = null;
    private RxnMoleculeAtomIterator embeddedIterator = null;
    private int productAtomCount = 0;
    private int reactantAtomCount = 0;
    private int[][] preMappedAtoms = null;
    private int preMappedAtomCount = 0;
    private int preMappedReactantAtomCount = 0;
    private int[][] mcsMappedAtoms = null;
    private int mcsMappedAtomCount = 0;
    private boolean[] initialMapIndex = new boolean[1023];
    private boolean[] fixedMapIndex = new boolean[1023];
    private int currentSize = 0;
    private int size = 0;
    private int maxMapIndex = 0;
    private int currentMapIndex = -1;
    private double complexityThreshold = 1.0E30;
    private int lastStopCause;
    private long stepCountLimit = 80000L;
    private boolean stepCountLimitReached = false;
    private long stepCount = 0L;
    private long timeLimit = -1L;
    private long startTime;
    private int[] state = null;
    private int[] baseNumber = null;
    private boolean carry = false;
    private int pos = 0;
    private boolean[] isWidow = null;
    private int[] positionToReactantAtom = null;
    private int[][] valueToProductAtom = null;
    private int[][] productAtomMap = null;
    private int[][] reactantAtomMap = null;
    private int[] productAtoms = null;
    private int[] reactantMapMatrix = null;
    private int[] productMapMatrix = null;
    private int[][] maps = null;
    private float[] scores = null;
    private int storedMapsCount = 0;
    private long[] steps = null;
    private MCS css = null;
    private BondClassifier ringFinder = new BondClassifier();
    private int reactantRingCount;
    private int productRingCount;
    private boolean keepAllRings = false;
    private long finishedAt;
    final int WIDOWSCORE = 9;
    Molecule[] sortedReactants;
    private static int mcsLevel = 1;

    public static void map(Molecule mol, int mappingStyle) throws AutoMapperException {
        if (mol instanceof RgMolecule) {
            AutoMapper.map(((RgMolecule)mol).getRoot(), mappingStyle);
        }
        if (mol instanceof RxnMolecule) {
            AutoMapper mapper = new AutoMapper();
            mapper.setMappingStyle(mappingStyle);
            mapper.map((RxnMolecule)mol);
        } else {
            AutoMapper.idiotMap(mol);
        }
    }

    private static void idiotMap(Molecule mol) {
        int maxMap = 0;
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            int map = mol.getAtom(i).getAtomMap();
            if (map == 0 || map <= maxMap) continue;
            maxMap = map;
        }
        boolean[] mapUsed = new boolean[maxMap + 1];
        for (int i = 0; maxMap != 0 && i < mol.getAtomCount(); ++i) {
            int map = mol.getAtom(i).getAtomMap();
            if (map == 0) continue;
            mapUsed[map] = true;
        }
        int currentMapId = 1;
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            if (mol.getAtom(i).getAtomMap() != 0) continue;
            while (currentMapId <= maxMap && mapUsed[currentMapId]) {
                ++currentMapId;
            }
            mol.getAtom(i).setAtomMap(currentMapId++);
        }
    }

    public AutoMapper() {
        this.iterator = new RxnMoleculeAtomIterator();
        this.embeddedIterator = new RxnMoleculeAtomIterator();
        this.resetMapIndicesInUse();
    }

    public void setMappingStyle(int mappingStyle) {
        this.mappingStyle = mappingStyle;
    }

    public void setMappingMode(int mappingMode) {
        this.setMappingStyle(mappingMode);
    }

    public void setMappingStrategy(int newStrategy) {
        this.mappingStrategy = newStrategy;
    }

    public void setIgnoreH(boolean ignoreH) {
        this.ignoreH = ignoreH;
    }

    public void setComplexityThreshold(float newThreshold) {
        this.complexityThreshold = newThreshold;
    }

    public void setStepCountLimit(long maxNumberOfSteps) {
        this.stepCountLimit = maxNumberOfSteps;
    }

    public void setTimeLimit(long maxMilliseconds) {
        this.timeLimit = maxMilliseconds;
    }

    public boolean setOption(String parameterName, String parameterValue) {
        if (parameterName.equalsIgnoreCase("MappingStyle")) {
            if (parameterValue.equalsIgnoreCase("CHANGING")) {
                this.setMappingStyle(4);
            } else if (parameterValue.equalsIgnoreCase("MATCHING")) {
                this.setMappingStyle(3);
            } else if (parameterValue.equalsIgnoreCase("COMPLETE")) {
                this.setMappingStyle(2);
            } else if (parameterValue.equalsIgnoreCase("DAYLIGHT")) {
                this.setMappingStyle(3);
            } else if (parameterValue.equalsIgnoreCase("CHEMAXON")) {
                this.setMappingStyle(4);
            } else if (parameterValue.equalsIgnoreCase("ORPHANS")) {
                this.setMappingStyle(1);
            } else {
                return false;
            }
            return true;
        }
        if (parameterName.equalsIgnoreCase("TimeLimit")) {
            this.setTimeLimit(Long.parseLong(parameterValue));
            return true;
        }
        return false;
    }

    public void setReaction(RxnMolecule rm) throws AutoMapperException {
        this.setReactionWithoutMapping(rm);
        this.map();
    }

    public int getlastStopCause() {
        return this.lastStopCause;
    }

    public String getDiagnosticMessage(int diagLevel) {
        if (diagLevel == 0) {
            return "";
        }
        String basic = "Last mapping took " + (this.finishedAt - this.startTime) + "ms.";
        if (diagLevel == 1) {
            return basic;
        }
        basic = basic + " step count = " + this.stepCount + ".";
        switch (this.lastStopCause) {
            case 2: {
                return basic + " Optimal mapping was found.";
            }
            case 3: {
                return basic + " Maximum allowed step count limit was reached, no optimal solution was found.";
            }
            case 4: {
                return basic + " No solution was found.";
            }
            case 5: {
                return basic + " Maximum allowed time limit was reached, no optimal solution was found.";
            }
        }
        return basic + " Last mapping stopped for an unknown reason.";
    }

    private void setReactionWithoutMapping(RxnMolecule rm) throws AutoMapperException {
        if (rm.getReactantCount() > 10 || rm.getProductCount() > 10) {
            throw new AutoMapperException("RxnMolecule too big: at most 10 reactants/products per reaction are allowed.");
        }
        this.reaction = rm;
        this.iterator.setRxnMolecule(this.reaction);
        this.embeddedIterator.setRxnMolecule(this.reaction);
    }

    private void map() throws AutoMapperException {
        this.startTime = System.currentTimeMillis();
        this.lastStopCause = 1;
        this.init();
        if (this.stepCountLimitReached) {
            this.lastStopCause = 3;
        }
        if (this.size == 0 || this.productAtomCount == 0 || this.mappingStyle == 1) {
            if (this.mappingStyle == 3) {
                this.removeOrphanAndWidowMaps();
            }
            this.saveMap(0.0f);
            this.finishedAt = System.currentTimeMillis();
            this.lastStopCause = this.storedMapsCount > 0 ? 2 : 4;
            return;
        }
        this.carry = false;
        this.pos = 0;
        while (!this.carry && !this.stepCountLimitReached) {
            if (this.find()) {
                float score = this.calcScore();
                this.saveMap(score);
                boolean bl = this.stepCountLimitReached = ++this.stepCount > this.stepCountLimit && this.stepCountLimit > 0L;
                if (this.timeLimit != -1L && System.currentTimeMillis() - this.startTime > this.timeLimit) {
                    this.lastStopCause = 5;
                    break;
                }
            }
            this.next();
        }
        if (this.mappingStyle == 3) {
            this.removeOrphanAndWidowMaps();
        }
        this.finishedAt = System.currentTimeMillis();
        if (this.stepCountLimitReached) {
            this.lastStopCause = 3;
        } else if (this.timeLimit != -1L && System.currentTimeMillis() - this.startTime > this.timeLimit) {
            this.lastStopCause = 5;
        }
        if (this.lastStopCause == 1) {
            this.lastStopCause = this.storedMapsCount > 0 ? 2 : 4;
        }
    }

    public int guessMappingStyle(RxnMolecule reaction) {
        try {
            this.setReactionWithoutMapping(reaction);
            this.init();
            if (this.preMappedAtomCount == 0) {
                return 17;
            }
            int[][] originalMap = new int[this.maxMapIndex + 1][2];
            int mappedAtomCount = this.getCurrentMapping(originalMap);
            if (mappedAtomCount == -1) {
                return 16;
            }
            this.clearAllMaps(reaction);
            this.resetMapIndicesInUse();
            this.setMappingStyle(2);
            this.map(reaction);
            for (int i = 0; i < originalMap.length; ++i) {
                if (originalMap[i][0] == -1 || originalMap[i][1] == -1 || reaction.getAtom(originalMap[i][0]).getAtomMap() == reaction.getAtom(originalMap[i][1]).getAtomMap()) continue;
                this.restoreMap(reaction, originalMap);
                return 16;
            }
            int[][] newMap = new int[this.maxMapIndex + 1][2];
            this.getCurrentMapping(newMap);
            this.restoreMap(reaction, originalMap);
            int mappedOrphanInOriginal = 0;
            int notMappedOrphanInOriginal = 0;
            int orphanInNew = 0;
            for (int i = 0; i < newMap.length; ++i) {
                if (newMap[i][0] == -1 || newMap[i][1] != -1) continue;
                ++orphanInNew;
                if (reaction.getAtom(newMap[i][0]).getAtomMap() != 0) {
                    ++mappedOrphanInOriginal;
                    continue;
                }
                ++notMappedOrphanInOriginal;
            }
            if (orphanInNew == mappedOrphanInOriginal) {
                return 4;
            }
            if (orphanInNew == notMappedOrphanInOriginal) {
                return 3;
            }
            if (orphanInNew == 0) {
                if (mappedAtomCount == reaction.getAtomCount()) {
                    return 4;
                }
                return 18;
            }
            return 16;
        }
        catch (AutoMapperException e) {
            return 16;
        }
    }

    private void clearAllMaps(RxnMolecule r) {
        for (int i = 0; i < r.getAtomCount(); ++i) {
            r.getAtom(i).setAtomMap(0);
        }
    }

    private int getCurrentMapping(int[][] map) {
        for (int i = 0; i < map.length; ++i) {
            map[i][1] = -1;
            map[i][0] = -1;
        }
        int mappedAtomCount = 0;
        for (int i = 0; i < this.reaction.getAtomCount(); ++i) {
            MolAtom a = this.reaction.getAtom(i);
            int m = a.getAtomMap();
            if (m == 0) continue;
            ++mappedAtomCount;
            if (map[m][0] == -1) {
                map[m][0] = i;
                continue;
            }
            if (map[m][1] == -1) {
                map[m][1] = i;
                continue;
            }
            return -1;
        }
        return mappedAtomCount;
    }

    private void restoreMap(RxnMolecule reaction, int[][] map) {
        this.clearAllMaps(reaction);
        for (int i = 0; i < map.length; ++i) {
            if (map[i][0] == -1) continue;
            reaction.getAtom(map[i][0]).setAtomMap(i);
            if (map[i][1] == -1) continue;
            reaction.getAtom(map[i][1]).setAtomMap(i);
        }
    }

    @Override
    public Object modfunc(Object arg) {
        Object[] args = (Object[])arg;
        if (args.length < 2) {
            this.lastStopCause = 6;
            return null;
        }
        Object actionObj = args[0];
        if (!(actionObj instanceof String)) {
            this.lastStopCause = 6;
            return null;
        }
        String action = (String)actionObj;
        if (action.equalsIgnoreCase("setForbiddenMap")) {
            this.setForbiddenMap((Integer)args[1]);
            return new Boolean(true);
        }
        if (action.equalsIgnoreCase("map")) {
            try {
                AutoMapper.map((Molecule)args[1], this.mappingStyle);
                return new Integer(this.lastStopCause);
            }
            catch (AutoMapperException e) {
                return null;
            }
        }
        if (action.equalsIgnoreCase("setOption")) {
            if (args.length != 3) {
                this.lastStopCause = 6;
                return null;
            }
            return this.setOption((String)args[1], (String)args[2]);
        }
        this.lastStopCause = 6;
        return null;
    }

    public void setForbiddenMap(int mapId) {
        this.initialMapIndex[mapId] = true;
        this.fixedMapIndex[mapId] = true;
    }

    public int map(RxnMolecule reaction) throws AutoMapperException {
        this.setReaction(reaction);
        if (this.getMapCount() == 0 && this.preMappedAtomCount + this.mcsMappedAtomCount == 0 && this.productAtomCount != 0 && this.reactantAtomCount != 0 && (this.mappingStyle == 2 || this.mappingStyle == 3)) {
            throw new AutoMapperException("No valid mapping found.");
        }
        this.setMap(0);
        this.resetMapIndicesInUse();
        return this.lastStopCause;
    }

    public int map(RxnMolecule reaction, boolean mapAlways) throws AutoMapperException {
        this.setReaction(reaction);
        if (this.getMapCount() == 0 && this.preMappedAtomCount + this.mcsMappedAtomCount == 0 && this.productAtomCount != 0 && this.reactantAtomCount != 0 && (this.mappingStyle == 2 || this.mappingStyle == 3)) {
            throw new AutoMapperException("No valid mapping found.");
        }
        if (mapAlways || this.lastStopCause == 2) {
            this.setMap(0);
            this.resetMapIndicesInUse();
        }
        return this.lastStopCause;
    }

    public static void mapReaction(RxnMolecule reaction) throws AutoMapperException {
        new AutoMapper().map(reaction);
    }

    public int getMapCount() {
        return this.storedMapsCount;
    }

    float getScore(int mapId) {
        return this.scores[mapId];
    }

    public void setMap(int mapId) {
        this.resetMapIndex();
        if (this.mappingStyle != 1) {
            this.setFullMap(mapId);
        }
        if (this.mappingStyle == 3) {
            return;
        }
        this.iterator.setReactantSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            MolAtom ra = this.iterator.getAtom();
            if (this.needsMap(ra)) {
                ra.setAtomMap(this.nextMapIndex(this.initialMapIndex));
            }
            this.iterator.next();
        }
        this.iterator.setProductSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            MolAtom pa = this.iterator.getAtom();
            if (this.needsMap(pa)) {
                pa.setAtomMap(this.nextMapIndex(this.initialMapIndex));
            }
            this.iterator.next();
        }
        if (this.mappingStyle == 4) {
            this.removeNonChangingAtomMaps();
        }
    }

    private void canonicalizeMap() {
        int[] gr = new int[this.reaction.getAtomCount()];
        this.reaction.getGrinv(gr);
        this.canonicalizeGrinvs(gr);
        this.iterator.setReactantSide();
        this.embeddedIterator.setProductSide();
        int mapDisplacement = 0;
        int[] productMap = new int[this.productAtomCount];
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            MolAtom ra = this.iterator.getAtom();
            int oldMap = ra.getAtomMap();
            if (oldMap > 0) {
                int newMap = mapDisplacement + gr[this.iterator.getAtomId()] + 1;
                while (this.initialMapIndex[newMap]) {
                    mapDisplacement = newMap++;
                }
                int pa = this.findProductAtomWithMap(oldMap);
                if (pa != -1) {
                    productMap[pa] = newMap;
                    ra.setAtomMap(newMap);
                }
            }
            this.iterator.next();
        }
        this.embeddedIterator.reset();
        while (this.embeddedIterator.hasNext()) {
            int atomId = this.embeddedIterator.getAtomId();
            if (productMap[atomId] != 0) {
                this.embeddedIterator.getAtom().setAtomMap(productMap[atomId]);
            }
            this.embeddedIterator.next();
        }
    }

    private void canonicalizeGrinvs(int[] gr) {
        int i;
        boolean[] grMult = new boolean[gr.length];
        int maxGrinv = 0;
        for (i = 0; i < this.reactantAtomCount; ++i) {
            if (gr[i] <= maxGrinv) continue;
            maxGrinv = gr[i];
        }
        for (i = 0; i < this.reactantAtomCount; ++i) {
            if (grMult[gr[i]]) {
                gr[i] = ++maxGrinv;
            }
            grMult[gr[i]] = true;
        }
    }

    private int findProductAtomWithMap(int oldMap) {
        this.embeddedIterator.reset();
        while (this.embeddedIterator.hasNext()) {
            if (this.embeddedIterator.getAtom().getAtomMap() == oldMap) {
                return this.embeddedIterator.getAtomId();
            }
            this.embeddedIterator.next();
        }
        return -1;
    }

    private void removeOrphanAndWidowMaps() {
        this.iterator.setReactantSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            MolAtom ra = this.iterator.getAtom();
            if (ra.getAtomMap() != 0 && this.findMappedProductAtom(ra.getAtomMap()) == -1) {
                ra.setAtomMap(0);
            }
            this.iterator.next();
        }
        this.iterator.setProductSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            MolAtom pa = this.iterator.getAtom();
            if (pa.getAtomMap() != 0 && this.findMappedReactantAtom(pa.getAtomMap()) == -1) {
                pa.setAtomMap(0);
            }
            this.iterator.next();
        }
    }

    private boolean needsMap(MolAtom a) {
        return a.getAtomMap() == 0 && (!this.ignoreH || a.getAtno() != 1) && a.getAtno() != 137;
    }

    private void setFullMap(int mapId) {
        this.iterator.setReactantSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            MolAtom ra = this.iterator.getAtom();
            if (!this.initialMapIndex[ra.getAtomMap()]) {
                ra.setAtomMap(0);
            }
            this.iterator.next();
        }
        this.iterator.setProductSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            MolAtom pa = this.iterator.getAtom();
            if (!this.initialMapIndex[pa.getAtomMap()]) {
                pa.setAtomMap(0);
            }
            this.iterator.next();
        }
        if (this.productAtomCount > 0 && this.reactantAtomCount > 0) {
            int[] map = this.maps[mapId];
            for (int i = 0; i < this.currentSize; ++i) {
                int pFId;
                if (this.isWidow[i] && map[i] == this.baseNumber[i] - 1) continue;
                int rFId = this.compositeIdToFragId(this.positionToReactantAtom[i]);
                int rAId = this.compositeIdToAtomId(this.positionToReactantAtom[i]);
                Molecule reactant = this.sortedReactants[rFId];
                int mapIndex = this.nextMapIndex(this.initialMapIndex);
                MolAtom ra = reactant.getAtom(rAId);
                if (this.needsMap(ra)) {
                    ra.setAtomMap(mapIndex);
                }
                if ((pFId = this.compositeIdToFragId(this.valueToProductAtom[i][map[i]])) == -1) continue;
                int pAId = this.compositeIdToAtomId(this.valueToProductAtom[i][map[i]]);
                Molecule product = this.reaction.getProduct(pFId);
                MolAtom pa = product.getAtom(pAId);
                if (!this.needsMap(pa)) continue;
                pa.setAtomMap(mapIndex);
            }
        }
        for (int i = 0; i < this.mcsMappedAtomCount; ++i) {
            Molecule reactant = this.sortedReactants[this.compositeIdToFragId(this.mcsMappedAtoms[i][0])];
            int mapIndex = this.nextMapIndex(this.initialMapIndex);
            MolAtom ra = reactant.getAtom(this.compositeIdToAtomId(this.mcsMappedAtoms[i][0]));
            Molecule product = this.reaction.getProduct(this.compositeIdToFragId(this.mcsMappedAtoms[i][1]));
            MolAtom pa = product.getAtom(this.compositeIdToAtomId(this.mcsMappedAtoms[i][1]));
            ra.setAtomMap(mapIndex);
            pa.setAtomMap(mapIndex);
        }
    }

    private void removeNonChangingAtomMaps() {
        int map;
        MolAtom ra;
        boolean[] changingAtomMaps = new boolean[this.maxMapIndex];
        this.iterator.setReactantSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            ra = this.iterator.getAtom();
            if (ra.getAtomMap() != 0 && this.isChangingAtom(this.iterator.getFragment(), this.iterator.getAtomId())) {
                changingAtomMaps[ra.getAtomMap()] = true;
            }
            this.iterator.next();
        }
        this.iterator.setProductSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            MolAtom pa = this.iterator.getAtom();
            if (pa.getAtomMap() != 0 && this.findMappedReactantAtom(pa.getAtomMap()) == -1) {
                changingAtomMaps[pa.getAtomMap()] = true;
            }
            this.iterator.next();
        }
        this.iterator.setReactantSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            ra = this.iterator.getAtom();
            map = ra.getAtomMap();
            if (!changingAtomMaps[map]) {
                ra.setAtomMap(0);
            }
            this.iterator.next();
        }
        this.iterator.setProductSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            ra = this.iterator.getAtom();
            map = ra.getAtomMap();
            if (!changingAtomMaps[map]) {
                ra.setAtomMap(0);
            }
            this.iterator.next();
        }
    }

    private boolean hasChangingNeighbour(Molecule frag, MolAtom atom, boolean[] changing) {
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolAtom neighbour;
            MolBond b = atom.getBond(i);
            MolAtom molAtom = neighbour = b.getAtom1() == atom ? b.getAtom2() : b.getAtom1();
            if (neighbour.getAtomMap() == 0 || !changing[neighbour.getAtomMap()]) continue;
            return true;
        }
        return false;
    }

    private void setInternalMap() {
        this.clearInternalMaps();
        this.resetMapIndex();
        for (int i = 0; i < this.currentSize; ++i) {
            int mapIndex;
            if (this.isWidow[i] && this.state[i] == this.baseNumber[i] - 1) continue;
            int rFId = this.compositeIdToFragId(this.positionToReactantAtom[i]);
            int rAId = this.compositeIdToAtomId(this.positionToReactantAtom[i]);
            this.reactantAtomMap[rFId][rAId] = mapIndex = this.nextMapIndex(this.fixedMapIndex);
            int pFId = this.compositeIdToFragId(this.valueToProductAtom[i][this.state[i]]);
            if (pFId == -1) continue;
            int pAId = this.compositeIdToAtomId(this.valueToProductAtom[i][this.state[i]]);
            this.productAtomMap[pFId][pAId] = mapIndex;
        }
        this.iterator.setReactantSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            int rAId;
            int rFId = this.iterator.getFragId();
            if (this.reactantAtomMap[rFId][rAId = this.iterator.getAtomId()] == 0) {
                this.reactantAtomMap[rFId][rAId] = this.nextMapIndex(this.fixedMapIndex);
            }
            this.iterator.next();
        }
        this.iterator.setProductSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            int pAId;
            int pFId = this.iterator.getFragId();
            if (this.productAtomMap[pFId][pAId = this.iterator.getAtomId()] == 0) {
                this.productAtomMap[pFId][pAId] = this.nextMapIndex(this.fixedMapIndex);
            }
            this.iterator.next();
        }
    }

    private void clearInternalMaps() {
        for (int i = 0; i < 10; ++i) {
            int j;
            for (j = 0; j < this.productAtomCount; ++j) {
                if (this.fixedMapIndex[this.productAtomMap[i][j]]) continue;
                this.productAtomMap[i][j] = 0;
            }
            for (j = 0; j < this.size; ++j) {
                if (this.fixedMapIndex[this.reactantAtomMap[i][j]]) continue;
                this.reactantAtomMap[i][j] = 0;
            }
        }
    }

    private void resetMapIndicesInUse() {
        for (int i = 0; i < 1023; ++i) {
            this.initialMapIndex[i] = false;
            this.fixedMapIndex[i] = false;
        }
    }

    private boolean isChangingAtom(Molecule reactant, int reacAtomIndex) {
        int atomMap = reactant.getAtom(reacAtomIndex).getAtomMap();
        int prodAtomIndex = this.findMappedProductAtom(atomMap);
        if (prodAtomIndex == -1) {
            return true;
        }
        prodAtomIndex = this.compositeIdToAtomId(prodAtomIndex);
        Molecule product = this.embeddedIterator.getFragment();
        if (reactant.getAtom(reacAtomIndex).getBondCount() != product.getAtom(prodAtomIndex).getBondCount()) {
            return true;
        }
        int[] reacBonds = new int[15];
        int maxBondType = this.countBondsByOrder(reactant, reacAtomIndex, reacBonds);
        int[] prodBonds = new int[15];
        this.countBondsByOrder(product, prodAtomIndex, prodBonds);
        for (int i = 0; i < maxBondType; ++i) {
            if (reacBonds[i] == prodBonds[i]) continue;
            return true;
        }
        int[] reacAtomNeighs = new int[8];
        this.getNeighsSortedByType(reactant, reacAtomIndex, reacAtomNeighs);
        int[] prodAtomNeighs = new int[8];
        this.getNeighsSortedByType(product, prodAtomIndex, prodAtomNeighs);
        for (int i = 0; i < 8; ++i) {
            if (reacAtomNeighs[i] == prodAtomNeighs[i]) continue;
            return true;
        }
        int[] reacAtomMaps = new int[8];
        this.getNeighsSortedByMap(reactant, reacAtomIndex, reacAtomMaps);
        int[] prodAtomMaps = new int[8];
        this.getNeighsSortedByMap(product, prodAtomIndex, prodAtomMaps);
        for (int i = 0; i < 8; ++i) {
            if (reacAtomMaps[i] == prodAtomMaps[i]) continue;
            return true;
        }
        return false;
    }

    private int countBondsByOrder(Molecule fragment, int atomIndex, int[] bondCounts) {
        int maxBondType = 0;
        MolAtom atom = fragment.getAtom(atomIndex);
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolBond b = atom.getBond(i);
            int n = b.getType();
            bondCounts[n] = bondCounts[n] + 1;
            if (b.getType() <= maxBondType) continue;
            maxBondType = b.getType();
        }
        return maxBondType;
    }

    private void getNeighsSortedByType(Molecule fragment, int atomIndex, int[] atomTypes) {
        MolAtom atom = fragment.getAtom(atomIndex);
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolBond b = atom.getBond(i);
            MolAtom neigh = b.getAtom1() == fragment.getAtom(atomIndex) ? b.getAtom2() : b.getAtom1();
            atomTypes[i] = neigh.getAtno();
        }
        Arrays.sort(atomTypes, 0, atom.getBondCount());
    }

    private void getNeighsSortedByMap(Molecule fragment, int atomIndex, int[] atomMaps) {
        MolAtom atom = fragment.getAtom(atomIndex);
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolBond b = atom.getBond(i);
            MolAtom neigh = b.getAtom1().getAtomMap() == atom.getAtomMap() ? b.getAtom2() : b.getAtom1();
            atomMaps[i] = neigh.getAtomMap();
        }
        Arrays.sort(atomMaps, 0, atom.getBondCount());
    }

    private boolean find() {
        --this.pos;
        boolean found = true;
        while (found && this.pos != this.currentSize - 1 && !this.stepCountLimitReached) {
            ++this.pos;
            this.stepCountLimitReached = ++this.stepCount > this.stepCountLimit && this.stepCountLimit > 0L;
            found = this.good();
        }
        return found;
    }

    private boolean good() {
        ++this.stepCount;
        if (this.baseNumber[this.pos] == 0) {
            return true;
        }
        if (this.baseNumber[this.pos] - 1 == this.state[this.pos] && this.isWidow[this.pos]) {
            return true;
        }
        for (int i = 0; i < this.pos; ++i) {
            if (this.isWidow[i] && this.state[i] == this.baseNumber[i] - 1) continue;
            try {
                if (this.valueToProductAtom[i][this.state[i]] != this.valueToProductAtom[this.pos][this.state[this.pos]]) continue;
                return false;
            }
            catch (ArrayIndexOutOfBoundsException a) {
                return false;
            }
        }
        return true;
    }

    private void next() {
        this.carry = true;
        while (this.carry && this.pos != -1) {
            if (this.state[this.pos] == this.baseNumber[this.pos] - 1) {
                this.state[this.pos] = 0;
                --this.pos;
                continue;
            }
            int n = this.pos;
            this.state[n] = this.state[n] + 1;
            this.carry = false;
        }
    }

    private float calcScore() {
        this.setInternalMap();
        float score = 0.0f;
        this.calcReactantMapMatrix();
        this.calcProductMapMatrix();
        for (int i = 0; i < this.reactantMapMatrix.length; ++i) {
            if (this.productMapMatrix[i] == this.reactantMapMatrix[i]) continue;
            score -= 1.0f;
        }
        int bondScore = 0;
        for (int i = 0; i < this.maxMapIndex; ++i) {
            int j;
            int rc = 0;
            int pc = 0;
            for (j = 0; j < i; ++j) {
                pc += this.productMapMatrix[i * (i - 1) / 2 + j] < 8 ? 1 : 0;
                rc += this.reactantMapMatrix[i * (i - 1) / 2 + j] < 8 ? 1 : 0;
            }
            ++j;
            while (j < this.maxMapIndex) {
                pc += this.productMapMatrix[j * (j - 1) / 2 + i] < 8 ? 1 : 0;
                rc += this.reactantMapMatrix[j * (j - 1) / 2 + i] < 8 ? 1 : 0;
                ++j;
            }
            bondScore += Math.abs(pc - rc);
        }
        return score - (float)bondScore;
    }

    private void calcReactantMapMatrix() {
        this.calcMapMatrix(true);
    }

    private void calcProductMapMatrix() {
        this.calcMapMatrix(false);
    }

    private void calcMapMatrix(boolean reactantSide) {
        this.clearMapMatrix(reactantSide);
        int fragCount = reactantSide ? this.reaction.getReactantCount() : this.reaction.getProductCount();
        for (int fId = 0; fId < fragCount; ++fId) {
            Molecule frag = reactantSide ? this.sortedReactants[fId] : this.reaction.getProduct(fId);
            BondTable bTab = frag.getBondTable();
            for (int i = 0; i < bTab.getAtomCount(); ++i) {
                for (int j = 0; j < i; ++j) {
                    int edgeIndex = bTab.getBondIndex(i, j);
                    int bt = edgeIndex == -1 ? 8 : frag.getBond(edgeIndex).getFlags() & 0xF;
                    this.setMapMatrix(reactantSide, fId, i, j, bt);
                }
            }
        }
    }

    private void clearMapMatrix(boolean reactantSide) {
        int[] mat = reactantSide ? this.reactantMapMatrix : this.productMapMatrix;
        for (int i = 0; i < mat.length; ++i) {
            mat[i] = 9;
        }
    }

    private void setMapMatrix(boolean reactantSide, int fragmentId, int atom1, int atom2, int type) {
        int[] mapMatrix;
        int[][] maps = reactantSide ? this.reactantAtomMap : this.productAtomMap;
        int[][] otherSideMaps = !reactantSide ? this.reactantAtomMap : this.productAtomMap;
        int mapOfAtom1 = maps[fragmentId][atom1];
        int mapOfAtom2 = maps[fragmentId][atom2];
        int[] nArray = mapMatrix = reactantSide ? this.reactantMapMatrix : this.productMapMatrix;
        if (--mapOfAtom1 < --mapOfAtom2) {
            mapMatrix[mapOfAtom2 * (mapOfAtom2 - 1) / 2 + mapOfAtom1] = type;
        } else {
            mapMatrix[mapOfAtom1 * (mapOfAtom1 - 1) / 2 + mapOfAtom2] = type;
        }
    }

    private void saveMap(float score) {
        int i;
        if (this.storedMapsCount == 10) {
            --this.storedMapsCount;
        }
        for (i = 0; i < this.storedMapsCount && this.scores[i] > score; ++i) {
        }
        for (int j = this.storedMapsCount; j > i; --j) {
            this.scores[j] = this.scores[j - 1];
            this.steps[j] = this.steps[j - 1];
            System.arraycopy(this.maps[j - 1], 0, this.maps[j], 0, this.maps[j - 1].length);
        }
        this.scores[i] = score;
        this.steps[i] = this.stepCount;
        System.arraycopy(this.state, 0, this.maps[i], 0, this.state.length);
        ++this.storedMapsCount;
    }

    private void init() throws AutoMapperException {
        this.storedMapsCount = 0;
        this.preMappedAtomCount = 0;
        this.mcsMappedAtomCount = 0;
        this.maxMapIndex = 0;
        this.preMappedReactantAtomCount = 0;
        this.currentSize = 0;
        this.size = 0;
        this.currentMapIndex = -1;
        this.storedMapsCount = 0;
        this.stepCount = 0L;
        this.stepCountLimitReached = false;
        this.sortedReactants = this.sortReactants();
        this.calcProblemSize();
        this.alloc();
        this.reactantRingCount = this.ringCount(true);
        this.productRingCount = this.ringCount(false);
        this.keepAllRings = this.reactantRingCount == this.productRingCount;
        this.startTime = System.currentTimeMillis();
        this.findMappedAtoms();
        float preMappedRatio = (float)this.preMappedAtomCount / (float)(this.reactantAtomCount + this.preMappedAtomCount);
        if ((double)preMappedRatio < 0.2 && (this.stepCountLimit == -1L || this.stepCountLimit > 5000L)) {
            this.perceiveMCSMaps();
            if (this.stepCountLimitReached) {
                return;
            }
        }
        this.size = this.reactantAtomCount - this.preMappedReactantAtomCount - this.mcsMappedAtomCount;
        if (this.mappingStyle == 1 || this.size == 0 || this.productAtomCount == 0) {
            return;
        }
        this.iterator.setReactantSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            int cId = this.idsToCompositeId(this.iterator.getFragId(), this.iterator.getAtomId());
            MolAtom ra = this.iterator.getAtom();
            if (!this.isReactantAtomMapped(cId) && ra.isMappable() && !this.addAtomToBacktracking(cId, ra)) {
                --this.size;
            }
            this.iterator.next();
        }
        double cmplx = this.estimatedComplexity();
        if (cmplx > this.complexityThreshold) {
            throw new AutoMapperException("Reaction is too complex to be automapped. Complexity score is " + cmplx + " allowed threshold is " + this.complexityThreshold);
        }
    }

    private int ringCount(boolean reactantSide) {
        SSSR ringer = new SSSR();
        int fc = reactantSide ? this.reaction.getReactantCount() : this.reaction.getProductCount();
        int ringCount = 0;
        for (int frag = 0; frag < fc; ++frag) {
            ringer.setGraph(reactantSide ? this.reaction.getReactant(frag).smol() : this.reaction.getProduct(frag).smol());
            ringer.startRingSearch(false);
            int[][] rings = ringer.getRings();
            ringCount += ringer.getRingCount();
        }
        return ringCount;
    }

    private double estimatedComplexity() {
        double complexity = 1.0;
        for (int i = 0; i < this.currentSize; ++i) {
            complexity *= (double)this.baseNumber[i];
        }
        return complexity;
    }

    private void findMappedAtoms() {
        int mapIndex;
        int j;
        int i;
        this.preMappedAtomCount = 0;
        this.preMappedReactantAtomCount = 0;
        for (i = 0; i < this.reactantAtomMap.length; ++i) {
            for (j = 0; j < this.reactantAtomMap[i].length; ++j) {
                this.reactantAtomMap[i][j] = 0;
            }
        }
        for (i = 0; i < this.productAtomMap.length; ++i) {
            for (j = 0; j < this.productAtomMap[i].length; ++j) {
                this.productAtomMap[i][j] = 0;
            }
        }
        this.iterator.setReactantSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            mapIndex = this.iterator.getAtom().getAtomMap();
            if (mapIndex != 0) {
                int productAtomIndex = this.findMappedProductAtom(mapIndex);
                this.preMappedAtoms[this.preMappedAtomCount][0] = this.idsToCompositeId(this.iterator.getFragId(), this.iterator.getAtomId());
                this.preMappedAtoms[this.preMappedAtomCount][1] = productAtomIndex;
                ++this.preMappedAtomCount;
                ++this.preMappedReactantAtomCount;
                this.initialMapIndex[mapIndex] = true;
                this.fixedMapIndex[mapIndex] = true;
                this.reactantAtomMap[this.iterator.getFragId()][this.iterator.getAtomId()] = mapIndex;
                if (productAtomIndex != -1) {
                    this.productAtomMap[this.compositeIdToFragId((int)productAtomIndex)][this.compositeIdToAtomId((int)productAtomIndex)] = mapIndex;
                }
            }
            this.iterator.next();
        }
        this.iterator.setProductSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            mapIndex = this.iterator.getAtom().getAtomMap();
            int cId = this.idsToCompositeId(this.iterator.getFragId(), this.iterator.getAtomId());
            if (mapIndex != 0 && !this.isProductAtomMapped(cId)) {
                this.preMappedAtoms[this.preMappedAtomCount][0] = -1;
                this.preMappedAtoms[this.preMappedAtomCount][1] = cId;
                ++this.preMappedAtomCount;
                this.initialMapIndex[mapIndex] = true;
                this.fixedMapIndex[mapIndex] = true;
                this.productAtomMap[this.iterator.getFragId()][this.iterator.getAtomId()] = mapIndex;
            }
            this.iterator.next();
        }
    }

    private int findMappedProductAtom(int mapIndex) {
        this.embeddedIterator.setProductSide();
        return this.findMappedtAtom(mapIndex);
    }

    private int findMappedtAtom(int mapIndex) {
        this.embeddedIterator.reset();
        while (this.embeddedIterator.hasNext()) {
            if (this.embeddedIterator.getAtom().getAtomMap() == mapIndex) {
                return this.idsToCompositeId(this.embeddedIterator.getFragId(), this.embeddedIterator.getAtomId());
            }
            this.embeddedIterator.next();
        }
        return -1;
    }

    private int findMappedReactantAtom(int mapIndex) {
        this.embeddedIterator.setReactantSide();
        return this.findMappedtAtom(mapIndex);
    }

    private void perceiveMCSMaps() {
        int rc = this.reaction.getReactantCount();
        int pc = this.reaction.getProductCount();
        this.resetMapIndex();
        int[][][] pairwiseMCS = new int[rc][pc][];
        boolean[][] acceptedMCSMap = new boolean[rc][pc];
        boolean[][] secondTryMCSMap = new boolean[rc][pc];
        boolean[][] failedMCSMap = new boolean[rc][pc];
        while (this.calculatePairWiseMCS(pairwiseMCS, acceptedMCSMap, secondTryMCSMap, failedMCSMap) && !this.stepCountLimitReached) {
            int[] maxId = this.findMaxMCS(pairwiseMCS, acceptedMCSMap, secondTryMCSMap);
            int rFIdMax = maxId[0];
            int pFIdMax = maxId[1];
            this.appendMCSMap(rFIdMax, pFIdMax, pairwiseMCS[rFIdMax][pFIdMax]);
            secondTryMCSMap[rFIdMax][pFIdMax] = acceptedMCSMap[rFIdMax][pFIdMax];
            acceptedMCSMap[rFIdMax][pFIdMax] = true;
            for (int i = 0; i < rc; ++i) {
                for (int j = 0; j < failedMCSMap[i].length; ++j) {
                    failedMCSMap[i][j] = false;
                }
            }
        }
    }

    private boolean calculatePairWiseMCS(int[][][] pairwiseMCS, boolean[][] acceptedMCSMap, boolean[][] secondTryMCSMap, boolean[][] failedMCSMap) {
        int rc = this.reaction.getReactantCount();
        int pc = this.reaction.getProductCount();
        int[] m = null;
        for (int rFId = 0; rFId < rc; ++rFId) {
            Molecule r = this.sortedReactants[rFId];
            for (int pFId = 0; pFId < pc; ++pFId) {
                if (acceptedMCSMap[rFId][pFId] && secondTryMCSMap[rFId][pFId] || failedMCSMap[rFId][pFId]) continue;
                Molecule p = this.reaction.getProduct(pFId);
                pairwiseMCS[rFId][pFId] = null;
                if (!this.initMCS(r, p) || !this.updateAllowedAtomsInCSS(rFId, pFId)) continue;
                if (this.css.search()) {
                    m = this.css.getResult();
                    pairwiseMCS[rFId][pFId] = m;
                }
                this.stepCount += this.css.getStepCount();
                if (this.stepCount <= this.stepCountLimit || this.stepCountLimit <= 0L) continue;
                this.stepCountLimitReached = true;
                return m != null;
            }
        }
        return m != null;
    }

    private boolean initMCS(Molecule reactantFragment, Molecule productFragment) {
        this.css = new MCS();
        this.css.setIgnoreIsotopes(false);
        this.css.setMolecules(reactantFragment, productFragment);
        this.css.setMode(this.mappingStrategy == 1 ? 3 : 2);
        this.css.setMinimumCommonSize(4);
        this.css.setIgnoreAtomType(false);
        this.css.setIgnoreBondType(true);
        if (this.stepCountLimit > 0L) {
            this.css.setStepCountLimit(this.stepCountLimit - this.stepCount);
        }
        if (this.keepAllRings) {
            this.css.setDontBreakRingBonds(true);
        }
        long t0 = System.currentTimeMillis();
        SSSR rringer = new SSSR();
        rringer.setGraph(reactantFragment.smol());
        rringer.startRingSearch(false);
        int[][] rrings = rringer.getRings();
        long t1 = System.currentTimeMillis();
        if (t1 - t0 > 1000L) {
            System.out.println("ring time " + (t1 - t0) / 1000L);
        }
        if (rringer.getRingCount() > 0 && rrings[0].length == 6 && this.substitutionCount(reactantFragment, rrings[0]) == 1) {
            this.css.setIgnoreAtomType(true);
            this.css.setDontBreakRingBonds(true);
            this.css.setIgnoreBondType(false);
            return true;
        }
        if (this.preMappedAtomCount == 0 && rringer.getRingCount() == 2) {
            for (int i = 0; i < rringer.getRingCount(); ++i) {
                if (rrings[i].length != 6) continue;
                this.css.setIgnoreBondType(false);
                return true;
            }
        }
        this.css.setDontBreakRingBonds(true);
        t0 = System.currentTimeMillis();
        SSSR pringer = new SSSR();
        pringer.setGraph(productFragment.smol());
        pringer.startRingSearch(false);
        if (this.preMappedAtomCount != 0) {
            if (!this.keepAllRings) {
                this.css.setDontBreakRingBonds(false);
            }
            this.css.setIgnoreBondType(false);
        } else {
            int[][] prings = pringer.getRings();
            if (Math.abs(pringer.getRingCount() - rringer.getRingCount()) >= 2) {
                this.css.setIgnoreBondType(false);
                this.css.setMode(2);
            }
            if (pringer.getRingCount() + rringer.getRingCount() > 0 && (pringer.getRingCount() == 0 || rringer.getRingCount() == 0)) {
                this.css.setDontBreakRingBonds(true);
            } else if (!this.keepAllRings) {
                this.css.setDontBreakRingBonds(false);
            }
        }
        t1 = System.currentTimeMillis();
        if (t1 - t0 > 1000L) {
            System.out.println("ring time " + (t1 - t0) / 1000L);
        }
        if (rringer.getRingCount() == 0) {
            this.css.setIgnoreBondType(false);
        }
        return true;
    }

    private int substitutionCount(Molecule frag, int[] ringAtoms) {
        int sc = 0;
        for (int ri = 0; ri < ringAtoms.length; ++ri) {
            MolAtom ai = frag.getAtom(ringAtoms[ri]);
            sc += ai.getBondCount() > 2 && ai.getExplicitHcount() == 0 ? 1 : 0;
        }
        return sc;
    }

    private int[] findMaxMCS(int[][][] pairwiseMCS, boolean[][] acceptedMCSMap, boolean[][] secondTryMCSMap) {
        int maxMCS = 0;
        int rc = this.reaction.getReactantCount();
        int pc = this.reaction.getProductCount();
        int rFIdMax = -1;
        int pFIdMax = -1;
        for (int rFId = 0; rFId < rc; ++rFId) {
            for (int pFId = 0; pFId < pc; ++pFId) {
                int mcsSize;
                if (acceptedMCSMap[rFId][pFId] && secondTryMCSMap[rFId][pFId] || (mcsSize = this.getMCSSize(pairwiseMCS[rFId][pFId])) <= maxMCS) continue;
                maxMCS = mcsSize;
                rFIdMax = rFId;
                pFIdMax = pFId;
            }
        }
        int[] maxId = new int[]{rFIdMax, pFIdMax};
        return maxId;
    }

    private boolean updateAllowedAtomsInCSS(int rFId, int pFId) {
        int rAtomCount = this.reaction.getReactant(rFId).getAtomCount();
        int[] rMap = this.reactantAtomMap[rFId];
        for (int i = 0; i < rMap.length; ++i) {
            if (rMap[i] == 0 || this.initialMapIndex[rMap[i]]) continue;
            this.css.excludeQueryAtom(i);
            --rAtomCount;
        }
        if (rAtomCount < 2) {
            return false;
        }
        int pAtomCount = this.reaction.getProduct(pFId).getAtomCount();
        int[] pMap = this.productAtomMap[pFId];
        for (int i = 0; i < pMap.length; ++i) {
            if (pMap[i] == 0 || this.initialMapIndex[pMap[i]]) continue;
            this.css.excludeTargetAtom(i);
            --pAtomCount;
        }
        return pAtomCount > 1;
    }

    private boolean allNeighborsMapped(Molecule m, int mappedAtom, int[] maps) {
        int[][] ctab = m.getCtab();
        for (int i = 0; i < ctab[mappedAtom].length; ++i) {
            if (maps[ctab[mappedAtom][i]] != 0) continue;
            return false;
        }
        return true;
    }

    private int getMCSSize(int[] mcsMap) {
        if (mcsMap == null) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < mcsMap.length; ++i) {
            size += mcsMap[i] != -1 ? 1 : 0;
        }
        return size;
    }

    private void appendMCSMap(int reacFragId, int prodFragId, int[] mcsMap) {
        for (int i = 0; i < mcsMap.length; ++i) {
            if (mcsMap[i] == -1 || this.isReactantAtomMapped(this.idsToCompositeId(reacFragId, i)) || this.isProductAtomMapped(this.idsToCompositeId(prodFragId, mcsMap[i])) || !this.sortedReactants[reacFragId].getAtom(i).isMappable() || !this.reaction.getProduct(prodFragId).getAtom(mcsMap[i]).isMappable() || this.sortedReactants[reacFragId].getAtom(i).getAtno() != this.reaction.getProduct(prodFragId).getAtom(mcsMap[i]).getAtno()) continue;
            this.mcsMappedAtoms[this.mcsMappedAtomCount][0] = this.idsToCompositeId(reacFragId, i);
            this.mcsMappedAtoms[this.mcsMappedAtomCount][1] = this.idsToCompositeId(prodFragId, mcsMap[i]);
            ++this.mcsMappedAtomCount;
            int mapIndex = this.nextMapIndex(this.fixedMapIndex);
            this.fixedMapIndex[mapIndex] = true;
            this.reactantAtomMap[reacFragId][i] = mapIndex;
            this.productAtomMap[prodFragId][mcsMap[i]] = mapIndex;
        }
    }

    private boolean isReactantAtomMapped(int compositeId) {
        return this.isAtomMapped(compositeId, 0);
    }

    private boolean isProductAtomMapped(int compositeId) {
        return this.isAtomMapped(compositeId, 1);
    }

    private boolean isAtomMapped(int compositeId, int side) {
        int i;
        for (i = 0; i < this.preMappedAtomCount; ++i) {
            if (this.preMappedAtoms[i][side] != compositeId) continue;
            return true;
        }
        for (i = 0; i < this.mcsMappedAtomCount; ++i) {
            if (this.mcsMappedAtoms[i][side] != compositeId) continue;
            return true;
        }
        return false;
    }

    private Molecule[] sortReactants() {
        Molecule ri;
        int i;
        Molecule[] sortedReactants = new Molecule[this.reaction.getReactantCount()];
        int si = 0;
        for (i = 0; i < sortedReactants.length; ++i) {
            ri = this.reaction.getReactant(i);
            if (!this.containsRing(ri)) continue;
            sortedReactants[si++] = ri;
        }
        for (i = 0; i < sortedReactants.length; ++i) {
            ri = this.reaction.getReactant(i);
            if (this.containsRing(ri)) continue;
            sortedReactants[si++] = ri;
        }
        return sortedReactants;
    }

    private boolean addAtomToBacktracking(int compositeId, MolAtom ra) {
        int pos;
        boolean isWi;
        int atomNumber = ra.getAtno();
        int atomMassno = ra.getMassno();
        int atomCount = 0;
        this.embeddedIterator.setProductSide();
        this.embeddedIterator.reset();
        while (this.embeddedIterator.hasNext()) {
            int compId;
            MolAtom pa = this.embeddedIterator.getAtom();
            if (pa.getAtno() == atomNumber && pa.getMassno() == atomMassno && !this.isProductAtomMapped(compId = this.idsToCompositeId(this.embeddedIterator.getFragId(), this.embeddedIterator.getAtomId())) && pa.isMappable() && !this.isProductAtomMapped(compId) && pa.isMappable()) {
                this.productAtoms[atomCount++] = compId;
            }
            this.embeddedIterator.next();
        }
        boolean bl = isWi = this.getAtomCount(atomNumber, atomMassno, false) > this.getAtomCount(atomNumber, atomMassno, true);
        if (atomCount == 0) {
            return false;
        }
        for (pos = 0; pos < this.currentSize && this.baseNumber[pos] < atomCount; ++pos) {
        }
        for (int i = this.currentSize; i > pos; --i) {
            this.baseNumber[i] = this.baseNumber[i - 1];
            this.isWidow[i] = this.isWidow[i - 1];
            this.positionToReactantAtom[i] = this.positionToReactantAtom[i - 1];
            System.arraycopy(this.valueToProductAtom[i - 1], 0, this.valueToProductAtom[i], 0, this.valueToProductAtom[i - 1].length);
        }
        this.isWidow[pos] = isWi;
        this.baseNumber[pos] = atomCount;
        this.positionToReactantAtom[pos] = compositeId;
        System.arraycopy(this.productAtoms, 0, this.valueToProductAtom[pos], 0, atomCount - (isWi ? 1 : 0));
        ++this.currentSize;
        return true;
    }

    private void resetMapIndex() {
        this.currentMapIndex = 0;
    }

    private int nextMapIndex(boolean[] inUse) {
        while (inUse[++this.currentMapIndex] || this.currentMapIndex == 0) {
        }
        return this.currentMapIndex;
    }

    private int getAtomCount(int atomNumber, int atomMassno, boolean product) {
        int atomCount = 0;
        this.embeddedIterator.setSide(!product);
        this.embeddedIterator.reset();
        while (this.embeddedIterator.hasNext()) {
            MolAtom atom = this.embeddedIterator.getAtom();
            if (atom.getAtno() == atomNumber && atom.getMassno() == atomMassno && !this.isAtomMapped(this.idsToCompositeId(this.embeddedIterator.getFragId(), this.embeddedIterator.getAtomId()), product ? 1 : 0)) {
                ++atomCount;
            }
            this.embeddedIterator.next();
        }
        return atomCount;
    }

    private int idsToCompositeId(int fragmentIndex, int atomIndex) {
        return (fragmentIndex << 10) + atomIndex;
    }

    private int compositeIdToFragId(int compositeIndex) {
        return compositeIndex >> 10;
    }

    private int compositeIdToAtomId(int compositeIndex) {
        return compositeIndex & 0x3FF;
    }

    private void calcProblemSize() {
        this.reactantAtomCount = 0;
        for (int reacFragId = 0; reacFragId < this.reaction.getReactantCount(); ++reacFragId) {
            Molecule reactant = this.sortedReactants[reacFragId];
            this.reactantAtomCount += reactant.getAtomCount();
        }
        this.productAtomCount = 0;
        for (int prodFragId = 0; prodFragId < this.reaction.getProductCount(); ++prodFragId) {
            Molecule product = this.reaction.getProduct(prodFragId);
            this.productAtomCount += product.getAtomCount();
        }
        int rCarbonCount = 0;
        this.iterator.setReactantSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            MolAtom ra = this.iterator.getAtom();
            if (ra.getAtomMap() > this.maxMapIndex) {
                this.maxMapIndex = this.iterator.getAtom().getAtomMap();
            }
            rCarbonCount += ra.getAtno() == 6 ? 1 : 0;
            this.iterator.next();
        }
        int pCarbonCount = 0;
        this.iterator.setProductSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            MolAtom pa = this.iterator.getAtom();
            if (pa.getAtomMap() > this.maxMapIndex) {
                this.maxMapIndex = this.iterator.getAtom().getAtomMap();
            }
            pCarbonCount += pa.getAtno() == 6 ? 1 : 0;
            this.iterator.next();
        }
        this.maxMapIndex += this.productAtomCount + this.reactantAtomCount + 1;
    }

    private boolean containsRing(Molecule m) {
        this.ringFinder.classify(m);
        for (int i = 0; i < m.getAtomCount(); ++i) {
            if (!this.ringFinder.isRingAtom(i)) continue;
            return true;
        }
        return false;
    }

    private void alloc() {
        int mapMatSize = this.maxMapIndex * (this.maxMapIndex - 1) / 2;
        if (this.state == null || this.state.length < this.reactantAtomCount) {
            this.state = new int[this.reactantAtomCount];
            this.baseNumber = new int[this.reactantAtomCount];
            this.isWidow = new boolean[this.reactantAtomCount];
            this.positionToReactantAtom = new int[this.reactantAtomCount];
            this.valueToProductAtom = new int[this.reactantAtomCount][this.productAtomCount + 1];
            this.productAtomMap = new int[10][this.productAtomCount];
            this.reactantAtomMap = new int[10][this.reactantAtomCount];
            this.productAtoms = new int[this.productAtomCount];
            this.maps = new int[10][this.reactantAtomCount];
            this.preMappedAtoms = new int[this.maxMapIndex][2];
            this.mcsMappedAtoms = new int[this.reactantAtomCount][2];
            this.scores = new float[10];
            this.steps = new long[10];
            this.reactantMapMatrix = new int[mapMatSize];
            this.productMapMatrix = new int[mapMatSize];
            return;
        }
        this.clear(this.state);
        this.clear(this.baseNumber);
        this.clear(this.isWidow);
        this.clear(this.positionToReactantAtom);
        this.clear(this.valueToProductAtom);
        this.clear(this.productAtomMap);
        this.clear(this.reactantAtomMap);
        this.clear(this.productAtoms);
        this.clear(this.maps);
        this.clear(this.preMappedAtoms);
        this.clear(this.mcsMappedAtoms);
        this.clear(this.scores);
        this.clear(this.steps);
        this.clear(this.reactantMapMatrix);
        this.clear(this.productMapMatrix);
        int minSize = this.productAtomMap[0].length;
        for (int k = 1; k < 10; ++k) {
            if (minSize <= this.productAtomMap[k].length) continue;
            minSize = this.productAtomMap[k].length;
        }
        if (this.productAtomCount > minSize) {
            this.valueToProductAtom = new int[this.state.length][this.productAtomCount + 1];
            this.preMappedAtoms = new int[this.reactantAtomCount + this.productAtomCount][2];
            this.productAtomMap = new int[10][this.productAtomCount];
            this.productAtoms = new int[this.productAtomCount];
        } else {
            this.clear(this.valueToProductAtom);
            this.clear(this.preMappedAtoms);
            this.clear(this.productAtomMap);
            this.clear(this.productAtoms);
        }
        if (mapMatSize > this.productMapMatrix.length) {
            this.productMapMatrix = new int[mapMatSize];
            this.reactantMapMatrix = new int[mapMatSize];
        } else {
            this.clear(this.productMapMatrix);
            this.clear(this.reactantMapMatrix);
        }
    }

    private void clear(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = 0;
        }
    }

    private void clear(long[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = 0L;
        }
    }

    private void clear(int[][] a) {
        for (int i = 0; i < a.length; ++i) {
            this.clear(a[i]);
        }
    }

    private void clear(boolean[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = false;
        }
    }

    private void clear(float[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = 0.0f;
        }
    }

    protected void dump() {
        int j;
        int i;
        System.out.println("=== AutoMapper.dump ===");
        System.out.println("size = " + this.size);
        System.out.println("currentSize = " + this.currentSize);
        System.out.println("reactantAtomCount = " + this.reactantAtomCount);
        System.out.println("productAtomCount = " + this.productAtomCount);
        System.out.println("maxMapIndex = " + this.maxMapIndex);
        System.out.println("preMappedAtomCount = " + this.preMappedAtomCount);
        System.out.println("mcsMappedAtomCount = " + this.mcsMappedAtomCount);
        System.out.print("preMappedAtoms = ");
        for (i = 0; i < this.preMappedAtomCount; ++i) {
            System.out.print(this.compositeIdToString(this.preMappedAtoms[i][0]) + " -> " + this.compositeIdToString(this.preMappedAtoms[i][1]) + " ");
        }
        System.out.println();
        System.out.print("mcsMappedAtoms = ");
        for (i = 0; i < this.mcsMappedAtomCount; ++i) {
            System.out.print(this.compositeIdToString(this.mcsMappedAtoms[i][0]) + " -> " + this.compositeIdToString(this.mcsMappedAtoms[i][1]) + " ");
        }
        System.out.println();
        this.iterator.setReactantSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            System.out.println("reactantAtomMap[ " + this.iterator.getFragId() + " ][ " + this.iterator.getAtomId() + " ] = " + this.reactantAtomMap[this.iterator.getFragId()][this.iterator.getAtomId()]);
            this.iterator.next();
        }
        this.iterator.setProductSide();
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            System.out.println("productAtomMap[ " + this.iterator.getFragId() + " ][ " + this.iterator.getAtomId() + " ] = " + this.productAtomMap[this.iterator.getFragId()][this.iterator.getAtomId()]);
            this.iterator.next();
        }
        System.out.print("state = ");
        for (i = 0; i < this.size; ++i) {
            System.out.print(this.state[i] + ", ");
        }
        System.out.println();
        System.out.print("baseNumber = ");
        for (i = 0; i < this.size; ++i) {
            System.out.print(this.baseNumber[i] + ", ");
        }
        System.out.println();
        System.out.print("positionToReactantAtom = ");
        for (i = 0; i < this.size; ++i) {
            System.out.print(this.compositeIdToString(this.positionToReactantAtom[i]) + ", ");
        }
        System.out.println();
        System.out.println("valueToProductAtom = ");
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.baseNumber[i]; ++j) {
                System.out.print(this.compositeIdToString(this.valueToProductAtom[i][j]) + ", ");
            }
            System.out.println();
        }
        System.out.println("productMapMatrix[][] = ");
        for (i = 0; i < this.maxMapIndex; ++i) {
            for (j = 0; j < i; ++j) {
                System.out.print(this.productMapMatrix[i * (i - 1) / 2 + j] + " ");
            }
            System.out.println();
        }
        System.out.println("reactantMapMatrix[][] = ");
        for (i = 0; i < this.maxMapIndex; ++i) {
            for (j = 0; j < i; ++j) {
                System.out.print(this.reactantMapMatrix[i * (i - 1) / 2 + j] + " ");
            }
            System.out.println();
        }
        System.out.println("maps=");
        for (i = 0; i < this.storedMapsCount; ++i) {
            System.out.print("scores[" + i + "]=" + this.scores[i] + " at step: " + this.steps[i] + " map = ");
            for (j = 0; j < this.size; ++j) {
                System.out.print(this.compositeIdToString(this.positionToReactantAtom[j]) + "->" + this.compositeIdToString(this.valueToProductAtom[j][this.maps[i][j]]) + ", ");
            }
            System.out.println();
        }
        System.out.println("=== ---- ===");
    }

    private String compositeIdToString(int val) {
        if (val == -1) {
            return "-1";
        }
        return this.compositeIdToFragId(val) + ":" + this.compositeIdToAtomId(val);
    }

    public static void clearMaps(RxnMolecule mol) {
        int a;
        Molecule m;
        int i;
        for (i = 0; i < mol.getProductCount(); ++i) {
            m = mol.getProduct(i);
            for (a = 0; a < m.getAtomCount(); ++a) {
                m.getAtom(a).setAtomMap(0);
            }
        }
        for (i = 0; i < mol.getReactantCount(); ++i) {
            m = mol.getReactant(i);
            for (a = 0; a < m.getAtomCount(); ++a) {
                m.getAtom(a).setAtomMap(0);
            }
        }
    }

    public static void main(String[] args) {
        String[] typeName = new String[]{"?", "ORPHANS", "CHEMAXON", "DAYLIGHT", "UNKNOWN", "UNMAPPED", "EITHER"};
        int mapped = 0;
        int c = 0;
        long tt = 0L;
        AutoMapper mapper = new AutoMapper();
        try {
            MolImporter imp = args.length > 0 ? new MolImporter(args[0]) : new MolImporter(System.in);
            RxnMolecule mol = new RxnMolecule();
            mapper.setMappingStyle(4);
            while (imp.read(mol)) {
                ++c;
                AutoMapper.clearMaps(mol);
                long t0 = System.currentTimeMillis();
                try {
                    AutoMapper.map(mol, 4);
                    System.out.println(mol.toFormat("smarts"));
                    AutoMapper.map(mol, 3);
                    System.out.println(mol.toFormat("smarts"));
                }
                catch (AutoMapperException ae) {
                    System.out.println("\n" + ae.getMessage());
                }
                long t1 = System.currentTimeMillis();
                tt += t1 - t0;
                if (mapper.getMapCount() != 0) {
                    System.out.print(", " + mol.getAtomCount() + " atom mapped in " + (t1 - t0) + " ms");
                    System.out.println(", " + mapper.getMapCount() + " unique mapping found.");
                    System.out.println("best map: " + mapper.getScore(0) + " " + mol.toFormat("smarts"));
                    mapper.dump();
                    ++mapped;
                } else {
                    System.out.println(" no mapping found!!!!");
                }
                System.out.println(mapper.getDiagnosticMessage(2));
                mol = new RxnMolecule();
            }
            if (c > 0) {
                System.out.println(c + " reactions processed, " + mapped + " mapped. Average mapping time: " + tt / (long)c + " ms");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mapper.css.dump();
            mapper.dump();
        }
    }

    private class RxnMoleculeAtomIterator {
        private RxnMolecule react;
        private boolean reactantSide;
        private int fragId = -1;
        private int atomId = -1;

        public void setRxnMolecule(RxnMolecule m) {
            this.react = m;
            this.react.setGUIContracted(true);
            this.reset();
        }

        public void setReactantSide() {
            this.reactantSide = true;
        }

        public void setProductSide() {
            this.reactantSide = false;
        }

        public void setSide(boolean reactantSide) {
            this.reactantSide = reactantSide;
        }

        public void reset() {
            this.fragId = 0;
            this.atomId = 0;
        }

        public boolean hasNext() {
            Molecule m;
            if (this.fragId >= (this.reactantSide ? this.react.getReactantCount() : this.react.getProductCount())) {
                return false;
            }
            Molecule molecule = m = this.reactantSide ? AutoMapper.this.sortedReactants[this.fragId] : this.react.getProduct(this.fragId);
            if (this.atomId < m.getAtomCount()) {
                return true;
            }
            return this.fragId + 1 < (this.reactantSide ? this.react.getReactantCount() : this.react.getProductCount());
        }

        public int getFragId() {
            return this.fragId;
        }

        public int getAtomId() {
            return this.atomId;
        }

        public MolAtom getAtom() {
            return this.reactantSide ? AutoMapper.this.sortedReactants[this.fragId].getAtom(this.atomId) : this.react.getProduct(this.fragId).getAtom(this.atomId);
        }

        public Molecule getFragment() {
            return this.reactantSide ? AutoMapper.this.sortedReactants[this.fragId] : this.react.getProduct(this.fragId);
        }

        public void next() {
            Molecule m;
            Molecule molecule = m = this.reactantSide ? AutoMapper.this.sortedReactants[this.fragId] : this.react.getProduct(this.fragId);
            if (++this.atomId == m.getAtomCount()) {
                this.atomId = 0;
                ++this.fragId;
            }
        }
    }
}

