/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules;

import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.util.Vector;

public class BondsFromCoords
implements CallbackIface {
    private static int[] maxBonds0 = new int[256];
    private int[] maxBonds;
    private double bondFudge;
    private int xyzBonds;

    public void initParser() {
        this.maxBonds = new int[256];
        for (int i = 0; i < this.maxBonds.length; ++i) {
            this.maxBonds[i] = Integer.MAX_VALUE;
        }
        this.bondFudge = 1.12;
        this.xyzBonds = 0;
    }

    public int parseOption(String opts, int i) {
        char c = opts.charAt(i);
        if (c == 'b') {
            this.xyzBonds = 1;
            ++i;
        } else if (c == 'f') {
            int j;
            for (j = i + 1; j < opts.length() && ((c = opts.charAt(j)) == '.' || c >= '0' && c <= '9'); ++j) {
            }
            if (j > i + 1) {
                try {
                    String s = opts.substring(i + 1, j);
                    this.bondFudge = Double.valueOf(s);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                i = j - 1;
            }
            ++i;
        } else if (c >= 'A' && c <= 'Z' && i < opts.length() - 1) {
            String s;
            int atno;
            int j;
            for (j = i; j < opts.length() - 1 && ((c = opts.charAt(j)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z'); ++j) {
            }
            if (j > i && (atno = MolAtom.numOf(s = opts.substring(i, j))) > 0) {
                i = j;
                int max = 0;
                while (j < opts.length() && (c = opts.charAt(j)) >= '0' && c <= '9') {
                    max = 10 * max + (c - 48);
                    ++j;
                }
                if (j > i) {
                    this.maxBonds[atno] = max;
                }
                i = j - 1;
            }
            ++i;
        }
        return i;
    }

    public boolean getFixBonds() {
        return this.xyzBonds != 0;
    }

    public void calc(Molecule mol) {
        BondsFromCoords.calc(mol, this.bondFudge, this.xyzBonds, this.maxBonds);
    }

    @Override
    public Object callback(String method, Object arg) {
        Object[] args = (Object[])arg;
        double bondFudge = (Double)args[1];
        int xyzBonds = (Integer)args[2];
        int[] maxBonds = (int[])args[3];
        if (args[0] instanceof Molecule[]) {
            Molecule[] mols = (Molecule[])args[0];
            if (mols != null) {
                for (int i = 0; i < mols.length; ++i) {
                    BondsFromCoords.calc(mols[i], bondFudge, xyzBonds, maxBonds);
                }
            }
        } else {
            Molecule mol = (Molecule)args[0];
            if (mol != null) {
                BondsFromCoords.calc(mol, bondFudge, xyzBonds, maxBonds);
            }
        }
        return null;
    }

    public static void calc(Molecule mol, double bondFudge, int xyzBonds, int[] maxBonds) {
        int i;
        if (maxBonds == null) {
            maxBonds = maxBonds0;
        }
        DPoint3 min = new DPoint3(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        DPoint3 max = new DPoint3(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        int na = mol.getAtomCount();
        int[] cellIx = new int[na];
        int[] cellIy = new int[na];
        int[] cellIz = new int[na];
        Vector[][][] vv = BondsFromCoords.createCells(mol, cellIx, cellIy, cellIz);
        for (i = 0; i < na; ++i) {
            MolAtom a0 = mol.getAtom(i);
            int ix = cellIx[i];
            int iy = cellIy[i];
            int iz = cellIz[i];
            int minjx = ix > 0 ? ix - 1 : 0;
            int minjy = iy > 0 ? iy - 1 : 0;
            int minjz = iz > 0 ? iz - 1 : 0;
            int maxjx = ix < vv.length - 1 ? ix + 1 : vv.length - 1;
            int maxjy = iy < vv[0].length - 1 ? iy + 1 : vv[0].length - 1;
            int maxjz = iz < vv[0][0].length - 1 ? iz + 1 : vv[0][0].length - 1;
            for (int jx = minjx; jx <= maxjx; ++jx) {
                for (int jy = minjy; jy <= maxjy; ++jy) {
                    for (int jz = minjz; jz <= maxjz; ++jz) {
                        int k;
                        Vector v = vv[jx][jy][jz];
                        if (v == null) continue;
                        for (int j = v.size() - 1; j >= 0 && (k = ((Integer)v.elementAt(j)).intValue()) > i; --j) {
                            MolAtom a = mol.getAtom(k);
                            BondsFromCoords.tryToBond(mol, a0, a, bondFudge, xyzBonds);
                        }
                    }
                }
            }
        }
        BondsFromCoords.fixBondMax(mol, maxBonds);
        if (xyzBonds == 0) {
            for (i = 0; i < na; ++i) {
                MolAtom a = mol.getAtom(i);
                a.setCharge(0);
                a.setImplicitHcount(0);
            }
            mol.setProperty("anyBondsFromCoords", "true");
        } else if (xyzBonds > 0) {
            BondsFromCoords.fixIonCharges(mol);
            mol.valenceCheck();
            BondsFromCoords.fixBondTypes(mol);
            mol.setProperty("anyBondsFromCoords", null);
        }
    }

    private static Vector[][][] createCells(MoleculeGraph m, int[] cellIx, int[] cellIy, int[] cellIz) {
        int na = m.getAtomCount();
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minz = Double.MAX_VALUE;
        double maxx = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        double maxz = -1.7976931348623157E308;
        for (int i = 0; i < na; ++i) {
            MolAtom a = m.getAtom(i);
            double x = a.getX();
            double y = a.getY();
            double z = a.getZ();
            if (x < minx) {
                minx = x;
            }
            if (y < miny) {
                miny = y;
            }
            if (z < minz) {
                minz = z;
            }
            if (x > maxx) {
                maxx = x;
            }
            if (y > maxy) {
                maxy = y;
            }
            if (!(z > maxz)) continue;
            maxz = z;
        }
        double wx = maxx - minx;
        double wy = maxy - miny;
        double wz = maxz - minz;
        double d = Math.pow(wx * wy * wz / (double)na, 0.3333333333333333);
        if (d < 5.0) {
            d = 5.0;
        }
        int nx = (int)(wx / d + 0.5);
        int ny = (int)(wy / d + 0.5);
        int nz = (int)(wz / d + 0.5);
        if (nx == 0) {
            nx = 1;
        }
        if (ny == 0) {
            ny = 1;
        }
        if (nz == 0) {
            nz = 1;
        }
        Vector[][][] vv = new Vector[nx][ny][nz];
        wx += 0.001;
        wy += 0.001;
        wz += 0.001;
        for (int i = 0; i < na; ++i) {
            int iz;
            int iy;
            MolAtom a = m.getAtom(i);
            int ix = (int)((double)nx * (a.getX() - minx) / wx);
            Vector<Integer> v = vv[ix][iy = (int)((double)ny * (a.getY() - miny) / wy)][iz = (int)((double)nz * (a.getZ() - minz) / wz)];
            if (v == null) {
                vv[ix][iy][iz] = v = new Vector<Integer>();
            }
            v.addElement(new Integer(i));
            cellIx[i] = ix;
            cellIy[i] = iy;
            cellIz[i] = iz;
        }
        return vv;
    }

    private static void tryToBond(MoleculeGraph m, MolAtom a0, MolAtom a, double bondFudge, int xyzBonds) {
        double d;
        double z;
        double y;
        double x = a.getX() - a0.getX();
        double rsq = x * x + (y = a.getY() - a0.getY()) * y + (z = a.getZ() - a0.getZ()) * z;
        if (rsq < (d = m.getDesiredLength(a0.getAtno(), a.getAtno(), 1) * bondFudge) * d) {
            MolBond b = new MolBond(a0, a);
            int type = xyzBonds == 0 ? 0 : b.calcOrderFromLength();
            b.setFlags(type);
            m.add(b);
        }
    }

    private static void fixBondMax(Molecule mol, int[] maxBonds) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            int max;
            MolAtom atom = mol.getAtom(i);
            int a = atom.getAtno();
            int nb = atom.getBondCount();
            if (nb < (max = maxBonds[a])) continue;
            while (nb > max) {
                MolBond bmax = atom.getBond(0);
                double lmax = bmax.getLength() / mol.getDesiredLength(bmax);
                for (int j = 1; j < nb; ++j) {
                    MolBond b = atom.getBond(j);
                    double l = b.getLength() / mol.getDesiredLength(b);
                    if (!(l > lmax)) continue;
                    bmax = b;
                    lmax = l;
                }
                mol.removeBond(bmax);
                --nb;
            }
            for (int j = 0; j < nb; ++j) {
                MolBond b = atom.getBond(j);
                b.setFlags(1);
            }
        }
    }

    private static void fixIonCharges(Molecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom a = mol.getAtom(i);
            int Z = a.getAtno();
            if (a.getBondCount() != 0 || Z == 6) continue;
            a.setCharge(MolAtom.ionChargeOf(Z));
        }
    }

    private static void fixBondTypes(Molecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            int t;
            MolBond b;
            int j;
            MolAtom a = mol.getAtom(i);
            if (a.hasValenceError() || a.getImplicitHcount() != 0) {
                for (j = 0; j < a.getBondCount(); ++j) {
                    b = a.getBond(j);
                    if (b.getType() != 3) continue;
                    t = b.calcOrderFromValence();
                    b.setType(t);
                }
            }
            if (a.hasValenceError() || a.getImplicitHcount() != 0) {
                for (j = 0; j < a.getBondCount(); ++j) {
                    b = a.getBond(j);
                    t = b.calcOrderFromValence();
                    b.setType(t);
                }
            }
            BondsFromCoords.fixNplusCH(a);
        }
    }

    private static void fixNplusCH(MolAtom a) {
        int negox;
        int chg = a.getCharge();
        int n = negox = a.getAtno() >= 0 && a.getAtno() < 116 ? MolAtom.negOxOf(a.getAtno()) : 0;
        if (negox == 0) {
            chg = -chg;
        }
        if (chg == 1) {
            for (int j = 0; j < a.getBondCount(); ++j) {
                MolBond b = a.getBond(j);
                MolAtom aa = b.getOtherAtom(a);
                if (b.getType() != 1 || aa.getImplicitHcount() != chg) continue;
                b.setType(2);
                a.setCharge(0);
            }
        }
    }

    static {
        for (int i = 0; i < maxBonds0.length; ++i) {
            BondsFromCoords.maxBonds0[i] = Integer.MAX_VALUE;
        }
    }
}

