/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules;

import chemaxon.core.calculations.ElementalAnalysisCalc;
import chemaxon.core.util.BondTable;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.Vector;

public class CommonStructureSearch {
    public static final int DEFAULT_MIN_COMMON_SIZE = 3;
    private Molecule targetMol = null;
    private Molecule queryMol = null;
    private boolean queryMolChanged = true;
    private int minCommonSize = 3;
    private int maxCommonSize = 0;
    private boolean ignoreAtomType = false;
    private boolean ignoreBondType = false;
    private boolean ignoreCharge = true;
    private boolean ignoreHybridization = true;
    private boolean ignoreIsotopes = true;
    private boolean ignoreQueryProperties = true;
    private boolean[] allowedQueryAtoms = null;
    private boolean[] allowedTargetAtoms = null;
    private boolean mcsMode = false;
    private boolean mcesMode = true;
    private boolean sssMode = false;
    private boolean fastMode = false;
    private double complexityThreshold = 1.0E100;
    private boolean allowedDisjoint = false;
    private BondTable connectionMatrix = null;
    private MolAtom[] molAtom = null;
    private int[] mcs = null;
    private int[] startBFSFromAtom = null;
    private Molecule substruct = null;
    private Vector allHits = new Vector();
    private int treeSize = 0;
    private int[] route = null;
    private boolean[] visited = null;
    private Queue visitQueue = new Queue();
    private boolean[] adequateAtoms = null;
    private int[] baseNumber = null;
    private int[] state = null;
    private boolean carry = false;
    private int pos = 0;
    private int[][] valueToTargetAtomIndex = null;
    private int[] parentQueryNode = null;
    private int startingNode = -1;
    private int brokenAt = -1;
    private int continuedAt = -1;
    private boolean[] targetAtomMapped = null;
    private boolean[] mappedAtPos = null;
    private int[] queryAtomIndexToPos = null;
    private int currentMapSize = 0;
    private int currentMaxCommonSize = 0;
    private boolean solutionFound = false;
    private ElementalAnalysisCalc elemAnal = new ElementalAnalysisCalc();
    private int[] ringCountOfAtoms = null;
    private boolean isRingCountOfAtomsSet = false;

    public void setMolecules(Molecule query, Molecule target) {
        this.queryMol = query;
        this.queryMolChanged = true;
        this.targetMol = target;
        this.allowedQueryAtoms = null;
        this.allowedTargetAtoms = null;
    }

    public void setQuery(Molecule query) {
        this.queryMol = query;
        this.allowedQueryAtoms = null;
        this.queryMolChanged = true;
    }

    public void setTarget(Molecule target) {
        this.targetMol = target;
        this.allowedTargetAtoms = null;
    }

    public void setMinimumCommonSize(int minMCSsize) {
        this.minCommonSize = minMCSsize;
    }

    public void setIgnoreAtomType(boolean ignore) {
        this.ignoreAtomType = ignore;
    }

    public void setIgnoreHybridization(boolean ignore) {
        this.ignoreHybridization = ignore;
    }

    public void setIgnoreCharge(boolean ignore) {
        this.ignoreCharge = ignore;
    }

    public void setIgnoreIsotopes(boolean ignore) {
        this.ignoreIsotopes = ignore;
    }

    public void setIgnoreBondType(boolean ignore) {
        this.ignoreBondType = ignore;
    }

    public void setIgnoreQueryProperties(boolean ignore) {
        this.ignoreQueryProperties = ignore;
    }

    public void restrictMatching(int[] targetAtoms) {
        this.allowedTargetAtoms = new boolean[this.targetMol.getAtomCount()];
        for (int i = 0; i < targetAtoms.length; ++i) {
            this.allowedTargetAtoms[targetAtoms[i]] = true;
        }
    }

    public void excludeAtoms(int[] excludedQueryAtoms, int[] excludedTargetAtoms) {
        int i;
        if (this.allowedQueryAtoms == null) {
            this.allowedQueryAtoms = new boolean[this.queryMol.getAtomCount()];
            this.fill(this.allowedQueryAtoms, true);
        }
        if (this.allowedTargetAtoms == null) {
            this.allowedTargetAtoms = new boolean[this.targetMol.getAtomCount()];
            this.fill(this.allowedQueryAtoms, true);
        }
        for (i = 0; i < excludedQueryAtoms.length; ++i) {
            this.allowedQueryAtoms[excludedQueryAtoms[i]] = false;
        }
        for (i = 0; i < excludedTargetAtoms.length; ++i) {
            this.allowedTargetAtoms[excludedTargetAtoms[i]] = false;
        }
    }

    public void excludeQueryAtom(int excludedQueryAtom) {
        if (this.allowedQueryAtoms == null) {
            this.allowedQueryAtoms = new boolean[this.queryMol.getAtomCount()];
            this.fill(this.allowedQueryAtoms, true);
        }
        this.allowedQueryAtoms[excludedQueryAtom] = false;
    }

    public void excludeTargetAtom(int excludedTargetAtom) {
        if (this.allowedTargetAtoms == null) {
            this.allowedTargetAtoms = new boolean[this.targetMol.getAtomCount()];
            this.fill(this.allowedTargetAtoms, true);
        }
        this.allowedTargetAtoms[excludedTargetAtom] = false;
    }

    public void setFastSearch(boolean fastSearch) {
        this.fastMode = fastSearch;
    }

    public void setMCSMode(boolean mcsMode) {
        this.clearModeFlags();
        this.mcsMode = mcsMode;
    }

    public void setMCESMode(boolean mcesMode) {
        this.clearModeFlags();
        this.mcesMode = mcesMode;
    }

    public void setSSSMode(boolean sssMode) {
        this.clearModeFlags();
        this.sssMode = sssMode;
        this.ignoreBondType = false;
        this.ignoreAtomType = false;
        this.ignoreCharge = true;
        this.ignoreHybridization = true;
    }

    public boolean search() {
        if (this.sssMode && this.queryMol.getAtomCount() > this.targetMol.getAtomCount()) {
            return false;
        }
        this.init();
        for (int sn = 0; sn < this.queryMol.getAtomCount(); ++sn) {
            if (this.startBFSFromAtom[sn] == -1) continue;
            this.createSpannigTree(this.startBFSFromAtom[sn]);
            this.setupConstrainedBacktrack();
            if (this.estimatedComplexity() > this.complexityThreshold) {
                return false;
            }
            this.carry = false;
            this.pos = 0;
            while (!this.carry) {
                if (this.find() && this.solutionFound) {
                    return true;
                }
                this.next();
            }
        }
        return this.mcs != null;
    }

    public boolean findFirst() {
        if (this.sssMode && this.queryMol.getAtomCount() > this.targetMol.getAtomCount()) {
            return false;
        }
        this.init();
        this.startingNode = 0;
        while (this.startingNode < this.queryMol.getAtomCount()) {
            if (this.startBFSFromAtom[this.startingNode] != -1) {
                this.createSpannigTree(this.startBFSFromAtom[this.startingNode]);
                this.setupConstrainedBacktrack();
                this.carry = false;
                this.pos = 0;
                while (!this.carry) {
                    if (this.find() && this.solutionFound) {
                        return true;
                    }
                    this.next();
                }
            }
            ++this.startingNode;
        }
        return this.mcs != null;
    }

    public boolean findNext() {
        if (this.startingNode == this.queryMol.getAtomCount()) {
            return false;
        }
        this.solutionFound = false;
        this.mcs = null;
        if (!this.carry) {
            this.next();
        }
        while (true) {
            if (!this.carry) {
                if (this.find() && this.solutionFound) {
                    return true;
                }
                this.next();
                continue;
            }
            this.carry = false;
            this.pos = 0;
            ++this.startingNode;
            if (this.startingNode == this.queryMol.getAtomCount()) {
                return this.mcs != null;
            }
            if (this.startBFSFromAtom[this.startingNode] == -1) continue;
            this.createSpannigTree(this.startBFSFromAtom[this.startingNode]);
            this.setupConstrainedBacktrack();
        }
    }

    public int[] getResult() {
        return this.mcs;
    }

    public int getResultSize() {
        return this.currentMaxCommonSize;
    }

    public String getResultAsSmiles(boolean unique) {
        if (this.mcs == null) {
            return null;
        }
        return this.extractSubstructure(this.mcs, unique);
    }

    public Molecule getResultAsMolecule() {
        if (this.mcs == null) {
            return null;
        }
        this.extractSubstructure(this.mcs, false);
        return this.substruct;
    }

    public MolAtom[] getResultQueryAtoms() {
        if (this.mcs == null) {
            return null;
        }
        MolAtom[] resultAtoms = new MolAtom[this.currentMaxCommonSize];
        for (int i = 0; i < this.mcs.length; ++i) {
            if (this.mcs[i] == -1) continue;
            resultAtoms[i] = this.queryMol.getAtom(i);
        }
        return resultAtoms;
    }

    public MolAtom[] getResultTargetAtoms() {
        if (this.mcs == null) {
            return null;
        }
        MolAtom[] resultAtoms = new MolAtom[this.currentMaxCommonSize];
        for (int i = 0; i < this.mcs.length; ++i) {
            if (this.mcs[i] == -1) continue;
            resultAtoms[i] = this.queryMol.getAtom(this.mcs[i]);
        }
        return resultAtoms;
    }

    public MolBond[] getResultQueryBonds() {
        if (this.mcs == null) {
            return null;
        }
        BondTable btab = this.connectionMatrix;
        int bondCount = 0;
        for (int i = 0; i < btab.getAtomCount(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (btab.getBondIndex(i, j) == -1) continue;
                bondCount += this.queryBondInMCS(i, j) ? 1 : 0;
            }
        }
        MolBond[] resultBonds = new MolBond[bondCount];
        int bc = 0;
        for (int i = 0; i < this.queryMol.getAtomCount(); ++i) {
            MolAtom atomi = this.queryMol.getAtom(i);
            for (int j = 0; j < atomi.getBondCount(); ++j) {
                MolBond bondj = atomi.getBond(j);
                int a1 = this.queryMol.indexOf(bondj.getAtom1());
                int a2 = this.queryMol.indexOf(bondj.getAtom2());
                if (!this.queryBondInMCS(i, a1 != i ? a1 : a2) || this.inBondList(bondj, resultBonds, bc)) continue;
                resultBonds[bc++] = bondj;
            }
        }
        return resultBonds;
    }

    public MolBond[] getResultTargetBonds() {
        if (this.mcs == null) {
            return null;
        }
        BondTable btab = this.targetMol.getBondTable();
        int bondCount = 0;
        for (int i = 0; i < btab.getAtomCount(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (btab.getBondIndex(i, j) == -1) continue;
                bondCount += this.targetBondInMCS(i, j) ? 1 : 0;
            }
        }
        MolBond[] resultBonds = new MolBond[bondCount];
        int bc = 0;
        for (int i = 0; i < this.targetMol.getAtomCount(); ++i) {
            MolAtom atomi = this.targetMol.getAtom(i);
            for (int j = 0; j < atomi.getBondCount(); ++j) {
                MolBond bondj = atomi.getBond(j);
                int a1 = this.targetMol.indexOf(bondj.getAtom1());
                int a2 = this.targetMol.indexOf(bondj.getAtom2());
                if (!this.targetBondInMCS(i, a1 != i ? a1 : a2) || this.inBondList(bondj, resultBonds, bc)) continue;
                resultBonds[bc++] = bondj;
            }
        }
        return resultBonds;
    }

    private boolean inBondList(MolBond b, MolBond[] l, int s) {
        for (int i = 0; i < s; ++i) {
            if (b.getAtom1() == l[i].getAtom1() && b.getAtom2() == l[i].getAtom2()) {
                return true;
            }
            if (b.getAtom1() != l[i].getAtom2() || b.getAtom2() != l[i].getAtom1()) continue;
            return true;
        }
        return false;
    }

    private boolean queryBondInMCS(int a1, int a2) {
        boolean bondInMCS;
        boolean bl = bondInMCS = this.mcs[a1] != -1 && this.mcs[a2] != -1;
        if (!bondInMCS) {
            return false;
        }
        int ta1 = this.mcs[a1];
        int ta2 = this.mcs[a2];
        int tbi = this.targetMol.getBondTable().getBondIndex(ta1, ta2);
        if (tbi == -1) {
            return false;
        }
        int qbi = this.connectionMatrix.getBondIndex(a1, a2);
        return this.ignoreBondType ? true : this.matchBonds(qbi, tbi);
    }

    private boolean targetBondInMCS(int ta1, int ta2) {
        int a2;
        int a1;
        for (a1 = 0; a1 < this.mcs.length && this.mcs[a1] != ta1; ++a1) {
        }
        if (a1 == this.mcs.length) {
            return false;
        }
        for (a2 = 0; a2 < this.mcs.length && this.mcs[a2] != ta2; ++a2) {
        }
        if (a2 == this.mcs.length) {
            return false;
        }
        int qbi = this.connectionMatrix.getBondIndex(a1, a2);
        if (qbi == -1) {
            return false;
        }
        int tbi = this.targetMol.getBondTable().getBondIndex(ta1, ta2);
        return this.ignoreBondType ? true : this.matchBonds(qbi, tbi);
    }

    private void clearModeFlags() {
        this.sssMode = false;
        this.mcsMode = false;
        this.mcesMode = false;
    }

    private boolean find() {
        while (this.pos != this.treeSize) {
            if (!this.good()) {
                return false;
            }
            if (this.currentMapSize >= this.minCommonSize) {
                this.addCommonSubstructure();
            }
            ++this.pos;
        }
        --this.pos;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean good() {
        int predecessorPos;
        int targetAtom = this.valueToTargetAtomIndex[this.pos][this.state[this.pos]];
        if (this.pos == 0) {
            if (this.state[this.pos] == this.baseNumber[this.pos] - 1) {
                return false;
            }
            if (!this.matchAtoms(this.route[this.pos], targetAtom)) {
                return false;
            }
            this.targetAtomMapped[targetAtom] = true;
            this.mappedAtPos[this.pos] = true;
            ++this.currentMapSize;
            return true;
        }
        if (this.state[this.pos] == this.baseNumber[this.pos] - 1) {
            if (!this.sssMode) return true;
            if (this.brokenAt == -1) return true;
            if (this.continuedAt != -1) return false;
            return true;
        }
        if ((this.mcsMode || this.mcesMode) && this.currentMapSize + this.treeSize - this.pos - 1 < this.currentMaxCommonSize) {
            return false;
        }
        if (this.targetAtomMapped[targetAtom]) {
            return false;
        }
        int n = predecessorPos = this.parentQueryNode[this.pos] == -1 ? this.pos - 1 : this.parentQueryNode[this.pos];
        if (this.state[predecessorPos] == this.baseNumber[predecessorPos] - 1) {
            if (!this.allowedDisjoint) {
                return false;
            }
            if (this.brokenAt == -1) {
                this.brokenAt = predecessorPos;
            }
            if (this.state[this.pos] != this.baseNumber[this.pos] - 1) {
                if (this.continuedAt != -1) return false;
                this.continuedAt = this.pos;
            } else {
                if (this.continuedAt != -1) return false;
                return true;
            }
        }
        if (!this.match(predecessorPos)) {
            return false;
        }
        this.targetAtomMapped[targetAtom] = true;
        this.mappedAtPos[this.pos] = true;
        ++this.currentMapSize;
        return true;
    }

    private boolean match(int predecessorPos) {
        int queryBondIndex;
        int targetAtomMappedToPredecessor = this.state[predecessorPos] == this.baseNumber[predecessorPos] - 1 ? -1 : this.valueToTargetAtomIndex[predecessorPos][this.state[predecessorPos]];
        int atomAtPos = this.route[this.pos];
        int targetAtomMappedToAtomAtPos = this.state[this.pos] == this.baseNumber[this.pos] - 1 ? -1 : this.valueToTargetAtomIndex[this.pos][this.state[this.pos]];
        int targetBondIndex = -1;
        if (targetAtomMappedToAtomAtPos != -1 && targetAtomMappedToPredecessor != -1 && (targetBondIndex = this.targetMol.getBondTable().getBondIndex(targetAtomMappedToAtomAtPos, targetAtomMappedToPredecessor)) == -1) {
            return false;
        }
        if (targetAtomMappedToAtomAtPos != -1 && !this.matchAtoms(atomAtPos, targetAtomMappedToAtomAtPos)) {
            return false;
        }
        int predecessorAtom = this.route[predecessorPos];
        if (targetBondIndex != -1 && !this.ignoreBondType && !this.matchBonds(queryBondIndex = this.connectionMatrix.getBondIndex(atomAtPos, predecessorAtom), targetBondIndex)) {
            return false;
        }
        if (targetAtomMappedToAtomAtPos != -1 && !this.checkQueryTargetInducedEdges(predecessorAtom, atomAtPos, targetAtomMappedToAtomAtPos)) {
            return false;
        }
        if (targetAtomMappedToAtomAtPos == -1) {
            return true;
        }
        boolean r = !this.mcesMode || this.checkTargetQueryInducedEdges(predecessorAtom, atomAtPos, targetAtomMappedToAtomAtPos);
        return r;
    }

    private boolean checkQueryTargetInducedEdges(int predecessorAtom, int atomAtPos, int targetAtomAtPos) {
        int[] neighs = this.queryMol.getCtab()[atomAtPos];
        for (int i = 0; i < neighs.length; ++i) {
            int neighPos;
            if (neighs[i] == predecessorAtom || (neighPos = this.queryAtomIndexToPos[neighs[i]]) > this.pos) continue;
            int neighTargetAtom = this.valueToTargetAtomIndex[neighPos][this.state[neighPos]];
            if (neighTargetAtom == -1) {
                return true;
            }
            if (!this.mcsMode && this.targetMol.getBondTable().getBondIndex(targetAtomAtPos, neighTargetAtom) == -1) {
                return false;
            }
            if (this.ignoreBondType) continue;
            int queryBondIndex = this.connectionMatrix.getBondIndex(atomAtPos, neighs[i]);
            int targetBondIndex = this.targetMol.getBondTable().getBondIndex(targetAtomAtPos, neighTargetAtom);
            if (this.mcsMode && targetBondIndex == -1 || this.matchBonds(queryBondIndex, targetBondIndex)) continue;
            return false;
        }
        return true;
    }

    private boolean checkTargetQueryInducedEdges(int predecessorAtom, int atomAtPos, int targetAtomAtPos) {
        int[] neighs = this.targetMol.getCtab()[targetAtomAtPos];
        for (int i = 0; i < neighs.length; ++i) {
            int neighPos;
            if (neighs[i] == predecessorAtom || (neighPos = this.targetAtomIndexToPos(neighs[i])) == -1 || this.connectionMatrix.getBondIndex(atomAtPos, this.route[neighPos]) != -1) continue;
            return false;
        }
        return true;
    }

    private boolean matchAtoms(int queryAtomIndex, int targetAtomIndex) {
        MolAtom qa = this.queryMol.getAtom(queryAtomIndex);
        MolAtom ta = this.targetMol.getAtom(targetAtomIndex);
        if (!this.ignoreAtomType && (qa.getAtno() == 128 ? !this.atomInList(ta.getAtno(), qa.getList()) : (qa.getAtno() == 129 ? this.atomInList(ta.getAtno(), qa.getList()) : (qa.getAtno() == 132 ? ta.getAtno() == 1 || ta.getAtno() == 6 : qa.getAtno() != 131 && qa.getAtno() != ta.getAtno())))) {
            return false;
        }
        if (!this.ignoreHybridization && qa.getHybridizationState() != ta.getHybridizationState()) {
            return false;
        }
        if (!this.ignoreCharge && qa.getCharge() != ta.getCharge()) {
            return false;
        }
        if (!this.ignoreIsotopes && qa.getMassno() != ta.getMassno()) {
            return false;
        }
        if (!this.ignoreQueryProperties) {
            return this.matchQueryProperties(queryAtomIndex, targetAtomIndex);
        }
        return true;
    }

    private boolean matchBonds(int queryBondIndex, int targetBondIndex) {
        return (this.targetMol.getBond(targetBondIndex).getFlags() & 0xF) == (this.queryMol.getBond(queryBondIndex).getFlags() & 0xF);
    }

    private boolean matchQueryProperties(int queryAtomIndex, int targetAtomIndex) {
        MolAtom qa = this.queryMol.getAtom(queryAtomIndex);
        MolAtom ta = this.targetMol.getAtom(targetAtomIndex);
        int cc = qa.getQPropAsInt("X");
        if (cc != -1 && ta.getBondCount() + ta.getImplicitHcount() != cc) {
            return false;
        }
        int hc = qa.getQPropAsInt("H");
        if (hc != -1 && ta.getExplicitHcount() + ta.getImplicitHcount() != hc) {
            return false;
        }
        int rc = qa.getQPropAsInt("R");
        if (rc != -1) {
            if (!this.isRingCountOfAtomsSet) {
                int[][] rings = this.targetMol.getSSSR();
                for (int i = 0; i < rings.length; ++i) {
                    int[] r = rings[i];
                    for (int j = 0; j < r.length; ++j) {
                        int n = r[j];
                        this.ringCountOfAtoms[n] = this.ringCountOfAtoms[n] + 1;
                    }
                }
                this.isRingCountOfAtomsSet = true;
            }
            return rc == 256 && this.ringCountOfAtoms[targetAtomIndex] != 0 || rc != 256 && this.ringCountOfAtoms[targetAtomIndex] == rc;
        }
        return true;
    }

    private void next() {
        while (true) {
            if (this.mappedAtPos[this.pos]) {
                int targetAtom = this.valueToTargetAtomIndex[this.pos][this.state[this.pos]];
                this.targetAtomMapped[targetAtom] = false;
                this.mappedAtPos[this.pos] = false;
                --this.currentMapSize;
            }
            if (this.state[this.pos] < this.baseNumber[this.pos] - 1) {
                int n = this.pos;
                this.state[n] = this.state[n] + 1;
                this.carry = false;
                return;
            }
            if (this.pos == 0) {
                this.carry = true;
                return;
            }
            if (this.pos == this.continuedAt) {
                this.continuedAt = -1;
            }
            if (this.pos == this.brokenAt) {
                this.brokenAt = -1;
            }
            this.state[this.pos--] = 0;
        }
    }

    private void createSpannigTree(int startingNode) {
        this.treeSize = 0;
        for (int i = 0; i < this.visited.length; ++i) {
            this.visited[i] = false;
        }
        if (!this.isAllowedQueryAtom(startingNode)) {
            return;
        }
        this.visitQueue.addLast(-1);
        this.visitQueue.addLast(startingNode);
        this.visit();
    }

    private void visit() {
        while (!this.visitQueue.isEmpty()) {
            int parent = this.visitQueue.removeFirst();
            int nodeIndex = this.visitQueue.removeFirst();
            if (this.visited[nodeIndex]) continue;
            this.visited[nodeIndex] = true;
            this.route[this.treeSize++] = nodeIndex;
            int[] neighbours = this.queryMol.getCtab()[nodeIndex];
            for (int ni = 0; ni < neighbours.length; ++ni) {
                if (neighbours[ni] == parent || !this.isAllowedQueryAtom(neighbours[ni])) continue;
                this.visitQueue.addLast(nodeIndex);
                this.visitQueue.addLast(neighbours[ni]);
            }
        }
    }

    private boolean isAllowedQueryAtom(int atom) {
        return this.allowedQueryAtoms == null || this.allowedQueryAtoms[atom];
    }

    private boolean isAllowedTargetAtom(int atom) {
        return this.allowedTargetAtoms == null || this.allowedTargetAtoms[atom];
    }

    private void setupConstrainedBacktrack() {
        int j;
        int i;
        int ts = this.targetMol.getAtomCount();
        for (i = 0; i < this.treeSize; ++i) {
            this.queryAtomIndexToPos[this.route[i]] = i;
            this.baseNumber[i] = 0;
            for (j = 0; j < ts; ++j) {
                if (!this.isAllowedTargetAtom(j) || !this.adequateAtoms[this.route[i] * ts + j]) continue;
                int n = i;
                int n2 = this.baseNumber[n];
                this.baseNumber[n] = n2 + 1;
                this.valueToTargetAtomIndex[i][n2] = j;
            }
            int n = i;
            int n3 = this.baseNumber[n];
            this.baseNumber[n] = n3 + 1;
            this.valueToTargetAtomIndex[i][n3] = -1;
        }
        for (i = 0; i < this.treeSize; ++i) {
            this.parentQueryNode[i] = -1;
        }
        for (i = 1; i < this.treeSize; ++i) {
            if (this.connectionMatrix.getBondIndex(this.route[i], this.route[i - 1]) != -1) continue;
            for (j = i - 2; j >= 0 && this.connectionMatrix.getBondIndex(this.route[i], this.route[j]) == -1; --j) {
            }
            if (j < 0) {
                throw new RuntimeException("Unrecoverable error: corrupt query graph.");
            }
            this.parentQueryNode[i] = j;
        }
        this.solutionFound = false;
        for (i = 0; i < this.state.length; ++i) {
            this.state[i] = 0;
            this.mappedAtPos[i] = false;
        }
        for (i = 0; i < this.targetAtomMapped.length; ++i) {
            this.targetAtomMapped[i] = false;
        }
        this.currentMapSize = 0;
    }

    private boolean adequateAtoms(MolAtom queryAtom, MolAtom targetAtom) {
        int queryAtomType = queryAtom.getAtno();
        if (!(this.ignoreAtomType || queryAtomType == 131 || queryAtomType == 132 && targetAtom.getAtno() != 1 && targetAtom.getAtno() != 6 || queryAtomType == 128 && this.atomInList(targetAtom.getAtno(), queryAtom.getList()) || queryAtomType == 129 && !this.atomInList(targetAtom.getAtno(), queryAtom.getList()) || targetAtom.getAtno() == queryAtomType)) {
            return false;
        }
        if (!this.ignoreHybridization && queryAtom.getHybridizationState() != targetAtom.getHybridizationState()) {
            return false;
        }
        if (!this.ignoreCharge && queryAtom.getCharge() != targetAtom.getCharge()) {
            return false;
        }
        return !this.sssMode || queryAtom.getBondCount() <= targetAtom.getBondCount();
    }

    private void addCommonSubstructure() {
        int i;
        if (this.currentMapSize < this.minCommonSize) {
            return;
        }
        if (this.mcsMode || this.mcesMode) {
            if (this.currentMapSize <= this.currentMaxCommonSize) {
                return;
            }
            this.currentMaxCommonSize = this.currentMapSize;
        }
        int[] map = new int[this.queryMol.getAtomCount()];
        for (i = 0; i < map.length; ++i) {
            map[i] = -1;
        }
        for (i = 0; i <= this.pos; ++i) {
            map[this.route[i]] = this.valueToTargetAtomIndex[i][this.state[i]];
        }
        if (this.fastMode) {
            this.updateBFSStartingPoints(map);
        }
        if ((this.sssMode || this.mcsMode || this.mcesMode) && this.isNewSolution(map)) {
            this.mcs = map;
            this.allHits.addElement(map);
            this.solutionFound = this.sssMode || (this.mcsMode || this.mcesMode) && this.currentMaxCommonSize == this.maxCommonSize;
        }
    }

    private boolean isNewSolution(int[] map) {
        for (int i = 0; i < this.allHits.size(); ++i) {
            int[] m = (int[])this.allHits.elementAt(i);
            boolean same = true;
            for (int j = 0; same && j < m.length; ++j) {
                same = m[j] == map[j];
            }
            if (!same) continue;
            return false;
        }
        return true;
    }

    private String extractSubstructure(int[] map, boolean unique) {
        int i;
        unique = false;
        int bondCount = this.calcBondCount();
        this.substruct = new Molecule(this.queryMol, this.currentMapSize, bondCount);
        for (i = 0; i < this.queryMol.getAtomCount(); ++i) {
            this.molAtom[i] = null;
            if (map[i] == -1) continue;
            this.molAtom[i] = new MolAtom(this.queryMol.getAtom(i).getAtno());
            this.substruct.add(this.molAtom[i]);
        }
        for (i = 0; i < this.queryMol.getAtomCount(); ++i) {
            if (map[i] == -1) continue;
            for (int j = 0; j < i; ++j) {
                if (map[j] == -1 || this.connectionMatrix.getBondIndex(i, j) == -1) continue;
                MolBond b = this.queryMol.getBond(this.connectionMatrix.getBondIndex(i, j));
                this.substruct.add(new MolBond(this.molAtom[i], this.molAtom[j], b.getFlags() & 0xF));
            }
        }
        return this.substruct.toFormat("smiles" + (unique ? ":u" : ""));
    }

    private int calcBondCount() {
        int bc = 0;
        for (int i = 0; i < this.queryMol.getAtomCount(); ++i) {
            if (this.state[i] == 0) continue;
            for (int j = 0; j < i; ++j) {
                if (this.state[j] == 0) continue;
                bc += this.connectionMatrix.getBondIndex(i, j) != -1 ? 1 : 0;
            }
        }
        return bc;
    }

    private void updateBFSStartingPoints(int[] map) {
        block0: for (int i = 0; i < map.length; ++i) {
            int j;
            if (map[i] == -1) continue;
            int[] neighs = this.queryMol.getCtab()[i];
            boolean found = true;
            for (j = 0; found && j < neighs.length; ++j) {
                found = map[neighs[j]] != -1;
            }
            if (!found) continue;
            for (j = 0; j < this.queryMol.getAtomCount(); ++j) {
                if (this.startBFSFromAtom[j] != map[i] && this.isAllowedQueryAtom(j)) continue;
                this.startBFSFromAtom[j] = -1;
                continue block0;
            }
        }
    }

    private boolean atomInList(int atno, int[] atnoList) {
        for (int i = 0; i < atnoList.length; ++i) {
            if (atnoList[i] != atno) continue;
            return true;
        }
        return false;
    }

    private int targetAtomIndexToPos(int atomId) {
        for (int i = 0; i < this.pos; ++i) {
            if (this.valueToTargetAtomIndex[i][this.state[i]] != atomId) continue;
            return i;
        }
        return -1;
    }

    private void init() {
        this.alloc();
        this.mcs = null;
        this.allHits.removeAllElements();
        this.connectionMatrix = this.queryMol.getBondTable();
        if (this.sssMode) {
            this.minCommonSize = this.queryMol.getAtomCount();
        } else if (this.mcsMode || this.mcesMode) {
            this.maxCommonSize = Math.min(this.queryMol.getAtomCount(), this.targetMol.getAtomCount());
        }
        this.currentMaxCommonSize = 0;
        this.clear(this.ringCountOfAtoms);
        this.isRingCountOfAtomsSet = false;
        if (this.queryMolChanged) {
            this.initBFSStartingPoints();
        }
        this.initAdequateAtoms();
        this.queryMolChanged = false;
        this.brokenAt = -1;
        this.continuedAt = -1;
    }

    private void initBFSStartingPoints() {
        int i;
        this.elemAnal.setMolecule(this.queryMol);
        int qgSize = this.queryMol.getAtomCount();
        for (i = 0; i < qgSize; ++i) {
            this.startBFSFromAtom[i] = this.isAllowedQueryAtom(i) ? i : -1;
        }
        for (i = 0; i < qgSize - 1; ++i) {
            int ai = this.startBFSFromAtom[i];
            if (ai == -1) continue;
            int atnoi = this.queryMol.getAtom(ai).getAtno();
            int scorei = this.atomScore(ai, atnoi);
            for (int j = i + 1; j < qgSize; ++j) {
                int atnoj;
                int scorej;
                int aj = this.startBFSFromAtom[j];
                if (aj == -1 || (scorej = this.atomScore(aj, atnoj = this.queryMol.getAtom(aj).getAtno())) >= scorei) continue;
                int w = this.startBFSFromAtom[i];
                this.startBFSFromAtom[i] = this.startBFSFromAtom[j];
                this.startBFSFromAtom[j] = w;
                ai = this.startBFSFromAtom[i];
                scorei = scorej;
            }
        }
    }

    private int atomScore(int atomIndex, int atno) {
        return (atno == 6 || atno == 128 || atno == 131 || atno == 132 ? 6 : 2 * this.elemAnal.atomCount(atno)) + this.queryMol.getAtom(atomIndex).getBondCount();
    }

    private void initAdequateAtoms() {
        for (int i = 0; i < this.queryMol.getAtomCount(); ++i) {
            MolAtom queryAtom = this.queryMol.getAtom(i);
            for (int j = 0; j < this.targetMol.getAtomCount(); ++j) {
                MolAtom targetAtom = this.targetMol.getAtom(j);
                this.adequateAtoms[i * this.targetMol.getAtomCount() + j] = this.adequateAtoms(queryAtom, targetAtom);
            }
        }
    }

    private double estimatedComplexity() {
        double complexity = 1.0;
        for (int i = 0; i < this.baseNumber.length; ++i) {
            if (this.baseNumber[i] == 0) continue;
            complexity *= (double)this.baseNumber[i];
        }
        return complexity;
    }

    private void fill(boolean[] a, boolean v) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = v;
        }
    }

    private void clear(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = 0;
        }
    }

    private void alloc() {
        int qgSize = this.queryMol.getAtomCount();
        int tgSize = this.targetMol.getAtomCount();
        if (this.route == null || qgSize > this.route.length) {
            this.startBFSFromAtom = new int[qgSize];
            this.route = new int[qgSize];
            this.visited = new boolean[qgSize];
            this.baseNumber = new int[qgSize];
            this.state = new int[qgSize];
            this.parentQueryNode = new int[qgSize];
            this.mappedAtPos = new boolean[qgSize];
            this.valueToTargetAtomIndex = new int[qgSize][tgSize + 1];
            this.targetAtomMapped = new boolean[tgSize];
            this.queryAtomIndexToPos = new int[qgSize];
            this.visitQueue.setMaxSize(4 * qgSize);
            this.molAtom = new MolAtom[qgSize];
            this.ringCountOfAtoms = new int[tgSize];
            if (this.adequateAtoms == null || qgSize * tgSize > this.adequateAtoms.length) {
                this.adequateAtoms = new boolean[qgSize * tgSize];
            }
            return;
        }
        int minLength = 0;
        if (this.valueToTargetAtomIndex != null) {
            minLength = this.valueToTargetAtomIndex[0].length;
            for (int i = 1; i < this.valueToTargetAtomIndex.length; ++i) {
                if (this.valueToTargetAtomIndex[i].length >= minLength) continue;
                minLength = this.valueToTargetAtomIndex[i].length;
            }
            if (this.targetAtomMapped.length < minLength) {
                minLength = this.targetAtomMapped.length;
            }
        }
        if (this.valueToTargetAtomIndex == null || tgSize > minLength) {
            this.valueToTargetAtomIndex = new int[this.route.length][tgSize + 1];
            this.targetAtomMapped = new boolean[tgSize];
            this.ringCountOfAtoms = new int[tgSize];
        }
        if (qgSize * tgSize > this.adequateAtoms.length) {
            this.adequateAtoms = new boolean[qgSize * tgSize];
        }
    }

    public void dump() {
        int i;
        System.err.println("=== dump ===");
        System.err.println("treeSize = " + this.treeSize);
        for (i = 0; i < this.treeSize; ++i) {
            System.err.println("route[ " + i + " ] = " + this.route[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.err.println("baseNumber[ " + i + " ] = " + this.baseNumber[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.err.println("state[ " + i + " ] = " + this.state[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.err.print("valueToTargetAtomIndex[ " + i + " ] = ");
            for (int j = 0; j < this.valueToTargetAtomIndex[i].length && this.valueToTargetAtomIndex[i][j] != -1; ++j) {
                System.err.print(this.valueToTargetAtomIndex[i][j] + " ");
            }
            System.err.println();
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.err.println("parentQueryNode[ " + i + " ]= " + this.parentQueryNode[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.err.println("queryAtomIndexToPos[ " + i + " ]= " + this.queryAtomIndexToPos[i]);
        }
        if (this.mcs != null) {
            for (i = 0; i < this.mcs.length; ++i) {
                System.err.println("mcs[" + i + "]=" + this.mcs[i]);
            }
        }
        System.err.println("=== ---- ===");
    }

    private class Queue {
        private int[] values = null;
        private int head = -1;
        private int tail = -1;
        private boolean empty = true;

        public void setMaxSize(int maxSize) {
            if (this.values == null || maxSize > this.values.length) {
                this.values = new int[maxSize];
            }
            this.clear();
        }

        public void clear() {
            this.head = 0;
            this.tail = -1;
            this.empty = true;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public void addLast(int value) throws RuntimeException {
            if (this.overflow()) {
                throw new RuntimeException("Queue overflow.");
            }
            this.tail = (this.tail + 1) % this.values.length;
            this.values[this.tail] = value;
            this.empty = false;
        }

        private int removeFirst() throws RuntimeException {
            if (this.empty) {
                throw new RuntimeException("Queue underflow.");
            }
            int r = this.values[this.head];
            this.empty = this.head == this.tail;
            this.head = (this.head + 1) % this.values.length;
            return r;
        }

        private boolean overflow() {
            return !this.empty && (this.tail + 1) % this.values.length == this.head;
        }
    }
}

