/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules;

import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.modules.MaxClique;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Arrays;

public class MCES
implements Licensable {
    public static final int DEFAULT_MIN_COMPONENT_SIZE = 5;
    public static final long DEFAULT_RANDOM_SEED = 308051301241514L;
    protected Molecule queryMol = null;
    protected Molecule targetMol = null;
    protected Molecule queryOrig = null;
    protected Molecule targetOrig = null;
    protected int minComponentSize = 5;
    protected boolean atomTypeMatch = true;
    protected boolean bondTypeMatch = true;
    protected boolean chargeMatch = false;
    protected boolean hybridizationMatch = false;
    protected boolean isotopeMatch = false;
    protected boolean atomMapMatch = false;
    protected boolean keepLargestComponent = false;
    protected int aromMode = 2;
    protected SearchMode searchMode = SearchMode.STANDARD;
    protected int stepCountLimit = -1;
    protected long timeLimit = -1L;
    protected int restartCountLimit;
    protected int ecfpDiameter;
    protected float ecfpPower;
    protected long randomSeed = 308051301241514L;
    protected long startTime;
    protected TerminationCause terminationCause;
    protected int atomCount;
    protected int bondCount;
    protected int componentCount;
    protected int[] atomMap = null;
    protected int[] atomRevMap = null;
    protected int[] bondMap = null;
    protected int[] bondRevMap = null;
    private String licenseEnvironment = "";

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("MCES", this.licenseEnvironment);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("MCES", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    public void setMolecules(Molecule query, Molecule target) {
        this.queryOrig = query;
        this.targetOrig = target;
    }

    public void setQueryMolecule(Molecule query) {
        this.queryOrig = query;
    }

    public void setTargetMolecule(Molecule target) {
        this.targetOrig = target;
    }

    public Molecule getQueryMolecule() {
        return this.queryOrig;
    }

    public Molecule getTargetMolecule() {
        return this.targetOrig;
    }

    public void enableAromatization() {
        this.aromMode = 2;
    }

    public void enableAromatization(int method) {
        this.aromMode = method;
    }

    public void disableAromatization() {
        this.aromMode = -1;
    }

    public int getAromatizationMethod() {
        return this.aromMode;
    }

    public void setSearchMode(SearchMode mode) {
        this.searchMode = mode;
    }

    public SearchMode getSearchMode() {
        return this.searchMode;
    }

    public void setAtomTypeMatch(boolean match) {
        this.atomTypeMatch = match;
    }

    public void setBondTypeMatch(boolean match) {
        this.bondTypeMatch = match;
    }

    public void setChargeMatch(boolean match) {
        this.chargeMatch = match;
    }

    public void setHybridizationMatch(boolean match) {
        this.hybridizationMatch = match;
    }

    public void setIsotopeMatch(boolean match) {
        this.isotopeMatch = match;
    }

    public void setAtomMapMatch(boolean match) {
        this.atomMapMatch = match;
    }

    public boolean getAtomTypeMatch() {
        return this.atomTypeMatch;
    }

    public boolean getBondTypeMatch() {
        return this.bondTypeMatch;
    }

    public boolean getChargeMatch() {
        return this.chargeMatch;
    }

    public boolean getHybridizationMatch() {
        return this.hybridizationMatch;
    }

    public boolean getIsotopeMatch() {
        return this.isotopeMatch;
    }

    public boolean getAtomMapMatch() {
        return this.atomMapMatch;
    }

    public void setMinComponentSize(int bondCount) {
        this.minComponentSize = bondCount;
    }

    public int getMinComponentSize() {
        return this.minComponentSize;
    }

    public void setKeepLargestComponent(boolean keepLargest) {
        this.keepLargestComponent = keepLargest;
    }

    public boolean getKeepLargestComponent() {
        return this.keepLargestComponent;
    }

    public void setStepCountLimit(int maxStepCount) {
        this.stepCountLimit = maxStepCount;
    }

    public int getStepCountLimit() {
        return this.stepCountLimit;
    }

    public void setTimeLimit(long maxMilliseconds) {
        this.timeLimit = maxMilliseconds;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setRandomSeed(long seed) {
        this.randomSeed = seed;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public boolean search() {
        this.checkLicense();
        if (this.aromMode > -1) {
            this.queryMol = this.queryOrig.cloneMolecule();
            this.targetMol = this.targetOrig.cloneMolecule();
            this.queryMol.aromatize(this.aromMode);
            this.targetMol.aromatize(this.aromMode);
        } else {
            this.queryMol = this.queryOrig;
            this.targetMol = this.targetOrig;
        }
        if (this.hybridizationMatch) {
            this.queryMol.calcHybridization();
            this.targetMol.calcHybridization();
        }
        this.findMCES();
        return this.bondCount > 0;
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public int getComponentCount() {
        return this.componentCount;
    }

    public int[] getAtomMapping() {
        return this.atomMap;
    }

    public int[] getAtomReverseMapping() {
        return this.atomRevMap;
    }

    public int[] getBondMapping() {
        return this.bondMap;
    }

    public int[] getBondReverseMapping() {
        return this.bondRevMap;
    }

    public MolAtom[] getMatchedQueryAtoms() {
        MolAtom[] array = new MolAtom[this.atomCount];
        int k = 0;
        for (int i = 0; i < this.atomMap.length; ++i) {
            if (this.atomMap[i] <= -1) continue;
            array[k++] = this.queryOrig.getAtom(i);
        }
        return array;
    }

    public MolBond[] getMatchedQueryBonds() {
        MolBond[] array = new MolBond[this.bondCount];
        int k = 0;
        for (int j = 0; j < this.bondMap.length; ++j) {
            if (this.bondMap[j] <= -1) continue;
            array[k++] = this.queryOrig.getBond(j);
        }
        return array;
    }

    public MolAtom[] getMatchedTargetAtoms() {
        MolAtom[] array = new MolAtom[this.atomCount];
        int k = 0;
        for (int i = 0; i < this.atomMap.length; ++i) {
            if (this.atomMap[i] <= -1) continue;
            array[k++] = this.targetOrig.getAtom(this.atomMap[i]);
        }
        return array;
    }

    public MolBond[] getMatchedTargetBonds() {
        MolBond[] array = new MolBond[this.bondCount];
        int k = 0;
        for (int j = 0; j < this.bondMap.length; ++j) {
            if (this.bondMap[j] <= -1) continue;
            array[k++] = this.targetOrig.getBond(this.bondMap[j]);
        }
        return array;
    }

    public MolAtom[] getUnmatchedQueryAtoms() {
        MolAtom[] array = new MolAtom[this.queryOrig.getAtomCount() - this.atomCount];
        int k = 0;
        for (int i = 0; i < this.atomMap.length; ++i) {
            if (this.atomMap[i] != -1) continue;
            array[k++] = this.queryOrig.getAtom(i);
        }
        return array;
    }

    public MolBond[] getUnmatchedQueryBonds() {
        MolBond[] array = new MolBond[this.queryOrig.getBondCount() - this.bondCount];
        int k = 0;
        for (int j = 0; j < this.bondMap.length; ++j) {
            if (this.bondMap[j] != -1) continue;
            array[k++] = this.queryOrig.getBond(j);
        }
        return array;
    }

    public MolAtom[] getUnmatchedTargetAtoms() {
        MolAtom[] array = new MolAtom[this.targetOrig.getAtomCount() - this.atomCount];
        int k = 0;
        for (int i = 0; i < this.atomRevMap.length; ++i) {
            if (this.atomRevMap[i] != -1) continue;
            array[k++] = this.targetOrig.getAtom(i);
        }
        return array;
    }

    public MolBond[] getUnmatchedTargetBonds() {
        MolBond[] array = new MolBond[this.targetOrig.getBondCount() - this.bondCount];
        int k = 0;
        for (int j = 0; j < this.bondRevMap.length; ++j) {
            if (this.bondRevMap[j] != -1) continue;
            array[k++] = this.targetOrig.getBond(j);
        }
        return array;
    }

    public Molecule getAsMolecule() {
        Molecule mces = this.targetOrig.cloneMolecule();
        for (int j = this.bondRevMap.length - 1; j >= 0; --j) {
            if (this.bondRevMap[j] != -1) continue;
            mces.removeBond(j);
        }
        for (int i = this.atomRevMap.length - 1; i >= 0; --i) {
            if (this.atomRevMap[i] != -1) continue;
            mces.removeAtom(i);
        }
        return mces;
    }

    public TerminationCause getTerminationCause() {
        return this.terminationCause;
    }

    protected boolean matchAtoms(MolAtom queryAtom, MolAtom targetAtom) {
        if (this.atomTypeMatch) {
            int qa = queryAtom.getAtno();
            int ta = targetAtom.getAtno();
            if (qa == 128) {
                int[] list = queryAtom.getList();
                boolean found = false;
                for (int a : list) {
                    if (a != ta) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            } else if (qa == 129) {
                int[] list;
                for (int a : list = queryAtom.getList()) {
                    if (a != ta) continue;
                    return false;
                }
            } else if (qa == 132 ? ta == 1 || ta == 6 : qa != 131 && qa != ta) {
                return false;
            }
            if (this.isotopeMatch && queryAtom.getMassno() != targetAtom.getMassno()) {
                return false;
            }
        }
        if (this.hybridizationMatch && queryAtom.getHybridizationState() != targetAtom.getHybridizationState()) {
            return false;
        }
        if (this.chargeMatch && queryAtom.getCharge() != targetAtom.getCharge()) {
            return false;
        }
        return !this.atomMapMatch || queryAtom.getAtomMap() == targetAtom.getAtomMap();
    }

    protected boolean matchBonds(MolBond queryBond, MolBond targetBond) {
        if (this.bondTypeMatch && queryBond.getType() != targetBond.getType()) {
            return false;
        }
        return this.matchAtoms(queryBond.getAtom1(), targetBond.getAtom1()) && this.matchAtoms(queryBond.getAtom2(), targetBond.getAtom2()) || this.matchAtoms(queryBond.getAtom1(), targetBond.getAtom2()) && this.matchAtoms(queryBond.getAtom2(), targetBond.getAtom1());
    }

    protected int[][] computeECFP(Molecule mol, int maxIter) {
        int hashFactor = 691;
        int aCount = mol.getAtomCount();
        int[][] features = new int[aCount][maxIter + 1];
        for (int i = 0; i < aCount; ++i) {
            MolAtom a = mol.getAtom(i);
            int h = 0;
            if (this.atomTypeMatch) {
                h = h * 691 ^ a.getAtno();
                if (this.isotopeMatch) {
                    h = h * 691 ^ a.getMassno();
                }
            }
            if (this.hybridizationMatch) {
                h = h * 691 ^ a.getHybridizationState();
            }
            if (this.chargeMatch) {
                h = h * 691 ^ a.getCharge();
            }
            features[i][0] = h;
        }
        for (int iter = 1; iter <= maxIter; ++iter) {
            for (int i = 0; i < aCount; ++i) {
                int j;
                MolAtom a = mol.getAtom(i);
                Object[] ldata = new LigandData[a.getBondCount()];
                if (this.bondTypeMatch) {
                    for (j = 0; j != a.getBondCount(); ++j) {
                        MolBond nb = a.getBond(j);
                        MolAtom na = a.getLigand(j);
                        ldata[j] = new LigandData(nb.getType(), features[mol.indexOf(na)][iter - 1]);
                    }
                } else {
                    for (j = 0; j != a.getBondCount(); ++j) {
                        MolAtom na = a.getLigand(j);
                        ldata[j] = new LigandData(1, features[mol.indexOf(na)][iter - 1]);
                    }
                }
                Arrays.sort(ldata);
                int h = ldata.length;
                h = h * 691 ^ iter;
                h = h * 691 ^ features[i][iter - 1];
                for (int j2 = 0; j2 != ldata.length; ++j2) {
                    h = h * 691 ^ ((LigandData)ldata[j2]).bond;
                    h = h * 691 ^ ((LigandData)ldata[j2]).id;
                }
                features[i][iter] = h;
            }
        }
        return features;
    }

    protected void findMCES() {
        int j;
        int i;
        Molecule mol2;
        Molecule mol1;
        int i2;
        this.startTime = System.currentTimeMillis();
        boolean canExchange = true;
        for (int i3 = 0; i3 != this.queryMol.getAtomCount(); ++i3) {
            int z = this.queryMol.getAtom(i3).getAtno();
            if (z != 128 && z != 129 && z != 132 && z != 131) continue;
            canExchange = false;
            break;
        }
        boolean exchangeMol = false;
        if (canExchange) {
            for (i2 = 0; i2 != this.targetMol.getAtomCount(); ++i2) {
                int z = this.targetMol.getAtom(i2).getAtno();
                if (z != 128 && z != 129 && z != 132 && z != 131) continue;
                exchangeMol = true;
                break;
            }
        }
        if (canExchange && !exchangeMol) {
            if (this.queryMol.getAtomCount() != this.targetMol.getAtomCount()) {
                exchangeMol = this.queryMol.getAtomCount() > this.targetMol.getAtomCount();
            } else if (this.queryMol.getBondCount() != this.targetMol.getBondCount()) {
                exchangeMol = this.queryMol.getBondCount() > this.targetMol.getBondCount();
            } else {
                for (i2 = 0; i2 < this.queryMol.getAtomCount(); ++i2) {
                    MolAtom qa = this.queryMol.getAtom(i2);
                    MolAtom ta = this.targetMol.getAtom(i2);
                    if (qa.getAtno() != ta.getAtno()) {
                        exchangeMol = qa.getAtno() > ta.getAtno();
                        break;
                    }
                    if (qa.getBondCount() != ta.getBondCount()) {
                        exchangeMol = qa.getBondCount() > ta.getBondCount();
                        break;
                    }
                    boolean diff = false;
                    for (int j2 = 0; j2 != qa.getBondCount(); ++j2) {
                        int ti;
                        int qi = this.queryMol.indexOf(qa.getLigand(j2));
                        if (qi == (ti = this.targetMol.indexOf(ta.getLigand(j2)))) continue;
                        exchangeMol = qi > ti;
                        diff = true;
                        break;
                    }
                    if (diff) break;
                }
            }
        }
        switch (this.searchMode) {
            case FAST: {
                this.restartCountLimit = 100;
                this.ecfpDiameter = 12;
                break;
            }
            case STANDARD: {
                this.restartCountLimit = 500;
                this.ecfpDiameter = 12;
                break;
            }
            case EXHAUSTIVE: {
                this.restartCountLimit = 2000;
                this.ecfpDiameter = 12;
            }
        }
        this.ecfpPower = 0.5f;
        boolean deltaBasedRestart = false;
        int ecfpLevel = this.ecfpDiameter / 2;
        int unitPenalty = Math.max(1, (int)((float)this.restartCountLimit * this.ecfpPower / (float)ecfpLevel));
        this.atomCount = 0;
        this.atomMap = new int[this.queryMol.getAtomCount()];
        this.atomRevMap = new int[this.targetMol.getAtomCount()];
        Arrays.fill(this.atomMap, -1);
        Arrays.fill(this.atomRevMap, -1);
        this.bondCount = 0;
        this.bondMap = new int[this.queryMol.getBondCount()];
        this.bondRevMap = new int[this.targetMol.getBondCount()];
        Arrays.fill(this.bondMap, -1);
        Arrays.fill(this.bondRevMap, -1);
        this.componentCount = 0;
        if (exchangeMol) {
            mol1 = this.targetMol;
            mol2 = this.queryMol;
        } else {
            mol1 = this.queryMol;
            mol2 = this.targetMol;
        }
        int aCount1 = mol1.getAtomCount();
        int aCount2 = mol2.getAtomCount();
        int bCount1 = mol1.getBondCount();
        int bCount2 = mol2.getBondCount();
        if (Math.min(bCount1, bCount2) < Math.max(this.minComponentSize, 1)) {
            this.terminationCause = TerminationCause.OPTIMAL;
            return;
        }
        ArrayList<MolBond> bondGroups = new ArrayList<MolBond>();
        ArrayList<Integer> bondGroupSizes = new ArrayList<Integer>();
        for (int j3 = 0; j3 < bCount2; ++j3) {
            MolBond tb = mol2.getBond(j3);
            boolean found = false;
            for (int k = 0; k != bondGroups.size(); ++k) {
                if (!this.matchBonds(tb, (MolBond)bondGroups.get(k))) continue;
                found = true;
                bondGroupSizes.set(k, new Integer((Integer)bondGroupSizes.get(k) + 1));
                break;
            }
            if (found) continue;
            bondGroups.add(tb);
            bondGroupSizes.add(new Integer(1));
        }
        int bondGroupCount = bondGroupSizes.size();
        int[] queryBondGroupSizes = new int[bondGroupCount];
        Arrays.fill(queryBondGroupSizes, 0);
        for (int i4 = 0; i4 < bCount1; ++i4) {
            MolBond qb = mol1.getBond(i4);
            for (int k = 0; k != bondGroupCount; ++k) {
                if (!this.matchBonds(qb, (MolBond)bondGroups.get(k))) continue;
                int n = k;
                queryBondGroupSizes[n] = queryBondGroupSizes[n] + 1;
            }
        }
        int sizeLimit = 0;
        for (int k = 0; k != bondGroupCount; ++k) {
            sizeLimit += Math.min((Integer)bondGroupSizes.get(k), queryBondGroupSizes[k]);
        }
        sizeLimit = Math.min(sizeLimit, Math.min(bCount1, bCount2));
        int[][] ecfpIds1 = this.computeECFP(mol1, ecfpLevel);
        int[][] ecfpIds2 = this.computeECFP(mol2, ecfpLevel);
        ArrayList<MPNode> mpNodes = new ArrayList<MPNode>();
        ArrayList<Integer> mpPenalties = new ArrayList<Integer>();
        for (int i5 = 0; i5 < bCount1; ++i5) {
            for (int j4 = 0; j4 < bCount2; ++j4) {
                int k;
                int vi2;
                int ui2;
                int vi1;
                int ui1;
                MolBond b1 = mol1.getBond(i5);
                MolBond b2 = mol2.getBond(j4);
                if (this.bondTypeMatch && b1.getType() != b2.getType()) continue;
                boolean match = false;
                int score1a = 0;
                int score1b = 0;
                int score2a = 0;
                int score2b = 0;
                MolAtom u1 = b1.getAtom1();
                MolAtom v1 = b1.getAtom2();
                MolAtom u2 = b2.getAtom1();
                MolAtom v2 = b2.getAtom2();
                if (this.matchAtoms(u1, u2) && this.matchAtoms(v1, v2)) {
                    match = true;
                    ui1 = mol1.indexOf(u1);
                    vi1 = mol1.indexOf(v1);
                    ui2 = mol2.indexOf(u2);
                    vi2 = mol2.indexOf(v2);
                    k = 0;
                    while (k <= ecfpLevel && ecfpIds1[ui1][k] == ecfpIds2[ui2][k]) {
                        score1a = k++;
                    }
                    k = 0;
                    while (k <= ecfpLevel && ecfpIds1[vi1][k] == ecfpIds2[vi2][k]) {
                        score1b = k++;
                    }
                }
                u1 = b1.getAtom1();
                v1 = b1.getAtom2();
                u2 = b2.getAtom2();
                v2 = b2.getAtom1();
                if (this.matchAtoms(u1, u2) && this.matchAtoms(v1, v2)) {
                    match = true;
                    ui1 = mol1.indexOf(u1);
                    vi1 = mol1.indexOf(v1);
                    ui2 = mol2.indexOf(u2);
                    vi2 = mol2.indexOf(v2);
                    k = 0;
                    while (k <= ecfpLevel && ecfpIds1[ui1][k] == ecfpIds2[ui2][k]) {
                        score2a = k++;
                    }
                    k = 0;
                    while (k <= ecfpLevel && ecfpIds1[vi1][k] == ecfpIds2[vi2][k]) {
                        score2b = k++;
                    }
                }
                if (!match) continue;
                mpNodes.add(new MPNode(b1, b2));
                int score = Math.max(Math.min(score1a, score1b), Math.min(score2a, score2b));
                mpPenalties.add(new Integer(-score * unitPenalty));
            }
        }
        int N = mpNodes.size();
        boolean[][] mpGraph = new boolean[N][N];
        for (int i6 = 0; i6 < N; ++i6) {
            MPNode x = (MPNode)mpNodes.get(i6);
            for (int j5 = i6 + 1; j5 < N; ++j5) {
                MPNode y = (MPNode)mpNodes.get(j5);
                if (x.b1 == y.b1 || x.b2 == y.b2) {
                    mpGraph[i6][j5] = false;
                    mpGraph[j5][i6] = false;
                    continue;
                }
                MolAtom join1 = null;
                if (x.b1.getAtom1() == y.b1.getAtom1() || x.b1.getAtom1() == y.b1.getAtom2()) {
                    join1 = x.b1.getAtom1();
                }
                if (x.b1.getAtom2() == y.b1.getAtom1() || x.b1.getAtom2() == y.b1.getAtom2()) {
                    join1 = x.b1.getAtom2();
                }
                MolAtom join2 = null;
                if (x.b2.getAtom1() == y.b2.getAtom1() || x.b2.getAtom1() == y.b2.getAtom2()) {
                    join2 = x.b2.getAtom1();
                }
                if (x.b2.getAtom2() == y.b2.getAtom1() || x.b2.getAtom2() == y.b2.getAtom2()) {
                    join2 = x.b2.getAtom2();
                }
                mpGraph[i6][j5] = join1 == null && join2 == null || join1 != null && join2 != null && this.matchAtoms(join1, join2);
                mpGraph[j5][i6] = mpGraph[i6][j5];
            }
        }
        MaxClique mc = new MaxClique(mpGraph);
        mc.setDeltaBasedRestart(false);
        mc.setRestartCountLimit(this.restartCountLimit);
        mc.setStepCountLimit(this.stepCountLimit);
        if (this.timeLimit > 0L) {
            long remTime = this.timeLimit - (System.currentTimeMillis() - this.startTime);
            mc.setTimeLimit(remTime > 0L ? remTime : 0L);
        }
        mc.setSizeLimit(sizeLimit);
        mc.setPenalties(mpPenalties);
        MaxClique.TerminationCause mcStopCause = mc.search();
        boolean[] clique = mc.getClique();
        mc = null;
        mpGraph = null;
        switch (mcStopCause) {
            case SIZE_LIMIT: {
                this.terminationCause = TerminationCause.OPTIMAL;
                break;
            }
            case RESTART_LIMIT: {
                this.terminationCause = TerminationCause.FINISHED;
                break;
            }
            case STEP_LIMIT: {
                this.terminationCause = TerminationCause.STEP_LIMIT;
                break;
            }
            case TIME_LIMIT: {
                this.terminationCause = TerminationCause.TIME_LIMIT;
            }
        }
        if (exchangeMol) {
            this.bondCount = 0;
            for (i = 0; i < N; ++i) {
                if (!clique[i]) continue;
                this.bondMap[mol2.indexOf((MolBond)((MPNode)((MPNode)mpNodes.get((int)i))).b2)] = mol1.indexOf(((MPNode)mpNodes.get(i)).b1);
                ++this.bondCount;
            }
            mol1 = this.queryMol;
            mol2 = this.targetMol;
            aCount1 = mol1.getAtomCount();
            aCount2 = mol2.getAtomCount();
            bCount1 = mol1.getBondCount();
            bCount2 = mol2.getBondCount();
        } else {
            this.bondCount = 0;
            for (i = 0; i < N; ++i) {
                if (!clique[i]) continue;
                this.bondMap[mol1.indexOf((MolBond)((MPNode)((MPNode)mpNodes.get((int)i))).b1)] = mol2.indexOf(((MPNode)mpNodes.get(i)).b2);
                ++this.bondCount;
            }
        }
        if (this.bondCount == 0) {
            return;
        }
        int[] bondComp = new int[bCount1];
        Arrays.fill(bondComp, -1);
        MolAtom[] queue = new MolAtom[bCount1 + 1];
        int qfront = 0;
        int qback = 0;
        for (int k = 0; k < bCount1; ++k) {
            if (this.bondMap[k] == -1 || bondComp[k] != -1) continue;
            qback = 0;
            qfront = 0;
            queue[qback++] = mol1.getBond(k).getAtom1();
            while (qfront < qback) {
                MolAtom a = queue[qfront++];
                for (int j6 = 0; j6 < a.getBondCount(); ++j6) {
                    int bi = mol1.indexOf(a.getBond(j6));
                    if (this.bondMap[bi] == -1 || bondComp[bi] != -1) continue;
                    bondComp[bi] = this.componentCount;
                    queue[qback++] = a.getLigand(j6);
                }
            }
            ++this.componentCount;
        }
        int[] compSize = new int[this.componentCount];
        Arrays.fill(compSize, 0);
        for (int i7 = 0; i7 < bondComp.length; ++i7) {
            if (bondComp[i7] <= -1) continue;
            int n = bondComp[i7];
            compSize[n] = compSize[n] + 1;
        }
        if (this.keepLargestComponent && this.componentCount > 1) {
            int j7;
            int max = 0;
            for (int i8 = 1; i8 < compSize.length; ++i8) {
                if (compSize[i8] <= compSize[max]) continue;
                max = i8;
            }
            if (compSize[max] < this.minComponentSize) {
                for (j7 = 0; j7 < this.bondMap.length; ++j7) {
                    this.bondMap[j7] = -1;
                }
                this.bondCount = 0;
                this.componentCount = 0;
                return;
            }
            for (j7 = 0; j7 < this.bondMap.length; ++j7) {
                if (this.bondMap[j7] <= -1 || bondComp[j7] == max) continue;
                this.bondMap[j7] = -1;
                --this.bondCount;
            }
            this.componentCount = 1;
        } else {
            for (int c = 0; c < compSize.length; ++c) {
                if (compSize[c] >= this.minComponentSize) continue;
                --this.componentCount;
            }
            for (int j8 = 0; j8 < this.bondMap.length; ++j8) {
                if (this.bondMap[j8] <= -1 || compSize[bondComp[j8]] >= this.minComponentSize) continue;
                this.bondMap[j8] = -1;
                --this.bondCount;
            }
        }
        if (this.bondCount == 0) {
            return;
        }
        ArrayList<MolBond> matchedBonds = new ArrayList<MolBond>();
        for (int i9 = 0; i9 < aCount1; ++i9) {
            int ti;
            MolAtom a = mol1.getAtom(i9);
            matchedBonds.clear();
            for (int j9 = 0; j9 < a.getBondCount(); ++j9) {
                MolBond b = a.getBond(j9);
                if (this.bondMap[mol1.indexOf(b)] <= -1) continue;
                matchedBonds.add(b);
            }
            if (matchedBonds.size() < 2) continue;
            MolBond b1 = (MolBond)matchedBonds.get(0);
            MolBond b2 = (MolBond)matchedBonds.get(1);
            MolBond tb1 = mol2.getBond(this.bondMap[mol1.indexOf(b1)]);
            MolBond tb2 = mol2.getBond(this.bondMap[mol1.indexOf(b2)]);
            int n = ti = tb1.getAtom1() == tb2.getAtom1() || tb1.getAtom1() == tb2.getAtom2() ? mol2.indexOf(tb1.getAtom1()) : mol2.indexOf(tb1.getAtom2());
            if (this.atomRevMap[ti] == -1) {
                this.atomMap[i9] = ti;
                this.atomRevMap[ti] = i9;
                ++this.atomCount;
                continue;
            }
            if (this.atomMap[mol1.indexOf(b1.getOtherAtom(a))] == -1) {
                this.bondMap[mol1.indexOf((MolBond)b1)] = -1;
                --this.bondCount;
                continue;
            }
            this.bondMap[mol1.indexOf((MolBond)b2)] = -1;
            --this.bondCount;
        }
        for (j = 0; j < bCount1; ++j) {
            if (this.bondMap[j] == -1) continue;
            MolBond b = mol1.getBond(j);
            int u = mol1.indexOf(b.getAtom1());
            int v = mol1.indexOf(b.getAtom2());
            if (this.atomMap[u] != -1 && this.atomMap[v] != -1) continue;
            MolBond tb = mol2.getBond(this.bondMap[j]);
            int tu = mol2.indexOf(tb.getAtom1());
            int tv = mol2.indexOf(tb.getAtom2());
            if (this.atomMap[u] == -1 && this.atomMap[v] == -1) {
                if (this.matchAtoms(b.getAtom1(), tb.getAtom1())) {
                    this.atomMap[u] = tu;
                    this.atomMap[v] = tv;
                    this.atomRevMap[tu] = u;
                    this.atomRevMap[tv] = v;
                } else {
                    this.atomMap[u] = tv;
                    this.atomMap[v] = tu;
                    this.atomRevMap[tu] = v;
                    this.atomRevMap[tv] = u;
                }
                this.atomCount += 2;
                continue;
            }
            if (this.atomMap[v] == -1) {
                if (this.atomMap[u] == tu) {
                    this.atomMap[v] = tv;
                    this.atomRevMap[tv] = v;
                    ++this.atomCount;
                    continue;
                }
                if (this.atomMap[u] == tv) {
                    this.atomMap[v] = tu;
                    this.atomRevMap[tu] = v;
                    ++this.atomCount;
                    continue;
                }
                this.bondMap[j] = -1;
                --this.bondCount;
                continue;
            }
            if (this.atomMap[v] == tu) {
                this.atomMap[u] = tv;
                this.atomRevMap[tv] = u;
                ++this.atomCount;
                continue;
            }
            if (this.atomMap[v] == tv) {
                this.atomMap[u] = tu;
                this.atomRevMap[tu] = u;
                ++this.atomCount;
                continue;
            }
            this.bondMap[j] = -1;
            --this.bondCount;
        }
        for (j = 0; j != this.bondMap.length; ++j) {
            if (this.bondMap[j] <= -1) continue;
            this.bondRevMap[this.bondMap[j]] = j;
        }
    }

    protected static class MPNode {
        private MolBond b1;
        private MolBond b2;

        MPNode(MolBond b1, MolBond b2) {
            this.b1 = b1;
            this.b2 = b2;
        }
    }

    private static class LigandData
    implements Comparable {
        int bond;
        int id;

        public LigandData(int bond, int id) {
            this.bond = bond;
            this.id = id;
        }

        public int compareTo(Object o) {
            LigandData other = (LigandData)o;
            if (this.bond != other.bond) {
                return this.bond - other.bond;
            }
            if (this.id != other.id) {
                return this.id < other.id ? -1 : 1;
            }
            return 0;
        }
    }

    public static enum TerminationCause {
        FINISHED,
        OPTIMAL,
        STEP_LIMIT,
        TIME_LIMIT;

    }

    public static enum SearchMode {
        FAST,
        STANDARD,
        EXHAUSTIVE;

    }
}

