/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules;

import chemaxon.common.util.ArrayTools;
import chemaxon.core.calculations.SSSR;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.StaticMolecule;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Vector;

public class MCS {
    public static final int DEFAULT_MIN_COMMON_SIZE = 9;
    public static final int MAX_NON_BREAKING_RING_SIZE = 8;
    public static final int MODE_EXACT = 1;
    public static final int MODE_TURBO = 3;
    public static final int MODE_FASTEST = 3;
    public static final int MODE_FAST = 2;
    private int mode = 2;
    private boolean allCS = false;
    private StaticMolecule targetMol = null;
    private StaticMolecule queryMol = null;
    private boolean queryMolChanged = true;
    private int minCommonSize = 9;
    private int maxCommonSize = 0;
    private boolean ignoreAtomType = false;
    private boolean ignoreBondType = false;
    private boolean ignoreCharge = true;
    private boolean ignoreHybridization = true;
    private boolean ignoreIsotopes = true;
    private boolean ignoreHydrogens = true;
    private boolean extendedAtomTypes = false;
    private boolean dontBreakRingBond = true;
    private boolean[] allowedQueryAtoms = null;
    private boolean[] allowedTargetAtoms = null;
    private boolean allowedDisjoint = false;
    private MolAtom[] molAtom = null;
    private int[] mcs = null;
    private int[] startBFSFromAtom = null;
    private Molecule substruct = null;
    private Vector allHits = new Vector();
    private Vector allHitSizes = new Vector();
    private int treeSize = 0;
    private int[] route = null;
    private boolean[] visited = null;
    private Queue visitQueue = new Queue();
    private boolean[] adequateAtoms = null;
    private int qRingCount = 0;
    private int[] qRingsSize = null;
    private int[] qRingsMappedAtomCount = null;
    private int[] qAtomIsInRing = null;
    private int[] qAtomIsInRingOfSize = null;
    private int tRingCount = 0;
    private int[] tRingsSize = null;
    private int[] tRingsMappedAtomCount = null;
    private int[] tAtomIsInRing = null;
    private int[] tAtomIsInRingOfSize = null;
    private int[] qRingToTRingMapped = null;
    private int[] baseNumber = null;
    private int[] state = null;
    private boolean carry = false;
    private int pos = 0;
    private int[][] valueToTargetAtomIndex = null;
    private int[] parentQueryNode = null;
    private int startingNode = -1;
    private boolean[] targetAtomMapped = null;
    private boolean[] mappedAtPos = null;
    private int[] mappedQRingAtPos = null;
    private int[] mappedTRingAtPos = null;
    private int[] queryAtomIndexToPos = null;
    private int currentMapSize = 0;
    private int currentMaxCommonSize = 0;
    private int[] reverseMap = null;
    private long timeLimit = 0L;
    private boolean timeLimitReached;
    private long startTime = 0L;
    private long stepCountLimit = 0L;
    private long stepCount;
    private boolean stepCountLimitReached;
    private boolean solutionFound = false;
    private int[] elemAnal = new int[109];
    private boolean allowDisjoint = false;

    public void setMolecules(Molecule query, Molecule target) {
        this.queryMol = new StaticMolecule(query, true);
        this.queryMolChanged = true;
        this.targetMol = new StaticMolecule(target);
        this.allowedQueryAtoms = null;
        this.allowedTargetAtoms = null;
        this.doElemAnal();
    }

    public void setMolecules(Molecule query, int[] queryExtraAtomTypes, Molecule target, int[] targetExtraAtomTypes) {
        this.queryMol = new StaticMolecule(query, true);
        this.queryMolChanged = true;
        this.targetMol = new StaticMolecule(target);
        this.allowedQueryAtoms = null;
        this.allowedTargetAtoms = null;
        this.setExtraAtomTypes(this.queryMol, queryExtraAtomTypes);
        this.setExtraAtomTypes(this.targetMol, targetExtraAtomTypes);
        this.doElemAnal();
    }

    private void setExtraAtomTypes(StaticMolecule m, int[] extraAtomTypes) {
        for (int i = 0; i < extraAtomTypes.length; ++i) {
            m.setAtomType(i, (byte)extraAtomTypes[i]);
        }
    }

    public void setMolecules(StaticMolecule query, StaticMolecule target) {
        this.queryMol = query;
        this.queryMolChanged = true;
        this.targetMol = target;
        this.allowedQueryAtoms = null;
        this.allowedTargetAtoms = null;
        this.doElemAnal();
    }

    public void setQuery(Molecule query) {
        this.queryMol = new StaticMolecule(query, true);
        this.allowedQueryAtoms = null;
        this.queryMolChanged = true;
        this.doElemAnal();
    }

    public void setTarget(Molecule target) {
        this.targetMol = new StaticMolecule(target, true);
        this.allowedTargetAtoms = null;
    }

    public void setStepCountLimit(long stepCountLimit) {
        this.stepCountLimit = stepCountLimit;
    }

    public void setMinimumCommonSize(int minMCSsize) {
        this.minCommonSize = minMCSsize;
    }

    public void setIgnoreAtomType(boolean ignore) {
        this.ignoreAtomType = ignore;
    }

    public void setIgnoreHybridization(boolean ignore) {
        this.ignoreHybridization = ignore;
    }

    public void setIgnoreCharge(boolean ignore) {
        this.ignoreCharge = ignore;
    }

    public void setIgnoreIsotopes(boolean ignore) {
        this.ignoreIsotopes = ignore;
    }

    public void setIgnoreBondType(boolean ignore) {
        this.ignoreBondType = ignore;
    }

    public void setIgnoreHydrogens(boolean ignore) {
        this.ignoreHydrogens = ignore;
    }

    public void setDontBreakRingBonds(boolean dontBreakRingBond) {
        this.dontBreakRingBond = dontBreakRingBond;
    }

    public void setMode(int newMode) {
        this.mode = newMode;
    }

    public void setAllCS(boolean allCS) {
        this.allCS = allCS;
    }

    public void setMatchExtendedAtomTypes(boolean extendedAtomTypes) {
        this.extendedAtomTypes = extendedAtomTypes;
    }

    long getStepCount() {
        return this.stepCount;
    }

    public void excludeQueryAtom(int excludedQueryAtom) {
        if (this.allowedQueryAtoms == null) {
            this.allowedQueryAtoms = new boolean[this.queryMol.getAtomCount()];
            this.fill(this.allowedQueryAtoms, true);
        }
        this.allowedQueryAtoms[excludedQueryAtom] = false;
    }

    public void excludeTargetAtom(int excludedTargetAtom) {
        if (this.allowedTargetAtoms == null) {
            this.allowedTargetAtoms = new boolean[this.targetMol.getAtomCount()];
            this.fill(this.allowedTargetAtoms, true);
        }
        this.allowedTargetAtoms[excludedTargetAtom] = false;
    }

    public void setTimeLimit(long maxAllowedSearchTime) {
        this.timeLimit = maxAllowedSearchTime;
    }

    public boolean search() {
        if (!this.findFirst()) {
            return false;
        }
        while (this.findNext()) {
        }
        return true;
    }

    public boolean findFirst() {
        this.init();
        this.startingNode = 0;
        while (this.startingNode < this.queryMol.getAtomCount()) {
            if (this.startBFSFromAtom[this.startingNode] != Integer.MAX_VALUE) {
                this.createSpannigTree(this.startBFSFromAtom[this.startingNode]);
                if (this.treeSize >= this.minCommonSize) {
                    this.setupConstrainedBacktrack();
                    if (this.treeSize >= this.minCommonSize) {
                        this.carry = false;
                        this.pos = 0;
                        while (!(this.carry || this.timeLimitReached || this.stepCountLimitReached)) {
                            if (this.find() && this.solutionFound) {
                                return true;
                            }
                            this.next();
                        }
                    }
                }
            }
            ++this.startingNode;
        }
        return this.mcs != null;
    }

    public boolean findNext() {
        if (this.timeLimitReached || this.stepCountLimitReached) {
            return false;
        }
        if (this.startingNode == this.queryMol.getAtomCount()) {
            return false;
        }
        this.solutionFound = false;
        if (!this.carry) {
            this.next();
        }
        while (true) {
            if (!(this.carry || this.timeLimitReached || this.stepCountLimitReached)) {
                if (this.find() && this.solutionFound) {
                    return true;
                }
                this.next();
                continue;
            }
            this.carry = false;
            this.pos = 0;
            while (++this.startingNode < this.queryMol.getAtomCount()) {
                if (this.startBFSFromAtom[this.startingNode] == Integer.MAX_VALUE) continue;
                this.createSpannigTree(this.startBFSFromAtom[this.startingNode]);
                if (this.treeSize < this.minCommonSize) continue;
                this.setupConstrainedBacktrack();
                if (this.treeSize < this.minCommonSize) continue;
            }
            if (this.startingNode == this.queryMol.getAtomCount()) break;
        }
        return false;
    }

    public int[] getResult() {
        return this.mcs;
    }

    public int getResultSize() {
        return this.currentMaxCommonSize;
    }

    public int getCSCount() {
        if (!this.allCS) {
            throw new RuntimeException("Bad usage: getCSCount() can be called in allCS mode only.");
        }
        return this.allHits.size();
    }

    public int[] getCS(int i) {
        if (!this.allCS) {
            throw new RuntimeException("Bad usage: getCS() can be called in allCS mode only.");
        }
        return (int[])this.allHits.get(i);
    }

    public int getCSSize(int i) {
        if (!this.allCS) {
            throw new RuntimeException("Bad usage: getCSSize() can be called in allCS mode only.");
        }
        return (Integer)this.allHitSizes.get(i);
    }

    public String getResultAsSmiles(boolean unique) {
        if (this.mcs == null) {
            return null;
        }
        return this.extractSubstructure(this.mcs, unique);
    }

    public Molecule getResultAsMolecule() {
        if (this.mcs == null) {
            return null;
        }
        this.extractSubstructure(this.mcs, false);
        return this.substruct;
    }

    public StaticMolecule getResultAsStaticMolecule() {
        int i;
        if (this.mcs == null) {
            return null;
        }
        int[] molAtom = new int[this.queryMol.getAtomCount()];
        StaticMolecule sm = new StaticMolecule(this.currentMaxCommonSize, this.currentMaxCommonSize, 777);
        int ai = 0;
        for (i = 0; i < this.queryMol.getAtomCount(); ++i) {
            if (this.mcs[i] == -1) continue;
            sm.addAtom((byte)this.queryMol.getAtomType(i));
            molAtom[i] = ai++;
        }
        for (i = 0; i < this.queryMol.getAtomCount(); ++i) {
            if (this.mcs[i] == -1) continue;
            for (int j = 0; j < i; ++j) {
                if (this.mcs[j] == -1 || !this.queryMol.areNeighbors(i, j)) continue;
                sm.addBond(molAtom[i], molAtom[j], this.queryMol.getBondType(i, j));
            }
        }
        int[] rgAtoms = this.getRGroupAtoms();
        for (int i2 = 0; i2 < rgAtoms.length; ++i2) {
            rgAtoms[i2] = molAtom[rgAtoms[i2]];
        }
        return sm;
    }

    public int[] getRGroupAtoms() {
        int i;
        int[] rga = new int[2 * this.queryMol.getAtomCount()];
        int rgaCount = 0;
        for (i = 0; i < this.queryMol.getAtomCount(); ++i) {
            if (this.mcs[i] == -1) continue;
            for (int j = 0; j < this.queryMol.getNeighborCount(i); ++j) {
                int n = this.queryMol.getNeighbor(i, j);
                if (this.mcs[n] != -1) continue;
                rga[rgaCount++] = i;
            }
        }
        for (i = 0; i < this.queryMol.getAtomCount(); ++i) {
            if (this.mcs[i] == -1) continue;
            int targetAtom = this.mcs[i];
            for (int j = 0; j < this.targetMol.getNeighborCount(targetAtom); ++j) {
                int n = this.targetMol.getNeighbor(targetAtom, j);
                if (ArrayTools.foundInArray(this.mcs, n)) continue;
                rga[rgaCount++] = i;
            }
        }
        int[] rgaFinal = new int[rgaCount];
        System.arraycopy(rga, 0, rgaFinal, 0, rgaCount);
        return rgaFinal;
    }

    public int[] getResultQueryAtoms() {
        if (this.mcs == null) {
            return null;
        }
        int[] resultAtoms = new int[this.currentMaxCommonSize];
        int j = 0;
        for (int i = 0; i < this.mcs.length; ++i) {
            if (this.mcs[i] == -1) continue;
            resultAtoms[j++] = i;
        }
        return resultAtoms;
    }

    public int[] getResultTargetAtoms() {
        if (this.mcs == null) {
            return null;
        }
        int[] resultAtoms = new int[this.currentMaxCommonSize];
        int j = 0;
        for (int i = 0; i < this.mcs.length; ++i) {
            if (this.mcs[i] == -1) continue;
            resultAtoms[j++] = this.mcs[i];
        }
        return resultAtoms;
    }

    private boolean find() {
        while (this.pos != this.treeSize && !this.timeLimitReached && !this.stepCountLimitReached) {
            if (!this.good()) {
                return false;
            }
            if (this.currentMapSize >= this.minCommonSize && (!this.dontBreakRingBond || this.ringsComplete())) {
                this.addCommonSubstructure();
            }
            ++this.pos;
            this.timeLimitReached = this.timeLimit != 0L && System.currentTimeMillis() - this.startTime > this.timeLimit;
            this.stepCountLimitReached = this.stepCountLimit > 0L && ++this.stepCount > this.stepCountLimit;
        }
        --this.pos;
        return !this.timeLimitReached && !this.stepCountLimitReached;
    }

    private boolean good() {
        int predecessorPos;
        int targetAtom = this.valueToTargetAtomIndex[this.pos][this.state[this.pos]];
        if (this.pos == 0 || this.parentQueryNode[this.pos] == -2) {
            if (this.state[this.pos] == this.baseNumber[this.pos] - 1) {
                return false;
            }
            if (!this.matchAtoms(this.route[this.pos], targetAtom)) {
                return false;
            }
            if (!this.goodRings(targetAtom)) {
                return false;
            }
            this.targetAtomMapped[targetAtom] = true;
            this.mappedAtPos[this.pos] = true;
            ++this.currentMapSize;
            return true;
        }
        if (this.state[this.pos] == this.baseNumber[this.pos] - 1) {
            if (this.baseNumber[this.pos] == 1) {
                return true;
            }
            if (this.mode == 3) {
                return false;
            }
            int predecessorPos2 = this.parentQueryNode[this.pos] == -1 ? this.pos - 1 : this.parentQueryNode[this.pos];
            return !this.dontBreakRingBond || this.qAtomIsInRing[this.route[this.pos]] == 0;
        }
        if (this.targetAtomMapped[targetAtom]) {
            return false;
        }
        int n = predecessorPos = this.parentQueryNode[this.pos] == -1 ? this.pos - 1 : this.parentQueryNode[this.pos];
        if (this.state[predecessorPos] == this.baseNumber[predecessorPos] - 1) {
            return false;
        }
        try {
            if (!this.match(predecessorPos)) {
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace(System.out);
            System.err.println("q=" + this.queryMol.toMolecule().toFormat("smiles"));
            System.err.println("t=" + this.targetMol.toMolecule().toFormat("smiles"));
            System.err.println("pos=" + this.pos + " predecessorPos=" + predecessorPos);
            this.dump();
            throw e;
        }
        if (!this.goodRings(targetAtom)) {
            return false;
        }
        if (this.dontBreakRingBond && (this.pos + 1 == this.treeSize || this.allTargetAtomsMapped()) && !this.ringsComplete()) {
            return false;
        }
        this.targetAtomMapped[targetAtom] = true;
        this.mappedAtPos[this.pos] = true;
        ++this.currentMapSize;
        return true;
    }

    private boolean allTargetAtomsMapped() {
        for (int i = 0; i < this.targetAtomMapped.length; ++i) {
            if (this.targetAtomMapped[i]) continue;
            return false;
        }
        return true;
    }

    private boolean ringsComplete() {
        int i;
        for (i = 0; i < this.qRingsMappedAtomCount.length; ++i) {
            if (this.qRingsMappedAtomCount[i] == 0 || this.qRingsMappedAtomCount[i] == this.qRingsSize[i] || this.joinedRingCheck(i, this.qAtomIsInRing, this.qRingCount, this.qRingsMappedAtomCount, this.qRingsSize)) continue;
            return false;
        }
        for (i = 0; i < this.tRingsMappedAtomCount.length; ++i) {
            if (this.tRingsMappedAtomCount[i] == 0 || this.tRingsMappedAtomCount[i] == this.tRingsSize[i] || this.joinedRingCheck(i, this.tAtomIsInRing, this.tRingCount, this.tRingsMappedAtomCount, this.tRingsSize)) continue;
            return false;
        }
        return true;
    }

    private boolean goodRings(int targetAtom) {
        if (this.dontBreakRingBond && this.qAtomIsInRing[this.route[this.pos]] != 0) {
            int[] qri = new int[16];
            int[] tri = new int[16];
            if (!this.goodRingMapping(qri, tri, targetAtom)) {
                return false;
            }
            if (this.pos + 1 == this.treeSize) {
                // empty if block
            }
            this.updateRingMapping(qri, tri, targetAtom);
        }
        return true;
    }

    private boolean goodRingMapping(int[] qRingIndices, int[] tRingIndices, int targetAtom) {
        int i;
        this.fill(qRingIndices, -1);
        this.fill(tRingIndices, -1);
        int nqri = 0;
        int ringIndexBit = 1;
        for (i = 0; i < this.qRingCount; ++i) {
            if ((this.qAtomIsInRing[this.route[this.pos]] & ringIndexBit) != 0) {
                qRingIndices[nqri++] = i;
            }
            ringIndexBit <<= 1;
        }
        for (i = 0; i < nqri; ++i) {
            if (this.qRingToTRingMapped[qRingIndices[i]] == 0 || (this.qRingToTRingMapped[qRingIndices[i]] & this.tAtomIsInRing[targetAtom]) != 0) continue;
            qRingIndices[i] = -1;
            --nqri;
        }
        return nqri != 0;
    }

    private void updateRingMapping(int[] qRingIndices, int[] tRingIndices, int targetAtom) {
        for (int i = 0; i < qRingIndices.length; ++i) {
            if (qRingIndices[i] == -1) continue;
            int n = qRingIndices[i];
            this.qRingToTRingMapped[n] = this.qRingToTRingMapped[n] | this.tAtomIsInRing[targetAtom];
            int n2 = qRingIndices[i];
            this.qRingsMappedAtomCount[n2] = this.qRingsMappedAtomCount[n2] + 1;
            int n3 = this.pos;
            this.mappedQRingAtPos[n3] = this.mappedQRingAtPos[n3] | 1 << qRingIndices[i];
            int n4 = this.pos;
            this.mappedTRingAtPos[n4] = this.mappedTRingAtPos[n4] | this.tAtomIsInRing[targetAtom];
        }
        int tRingBit = 1;
        for (int j = 0; j < this.tRingsMappedAtomCount.length; ++j) {
            if ((this.tAtomIsInRing[targetAtom] & tRingBit) != 0) {
                int n = j;
                this.tRingsMappedAtomCount[n] = this.tRingsMappedAtomCount[n] + 1;
            }
            tRingBit <<= 1;
        }
    }

    private boolean joinedRingCheck(int ringIndex, int[] atomInRing, int ringCount, int[] mappedAtomCount, int[] ringSize) {
        int[] sharedAtom = new int[16];
        int sharedAtomCount = 0;
        int[] otherRings = new int[16];
        int otherRingCount = 0;
        int ringBitMask = 1 << ringIndex;
        for (int atom = 0; atom < atomInRing.length; ++atom) {
            if ((atomInRing[atom] & ringBitMask) == 0 || atomInRing[atom] - ringBitMask == 0) continue;
            int otherRingIndexes = atomInRing[atom] - ringBitMask;
            int riMask = 1;
            for (int ri = 0; ri < this.qRingCount; ++ri) {
                if ((otherRingIndexes & riMask) == 0) continue;
                boolean l = false;
                for (int j = 0; !l && j < otherRingCount; ++j) {
                    l = otherRings[j] == ri;
                }
                if (!l) {
                    otherRings[otherRingCount++] = ri;
                    sharedAtom[sharedAtomCount++] = atom;
                }
                riMask <<= 1;
            }
        }
        if (sharedAtomCount == 0) {
            return false;
        }
        for (int i = 0; i < otherRingCount; ++i) {
            ringBitMask = 1;
            for (int b = 0; b < ringCount; ++b) {
                if ((otherRings[i] & ringBitMask) != 0 && mappedAtomCount[b] != 0 && mappedAtomCount[b] != ringSize[b]) {
                    return false;
                }
                ringBitMask <<= 1;
            }
        }
        return true;
    }

    private boolean match(int predecessorPos) {
        int targetAtomMappedToPredecessor;
        int n = targetAtomMappedToPredecessor = this.state[predecessorPos] == this.baseNumber[predecessorPos] - 1 ? -1 : this.valueToTargetAtomIndex[predecessorPos][this.state[predecessorPos]];
        if (targetAtomMappedToPredecessor == -1) {
            return false;
        }
        int atomAtPos = this.route[this.pos];
        int targetAtomMappedToAtomAtPos = this.state[this.pos] == this.baseNumber[this.pos] - 1 ? -1 : this.valueToTargetAtomIndex[this.pos][this.state[this.pos]];
        int targetBond = -1;
        try {
            if (targetAtomMappedToAtomAtPos != -1 && targetAtomMappedToPredecessor != -1) {
                if (targetAtomMappedToAtomAtPos == targetAtomMappedToPredecessor) {
                    return false;
                }
                if (!this.targetMol.areNeighbors(targetAtomMappedToAtomAtPos, targetAtomMappedToPredecessor)) {
                    return false;
                }
                targetBond = this.targetMol.getBondType(targetAtomMappedToAtomAtPos, targetAtomMappedToPredecessor);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("targetAtomMappedToAtomAtPos = " + targetAtomMappedToAtomAtPos);
            System.err.println("targetAtomMappedToPredecessor = " + targetAtomMappedToPredecessor);
            throw e;
        }
        if (targetAtomMappedToAtomAtPos != -1 && !this.matchAtoms(atomAtPos, targetAtomMappedToAtomAtPos)) {
            return false;
        }
        int predecessorAtom = this.route[predecessorPos];
        if (targetBond != -1 && !this.ignoreBondType) {
            if (!this.queryMol.areNeighbors(atomAtPos, predecessorAtom)) {
                return false;
            }
            int queryBond = this.queryMol.getBondType(atomAtPos, predecessorAtom);
            if (queryBond != targetBond) {
                return false;
            }
        }
        return targetAtomMappedToAtomAtPos == -1 || this.checkQueryTargetInducedEdges(predecessorAtom, atomAtPos, targetAtomMappedToAtomAtPos);
    }

    private boolean checkQueryTargetInducedEdges(int predecessorAtom, int atomAtPos, int targetAtomAtPos) {
        for (int i = 0; i < this.queryMol.getNeighborCount(atomAtPos); ++i) {
            int neighPos;
            int neigh = this.queryMol.getNeighbor(atomAtPos, i);
            if (neigh == predecessorAtom || (neighPos = this.queryAtomIndexToPos[neigh]) > this.pos) continue;
            int neighTargetAtom = this.valueToTargetAtomIndex[neighPos][this.state[neighPos]];
            if (neighTargetAtom == -1) {
                return true;
            }
            if (this.ignoreBondType) continue;
            int queryBond = this.queryMol.getBondType(atomAtPos, neigh);
            if (this.targetMol.areNeighbors(targetAtomAtPos, neighTargetAtom)) continue;
            if (!this.targetMol.areNeighbors(targetAtomAtPos, neighTargetAtom)) {
                return false;
            }
            int targetBond = this.targetMol.getBondType(targetAtomAtPos, neighTargetAtom);
            if (queryBond == targetBond) continue;
            return false;
        }
        return true;
    }

    private boolean matchAtoms(int queryAtomIndex, int targetAtomIndex) {
        if ((this.queryMol.getAtomMap(queryAtomIndex) > 0 || this.targetMol.getAtomMap(targetAtomIndex) > 0) && this.queryMol.getAtomMap(queryAtomIndex) != this.targetMol.getAtomMap(targetAtomIndex)) {
            return false;
        }
        if (this.queryMol.getRgroupId(queryAtomIndex) != 0 || this.queryMol.getSGroupId(queryAtomIndex) != null) {
            return true;
        }
        int qa = this.queryMol.getAtomType(queryAtomIndex);
        int ta = this.targetMol.getAtomType(targetAtomIndex);
        if (!this.ignoreAtomType && (qa == 128 ? !this.queryMol.inAtomList(queryAtomIndex, ta) : (qa == 129 ? this.queryMol.inAtomList(queryAtomIndex, ta) : (qa == 132 ? ta == 1 || ta == 6 : qa != 131 && qa != ta)))) {
            return false;
        }
        if (!this.ignoreHybridization && this.queryMol.getHybridizationState(queryAtomIndex) != this.targetMol.getHybridizationState(targetAtomIndex)) {
            return false;
        }
        if (!this.ignoreCharge && this.queryMol.getCharge(queryAtomIndex) != this.targetMol.getCharge(targetAtomIndex)) {
            return false;
        }
        return this.ignoreIsotopes || this.queryMol.getMassno(queryAtomIndex) == this.targetMol.getMassno(targetAtomIndex);
    }

    private void next() {
        while (true) {
            if (this.mappedAtPos[this.pos]) {
                int targetAtom = this.valueToTargetAtomIndex[this.pos][this.state[this.pos]];
                this.targetAtomMapped[targetAtom] = false;
                --this.currentMapSize;
                this.mappedAtPos[this.pos] = false;
                if (this.mappedQRingAtPos[this.pos] != 0) {
                    int i;
                    int ringIndexBit = 1;
                    for (i = 0; i < this.qRingCount; ++i) {
                        if ((this.mappedQRingAtPos[this.pos] & ringIndexBit) != 0) {
                            int n = i;
                            this.qRingToTRingMapped[n] = this.qRingToTRingMapped[n] ^ this.tAtomIsInRing[targetAtom];
                            int n2 = i;
                            this.qRingsMappedAtomCount[n2] = this.qRingsMappedAtomCount[n2] - 1;
                        }
                        ringIndexBit <<= 1;
                    }
                    ringIndexBit = 1;
                    for (i = 0; i < this.tRingCount; ++i) {
                        if ((this.mappedTRingAtPos[this.pos] & ringIndexBit) != 0) {
                            int n = i;
                            this.tRingsMappedAtomCount[n] = this.tRingsMappedAtomCount[n] - 1;
                        }
                        ringIndexBit <<= 1;
                    }
                    this.mappedQRingAtPos[this.pos] = 0;
                    this.mappedTRingAtPos[this.pos] = 0;
                }
            }
            if (this.state[this.pos] < this.baseNumber[this.pos] - 1) {
                int n = this.pos;
                this.state[n] = this.state[n] + 1;
                this.carry = false;
                return;
            }
            if (this.pos == 0) {
                this.carry = true;
                return;
            }
            this.state[this.pos--] = 0;
        }
    }

    private void createSpannigTree(int startingNode) {
        int i;
        this.treeSize = 0;
        for (i = 0; i < this.visited.length; ++i) {
            this.visited[i] = false;
        }
        if (!this.isAllowedQueryAtom(startingNode)) {
            return;
        }
        this.visitQueue.addLast(-1);
        this.visitQueue.addLast(startingNode);
        this.visit();
        while (!this.visitQueue.empty && this.allowDisjoint) {
            this.visitQueue.clear();
            for (i = 0; i < this.queryMol.getAtomCount(); ++i) {
                if (this.visited[i]) continue;
                this.visitQueue.addLast(-1);
                this.visitQueue.addLast(i);
                break;
            }
            this.visit();
        }
    }

    private void visit() {
        while (!this.visitQueue.isEmpty()) {
            int parent = this.visitQueue.removeFirst();
            int nodeIndex = this.visitQueue.removeFirst();
            if (this.visited[nodeIndex]) continue;
            this.visited[nodeIndex] = true;
            if (this.ignoreHydrogens && this.queryMol.getAtomType(nodeIndex) == 1) continue;
            this.route[this.treeSize++] = nodeIndex;
            for (int ni = 0; ni < this.queryMol.getNeighborCount(nodeIndex); ++ni) {
                int neigh = this.queryMol.getNeighbor(nodeIndex, ni);
                if (neigh == parent || !this.isAllowedQueryAtom(neigh)) continue;
                this.visitQueue.addLast(nodeIndex);
                this.visitQueue.addLast(neigh);
            }
        }
    }

    private boolean isAllowedQueryAtom(int atom) {
        return this.allowedQueryAtoms == null || this.allowedQueryAtoms[atom];
    }

    private boolean isAllowedTargetAtom(int atom) {
        return this.allowedTargetAtoms == null || this.allowedTargetAtoms[atom];
    }

    private void setupConstrainedBacktrack() {
        int j;
        int i;
        int ts = this.targetMol.getAtomCount();
        int position = 0;
        for (i = 0; i < this.treeSize; ++i) {
            this.queryAtomIndexToPos[this.route[i]] = i;
            this.baseNumber[position] = 0;
            for (j = 0; j < ts; ++j) {
                if (!this.isAllowedTargetAtom(j) || !this.adequateAtoms[this.route[i] * ts + j]) continue;
                int n = position;
                int n2 = this.baseNumber[n];
                this.baseNumber[n] = n2 + 1;
                this.valueToTargetAtomIndex[position][n2] = j;
            }
            if (this.baseNumber[position] == 0) continue;
            int n = position;
            int n3 = this.baseNumber[n];
            this.baseNumber[n] = n3 + 1;
            this.valueToTargetAtomIndex[position][n3] = -1;
            ++position;
        }
        this.treeSize = position;
        for (i = 0; i < this.treeSize; ++i) {
            this.parentQueryNode[i] = -1;
        }
        for (i = 1; i < this.treeSize; ++i) {
            if (this.queryMol.areNeighbors(this.route[i], this.route[i - 1])) continue;
            for (j = i - 2; j >= 0 && !this.queryMol.areNeighbors(this.route[i], this.route[j]); --j) {
            }
            this.parentQueryNode[i] = j < 0 ? -2 : j;
        }
        this.solutionFound = false;
        for (i = 0; i < this.state.length; ++i) {
            this.state[i] = 0;
            this.mappedAtPos[i] = false;
        }
        for (i = 0; i < this.targetAtomMapped.length; ++i) {
            this.targetAtomMapped[i] = false;
        }
        this.currentMapSize = 0;
    }

    private boolean adequateAtoms(int queryAtomIndex, int targetAtomIndex) {
        if (this.queryMol.getRgroupId(queryAtomIndex) != 0) {
            return this.targetMol.getRgroupId(targetAtomIndex) == this.queryMol.getRgroupId(queryAtomIndex);
        }
        if (this.queryMol.getSGroupId(queryAtomIndex) != null) {
            return this.targetMol.getSGroupId(targetAtomIndex) != null && this.targetMol.getSGroupId(targetAtomIndex).equals(this.queryMol.getSGroupId(queryAtomIndex));
        }
        int queryAtomType = this.queryMol.getAtomType(queryAtomIndex);
        int targetAtomType = this.targetMol.getAtomType(targetAtomIndex);
        if (queryAtomType == 137 || targetAtomType == 137) {
            return false;
        }
        if (!(this.ignoreAtomType || queryAtomType == 131 || queryAtomType == 132 && targetAtomType != 1 && targetAtomType != 6 || queryAtomType == 128 && this.queryMol.inAtomList(queryAtomIndex, targetAtomType) || queryAtomType == 129 && !this.queryMol.inAtomList(queryAtomIndex, targetAtomType) || !this.extendedAtomTypes && targetAtomType == queryAtomType || this.extendedAtomTypes && this.queryMol.matchingExtendedAtomType(queryAtomIndex, this.targetMol.getExtendedAtomType(targetAtomIndex)))) {
            return false;
        }
        if (!this.ignoreHybridization && this.queryMol.getHybridizationState(queryAtomIndex) != this.targetMol.getHybridizationState(targetAtomIndex)) {
            return false;
        }
        if (this.dontBreakRingBond) {
            if (this.qAtomIsInRing[queryAtomIndex] == 0 && this.tAtomIsInRing[targetAtomIndex] == 0) {
                return true;
            }
            if (this.qAtomIsInRing[queryAtomIndex] == 0 && this.tAtomIsInRing[targetAtomIndex] != 0) {
                return this.hasChainBondedNeighbour(this.targetMol, targetAtomIndex);
            }
            if (this.qAtomIsInRing[queryAtomIndex] != 0 && this.tAtomIsInRing[targetAtomIndex] == 0) {
                return this.hasChainBondedNeighbour(this.queryMol, queryAtomIndex);
            }
            return (this.qAtomIsInRingOfSize[queryAtomIndex] & this.tAtomIsInRingOfSize[targetAtomIndex]) != 0;
        }
        return true;
    }

    private boolean hasChainBondedNeighbour(StaticMolecule m, int atomIndex) {
        for (int ni = 0; ni < m.getNeighborCount(atomIndex); ++ni) {
            if (m.isRingBond(atomIndex, m.getNeighbor(atomIndex, ni))) continue;
            return true;
        }
        return false;
    }

    private void addCommonSubstructure() {
        int i;
        if (this.currentMapSize < this.minCommonSize) {
            return;
        }
        if (!this.allCS && this.currentMapSize <= this.currentMaxCommonSize) {
            return;
        }
        this.currentMaxCommonSize = this.currentMapSize;
        int[] map = new int[this.queryMol.getAtomCount()];
        for (i = 0; i < map.length; ++i) {
            map[i] = -1;
        }
        for (i = 0; i <= this.pos; ++i) {
            map[this.route[i]] = this.valueToTargetAtomIndex[i][this.state[i]];
        }
        if (this.mode == 2 || this.mode == 3) {
            this.updateBFSStartingPoints(map);
        }
        if (this.isNewSolution(map)) {
            this.mcs = map;
            if (this.allCS) {
                this.insertNewHit(map, this.currentMapSize);
            } else {
                this.allHits.addElement(map);
            }
            this.solutionFound = this.currentMaxCommonSize == this.maxCommonSize;
        }
    }

    private void updateReverseMap() {
        Arrays.fill(this.reverseMap, -1);
        for (int i = 0; i <= this.pos; ++i) {
            this.reverseMap[this.valueToTargetAtomIndex[i][this.state[i]]] = this.route[i];
        }
    }

    private boolean isNewSolution(int[] map) {
        for (int i = 0; i < this.allHits.size(); ++i) {
            int[] m = (int[])this.allHits.elementAt(i);
            boolean same = true;
            for (int j = 0; same && j < m.length; ++j) {
                same = m[j] == map[j];
            }
            if (!same) continue;
            return false;
        }
        return true;
    }

    private void insertNewHit(int[] map, int size) {
        int i;
        for (i = 0; i < this.allHits.size() && (Integer)this.allHitSizes.get(i) > size; ++i) {
        }
        this.allHits.add(i, map);
        this.allHitSizes.add(i, new Integer(size));
    }

    private String extractSubstructure(int[] map, boolean unique) {
        int i;
        unique = false;
        int bondCount = this.queryMol.getBondCount();
        this.substruct = new Molecule(null, this.currentMapSize, bondCount);
        for (i = 0; i < this.queryMol.getAtomCount(); ++i) {
            this.molAtom[i] = null;
            if (map[i] == -1) continue;
            this.molAtom[i] = new MolAtom(this.queryMol.getAtomType(i));
            this.substruct.add(this.molAtom[i]);
        }
        for (i = 0; i < this.queryMol.getAtomCount(); ++i) {
            if (map[i] == -1) continue;
            for (int j = 0; j < i; ++j) {
                if (map[j] == -1 || !this.queryMol.areNeighbors(i, j) || !this.matchingBonds(i, j, map[i], map[j])) continue;
                this.substruct.add(new MolBond(this.molAtom[i], this.molAtom[j], this.queryMol.getBondType(i, j)));
            }
        }
        return this.substruct.toFormat("smiles" + (unique ? ":u" : ""));
    }

    public boolean matchingBonds(int qa1, int qa2, int ta1, int ta2) {
        if (!this.queryMol.areNeighbors(qa1, qa2)) {
            return false;
        }
        if (!this.targetMol.areNeighbors(ta1, ta2)) {
            return false;
        }
        if (this.ignoreBondType) {
            return true;
        }
        return this.queryMol.getBondType(qa1, qa2) == this.targetMol.getBondType(ta1, ta2);
    }

    private void updateBFSStartingPoints(int[] map) {
        block0: for (int i = 0; i < map.length; ++i) {
            int j;
            if (map[i] == -1) continue;
            boolean found = true;
            for (j = 0; found && j < this.queryMol.getNeighborCount(i); ++j) {
                found = map[this.queryMol.getNeighbor(i, j)] != -1;
            }
            if (!found) continue;
            for (j = 0; j < this.queryMol.getAtomCount(); ++j) {
                if (this.startBFSFromAtom[j] != map[i] && this.isAllowedQueryAtom(j)) continue;
                this.startBFSFromAtom[j] = Integer.MAX_VALUE;
                continue block0;
            }
        }
    }

    private void init() {
        this.timeLimitReached = false;
        this.stepCountLimitReached = false;
        this.startTime = 0L;
        this.stepCount = 0L;
        this.alloc();
        this.mcs = null;
        this.allHits.removeAllElements();
        this.maxCommonSize = Math.min(this.queryMol.getAtomCount(), this.targetMol.getAtomCount());
        this.currentMaxCommonSize = 0;
        if (this.queryMolChanged) {
            this.initBFSStartingPoints();
        }
        if (this.dontBreakRingBond) {
            this.clear(this.mappedQRingAtPos);
            this.clear(this.mappedTRingAtPos);
            this.findRingAtoms();
        }
        this.initAdequateAtoms();
        this.queryMolChanged = false;
    }

    private void findRingAtoms() {
        SSSR rs = new SSSR();
        this.clear(this.qAtomIsInRing);
        this.clear(this.tAtomIsInRing);
        this.clear(this.qAtomIsInRingOfSize);
        this.clear(this.tAtomIsInRingOfSize);
        rs.setGraph(this.queryMol.toMolecule().smol());
        rs.startRingSearch(false);
        int[][] qr = rs.getRings();
        this.qRingCount = rs.getRingCount();
        int ringIndexBit = 1;
        for (int i = 0; i < qr.length; ++i) {
            this.qRingsSize[i] = qr[i].length;
            this.qRingsMappedAtomCount[i] = 0;
            for (int j = 0; j < qr[i].length; ++j) {
                int n = qr[i][j];
                this.qAtomIsInRing[n] = this.qAtomIsInRing[n] | ringIndexBit;
                int n2 = qr[i][j];
                this.qAtomIsInRingOfSize[n2] = this.qAtomIsInRingOfSize[n2] | 1 << this.qRingsSize[i];
            }
            ringIndexBit <<= 1;
        }
        rs.setGraph(this.targetMol.toMolecule().smol());
        rs.startRingSearch(false);
        int[][] tr = rs.getRings();
        this.tRingCount = rs.getRingCount();
        ringIndexBit = 1;
        for (int i = 0; i < tr.length; ++i) {
            this.tRingsSize[i] = tr[i].length;
            this.tRingsMappedAtomCount[i] = 0;
            for (int j = 0; j < tr[i].length; ++j) {
                int n = tr[i][j];
                this.tAtomIsInRing[n] = this.tAtomIsInRing[n] | ringIndexBit;
                int n3 = tr[i][j];
                this.tAtomIsInRingOfSize[n3] = this.tAtomIsInRingOfSize[n3] | 1 << this.tRingsSize[i];
            }
            ringIndexBit <<= 1;
        }
    }

    private void initBFSStartingPoints() {
        int mini;
        int i;
        int qgSize = this.queryMol.getAtomCount();
        float[] scores = new float[qgSize];
        for (i = 0; i < qgSize; ++i) {
            scores[i] = this.isAllowedQueryAtom(i) ? this.atomScore(i) : 2.1474836E9f;
        }
        for (i = 0; i < qgSize && scores[mini = this.findmin(scores)] != 2.1474836E9f; ++i) {
            this.startBFSFromAtom[i] = mini;
            scores[mini] = 2.1474836E9f;
        }
    }

    private int findmin(float[] a) {
        int mini = 0;
        float min = a[mini];
        for (int i = 1; i < a.length; ++i) {
            if (!(a[i] < min)) continue;
            mini = i;
            min = a[mini];
        }
        return mini;
    }

    private float atomScore(int atomIndex) {
        float frequencyScore;
        if (this.queryMol.getRgroupId(atomIndex) != 0 || this.queryMol.getSGroupId(atomIndex) != null) {
            return 1.0f;
        }
        int atno = this.queryMol.getAtomType(atomIndex);
        float f = frequencyScore = atno > 109 ? 1.0f : (float)this.elemAnal[atno] / (float)this.queryMol.getAtomCount();
        if (atno < this.elemAnal.length && this.elemAnal[atno] == 1 || this.queryMol.getNeighborCount(atomIndex) == 1) {
            return frequencyScore;
        }
        float locationScore = (float)this.queryMol.getNeighborCount(atomIndex) / 4.0f;
        return 0.5f * frequencyScore + 0.5f * locationScore;
    }

    private void initAdequateAtoms() {
        if (this.extendedAtomTypes) {
            this.queryMol.generateExtendedAtomType(!this.ignoreHydrogens);
            this.targetMol.generateExtendedAtomType(!this.ignoreHydrogens);
        }
        for (int i = 0; i < this.queryMol.getAtomCount(); ++i) {
            for (int j = 0; j < this.targetMol.getAtomCount(); ++j) {
                this.adequateAtoms[i * this.targetMol.getAtomCount() + j] = this.adequateAtoms(i, j);
            }
        }
    }

    private void doElemAnal() {
        int i;
        for (i = 0; i < this.elemAnal.length; ++i) {
            this.elemAnal[i] = 0;
        }
        for (i = 0; i < this.queryMol.getAtomCount(); ++i) {
            int at = this.queryMol.getAtomType(i);
            if (at >= this.elemAnal.length) continue;
            int n = at;
            this.elemAnal[n] = this.elemAnal[n] + 1;
        }
    }

    private void fill(boolean[] a, boolean v) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = v;
        }
    }

    private void fill(int[] a, int v) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = v;
        }
    }

    private void clear(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = 0;
        }
    }

    private void alloc() {
        int qgSize = this.queryMol.getAtomCount();
        int tgSize = this.targetMol.getAtomCount();
        if (this.route == null || qgSize > this.route.length) {
            this.startBFSFromAtom = new int[qgSize];
            this.route = new int[qgSize];
            this.visited = new boolean[qgSize];
            this.baseNumber = new int[qgSize];
            this.state = new int[qgSize];
            this.parentQueryNode = new int[qgSize];
            this.mappedAtPos = new boolean[qgSize];
            this.valueToTargetAtomIndex = new int[qgSize][tgSize + 1];
            this.targetAtomMapped = new boolean[tgSize];
            this.queryAtomIndexToPos = new int[qgSize];
            this.visitQueue.setMaxSize(8 * qgSize);
            this.molAtom = new MolAtom[qgSize];
            if (this.adequateAtoms == null || qgSize * tgSize > this.adequateAtoms.length) {
                this.adequateAtoms = new boolean[qgSize * tgSize];
            }
            this.qRingsSize = new int[qgSize];
            this.qRingsMappedAtomCount = new int[qgSize];
            this.qAtomIsInRing = new int[qgSize];
            this.qAtomIsInRingOfSize = new int[qgSize];
            this.tRingsSize = new int[tgSize];
            this.tRingsMappedAtomCount = new int[tgSize];
            this.tAtomIsInRing = new int[tgSize];
            this.qRingToTRingMapped = new int[qgSize];
            this.tAtomIsInRingOfSize = new int[tgSize];
            this.mappedQRingAtPos = new int[qgSize];
            this.mappedTRingAtPos = new int[qgSize];
            return;
        }
        int minLength = 0;
        if (this.valueToTargetAtomIndex != null) {
            minLength = this.valueToTargetAtomIndex[0].length;
            for (int i = 1; i < this.valueToTargetAtomIndex.length; ++i) {
                if (this.valueToTargetAtomIndex[i].length >= minLength) continue;
                minLength = this.valueToTargetAtomIndex[i].length;
            }
            if (this.targetAtomMapped.length < minLength) {
                minLength = this.targetAtomMapped.length;
            }
        }
        if (this.valueToTargetAtomIndex == null || tgSize > minLength) {
            this.valueToTargetAtomIndex = new int[this.route.length][tgSize + 1];
            this.targetAtomMapped = new boolean[tgSize];
        }
        if (qgSize * tgSize > this.adequateAtoms.length) {
            this.adequateAtoms = new boolean[qgSize * tgSize];
        }
        this.tRingsSize = new int[tgSize];
        this.tRingsMappedAtomCount = new int[tgSize];
        this.tAtomIsInRing = new int[tgSize];
        this.tAtomIsInRingOfSize = new int[tgSize];
        this.reverseMap = new int[tgSize];
    }

    public void dump() {
        int i;
        System.out.println("=== dump ===");
        System.out.println("treeSize = " + this.treeSize);
        for (i = 0; i < this.treeSize; ++i) {
            System.out.println("route[ " + i + " ] = " + this.route[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.out.println("baseNumber[ " + i + " ] = " + this.baseNumber[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.out.println("state[ " + i + " ] = " + this.state[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.out.print("valueToTargetAtomIndex[ " + i + " ] = ");
            for (int j = 0; j < this.valueToTargetAtomIndex[i].length && this.valueToTargetAtomIndex[i][j] != -1; ++j) {
                System.out.print(this.valueToTargetAtomIndex[i][j] + " ");
            }
            System.out.println();
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.out.println("parentQueryNode[ " + i + " ]= " + this.parentQueryNode[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.out.println("queryAtomIndexToPos[ " + i + " ]= " + this.queryAtomIndexToPos[i]);
        }
        if (this.mcs != null) {
            for (i = 0; i < this.mcs.length; ++i) {
                System.out.println("mcs[" + i + "]=" + this.mcs[i]);
            }
        }
        System.out.println("qRingCount=" + this.qRingCount);
        for (i = 0; i < this.qRingCount; ++i) {
            System.out.println("qRingsSize[" + i + "]=" + this.qRingsSize[i]);
        }
        for (i = 0; i < this.qAtomIsInRing.length; ++i) {
            System.out.println("qAtomIsInRing[" + i + "]=" + this.qAtomIsInRing[i] + " size:" + this.qAtomIsInRingOfSize[i]);
        }
        System.out.println("tRingCount=" + this.tRingCount);
        for (i = 0; i < this.tRingCount; ++i) {
            System.out.println("tRingsSize[" + i + "]=" + this.tRingsSize[i]);
        }
        for (i = 0; i < this.tAtomIsInRing.length; ++i) {
            System.out.println("tAtomIsInRing[" + i + "]=" + this.tAtomIsInRing[i] + " size:" + this.tAtomIsInRingOfSize[i]);
        }
        for (i = 0; i < this.qRingToTRingMapped.length; ++i) {
            System.out.println("qRingToTRingMapped[" + i + "]=" + this.qRingToTRingMapped[i]);
        }
        System.out.println("=== ---- ===");
    }

    public static void main(String[] args) {
        MCS mcs = new MCS();
        try {
            String fromStr = "COC1=CC(=CC(OC)=C1OC)[C@@H]1NC(=O)C2(CCCCC2)N1";
            String toStr = "COC1=CC=C(C=C1)[C@H]1NC(=O)C2(CCCC2)N1";
            int[] eatFrom = new int[]{5, 5, 5, 5, 5, 5, 6, 10, 5, 9, 15, 6, 6, 6, 6, 6, 6, 13, 13, 13, 5, 5, 5};
            int[] eatTo = new int[]{5, 6, 10, 5, 9, 5, 5, 5, 5, 15, 6, 6, 6, 6, 6, 6, 13, 5};
            MolInputStream mis = new MolInputStream(new ByteArrayInputStream(fromStr.getBytes()));
            MolImporter mi = new MolImporter(mis, "smiles");
            Molecule from = mi.read();
            mis = new MolInputStream(new ByteArrayInputStream(toStr.getBytes()));
            mi = new MolImporter(mis, "smiles");
            Molecule to = mi.read();
            if (args.length > 2) {
                mcs.setMinimumCommonSize(Integer.parseInt(args[2]));
            }
            from.calcHybridization();
            from.aromatize();
            from.clean(2, null);
            to.calcHybridization();
            to.aromatize();
            to.clean(2, null);
            long t0 = System.currentTimeMillis();
            mcs.setMolecules(from, eatFrom, to, eatTo);
            mcs.setIgnoreHybridization(true);
            mcs.setMinimumCommonSize(3);
            mcs.setIgnoreAtomType(false);
            mcs.setIgnoreBondType(false);
            mcs.setIgnoreCharge(false);
            mcs.setDontBreakRingBonds(false);
            mcs.setIgnoreHydrogens(false);
            mcs.setMode(2);
            if (mcs.findFirst()) {
                System.out.println(System.currentTimeMillis() - t0 + " ms");
                MCS.printResults(mcs);
                while (mcs.findNext()) {
                    System.out.println(System.currentTimeMillis() - t0 + " ms");
                    MCS.printResults(mcs);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mcs.dump();
        }
    }

    private static void printResults(MCS mcs) {
        int[] m = mcs.getResult();
        if (m == null) {
            System.out.println("no hit found\n");
        } else {
            System.out.println("hit found");
            MCS.printResult(m);
            System.out.print("query atoms: ");
            int[] rqa = mcs.getResultQueryAtoms();
            for (int i = 0; i < rqa.length; ++i) {
                System.out.print(rqa[i] + ", ");
            }
            System.out.println();
        }
    }

    private static void printResult(int[] m) {
        for (int j = 0; j < m.length; ++j) {
            if (m[j] == -1) continue;
            System.out.print(j + 1 + " -> " + (m[j] + 1) + " ");
        }
        System.out.println();
    }

    private static int[] generateExtraAtomTypes(Molecule m) {
        int[] at = new int[m.getAtomCount()];
        for (int i = 0; i < m.getAtomCount(); ++i) {
            at[i] = i;
        }
        return at;
    }

    private class Queue {
        private int[] values = null;
        private int head = -1;
        private int tail = -1;
        private boolean empty = true;

        public void setMaxSize(int maxSize) {
            if (this.values == null || maxSize > this.values.length) {
                this.values = new int[maxSize];
            }
            this.clear();
        }

        public void clear() {
            this.head = 0;
            this.tail = -1;
            this.empty = true;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public void addLast(int value) throws RuntimeException {
            if (this.overflow()) {
                throw new RuntimeException("Queue overflow.");
            }
            this.tail = (this.tail + 1) % this.values.length;
            this.values[this.tail] = value;
            this.empty = false;
        }

        private int removeFirst() throws RuntimeException {
            if (this.empty) {
                throw new RuntimeException("Queue underflow.");
            }
            int r = this.values[this.head];
            this.empty = this.head == this.tail;
            this.head = (this.head + 1) % this.values.length;
            return r;
        }

        private boolean overflow() {
            return !this.empty && (this.tail + 1) % this.values.length == this.head;
        }
    }
}

