/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules;

import chemaxon.marvin.paint.DispOptConsts;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public class Spacefill
extends MarvinModule
implements DispOptConsts {
    private Color bgcolor = null;
    private Color fgcolor = null;
    private MolPainter painter = null;
    private double mag = 1.0;
    private transient Image[] images = null;
    private int colorScheme = 0;
    private boolean setColoringEnabled = true;

    @Override
    public Object getSomething(Object arg) {
        if (arg instanceof Object[]) {
            Object[] args = (Object[])arg;
            MolAtom atom = (MolAtom)args[0];
            MoleculeGraph molg = (MoleculeGraph)args[1];
            int seq = atom.getSetSeq();
            int index = seq != 0 && this.setColoringEnabled ? 139 + seq : (this.colorScheme == 128 ? atom.getResidueType() : (this.colorScheme == 192 ? atom.getResidueSeq() & 0x7F : atom.getAtno()));
            if (this.images == null) {
                this.images = new Image[139];
            }
            if (index < 0) {
                index = 0;
            }
            if (index >= this.images.length) {
                Image[] tmp = new Image[2 * this.images.length];
                System.arraycopy(this.images, 0, tmp, 0, this.images.length);
                this.images = tmp;
            }
            if (this.images[index] == null) {
                int bfg;
                int gfg;
                int rfg;
                int bbg;
                int gbg;
                Color color = this.painter.getColor(atom, molg.getDocument());
                int rbg = this.bgcolor.getRed();
                boolean darkbg = rbg + (gbg = this.bgcolor.getGreen()) + (bbg = this.bgcolor.getBlue()) < (rfg = color.getRed()) + (gfg = color.getGreen()) + (bfg = color.getBlue());
                byte[] red = new byte[256];
                byte[] green = new byte[256];
                byte[] blue = new byte[256];
                for (int i = 0; i < 256; ++i) {
                    double d = (double)i / 256.0;
                    if (darkbg) {
                        red[i] = (byte)((double)rfg + (double)(rbg - rfg) * d + 0.5);
                        green[i] = (byte)((double)gfg + (double)(gbg - gfg) * d + 0.5);
                        blue[i] = (byte)((double)bfg + (double)(bbg - bfg) * d + 0.5);
                        continue;
                    }
                    red[i] = (byte)(255.0 + (double)(rfg - 255) * d + 0.5);
                    green[i] = (byte)(255.0 + (double)(gfg - 255) * d + 0.5);
                    blue[i] = (byte)(255.0 + (double)(bfg - 255) * d + 0.5);
                }
                IndexColorModel icm = new IndexColorModel(8, 256, red, green, blue, 0);
                double covr = this.colorScheme > 64 ? 1.5 : MolAtom.covalentRadiusOf(atom.getAtno(), 1);
                int radius = (int)(covr * this.mag + 0.5);
                int n = 2 * radius;
                if (n == 0) {
                    return null;
                }
                byte[] pix = new byte[n * n];
                int hx = radius / 3;
                for (int y = -radius + 1; y <= radius; ++y) {
                    int x0 = (int)(Math.sqrt(radius * radius - y * y) + 0.5);
                    int i = n * (radius + y) + radius - x0;
                    for (int x = -x0; x < x0; ++x) {
                        int xx = x + hx;
                        int yy = y + hx;
                        int r = (int)(Math.sqrt(xx * xx + yy * yy) + 0.5);
                        pix[i++] = r <= 0 ? (byte)1 : (byte)(175 * r / radius);
                    }
                }
                this.images[index] = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n, (ColorModel)icm, pix, 0, n));
            }
            return this.images[index];
        }
        return null;
    }

    @Override
    public Object modfunc(Object arg) {
        Object[] args = (Object[])arg;
        this.bgcolor = (Color)args[0];
        this.fgcolor = (Color)args[1];
        this.painter = (MolPainter)args[2];
        this.mag = (Double)args[3];
        this.images = null;
        int opts = this.painter.getCommon().getDispopts();
        this.colorScheme = opts & 0xC0;
        this.setColoringEnabled = (opts & 0x100) != 0;
        return null;
    }
}

