/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer;

import chemaxon.marvin.modules.datatransfer.CompositeClipboard;
import chemaxon.marvin.modules.datatransfer.MTransferable;
import chemaxon.marvin.modules.datatransfer.MarvinImageTransfer;
import chemaxon.marvin.modules.datatransfer.MarvinOLETransfer;
import chemaxon.marvin.modules.datatransfer.TransferableDescriptor;
import chemaxon.marvin.modules.datatransfer.Transferables;
import chemaxon.marvin.modules.osx.OSXPasteboardWrapper;
import chemaxon.marvin.modules.win.Jacob;
import chemaxon.marvin.util.Environment;
import chemaxon.struc.Molecule;
import chemaxon.util.DotfileUtil;
import chemaxon.util.ImageExportUtil;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public final class ClipboardHandler {
    private static Clipboard mclipboard = null;
    private static boolean workOnBackground = false;
    private static boolean clearClipboardBeforeExport = true;
    private static boolean resourcesStarted = false;
    private static ExecutorService executor = null;
    private static Queue<Future<?>> futures = null;
    private static final int FUTUREQUEUEMAXSIZE = 10;
    private static Logger log;

    private ClipboardHandler() {
    }

    private static synchronized void createLogger() {
        if (log != null) {
            return;
        }
        try {
            log = Logger.getLogger("OLELog");
            log.setLevel(Level.OFF);
            if (!log.getLevel().equals(Level.OFF)) {
                FileHandler h = new FileHandler(DotfileUtil.getDotFileWithEnsuredPath("log/Clipboard.log").getAbsolutePath(), true);
                h.setFormatter(new SimpleFormatter());
                log.addHandler(h);
            }
        }
        catch (SecurityException e1) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Logger getLog() {
        if (log == null) {
            ClipboardHandler.createLogger();
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setWorkOnBackground(boolean b) {
        log.entering("ClipboardHandler", "setWorkOnBackground");
        workOnBackground = b;
        if (workOnBackground) {
            log.fine("Starting executors.");
            executor = Executors.newSingleThreadExecutor(Executors.defaultThreadFactory());
            futures = new LinkedList();
        } else {
            log.fine("Stopping executors.");
            Queue<Future<?>> queue = futures;
            synchronized (queue) {
                if (executor != null && futures != null) {
                    Future<?> t;
                    while ((t = futures.poll()) != null) {
                        try {
                            t.get();
                        }
                        catch (InterruptedException e) {
                        }
                        catch (ExecutionException executionException) {}
                    }
                    futures = null;
                    executor.shutdown();
                    executor = null;
                }
            }
        }
        log.exiting("ClipboardHandler", "setWorkOnBackground");
    }

    public static synchronized boolean getWorkOnBackGround() {
        return workOnBackground;
    }

    public static synchronized void setClearClipboardBeforeExport(boolean b) {
        clearClipboardBeforeExport = b;
    }

    public static synchronized boolean isClearClipboardBeforeExport() {
        return clearClipboardBeforeExport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enQueueFuture(Future<?> f) {
        Queue<Future<?>> queue = futures;
        synchronized (queue) {
            if (futures.size() >= 10) {
                ClipboardHandler.processFutures(false);
            }
            futures.add(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processFutures(boolean processAll) {
        if (!ClipboardHandler.getWorkOnBackGround()) {
            return;
        }
        Queue<Future<?>> queue = futures;
        synchronized (queue) {
            while (futures.peek() != null && (futures.peek().isDone() || futures.peek().isCancelled())) {
                futures.poll();
            }
            if (futures.size() >= 10 || processAll) {
                while (futures.size() >= Math.round(5.0f) || processAll && futures.peek() != null) {
                    Future<?> t = futures.poll();
                    try {
                        t.get();
                    }
                    catch (InterruptedException e) {
                    }
                    catch (ExecutionException executionException) {}
                }
            }
        }
    }

    public static void putStringToClipboard(String str) {
        ClipboardHandler.clearClipboardConditionally();
        if (ClipboardHandler.getWorkOnBackGround()) {
            ClipboardHandler.enQueueFuture(executor.submit(new StringToClipboardTask(str)));
        } else {
            ClipboardHandler.putStringToClipboardImpl(str);
        }
    }

    private static void putStringToClipboardImpl(String str) {
        ClipboardHandler.getClipboard().setContents(new StringSelection(str), null);
    }

    public static void putImageToClipboard(Image img) {
        ClipboardHandler.clearClipboardConditionally();
        if (ClipboardHandler.getWorkOnBackGround()) {
            ClipboardHandler.enQueueFuture(executor.submit(new ImageToClipboardTask(img)));
        } else {
            ClipboardHandler.putImageToClipboardImpl(img);
        }
    }

    private static void putImageToClipboardImpl(Image img) {
        ClipboardHandler.getClipboard().setContents(new MarvinImageTransfer(img), null);
    }

    public static void putMoleculeToClipboard(Molecule mol, Properties props) {
        ClipboardHandler.putMoleculeToClipboard(mol, props, null);
    }

    public static void putMoleculeToClipboard(Molecule mol, Properties props, String fmt) {
        ClipboardHandler.clearClipboardConditionally();
        if (ClipboardHandler.getWorkOnBackGround()) {
            ClipboardHandler.enQueueFuture(executor.submit(new MoleculeToClipboardTask(mol, fmt, props)));
        } else {
            ClipboardHandler.putMoleculeToClipboardImpl(mol, props, fmt);
        }
    }

    private static void putMoleculeToClipboardImpl(Molecule mol, Properties props, String fmt) {
        Transferables.getInstance().init();
        if (fmt != null && fmt.equals(Transferables.getInstance().getOLEId())) {
            ClipboardHandler.putOLEToClipboardImpl(mol, props);
            return;
        }
        Transferable transfer = ClipboardHandler.getTransferableFor(mol, props, fmt);
        ClipboardHandler.getClipboard().setContents(transfer, null);
        if (fmt == null) {
            ClipboardHandler.putOLEToClipboardImpl(mol, props);
        }
    }

    private static void putOLEToClipboardImpl(Molecule mol, Properties props) {
        MarvinOLETransfer oleHandler;
        if (!Transferables.getInstance().isOLESupported()) {
            return;
        }
        try {
            oleHandler = new MarvinOLETransfer(mol, props);
        }
        catch (MissingResourceException ex) {
            ClipboardHandler.OLEFailedOnCopy(mol, props);
            return;
        }
        catch (IOException e) {
            ClipboardHandler.OLEFailedOnCopy(mol, props);
            return;
        }
        try {
            oleHandler.getDataToClipboard();
        }
        catch (IllegalStateException ex) {
            ClipboardHandler.OLEFailedOnCopy(mol, props);
        }
        catch (IllegalArgumentException ex) {
            ClipboardHandler.OLEFailedOnCopy(mol, props);
        }
        catch (MissingResourceException ex) {
            ClipboardHandler.OLEFailedOnCopy(mol, props);
        }
    }

    private static void OLEFailedOnCopy(Molecule mol, Properties props) {
        ClipboardHandler.clearClipboardConditionally();
        ClipboardHandler.OLEFailureHandler();
        ClipboardHandler.putMoleculeToClipboardImpl(mol, props, null);
    }

    private static synchronized void OLEFailureHandler() {
        Transferables.getInstance().removeOLESupport();
        mclipboard = null;
    }

    public static synchronized void removeOLESupport() {
        Transferables.getInstance().removeOLESupport();
    }

    public static String getStringFromClipboard() {
        ClipboardHandler.processFutures(true);
        if (ClipboardHandler.getClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor)) {
            String str;
            Transferable t = ClipboardHandler.getClipboard().getContents(null);
            try {
                str = (String)t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
            return str;
        }
        return null;
    }

    private static Object getDataFromClipboardOLE0() {
        MarvinOLETransfer oleHandler;
        ClipboardHandler.processFutures(true);
        try {
            oleHandler = new MarvinOLETransfer();
        }
        catch (MissingResourceException ex) {
            ClipboardHandler.OLEFailureHandler();
            return null;
        }
        catch (IOException e) {
            ClipboardHandler.OLEFailureHandler();
            return null;
        }
        return oleHandler.getDataFromClipboard();
    }

    public static Object getObjectFromClipboard() {
        ClipboardHandler.processFutures(true);
        Transferables.getInstance().init();
        Transferable t = ClipboardHandler.getClipboard().getContents(null);
        Object m = ClipboardHandler.getDataFromClipboardOLE0();
        if (m != null) {
            return m;
        }
        return ClipboardHandler.getObjectFromTransferable(t);
    }

    public static Object getObjectFromTransferable(Transferable transfer) {
        MTransferable t;
        ClipboardHandler.processFutures(true);
        Transferables.getInstance().init();
        Object ret = null;
        DataFlavor[] flavors = transfer.getTransferDataFlavors();
        Iterator<MTransferable> ti = Transferables.getInstance().getInputTransferables().iterator();
        while (ret == null && ti.hasNext()) {
            t = ti.next();
            for (int i = 0; ret == null && i < flavors.length; ++i) {
                if (DataFlavor.stringFlavor.equals(flavors[i]) || !t.isDataFlavorSupported(flavors[i]) || !t.isInputAvailable()) continue;
                t.setTransfer(transfer);
                try {
                    ret = t.getTransferData(flavors[i]);
                    continue;
                }
                catch (UnsupportedFlavorException e) {
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (ret == null) {
            t = Transferables.getInstance().getStringTransferable();
            t.setTransfer(transfer);
            try {
                ret = t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return ret;
    }

    public static Transferable getTransferableFor(Molecule mol, Properties props) {
        return ClipboardHandler.getTransferableFor(mol, props, null);
    }

    public static Transferable getTransferableFor(Molecule mol, Properties props, String fmt) {
        MTransferable t = Transferables.getInstance().getTransferable(fmt);
        t.setMolecule(mol);
        t.setProperties(props);
        return t;
    }

    public static boolean isSupportedTransferFormat(String fmtId) {
        return Transferables.getInstance().getTransferable(fmtId) != null;
    }

    public static List<String> getCopyAsTransferableNames() {
        return Transferables.getInstance().getCopyAsTransferableNames();
    }

    public static synchronized void clearClipboard() {
        ClipboardHandler.getClipboard().setContents(new EmptyTransferable(), null);
    }

    private static void clearClipboardConditionally() {
        if (ClipboardHandler.isClearClipboardBeforeExport()) {
            if (ClipboardHandler.getWorkOnBackGround()) {
                ClipboardHandler.enQueueFuture(executor.submit(new ClipboardClearerTask()));
            } else {
                ClipboardHandler.clearClipboard();
            }
        }
    }

    public static synchronized Clipboard getClipboard() {
        Clipboard cb = mclipboard;
        if (cb == null) {
            try {
                if (Environment.MACOS && OSXPasteboardWrapper.isAvailable()) {
                    cb = new CompositeClipboard("CompositeClipboard");
                    ((CompositeClipboard)cb).addClipboard(Toolkit.getDefaultToolkit().getSystemClipboard());
                } else {
                    cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                }
            }
            catch (SecurityException sex) {
                System.err.println("Warning: Cannot access system clipboard -> using local");
                cb = new Clipboard("Marvin");
            }
            mclipboard = cb;
        }
        return cb;
    }

    public static TransferableDescriptor removeTransferable(TransferableDescriptor d) {
        return Transferables.getInstance().removeTransferableDescriptor(d.getName());
    }

    public static TransferableDescriptor removeTransferable(String name) {
        return Transferables.getInstance().removeTransferableDescriptor(name);
    }

    public static void addTransferable(TransferableDescriptor d) {
        Transferables.getInstance().addTransferableDescriptor(d);
    }

    @Deprecated
    public static void addTransferable(String name, String className, Integer priority, Integer inputPriority, boolean isdefault, boolean copyAsTransferable) {
        Transferables.getInstance().addTransferableDescriptor(new TransferableDescriptor(name, className, priority, inputPriority, isdefault, copyAsTransferable));
    }

    public static void addTransferable(String name, String className, Integer priority, Integer inputPriority, boolean isdefault, boolean copyAsTransferable, boolean dndTransferable) {
        Transferables.getInstance().addTransferableDescriptor(new TransferableDescriptor(name, className, priority, inputPriority, isdefault, copyAsTransferable, dndTransferable));
    }

    public static synchronized void releasePermanentResources() {
        log.entering("ClipboardHandler", "releasePermanentResources");
        if (resourcesStarted) {
            log.fine("Processing clipboard operations queue.");
            ClipboardHandler.setWorkOnBackground(false);
            log.fine("Stopping permanent OLE reference");
            Transferables.getInstance().removeOLESupport();
            log.fine("release new emf generator architecture.");
            ImageExportUtil.releaseNewEMFGenerator();
            resourcesStarted = false;
        }
        log.exiting("ClipboardHandler", "releasePermanentResources");
    }

    public static synchronized void startPermanentResources() {
        log.entering("ClipboardHandler", "startPermanentResources");
        if (!resourcesStarted) {
            if (!Jacob.getInstance().isSupported()) {
                Transferables.getInstance().removeOLESupport();
                ImageExportUtil.disableNewEmfGenerator();
                return;
            }
            if (Transferables.getInstance().isOLESupported()) {
                try {
                    log.fine("Starting OLE Server");
                    new MarvinOLETransfer();
                }
                catch (Throwable ex) {
                    log.throwing("ClipboardHandler", "startPermanentResources", ex);
                    Transferables.getInstance().removeOLESupport();
                    System.err.println("MarvinOLE initialization failed with the followning message:");
                    System.err.println(ex.getMessage());
                }
            }
            log.fine("Starting new EMF generator on background.");
            ImageExportUtil.startEMFGenerator();
            resourcesStarted = true;
        }
        log.exiting("ClipboardHandler", "startPermanentResources");
    }

    static {
        Transferables.getInstance().init();
        ClipboardHandler.createLogger();
    }

    private static class EmptyTransferable
    implements Transferable {
        private EmptyTransferable() {
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[0];
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return false;
        }
    }

    private static final class MoleculeToClipboardTask
    implements Runnable {
        private final Molecule mol;
        private final String formatId;
        private final Properties props;

        private MoleculeToClipboardTask(Molecule mol, String formatId, Properties props) {
            this.mol = mol;
            this.formatId = formatId;
            this.props = props;
        }

        @Override
        public void run() {
            boolean isDone = false;
            while (!isDone) {
                try {
                    ClipboardHandler.putMoleculeToClipboardImpl(this.mol, this.props, this.formatId);
                    isDone = true;
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }

    private static final class StringToClipboardTask
    implements Runnable {
        private final String str;

        private StringToClipboardTask(String str) {
            this.str = str;
        }

        @Override
        public void run() {
            boolean isDone = false;
            while (!isDone) {
                try {
                    ClipboardHandler.putStringToClipboardImpl(this.str);
                    isDone = true;
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }

    private static final class ImageToClipboardTask
    implements Runnable {
        private final Image img;

        private ImageToClipboardTask(Image img) {
            this.img = img;
        }

        @Override
        public void run() {
            boolean isDone = false;
            while (!isDone) {
                try {
                    ClipboardHandler.putImageToClipboardImpl(this.img);
                    isDone = true;
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }

    private static final class ClipboardClearerTask
    implements Runnable {
        private ClipboardClearerTask() {
        }

        @Override
        public void run() {
            boolean isDone = false;
            while (!isDone) {
                try {
                    ClipboardHandler.clearClipboard();
                    isDone = true;
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }
}

