/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer;

import chemaxon.marvin.modules.datatransfer.transferables.CompositeTransferable;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CompositeClipboard
extends Clipboard {
    private Set<Clipboard> clipboards = new HashSet<Clipboard>();

    public CompositeClipboard(String name) {
        super(name);
    }

    public void addClipboard(Clipboard e) {
        this.clipboards.add(e);
    }

    @Override
    public synchronized void addFlavorListener(FlavorListener listener) {
        for (Clipboard e : this.clipboards) {
            e.addFlavorListener(listener);
        }
    }

    @Override
    public DataFlavor[] getAvailableDataFlavors() {
        HashSet<DataFlavor> flavors = new HashSet<DataFlavor>();
        for (Clipboard c : this.clipboards) {
            flavors.addAll(Arrays.asList(c.getAvailableDataFlavors()));
        }
        return super.getAvailableDataFlavors();
    }

    @Override
    public synchronized Transferable getContents(Object requestor) {
        CompositeTransferable<Transferable> t = new CompositeTransferable<Transferable>();
        for (Clipboard c : this.clipboards) {
            t.add(c.getContents(requestor));
        }
        return t;
    }

    @Override
    public synchronized FlavorListener[] getFlavorListeners() {
        ArrayList<FlavorListener> listeners = new ArrayList<FlavorListener>();
        for (Clipboard c : this.clipboards) {
            listeners.addAll(Arrays.asList(c.getFlavorListeners()));
        }
        return (FlavorListener[])listeners.toArray();
    }

    @Override
    public boolean isDataFlavorAvailable(DataFlavor flavor) {
        for (Clipboard c : this.clipboards) {
            if (!c.isDataFlavorAvailable(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void removeFlavorListener(FlavorListener listener) {
        for (Clipboard c : this.clipboards) {
            c.removeFlavorListener(listener);
        }
    }

    @Override
    public synchronized void setContents(Transferable contents, ClipboardOwner owner) {
        for (Clipboard c : this.clipboards) {
            c.setContents(contents, owner);
        }
    }

    @Override
    public Object getData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        for (Clipboard c : this.clipboards) {
            Object data = c.getData(flavor);
            if (data == null) continue;
            return data;
        }
        return null;
    }
}

