/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.uif.util.swing.AbstractDialog;
import chemaxon.marvin.util.CallbackIface;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CopyAsDialog
extends AbstractDialog
implements CallbackIface {
    private static final long serialVersionUID = -4564761584830399025L;
    public static final String COPYASDIALOGSEPARATORCLASS = "nonexistent.SEPARATOR";
    private static final String TITLE_KEY = "copyasdialog.title";
    private static final String LISTLABEL_KEY = "copyasdialog.listlabel";
    private ResourceBundle bundle;
    private List<String> formats;
    private String defaultFormat;
    private JList selectorList;
    private int prevSelectedIdx = 0;

    public CopyAsDialog(Dialog dialog, String defaultFormat) {
        super((Window)dialog);
        this.init(defaultFormat);
    }

    public CopyAsDialog(Frame frame, String defaultFormat) {
        super((Window)frame);
        this.init(defaultFormat);
    }

    private void init(String defformat) {
        this.bundle = MolPanel.getResourceBundle(CopyAsDialog.class.getName());
        this.setTitle(this.bundle.getString(TITLE_KEY));
        this.formats = ClipboardHandler.getCopyAsTransferableNames();
        this.defaultFormat = defformat;
    }

    private void initComponents() {
        this.selectorList = new JList<String>(new Vector<String>(this.formats));
        this.selectorList.setAlignmentX(0.0f);
        this.selectorList.setSelectionMode(0);
        if (this.defaultFormat != null && !"".equals(this.defaultFormat)) {
            this.selectorList.setSelectedValue(this.defaultFormat, true);
        }
        if (this.selectorList.getSelectedIndex() == -1 && this.selectorList.getModel().getSize() > 0) {
            this.selectorList.setSelectedIndex(0);
        }
        this.prevSelectedIdx = this.selectorList.getSelectedIndex();
    }

    private void initEventHandling() {
        SelectionHandler handler = new SelectionHandler();
        this.selectorList.addListSelectionListener(handler);
    }

    private void updateView() {
        if (this.selectorList.getSelectedIndex() != -1) {
            this.selectorList.ensureIndexIsVisible(this.selectorList.getSelectedIndex());
        }
    }

    @Override
    protected JComponent buildButtonBar() {
        JButton ok = new JButton(this.getOKAction());
        JButton cancel = new JButton(this.getCancelAction());
        this.getRootPane().setDefaultButton(ok);
        return ButtonBarFactory.buildRightAlignedBar((JButton)ok, (JButton)cancel);
    }

    @Override
    protected JComponent buildContentPanel() {
        this.initComponents();
        this.initEventHandling();
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        gbc.insets = new Insets(0, 0, 0, 0);
        JLabel listLabel = new JLabel(this.bundle.getString(LISTLABEL_KEY));
        result.add((Component)listLabel, gbc);
        gbc.gridy = 1;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.fill = 1;
        result.add((Component)new JScrollPane(this.selectorList), gbc);
        this.updateView();
        return result;
    }

    @Override
    public void apply() {
        this.defaultFormat = this.getSelectedFormat();
    }

    public String getSelectedFormat() {
        if (this.selectorList.getSelectedIndex() != -1) {
            return (String)this.selectorList.getSelectedValue();
        }
        return null;
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("open")) {
            this.open();
        } else {
            if (method.equals("getFormat")) {
                return this.defaultFormat;
            }
            if (method.equals("canceled")) {
                return Boolean.toString(this.canceled());
            }
        }
        return null;
    }

    private class SelectionHandler
    implements ListSelectionListener,
    ItemListener {
        private SelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                if (CopyAsDialog.this.selectorList.getModel().getElementAt(CopyAsDialog.this.selectorList.getSelectedIndex()).toString().contains("---")) {
                    CopyAsDialog.this.selectorList.setSelectedIndex(CopyAsDialog.this.prevSelectedIdx);
                }
                return;
            }
            CopyAsDialog.this.prevSelectedIdx = CopyAsDialog.this.selectorList.getSelectedIndex();
            CopyAsDialog.this.updateView();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            CopyAsDialog.this.updateView();
        }
    }
}

