/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer;

import chemaxon.formats.MFileFormat;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecordImporter;
import chemaxon.marvin.io.formats.pdb.PDBReader;
import chemaxon.marvin.modules.datatransfer.MTransferable;
import chemaxon.marvin.util.MolLoader;
import chemaxon.struc.Molecule;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public abstract class MarvinTransferable
implements MTransferable {
    protected DataFlavor flavor = null;
    protected String format = null;
    protected int clipboardOperation = 0;
    protected Molecule molecule = null;
    protected Properties properties = null;
    protected Transferable transfer = null;
    protected DataFlavor extraFlavor = null;

    @Override
    public Object getTransferData(DataFlavor flv) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(flv)) {
            throw new UnsupportedFlavorException(flv);
        }
        if (this.clipboardOperation == 1) {
            return this.getDataToClipboard(flv);
        }
        if (this.clipboardOperation == 2) {
            return this.getDataFromClipboard(flv);
        }
        throw new IllegalStateException("MarvinDataTransfer initialization failure");
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flv) {
        return this.flavor.equals(flv);
    }

    protected abstract Object getDataToClipboard(DataFlavor var1);

    protected abstract Object getDataFromClipboard(DataFlavor var1);

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] ret = new DataFlavor[]{this.flavor};
        return ret;
    }

    @Override
    public void registerNativeNames() {
    }

    @Override
    public void setMolecule(Molecule mol) {
        this.clipboardOperation = 1;
        this.molecule = mol;
    }

    @Override
    public void setProperties(Properties props) {
        this.properties = props;
    }

    @Override
    public boolean isInputAvailable() {
        return true;
    }

    @Override
    public void setTransfer(Transferable transfer) {
        this.clipboardOperation = 2;
        this.transfer = transfer;
    }

    protected Object createMoleculeFromInputStream(InputStream is) {
        try {
            MFileFormat isformat;
            MolInputStream mis;
            String informat = null;
            if (!"source".equals(this.format) && !"file".equals(this.format)) {
                informat = this.format.substring(0, this.format.indexOf(":") == -1 ? this.format.length() : this.format.indexOf(":"));
            }
            try {
                mis = new MolInputStream(is, informat);
                isformat = MFileFormatUtil.getFormat(mis.getFormat());
                if (isformat == null && informat != null) {
                    isformat = MFileFormatUtil.getFormat(informat);
                }
                if (isformat != null && isformat.isFlagSet(65536L) && !(is instanceof FileInputStream)) {
                    mis = new MolInputStream(this.readMultipleLines(is), isformat.getName());
                }
            }
            catch (MolFormatException e) {
                mis = new MolInputStream(this.readMultipleLines(is), null);
                isformat = MFileFormatUtil.getFormat(mis.getFormat());
            }
            if (!MFileFormat.PDB.equals(isformat)) {
                MRecordImporter mii = MolLoader.createImporter(mis, null);
                return mii.readMol(null);
            }
            PDBReader pr = new PDBReader();
            pr.setInput(mis);
            pr.setFixBondTypes(true);
            pr.setHydrogenize(39);
            return pr.read();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private InputStream readMultipleLines(InputStream is) throws IOException {
        String line;
        if (is.markSupported()) {
            is.reset();
        } else if (is instanceof FileInputStream) {
            ((FileInputStream)is).getChannel().position(0L);
        }
        StringBuilder entireText = new StringBuilder();
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        int lines = 0;
        while ((line = r.readLine()) != null) {
            if (line.startsWith("AuxInfo")) {
                entireText.append("\n");
            }
            if (++lines > 20) break;
            if (lines == 1) {
                while (line.startsWith("\t")) {
                    line = line.substring(1);
                }
            }
            entireText.append(line);
        }
        return new ByteArrayInputStream(entireText.toString().getBytes());
    }

    protected InputStream getInputStreamFromClipboard() {
        Object data = null;
        InputStream is = null;
        try {
            data = this.extraFlavor != null && this.transfer.isDataFlavorSupported(this.extraFlavor) ? this.transfer.getTransferData(this.extraFlavor) : this.transfer.getTransferData(this.flavor);
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        if (data instanceof InputStream) {
            is = (InputStream)data;
        }
        if (data instanceof String) {
            is = new ByteArrayInputStream(((String)data).getBytes());
        }
        if (data instanceof byte[]) {
            is = new ByteArrayInputStream((byte[])data);
        }
        if (data instanceof StringReader) {
            StringReader r = (StringReader)data;
            try {
                int c;
                StringBuffer sb = new StringBuffer();
                while ((c = ((Reader)r).read()) != -1) {
                    sb.append((char)c);
                }
                URL url = new URL(sb.toString());
                URLConnection conn = url.openConnection();
                is = conn.getInputStream();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return is;
    }
}

