/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer;

public class TransferableDescriptor
implements Comparable<TransferableDescriptor> {
    private String name;
    private String representationClass;
    private Integer priority;
    private Integer inputPriority;
    private boolean defaultTransferable;
    private boolean copyAsTransferable;
    private boolean dndTransferable = false;

    @Deprecated
    public TransferableDescriptor(String name, String className, Integer priority, Integer inputPriority, boolean isDefault, boolean copyAsTransferable) {
        this.name = name;
        this.representationClass = className;
        this.priority = priority;
        this.inputPriority = inputPriority;
        this.defaultTransferable = isDefault;
        this.copyAsTransferable = copyAsTransferable;
    }

    public TransferableDescriptor(String name, String className, Integer priority, Integer inputPriority, boolean isDefault, boolean copyAsTransferable, boolean dndTransferable) {
        this.name = name;
        this.representationClass = className;
        this.priority = priority;
        this.inputPriority = inputPriority;
        this.defaultTransferable = isDefault;
        this.copyAsTransferable = copyAsTransferable;
        this.dndTransferable = dndTransferable;
    }

    public String getName() {
        return this.name;
    }

    public String getRepresentationClass() {
        return this.representationClass;
    }

    public boolean isDefaultTransferable() {
        return this.defaultTransferable;
    }

    public boolean isCopyAsTransferable() {
        return this.copyAsTransferable;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Integer getInputPriority() {
        return this.inputPriority;
    }

    public boolean isDndTransferable() {
        return this.dndTransferable;
    }

    @Override
    public int compareTo(TransferableDescriptor o) {
        return this.priority.compareTo(o.getPriority());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.copyAsTransferable ? 1231 : 1237);
        result = 31 * result + (this.defaultTransferable ? 1231 : 1237);
        result = 31 * result + (this.dndTransferable ? 1231 : 1237);
        result = 31 * result + (this.inputPriority == null ? 0 : this.inputPriority.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + (this.representationClass == null ? 0 : this.representationClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransferableDescriptor other = (TransferableDescriptor)obj;
        if (this.copyAsTransferable != other.copyAsTransferable) {
            return false;
        }
        if (this.defaultTransferable != other.defaultTransferable) {
            return false;
        }
        if (this.dndTransferable != other.dndTransferable) {
            return false;
        }
        if (this.inputPriority == null ? other.inputPriority != null : !this.inputPriority.equals(other.inputPriority)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.priority == null ? other.priority != null : !this.priority.equals(other.priority)) {
            return false;
        }
        return !(this.representationClass == null ? other.representationClass != null : !this.representationClass.equals(other.representationClass));
    }
}

