/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.marvin.modules.datatransfer.MTransferable;
import chemaxon.marvin.modules.datatransfer.MarvinOLETransfer;
import chemaxon.marvin.modules.datatransfer.TransferableDescriptor;
import chemaxon.marvin.util.Environment;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

public final class Transferables {
    private static Transferables instance = null;
    private List<TransferableDescriptor> transferableData;
    private boolean initialized = false;
    private String OLEId;
    private String OLECoveredFormats;
    private boolean oleSupported = Environment.isOLESupported();
    private String defaultId;
    private List<String> separator;
    private Properties props;

    private Transferables() {
        Properties defaultProps = new Properties();
        try {
            InputStream is;
            defaultProps.load(this.getClass().getResourceAsStream("Transferables.properties"));
            this.props = new Properties(defaultProps);
            if (!Environment.isUseDefaultDatatransferConfig() && (is = BasicEnvironment.getResourceAsStream(this.getClass(), "/chemaxon/marvin/datatransfer.properties")) != null) {
                this.props.load(is);
            }
            this.configure(this.props);
            this.defaultId = this.props.getProperty("default.name");
            this.OLEId = this.props.getProperty("ole.name");
            this.OLECoveredFormats = this.props.getProperty("ole.coveredformats");
            if (!Boolean.valueOf(this.props.getProperty("ole.enabled")).booleanValue() || !this.isOLESupported()) {
                this.removeOLESupport();
            }
            this.separator = new ArrayList<String>();
            for (String s : this.props.getProperty("separator").split(",")) {
                this.separator.add(this.props.getProperty(s + ".name"));
            }
        }
        catch (IOException e) {
            System.err.println("Marvin ERROR: Copy module could not be initialized.");
        }
    }

    public static synchronized Transferables getInstance() {
        if (instance == null) {
            instance = new Transferables();
        }
        return instance;
    }

    private MTransferable createTransferable(TransferableDescriptor d) {
        if (d == null) {
            return null;
        }
        try {
            Class<?> cl = Class.forName(d.getRepresentationClass());
            return (MTransferable)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public void init() {
        this.init(false);
    }

    public synchronized void init(boolean force) {
        if (this.initialized && !force) {
            return;
        }
        this.initialized = true;
        for (TransferableDescriptor d : this.transferableData) {
            MTransferable t = this.createTransferable(d);
            if (t == null) continue;
            t.registerNativeNames();
        }
    }

    public TransferableDescriptor removeTransferableDescriptor(String name) {
        for (TransferableDescriptor d : this.transferableData) {
            if (!d.getName().equals(name)) continue;
            this.transferableData.remove(d);
            return d;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransferableDescriptor(TransferableDescriptor data) {
        if (data != null) {
            List<TransferableDescriptor> list = this.transferableData;
            synchronized (list) {
                this.transferableData.add(data);
                Collections.sort(this.transferableData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MTransferable> getDefaultTransferables() {
        ArrayList<MTransferable> list = new ArrayList<MTransferable>();
        ArrayList<TransferableDescriptor> td = null;
        List<TransferableDescriptor> list2 = this.transferableData;
        synchronized (list2) {
            td = new ArrayList<TransferableDescriptor>(this.transferableData);
        }
        Collections.sort(td);
        for (TransferableDescriptor d : td) {
            MTransferable t;
            if (!d.isDefaultTransferable() || (t = this.createTransferable(d)) == null) continue;
            t.registerNativeNames();
            list.add(t);
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MTransferable> getDndTransferables() {
        ArrayList<MTransferable> list = new ArrayList<MTransferable>();
        ArrayList<TransferableDescriptor> td = null;
        List<TransferableDescriptor> list2 = this.transferableData;
        synchronized (list2) {
            td = new ArrayList<TransferableDescriptor>(this.transferableData);
        }
        Collections.sort(td);
        for (TransferableDescriptor d : td) {
            MTransferable t;
            if (!d.isDndTransferable() || (t = this.createTransferable(d)) == null) continue;
            t.registerNativeNames();
            list.add(t);
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MTransferable> getInputTransferables() {
        ArrayList<MTransferable> list = new ArrayList<MTransferable>();
        ArrayList<TransferableDescriptor> td = null;
        List<TransferableDescriptor> list2 = this.transferableData;
        synchronized (list2) {
            td = new ArrayList<TransferableDescriptor>(this.transferableData);
        }
        Collections.sort(td, new InputTransferableComparator());
        for (TransferableDescriptor d : td) {
            MTransferable t = this.createTransferable(d);
            if (t == null || !t.isInputAvailable()) continue;
            t.registerNativeNames();
            list.add(t);
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCopyAsTransferableNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.OLEId != null && this.oleSupported) {
            names.add(this.OLEId);
        }
        ArrayList<TransferableDescriptor> td = null;
        List<TransferableDescriptor> list = this.transferableData;
        synchronized (list) {
            td = new ArrayList<TransferableDescriptor>(this.transferableData);
        }
        Collections.sort(td);
        for (TransferableDescriptor d : td) {
            if (!d.isCopyAsTransferable()) continue;
            names.add(d.getName());
            if (!this.separator.contains(d.getName())) continue;
            names.add("   ---------");
        }
        return Collections.unmodifiableList(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MTransferable getTransferable(String nameStr) {
        String name;
        String string = name = nameStr == null ? this.defaultId : nameStr;
        if (name.equals("___dnd")) {
            name = this.props.getProperty("dnd.name");
        }
        TransferableDescriptor d = null;
        List<TransferableDescriptor> list = this.transferableData;
        synchronized (list) {
            for (int i = 0; d == null && i < this.transferableData.size(); ++i) {
                TransferableDescriptor temp = this.transferableData.get(i);
                if (temp == null || !temp.getName().equals(name)) continue;
                d = temp;
            }
        }
        MTransferable t = this.createTransferable(d);
        if (t != null) {
            t.registerNativeNames();
        }
        return t;
    }

    public MTransferable getStringTransferable() {
        return this.getTransferable(this.props.getProperty("string.name"));
    }

    public String getOLEId() {
        return this.OLEId;
    }

    public boolean isOLESupported() {
        return this.oleSupported;
    }

    @Deprecated
    public void OLEIsRemoved() {
        this.removeOLESupport();
    }

    public void removeOLESupport() {
        this.oleSupported = false;
        MarvinOLETransfer.removeOLEReference();
        for (String s : this.OLECoveredFormats.split(",")) {
            TransferableDescriptor d = this.removeTransferableDescriptor(this.props.getProperty(s + ".name"));
            boolean def = Boolean.valueOf(this.props.getProperty(s + ".use.default")) != false && this.runtimeValOf(this.props.getProperty(s + ".use.default.depends"));
            this.addTransferableDescriptor(new TransferableDescriptor(d.getName(), d.getRepresentationClass(), d.getPriority(), d.getInputPriority(), def, d.isCopyAsTransferable(), def));
        }
    }

    private void configure(Properties properties) {
        this.transferableData = new ArrayList<TransferableDescriptor>();
        String pckg = properties.getProperty("implementation.package");
        String keys = properties.getProperty("implementation.keys");
        for (String s : keys.split(",")) {
            boolean isdnd;
            if (Boolean.valueOf(this.props.getProperty(s + ".disabled")).booleanValue()) continue;
            String name = properties.getProperty(s + ".name");
            String repClass = properties.getProperty(s + ".implementation");
            Integer prior = Integer.valueOf(properties.getProperty(s + ".priority.copy"));
            Integer iprior = Integer.valueOf(properties.getProperty(s + ".priority.paste"));
            boolean isdef = Boolean.valueOf(properties.getProperty(s + ".use.default")) != false && this.runtimeValOf(properties.getProperty(s + ".use.default.depends")) && (properties.getProperty("ole.coveredformats") == null || !properties.getProperty("ole.coveredformats").contains(s));
            boolean iscopyas = Boolean.valueOf(properties.getProperty(s + ".use.dialog")) != false && this.runtimeValOf(properties.getProperty(s + ".use.dialog.depends"));
            boolean bl = isdnd = Boolean.valueOf(properties.getProperty(s + ".use.default")) != false && this.runtimeValOf(properties.getProperty(s + ".use.default.depends"));
            if (pckg == null || name == null || repClass == null || prior == null || iprior == null) continue;
            try {
                this.preloadIfNeeded(properties, s, isdef);
                this.transferableData.add(new TransferableDescriptor(name, pckg + "." + repClass, prior, iprior, isdef, iscopyas, isdnd));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
    }

    private void preloadIfNeeded(Properties properties, String formatPropertyKey, boolean isFormatInDefault) throws ClassNotFoundException {
        boolean preloadDef = Boolean.valueOf(properties.getProperty("default.preload"));
        boolean preloadDefCopy = Boolean.valueOf(properties.getProperty("default.preload.copy"));
        boolean preloadDefPaste = Boolean.valueOf(properties.getProperty("default.preload.paste"));
        boolean preload = Boolean.valueOf(properties.getProperty(formatPropertyKey + ".preload"));
        boolean preloadCopy = Boolean.valueOf(properties.getProperty(formatPropertyKey + ".preload.copy"));
        boolean preloadPaste = Boolean.valueOf(properties.getProperty(formatPropertyKey + ".preload.paste"));
        String preloadClass = properties.getProperty(formatPropertyKey + ".preload.class");
        String preloadClassCopy = properties.getProperty(formatPropertyKey + ".preload.copy.class");
        String preloadClassPaste = properties.getProperty(formatPropertyKey + ".preload.paste.class");
        if (preloadClass != null && !preloadClass.equals("") && (preload || preloadCopy || preloadPaste || isFormatInDefault && (preloadDef || preloadDefCopy || preloadDefPaste))) {
            Class.forName(preloadClass);
        }
        if (preloadClassCopy != null && !preloadClassCopy.equals("") && (preload || preloadCopy || isFormatInDefault && (preloadDef || preloadDefCopy))) {
            Class.forName(preloadClassCopy);
        }
        if (preloadClassPaste != null && !preloadClassPaste.equals("") && (preload || preloadPaste || isFormatInDefault && (preloadDef || preloadDefPaste))) {
            Class.forName(preloadClassPaste);
        }
    }

    private boolean runtimeValOf(String dependency) {
        if (dependency == null) {
            return true;
        }
        boolean ret = true;
        if (dependency.contains("imagecopy")) {
            boolean bl = ret = ret && Environment.IMAGECOPY_ENABLED;
        }
        if (dependency.contains("olesupported")) {
            boolean bl = ret = ret && Environment.isOLESupported() && Boolean.valueOf(this.props.getProperty("ole.enabled")) != false;
        }
        if (dependency.contains("windows")) {
            boolean bl = ret = ret && Environment.MSWINDOWS;
        }
        if (dependency.contains("macos")) {
            boolean bl = ret = ret && Environment.MACOS;
        }
        if (dependency.contains("false")) {
            if (ret) {
                // empty if block
            }
            ret = false;
        }
        return ret;
    }

    private class InputTransferableComparator
    implements Comparator<TransferableDescriptor> {
        private InputTransferableComparator() {
        }

        @Override
        public int compare(TransferableDescriptor o1, TransferableDescriptor o2) {
            return o1.getInputPriority().compareTo(o2.getInputPriority());
        }
    }
}

