/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer.transferables;

import chemaxon.formats.MolExporter;
import chemaxon.marvin.modules.datatransfer.transferables.StructureTransferable;
import chemaxon.marvin.util.Environment;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class CDXTransferable
extends StructureTransferable {
    public CDXTransferable() {
        try {
            this.flavor = new DataFlavor("chemical/x-cdx");
            this.format = "cdx";
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void registerNativeNames() {
        SystemFlavorMap map = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
        if (!Environment.MACOS) {
            map.addUnencodedNativeForFlavor(this.flavor, "ChemDraw Interchange Format");
            map.addFlavorForUnencodedNative("ChemDraw Interchange Format", this.flavor);
        } else {
            map.addUnencodedNativeForFlavor(this.flavor, "CorePasteboardFlavorType 0x43444946");
            map.addFlavorForUnencodedNative("CorePasteboardFlavorType 0x43444946", this.flavor);
        }
    }

    @Override
    protected Object getDataToClipboard(DataFlavor flv) {
        byte[] ret;
        try {
            ret = MolExporter.exportToBinFormat(this.molecule, this.format);
        }
        catch (IOException e) {
            ret = new byte[]{};
        }
        return new ByteArrayInputStream(ret);
    }
}

