/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer.transferables;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.util.OSRA;
import chemaxon.marvin.modules.datatransfer.MarvinTransferable;
import chemaxon.struc.Molecule;
import chemaxon.util.ImageExportUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageTransferable
extends MarvinTransferable {
    public ImageTransferable() {
        this.flavor = DataFlavor.imageFlavor;
        this.format = "jpeg";
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flv) {
        if (this.extraFlavor != null) {
            return this.extraFlavor.equals(flv) || super.isDataFlavorSupported(flv);
        }
        return super.isDataFlavorSupported(flv);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        int count = 1;
        if (this.extraFlavor != null) {
            ++count;
        }
        DataFlavor[] ret = new DataFlavor[count];
        ret[0] = this.flavor;
        if (this.extraFlavor != null) {
            ret[1] = this.extraFlavor;
        }
        return ret;
    }

    public ByteArrayInputStream createGraphicsStream(String fmt) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String params = ImageExportUtil.createImageExporterParameter(this.properties, fmt, this.molecule.getDocument());
        try {
            MolExporter exporter = new MolExporter(outputStream, params);
            exporter.write(this.molecule);
            exporter.close();
        }
        catch (MolExportException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] data = outputStream.toByteArray();
        if (data != null) {
            return new ByteArrayInputStream(data);
        }
        return null;
    }

    @Override
    protected Object getDataToClipboard(DataFlavor flv) {
        ByteArrayInputStream stream = this.createGraphicsStream(this.format);
        if (flv.equals(this.extraFlavor)) {
            return stream;
        }
        if (flv.equals(this.flavor)) {
            try {
                return ImageIO.read(stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    protected Object getDataFromClipboard(DataFlavor flv) {
        Molecule mol = null;
        if (flv.equals(this.extraFlavor)) {
            try {
                MolImporter importer = new MolImporter(this.getInputStreamFromClipboard());
                mol = importer.read();
                importer.close();
                if (mol == null && OSRA.isAvailable()) {
                    mol = MolImporter.importMol(OSRA.readSDFFromStream(this.getInputStreamFromClipboard()));
                }
                return mol;
            }
            catch (MolFormatException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

