/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer.transferables;

import chemaxon.marvin.modules.datatransfer.transferables.ImageTransferable;
import chemaxon.marvin.modules.osx.PDFExchange;
import chemaxon.marvin.util.Environment;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PDFTransferable
extends ImageTransferable {
    public PDFTransferable() {
        try {
            this.flavor = new DataFlavor("application/pdf");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.format = "pdf";
    }

    @Override
    public void registerNativeNames() {
        SystemFlavorMap map = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
        if (Environment.MACOS) {
            map.addUnencodedNativeForFlavor(this.flavor, "com.adobe.pdf");
            map.addFlavorForUnencodedNative("com.adobe.pdf", this.flavor);
        } else {
            map.addUnencodedNativeForFlavor(this.flavor, "PDF");
            map.addFlavorForUnencodedNative("PDF", this.flavor);
        }
    }

    @Override
    public Object getDataToClipboard(DataFlavor flv) {
        return new ByteArrayInputStream(PDFExchange.exportToPdf(this.molecule, this.properties));
    }

    @Override
    protected Object getDataFromClipboard(DataFlavor flv) {
        InputStream pdf = null;
        pdf = this.getInputStreamFromClipboard();
        return PDFExchange.importFromPDF(pdf);
    }
}

