/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer.transferables;

import chemaxon.formats.MolExporter;
import chemaxon.marvin.modules.datatransfer.transferables.StructureTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class SKCTransferable
extends StructureTransferable {
    public SKCTransferable() {
        try {
            this.extraFlavor = new DataFlavor("chemical/x-mdl-isis");
            this.format = "skc";
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void registerNativeNames() {
        SystemFlavorMap map = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
        map.addUnencodedNativeForFlavor(this.extraFlavor, "MDLSK");
        map.addFlavorForUnencodedNative("MDLSK", this.extraFlavor);
    }

    @Override
    protected Object getDataToClipboard(DataFlavor flv) {
        if (!flv.equals(DataFlavor.stringFlavor) && this.isDataFlavorSupported(flv)) {
            byte[] ret;
            try {
                ret = MolExporter.exportToBinFormat(this.molecule, this.format);
            }
            catch (IOException e) {
                ret = new byte[]{};
            }
            return new ByteArrayInputStream(ret);
        }
        return super.getDataToClipboard(flv);
    }
}

