/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer.transferables;

import chemaxon.formats.MolExporter;
import chemaxon.marvin.modules.datatransfer.MarvinTransferable;
import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class StringTransferable
extends MarvinTransferable {
    public StringTransferable() {
        this.flavor = DataFlavor.stringFlavor;
        this.format = "source";
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flv) {
        if (this.extraFlavor != null) {
            return this.extraFlavor.equals(flv) || super.isDataFlavorSupported(flv);
        }
        return super.isDataFlavorSupported(flv);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        int count = 1;
        if (this.extraFlavor != null) {
            ++count;
        }
        DataFlavor[] ret = new DataFlavor[count];
        ret[0] = this.flavor;
        if (this.extraFlavor != null) {
            ret[1] = this.extraFlavor;
        }
        return ret;
    }

    protected String getMoleculeString() {
        if ("source".equals(this.format)) {
            this.format = this.molecule.getInputFormat();
            if (this.format == null) {
                this.format = "mrv";
            }
        }
        try {
            return MolExporter.exportToFormat(this.molecule, this.format);
        }
        catch (IOException e) {
            return "";
        }
    }

    @Override
    protected Object getDataToClipboard(DataFlavor flv) {
        if (flv.equals(DataFlavor.stringFlavor)) {
            return this.getMoleculeString();
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    protected Object getDataFromClipboard(DataFlavor flv) {
        InputStream is = this.getInputStreamFromClipboard();
        if (is != null) {
            return this.createMoleculeFromInputStream(is);
        }
        return null;
    }
}

