/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.mprop;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.formats.MolFormatException;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MProp;
import java.text.DecimalFormat;

public class VolumetricData
extends MProp {
    private static final String SEP = "\t";
    private static final String COMMENT1 = "Gaussian Cube file with atom data.";
    private static final String COMMENT2 = "No surface data provided.";
    private static final float BOHR_TO_ANGSTROMS_FACTOR = 0.5291772f;
    private static final float ANGSTROMS_TO_BOHR_FACTOR = 1.889726f;
    public String comment1 = "Gaussian Cube file with atom data.";
    public String comment2 = "No surface data provided.";
    public float[] origo = new float[3];
    public float[][] axes = new float[3][3];
    public float[] step = new float[3];
    public float[][][] grid = null;
    public int[] size = new int[3];

    public VolumetricData() {
        this.setDummyData();
    }

    public VolumetricData(String sval) throws MolFormatException {
        this(sval, null);
    }

    public VolumetricData(String sval, MProgressMonitor pmon) throws MolFormatException {
        new Parser(sval, pmon).parseVolumetricData();
        this.convertAfterImport();
    }

    public VolumetricData(float[][] axes, float[] step, float[] origo, float[][][] grid) {
        this.comment1 = COMMENT1;
        this.comment2 = COMMENT2;
        this.axes = axes;
        this.step = step;
        this.origo = origo;
        this.grid = grid;
        this.size = new int[3];
        this.size[0] = grid.length;
        this.size[1] = grid[0].length;
        this.size[2] = grid[0][0].length;
    }

    private void setDummyData() {
        this.comment1 = COMMENT1;
        this.comment2 = COMMENT2;
        this.size[0] = 1;
        this.size[1] = 1;
        this.size[2] = 1;
        this.axes[0][0] = 1.0f;
        this.axes[1][1] = 1.0f;
        this.axes[2][2] = 1.0f;
        this.step[0] = 1.0f;
        this.step[1] = 1.0f;
        this.step[2] = 1.0f;
        this.grid = new float[1][1][1];
        this.grid[0][0][0] = 0.0f;
    }

    private static float convertBeforeExport(float v) {
        return v * 1.889726f;
    }

    private void convertAfterImport() {
        this.convert(0.5291772f);
    }

    private void convert(float factor) {
        for (int i = 0; i < 3; ++i) {
            int n = i;
            this.origo[n] = this.origo[n] * factor;
            int n2 = i;
            this.step[n2] = this.step[n2] * factor;
            int j = 0;
            while (j < 3) {
                float[] fArray = this.axes[i];
                int n3 = j++;
                fArray[n3] = fArray[n3] * factor;
            }
        }
    }

    @Override
    @Deprecated
    public String convertToString(String fmt, int flags) throws IllegalArgumentException {
        MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
        return handler.convertToString(this, fmt);
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.comment1 + "\n" + this.comment2);
        b.append("\n" + VolumetricData.convertBeforeExport(this.origo[0]) + SEP + VolumetricData.convertBeforeExport(this.origo[1]) + SEP + VolumetricData.convertBeforeExport(this.origo[2]));
        b.append("\n" + this.size[2] + SEP + VolumetricData.convertBeforeExport(this.axes[0][0]) + SEP + VolumetricData.convertBeforeExport(this.axes[0][1]) + SEP + VolumetricData.convertBeforeExport(this.axes[0][2]));
        b.append("\n" + this.size[1] + SEP + VolumetricData.convertBeforeExport(this.axes[1][0]) + SEP + VolumetricData.convertBeforeExport(this.axes[1][1]) + SEP + VolumetricData.convertBeforeExport(this.axes[1][2]));
        b.append("\n" + this.size[0] + SEP + VolumetricData.convertBeforeExport(this.axes[2][0]) + SEP + VolumetricData.convertBeforeExport(this.axes[2][1]) + SEP + VolumetricData.convertBeforeExport(this.axes[2][2]));
        b.append("\n");
        b.append(this.convertGridToString());
        return new String(b);
    }

    public String convertGridToString() {
        DecimalFormat df = new DecimalFormat("0.00000E00");
        StringBuffer s = new StringBuffer();
        int k = 0;
        for (int ix = 0; ix < this.size[2]; ++ix) {
            for (int iy = 0; iy < this.size[1]; ++iy) {
                for (int iz = 0; iz < this.size[0]; ++iz) {
                    s.append(this.grid[iz][iy][ix] > 0.0f ? "  " : " ");
                    s.append(df.format(this.grid[iz][iy][ix]));
                    if (++k != 6) continue;
                    s.append("\n");
                    k = 0;
                }
            }
        }
        if (s.charAt(s.length() - 1) != '\n') {
            s.append("\n");
        }
        return s.toString();
    }

    @Override
    public Object getPropValue() {
        return this;
    }

    @Override
    public String getPropType() {
        return "VolumetricData";
    }

    @Override
    public String getPropXSDType() {
        return "ENTITY";
    }

    @Override
    public MProp cloneProp() {
        int j;
        int i;
        VolumetricData vd = new VolumetricData();
        vd.comment1 = this.comment1;
        vd.comment2 = this.comment2;
        for (i = 0; i < this.origo.length; ++i) {
            vd.origo[i] = this.origo[i];
        }
        for (i = 0; i < this.axes.length; ++i) {
            for (j = 0; j < this.axes[i].length; ++j) {
                vd.axes[i][j] = this.axes[i][j];
            }
        }
        for (i = 0; i < this.step.length; ++i) {
            vd.step[i] = this.step[i];
        }
        for (i = 0; i < this.size.length; ++i) {
            vd.size[i] = this.size[i];
        }
        vd.grid = new float[this.size[0]][this.size[1]][this.size[2]];
        for (i = 0; i < this.grid.length; ++i) {
            for (j = 0; j < this.grid[i].length; ++j) {
                System.arraycopy(this.grid[i], 0, vd.grid[i], 0, this.grid[i].length);
            }
        }
        return vd;
    }

    class Parser {
        int pos = 0;
        String sval = null;
        int len = 0;
        MProgressMonitor pmon = null;

        Parser(String sval, MProgressMonitor pmon) {
            this.sval = sval;
            this.len = sval.length();
            this.pmon = pmon;
        }

        void parseVolumetricData() throws MolFormatException {
            this.initProgress();
            this.parseComments();
            this.pos = this.findWordStart();
            this.parseOrigo();
            this.setProgress(5);
            this.parseAxes();
            this.setProgress(10);
            this.parseGrid();
            this.setProgress(100);
        }

        void parseComments() throws MolFormatException {
            VolumetricData.this.comment1 = this.readLine();
            VolumetricData.this.comment2 = this.readLine();
        }

        void parseOrigo() throws MolFormatException {
            VolumetricData.this.origo[0] = this.readFloat();
            VolumetricData.this.origo[1] = this.readFloat();
            VolumetricData.this.origo[2] = this.readFloat();
        }

        void parseAxes() throws MolFormatException {
            for (int i = 0; i < 3; ++i) {
                VolumetricData.this.size[2 - i] = Math.abs(this.readInteger());
                VolumetricData.this.axes[i][0] = this.readFloat();
                VolumetricData.this.axes[i][1] = this.readFloat();
                VolumetricData.this.axes[i][2] = this.readFloat();
                VolumetricData.this.step[i] = VolumetricData.this.axes[i][i];
            }
        }

        void parseGrid() throws MolFormatException {
            VolumetricData.this.grid = new float[VolumetricData.this.size[0]][VolumetricData.this.size[1]][VolumetricData.this.size[2]];
            int pl = 90 / VolumetricData.this.size[2];
            for (int ix = 0; ix < VolumetricData.this.size[2]; ++ix) {
                for (int iy = 0; iy < VolumetricData.this.size[1]; ++iy) {
                    for (int iz = 0; iz < VolumetricData.this.size[0]; ++iz) {
                        VolumetricData.this.grid[iz][iy][ix] = this.readFloat();
                    }
                }
                this.setProgress(10 + ix * pl);
            }
        }

        private int findWordEnd() {
            int i;
            for (i = this.pos; i < this.len && !Character.isWhitespace(this.sval.charAt(i)); ++i) {
            }
            return i;
        }

        private int findWordStart() {
            int i;
            for (i = this.pos; i < this.len && Character.isWhitespace(this.sval.charAt(i)); ++i) {
            }
            return i;
        }

        private int findLineEnd() {
            int i;
            for (i = this.pos; i < this.len && this.sval.charAt(i) != '\n'; ++i) {
            }
            return i;
        }

        private int readInteger() throws MolFormatException {
            int result;
            int i = this.pos;
            this.pos = this.findWordEnd();
            try {
                result = Integer.parseInt(this.sval.substring(i, this.pos));
            }
            catch (NumberFormatException e) {
                throw new MolFormatException(this.sval.substring(i, this.pos) + " - integer expected at position: " + i);
            }
            this.pos = this.findWordStart();
            return result;
        }

        private float readFloat() throws MolFormatException {
            float result;
            int i = this.pos;
            this.pos = this.findWordEnd();
            try {
                result = Float.parseFloat(this.sval.substring(i, this.pos));
            }
            catch (NumberFormatException e) {
                throw new MolFormatException(this.sval.substring(i, this.pos) + " - float expected at position: " + i);
            }
            this.pos = this.findWordStart();
            return result;
        }

        private String readLine() throws MolFormatException {
            int i = this.pos;
            this.pos = this.findLineEnd();
            String line = this.sval.substring(i, this.pos);
            if (this.pos < this.len) {
                ++this.pos;
            }
            return line;
        }

        private void initProgress() {
            if (this.pmon != null) {
                this.pmon.initProgressMonitor("Reading volumetric data", 0, 100);
            }
        }

        private void setProgress(int i) {
            if (this.pmon != null) {
                this.pmon.setProgressValue(i);
            }
        }
    }
}

