/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.osx;

import chemaxon.marvin.modules.datatransfer.transferables.CompositeTransferable;
import chemaxon.marvin.modules.osx.OSXPasteboardWrapper;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class OSXClipboard
extends Clipboard {
    private FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();

    public OSXClipboard(String name) {
        super(name);
    }

    @Override
    public DataFlavor[] getAvailableDataFlavors() {
        Map<String, DataFlavor> map = this.flavorMap.getFlavorsForNatives(OSXPasteboardWrapper.getTypesFromPasteboard(OSXPasteboardWrapper.OSXPasteboard.GENERAL_PASTEBOARD));
        ArrayList<DataFlavor> flavors = new ArrayList<DataFlavor>();
        for (DataFlavor dataFlavor : map.values()) {
            if (dataFlavor == null) continue;
            flavors.add(dataFlavor);
        }
        return flavors.toArray(new DataFlavor[flavors.size()]);
    }

    @Override
    public synchronized Transferable getContents(Object requestor) {
        CompositeTransferable<TransferableImpl> ret = new CompositeTransferable<TransferableImpl>();
        DataFlavor[] flavors = this.getAvailableDataFlavors();
        Map<DataFlavor, String> map = this.flavorMap.getNativesForFlavors(flavors);
        for (DataFlavor flavor : flavors) {
            byte[] data = OSXPasteboardWrapper.getDataFromPasteBoard(map.get(flavor), OSXPasteboardWrapper.OSXPasteboard.GENERAL_PASTEBOARD);
            TransferableImpl t = new TransferableImpl(flavor, data);
            ret.add(t);
        }
        return ret;
    }

    @Override
    public Object getData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this.getContents(null).getTransferData(flavor);
    }

    @Override
    public boolean isDataFlavorAvailable(DataFlavor flavor) {
        return this.getContents(null).isDataFlavorSupported(flavor);
    }

    @Override
    public synchronized void setContents(Transferable contents, ClipboardOwner owner) {
        Map<DataFlavor, String> map = this.flavorMap.getNativesForFlavors(contents.getTransferDataFlavors());
        OSXPasteboardWrapper.clearContentsFromPasteboard(OSXPasteboardWrapper.OSXPasteboard.GENERAL_PASTEBOARD);
        for (DataFlavor flavor : contents.getTransferDataFlavors()) {
            try {
                Object data = contents.getTransferData(flavor);
                byte[] arr = this.toArray(data);
                OSXPasteboardWrapper.setDataToPasteBoard(map.get(flavor), arr, OSXPasteboardWrapper.OSXPasteboard.GENERAL_PASTEBOARD);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private byte[] toArray(Object data) {
        byte[] byteArray = null;
        if (data instanceof ByteArrayInputStream) {
            int count = ((ByteArrayInputStream)data).available();
            byteArray = new byte[count];
            ((ByteArrayInputStream)data).read(byteArray, 0, count);
        }
        if (data instanceof byte[]) {
            byteArray = (byte[])data;
        }
        if (data instanceof String) {
            String s = (String)data;
            byteArray = s.getBytes();
        }
        return byteArray;
    }

    @Override
    public synchronized void addFlavorListener(FlavorListener listener) {
    }

    @Override
    public synchronized FlavorListener[] getFlavorListeners() {
        return null;
    }

    @Override
    public synchronized void removeFlavorListener(FlavorListener listener) {
    }

    private class TransferableImpl
    implements Transferable {
        private DataFlavor supportedDataFlavor;
        private byte[] data;

        public TransferableImpl(DataFlavor flavor, byte[] data) {
            this.data = data;
            this.supportedDataFlavor = flavor;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.supportedDataFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{this.supportedDataFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.supportedDataFlavor.equals(flavor);
        }
    }
}

