/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.osx;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.MolPrinter;
import chemaxon.struc.Molecule;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class PDFExchange {
    public static byte[] exportToPdf(Molecule mol, Properties properties) {
        Document doc = new Document(new com.lowagie.text.Rectangle(100.0f, 100.0f));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)stream);
            doc.open();
            PdfContentByte content = writer.getDirectContent();
            MolPrinter printer = new MolPrinter(mol);
            printer.setScale(printer.maxScale(new Rectangle(100, 100)));
            Graphics2D g = content.createGraphics(100.0f, 100.0f);
            printer.paint(g, new Rectangle(100, 100));
            g.dispose();
            writer.createXmpMetadata();
            writer.setXmpMetadata(MolExporter.exportToBinFormat(mol, "MRV"));
            doc.close();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stream.toByteArray();
    }

    public static Molecule importFromPDF(InputStream pdf) {
        try {
            PdfReader reader = new PdfReader(pdf);
            byte[] metaData = reader.getMetadata();
            reader.close();
            return MolImporter.importMol(metaData);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

