/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.print;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.modules.print.MultiPageTable;
import chemaxon.marvin.view.MDocStorage;
import chemaxon.marvin.view.swing.CellFiller;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

class GridBagMPageTable
extends MultiPageTable {
    private PageTableModel tableModel = null;
    private JTable table;
    private JPanel tablePanel = null;
    private int cols;
    String[] cachedMolNames = null;
    String[] cachedGenNames = null;
    String[] cachedSMILES = null;
    String[] cachedSelectedFields = null;

    public GridBagMPageTable(ViewPanel viewPanel, File f, Integer molcount) {
        super(viewPanel, f, molcount);
        this.cols = viewPanel.getVisibleCols();
        this.tableModel = new PageTableModel();
        this.initDocStorage();
        this.initFields();
    }

    private void initFields() {
        CellFiller cf = this.viewPanel.getViewHandler().getCellFiller();
        boolean isMolNameShown = cf.isMolNameShown();
        boolean isGenNameShown = cf.isGenNameShown() && LicenseHandler.getInstance().isLicensed("Structure to Name Plugin");
        boolean isSMILESShown = cf.isSMILESShown();
        boolean isSelectedFieldsShown = cf.getFieldsShown();
        boolean isAnyField = isMolNameShown || isGenNameShown || isSMILESShown || isSelectedFieldsShown;
        int maxrec = this.getMaxRecPerPage();
        this.cachedMolNames = new String[maxrec];
        this.cachedGenNames = new String[maxrec];
        this.cachedSMILES = new String[maxrec];
        this.cachedSelectedFields = new String[maxrec];
        if (isAnyField) {
            for (int i = 0; i < maxrec; ++i) {
                try {
                    MDocument doc = this.docStorage.getDoc(i, null, null);
                    if (isMolNameShown) {
                        this.cachedMolNames[i] = GridBagMPageTable.getMolName(doc);
                    }
                    if (isGenNameShown) {
                        this.cachedGenNames[i] = GridBagMPageTable.getGenName(doc);
                    }
                    if (isSMILESShown) {
                        this.cachedSMILES[i] = GridBagMPageTable.getSMILES(doc);
                    }
                    if (!isSelectedFieldsShown) continue;
                    this.cachedSelectedFields[i] = GridBagMPageTable.getSelectedFields(doc, this.viewPanel.getViewHandler().getCellFiller());
                    continue;
                }
                catch (MDocStorage.RecordUnavailableException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (MDocStorage.CancellationException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.docStorage.setDocSource(this.docStorage.getDocSource(), 0, this.getMaxRecPerPage());
        }
    }

    private static String getMolName(MDocument doc) {
        return doc.getMainMoleculeGraph().getName();
    }

    private static String getGenName(MDocument doc) {
        String s = null;
        if (LicenseHandler.getInstance().isLicensed("Structure to Name Plugin")) {
            Molecule mol = doc.getPrimaryMolecule();
            try {
                s = mol.exportToFormat("name");
            }
            catch (MolExportException ex) {
                for (Throwable t = ex; t != null; t = t.getCause()) {
                    s = t.getMessage();
                }
            }
        }
        return s;
    }

    private static String getSMILES(MDocument doc) {
        String s = null;
        try {
            String[] res = MFileFormatUtil.convertToSmilingFormat(doc.getPrimaryMolecule());
            s = res[0];
        }
        catch (Throwable ex) {
            for (Throwable t = ex; t != null; t = t.getCause()) {
                s = t.getMessage();
            }
        }
        return s;
    }

    private static String getSelectedFields(MDocument doc, CellFiller cf) {
        String s = null;
        Molecule mainmol = (Molecule)doc.getMainMoleculeGraph();
        if (mainmol.getPropertyCount() > 0) {
            s = GridBagMPageTable.getFields(mainmol, cf.getSelectedFields());
        }
        return s;
    }

    @Override
    public int getMaxRecPerPage() {
        return this.rowPerPage * this.cols;
    }

    @Override
    public boolean isFirstPage() {
        return this.shift == 0;
    }

    @Override
    public void nextPage() {
        boolean visible = this.tablePanel.isVisible();
        if (visible) {
            this.tablePanel.setVisible(false);
        } else {
            this.tablePanel.invalidate();
        }
        this.hasMorePages();
        this.shift += this.getMaxRecPerPage();
        this.docStorage.setCacheCapacity(this.getMaxRecPerPage() * 2);
        this.docStorage.setDocSource(this.docStorage.getDocSource(), this.shift, this.getMaxRecPerPage());
        if (this.maxrec != -1 && this.shift > this.maxrec) {
            this.docStorage.setSize(this.shift - this.maxrec);
        }
        this.hasMorePages();
        if (visible) {
            this.tablePanel.setVisible(true);
        } else {
            this.tablePanel.validate();
        }
    }

    @Override
    public void previousPage() {
        this.shift -= this.getMaxRecPerPage();
        this.docStorage.setCacheCapacity(this.getMaxRecPerPage() * 2);
        this.docStorage.setDocSource(this.docStorage.getDocSource(), this.shift, this.getMaxRecPerPage());
    }

    @Override
    public boolean hasMorePages() {
        return (this.previousPage + 1) * this.getMaxRecPerPage() < this.maxrec;
    }

    @Override
    protected void initTablePanel(int paperWidth, int paperHeight) {
        this.tablePanel = new JPanel();
        this.table = new JTable(this.tableModel);
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)this.table, "Center");
        int defaultRowHeight = paperHeight / this.rowPerPage;
        this.tablePanel.setPreferredSize(new Dimension(paperWidth, paperHeight));
        this.table.setRowHeight(defaultRowHeight);
        this.table.setGridColor(Color.black);
        this.table.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        MViewCellRenderer cellRenderer = new MViewCellRenderer();
        this.table.setDefaultRenderer(MDocument.class, cellRenderer);
        this.tablePanel.validate();
    }

    private void displayTablePanel() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add(this.tablePanel);
        frame.pack();
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D graphics = (Graphics2D)g;
        if (!this.hasMorePages()) {
            return 1;
        }
        if (pageIndex == this.previousPage) {
            return 1;
        }
        this.previousPage = pageIndex;
        Dimension d = new Dimension();
        d.setSize(pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        if (this.tablePanel == null) {
            this.initTablePanel(d.width, d.height);
            this.displayTablePanel();
        } else {
            this.nextPage();
        }
        this.tablePanel.print(graphics);
        return 0;
    }

    private static String getFields(Molecule mol, String[] incFields) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < incFields.length; ++i) {
            GridBagMPageTable.appendField(mol, incFields[i], sb);
        }
        sb.setLength(sb.length() == 0 ? 0 : sb.length() - 1);
        return sb.toString();
    }

    private static String appendField(Molecule mol, String key, StringBuffer sb) {
        String value = mol.getProperty(key);
        if (value != null) {
            value = value.trim();
            try {
                try {
                    Integer inum = Integer.valueOf(value);
                    value = inum.toString();
                }
                catch (NumberFormatException ex) {
                    Double dnum = Double.valueOf(value);
                    value = dnum.toString();
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (!value.equals("")) {
                sb.append(key + ": " + value + "\n");
            }
        }
        return value;
    }

    private int getPreferredCellWidth() {
        int cols = this.tableModel.getColumnCount();
        return (int)(this.tablePanel.getPreferredSize().getWidth() - (double)(cols + 1)) / cols;
    }

    private static String findLongestString(String[] ss) {
        if (ss == null) {
            return null;
        }
        String longest = null;
        for (int i = 0; i < ss.length; ++i) {
            if (ss[i] == null) continue;
            if (longest == null) {
                longest = ss[i];
                continue;
            }
            if (longest.length() >= ss[i].length()) continue;
            longest = ss[i];
        }
        return longest;
    }

    class MViewCellRenderer
    implements TableCellRenderer {
        private ViewPanel viewpanel = new ViewPanel(null, 2, null);
        private JLabel jlabel = null;
        private JTextArea molNameComp = null;
        private JTextArea genNameComp = null;
        private JTextArea smilesComp = null;
        private JTextArea fieldsComp = null;
        private JPanel cellcomp = null;
        private float DEFAULTFONT_SIZE = 10.0f;
        private int TEXT_MARGIN_LEFT = 2;
        private int TEXT_MARGIN_RIGHT = 1;

        public MViewCellRenderer() {
            this.initLayout();
        }

        private void setParams(String s) {
            ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
            Properties props = new Properties();
            props.putAll(this.viewpanel.getUserSettings().getPropertyMap("persistent"));
            try {
                props.load(bais);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.viewpanel.setProperties(props);
        }

        private void initLayout() {
            CellFiller cf = GridBagMPageTable.this.viewPanel.getViewHandler().getCellFiller();
            boolean isMolNameShown = cf.isMolNameShown();
            boolean isGenNameShown = cf.isGenNameShown() && LicenseHandler.getInstance().isLicensed("Structure to Name Plugin");
            boolean isSMILESShown = cf.isSMILESShown();
            boolean isSelectedFieldsShown = cf.getFieldsShown();
            int cellWidth = GridBagMPageTable.this.getPreferredCellWidth();
            Dimension cellSize = new Dimension(cellWidth, GridBagMPageTable.this.table.getRowHeight());
            this.jlabel = new JLabel("#", 0);
            Font f = this.jlabel.getFont();
            f = f.deriveFont(this.DEFAULTFONT_SIZE);
            this.jlabel.setFont(f);
            int headerHeight = this.jlabel.getPreferredSize().height;
            if (GridBagMPageTable.this.getMaxRecPerPage() == 1) {
                headerHeight = 0;
            }
            int viewMinHeight = this.jlabel.getPreferredSize().height * 3;
            this.setParams("");
            this.viewpanel.setBackground(GridBagMPageTable.this.table.getBackground());
            this.viewpanel.setMolbg(GridBagMPageTable.this.table.getBackground());
            Dimension viewMinSize = new Dimension(cellWidth, viewMinHeight);
            int restHeight = cellSize.height;
            restHeight -= headerHeight;
            JPanel buttomPane = new JPanel();
            buttomPane.setLayout(new GridBagLayout());
            GridBagConstraints bgbc = new GridBagConstraints();
            bgbc.fill = 2;
            bgbc.weightx = 1.0;
            bgbc.weighty = 0.0;
            bgbc.gridx = 0;
            bgbc.gridy = -1;
            double textHeight = 0.0;
            Dimension textMaxSize = new Dimension(cellWidth, restHeight - viewMinSize.height);
            Color borderColor = this.jlabel.getBackground();
            if (isMolNameShown) {
                this.molNameComp = this.createJTextArea(GridBagMPageTable.findLongestString(GridBagMPageTable.this.cachedMolNames), this.DEFAULTFONT_SIZE, textMaxSize, borderColor);
                if (this.addComp(buttomPane, bgbc, this.molNameComp, textMaxSize)) {
                    textHeight += this.molNameComp.getMinimumSize().getHeight();
                }
            }
            if (isGenNameShown) {
                this.genNameComp = this.createJTextArea(GridBagMPageTable.findLongestString(GridBagMPageTable.this.cachedGenNames), this.DEFAULTFONT_SIZE, textMaxSize, borderColor);
                if (this.addComp(buttomPane, bgbc, this.genNameComp, textMaxSize)) {
                    textHeight += this.genNameComp.getMinimumSize().getHeight();
                }
            }
            if (isSMILESShown) {
                this.smilesComp = this.createJTextArea(GridBagMPageTable.findLongestString(GridBagMPageTable.this.cachedSMILES), this.DEFAULTFONT_SIZE, textMaxSize, borderColor);
                if (this.addComp(buttomPane, bgbc, this.smilesComp, textMaxSize)) {
                    textHeight += this.smilesComp.getMinimumSize().getHeight();
                }
            }
            String[] fields = cf.getSelectedFields();
            if (isSelectedFieldsShown && fields != null && fields.length > 0) {
                String lest = GridBagMPageTable.findLongestString(GridBagMPageTable.this.cachedSelectedFields);
                this.fieldsComp = this.createJTextArea(lest, this.DEFAULTFONT_SIZE, textMaxSize, borderColor);
                if (this.addComp(buttomPane, bgbc, this.fieldsComp, textMaxSize)) {
                    textHeight += this.fieldsComp.getMinimumSize().getHeight();
                }
            }
            this.cellcomp = new JPanel();
            this.cellcomp.setLayout(new BorderLayout());
            if (headerHeight > 0) {
                JPanel topPane = this.createGridBagRenderedPane(this.jlabel, this.viewpanel);
                this.cellcomp.add((Component)topPane, "North");
            } else {
                this.cellcomp.add((Component)this.viewpanel, "North");
            }
            if (textHeight > 0.0) {
                this.cellcomp.add((Component)buttomPane, "Center");
                viewMinSize.height = cellSize.height - headerHeight - (int)textHeight;
                this.viewpanel.setMinimumSize(viewMinSize);
                this.viewpanel.setPreferredSize(viewMinSize);
            } else {
                viewMinSize.height = cellSize.height - headerHeight;
                this.viewpanel.setPreferredSize(viewMinSize);
            }
        }

        private boolean addComp(JPanel panel, GridBagConstraints gbc, JTextArea textArea, Dimension maxSize) {
            Dimension d = textArea.getMinimumSize();
            double h = maxSize.getHeight() - (double)d.height;
            if (h < 0.0) {
                FontMetrics fm = textArea.getFontMetrics(textArea.getFont());
                int fh = fm.getAscent() + fm.getDescent();
                while (maxSize.getHeight() < (double)d.height) {
                    d.height -= fh;
                }
                if (d.height > fh) {
                    textArea.setMinimumSize(d);
                } else {
                    return false;
                }
            }
            panel.add((Component)textArea, gbc);
            maxSize.height -= textArea.getMinimumSize().height;
            return true;
        }

        private JTextArea createJTextArea(String longestString, float fontsize, Dimension maxSize, Color borderColor) {
            if (longestString == null) {
                return null;
            }
            JTextArea textArea = new JTextArea(longestString);
            textArea.setEditable(false);
            textArea.setLineWrap(true);
            textArea.setBackground(Color.WHITE);
            textArea.setAlignmentX(0.5f);
            textArea.setAlignmentY(0.5f);
            Border emptyborder = BorderFactory.createEmptyBorder(0, this.TEXT_MARGIN_LEFT, 0, this.TEXT_MARGIN_RIGHT);
            MatteBorder matteborder = BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor);
            CompoundBorder border = BorderFactory.createCompoundBorder(matteborder, emptyborder);
            textArea.setBorder(border);
            Font f = textArea.getFont();
            f = f.deriveFont(fontsize);
            textArea.setFont(f);
            JFrame frame = new JFrame();
            frame.getContentPane().add(textArea);
            frame.setSize(maxSize);
            frame.pack();
            Dimension d = textArea.getPreferredSize();
            frame.invalidate();
            frame.getContentPane().remove(textArea);
            textArea.setMinimumSize(d);
            return textArea;
        }

        private JPanel createGridBagRenderedPane(JLabel label, ViewPanel vpan) {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridx = 0;
            gbc.gridy = -1;
            gbc.anchor = 10;
            panel.add((Component)label, gbc);
            gbc.fill = 1;
            gbc.weighty = 0.5;
            gbc.anchor = 10;
            panel.add((Component)vpan, gbc);
            gbc.weighty = 0.3;
            gbc.fill = 2;
            return panel;
        }

        private String getKeyValue(int index, MDocument document, String key) {
            String s = null;
            if (key.equals("$index")) {
                s = Integer.toString(index + 1);
            } else if (key.equals("$molname")) {
                s = document.getMainMoleculeGraph().getName();
                if (s == null) {
                    s = " ";
                }
            } else if (key.equals("$genname")) {
                s = GridBagMPageTable.getGenName(document);
            } else if (key.equals("$smiles")) {
                s = GridBagMPageTable.getSMILES(document);
            } else if (key.equals("$fields")) {
                s = GridBagMPageTable.getSelectedFields(document, GridBagMPageTable.this.viewPanel.getViewHandler().getCellFiller());
            }
            return s;
        }

        private void fillCell(int index, MDocument document) {
            Molecule m = (Molecule)document.getMainMoleculeGraph();
            this.viewpanel.setM(0, m);
            String label = this.getKeyValue(index, document, "$index");
            this.jlabel.setText(label);
            this.updateTextComp(this.molNameComp, this.getKeyValue(index, document, "$molname"));
            this.updateTextComp(this.genNameComp, this.getKeyValue(index, document, "$genname"));
            this.updateTextComp(this.smilesComp, this.getKeyValue(index, document, "$smiles"));
            this.updateTextComp(this.fieldsComp, this.getKeyValue(index, document, "$fields"));
        }

        private void updateTextComp(JTextArea comp, String txt) {
            if (comp == null) {
                return;
            }
            Dimension d = comp.getMinimumSize();
            comp.setText(null);
            StringBuffer text = new StringBuffer();
            text.append(txt);
            comp.setText(text.toString());
            comp.invalidate();
            comp.setPreferredSize(d);
            comp.validate();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object doc, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            if (doc == null) {
                return null;
            }
            int rh = table.getRowHeight(rowIndex);
            int cellwidth = table.getWidth() / GridBagMPageTable.this.cols;
            this.cellcomp.setPreferredSize(new Dimension(cellwidth, rh));
            MDocument document = (MDocument)doc;
            int index = GridBagMPageTable.this.shift + rowIndex * GridBagMPageTable.this.cols + columnIndex;
            this.fillCell(index, document);
            return this.cellcomp;
        }
    }

    class PageTableModel
    extends AbstractTableModel {
        PageTableModel() {
        }

        public Class getColumnClass(int arg0) {
            return MDocument.class;
        }

        @Override
        public int getColumnCount() {
            return GridBagMPageTable.this.cols;
        }

        @Override
        public int getRowCount() {
            int rc = GridBagMPageTable.this.docStorage.getSize();
            if (GridBagMPageTable.this.maxrec != -1) {
                rc = Math.min(rc, GridBagMPageTable.this.maxrec - GridBagMPageTable.this.shift);
            }
            if (rc == 0) {
                rc = 1;
            }
            return rc;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MDocument doc = null;
            try {
                int index = rowIndex * GridBagMPageTable.this.cols + columnIndex;
                doc = GridBagMPageTable.this.docStorage.getDoc(index, null, null);
            }
            catch (Exception e) {
                // empty catch block
            }
            return doc;
        }
    }
}

