/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.print;

import chemaxon.formats.MolImporter;
import chemaxon.marvin.modules.print.PrintProvider;
import chemaxon.marvin.view.MDocStorage;
import chemaxon.marvin.view.swing.ViewPanel;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

abstract class MultiPageTable
implements PrintProvider {
    protected ViewPanel viewPanel;
    protected File inputFile;
    protected MDocStorage docStorage;
    protected int rowPerPage;
    protected int shift = 0;
    protected int maxrec;
    protected int previousPage = -1;

    public MultiPageTable(ViewPanel viewPanel, File f, Integer molcount) {
        this.viewPanel = viewPanel;
        this.inputFile = f;
        this.rowPerPage = viewPanel.getVisibleRows();
        this.maxrec = molcount;
    }

    protected void initDocStorage() {
        try {
            FileInputStream fin = new FileInputStream(this.inputFile);
            MolImporter importer = new MolImporter(fin);
            this.docStorage = new MDocStorage();
            MolImporter docSource = importer;
            this.docStorage.setDocSource(docSource, this.shift, this.getMaxRecPerPage());
            this.docStorage.setSize(this.getMaxRecPerPage());
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract int getMaxRecPerPage();

    public abstract void nextPage();

    public abstract void previousPage();

    public abstract boolean isFirstPage();

    @Override
    public abstract boolean hasMorePages();

    @Override
    public boolean isMultiPageSupported() {
        return true;
    }

    protected abstract void initTablePanel(int var1, int var2);

    @Override
    public abstract int print(Graphics var1, PageFormat var2, int var3) throws PrinterException;
}

