/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.print;

import chemaxon.marvin.modules.print.PrintProvider;
import chemaxon.marvin.util.PrintConstants;
import chemaxon.marvin.view.swing.ViewCanvas;
import chemaxon.marvin.view.swing.ViewPanel;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Constructor;

class PrintFactory
implements PrintConstants {
    private ViewPanel viewPanel;
    private File tserFile = null;
    private int tserMolcount = -1;

    public PrintFactory(ViewPanel viewPanel) {
        this.viewPanel = viewPanel;
    }

    public PrintFactory(ViewPanel viewPanel, File tserFile, int tserMolcount) {
        this.viewPanel = viewPanel;
        this.tserFile = tserFile;
        this.tserMolcount = tserMolcount;
    }

    public PrintProvider createPrintProvider(int type) throws InstantiationException {
        PrintProvider pp = null;
        String className = null;
        Class[] argsClass = null;
        Object[] args = null;
        if (type == 0) {
            className = "chemaxon.marvin.modules.print.SimpleCellPanel";
            int n = this.viewPanel.getSelectedCellIndex();
            ViewCanvas canvas = this.viewPanel.getCanvas(n);
            if (canvas == null) {
                throw new InstantiationException("No cell selected for printing");
            }
            int dim = canvas.getDocument().getMainMoleculeGraph().getDim();
            argsClass = new Class[]{ViewCanvas.class, Color.class};
            Color bg = this.viewPanel.getMolbg(dim);
            args = new Object[]{canvas, bg};
        } else if (type == 1) {
            className = "chemaxon.marvin.modules.print.SinglePageTable";
            argsClass = new Class[]{ViewPanel.class};
            args = new Object[]{this.viewPanel};
        } else if (type == 2) {
            className = this.viewPanel.getViewHandler().getMultiPageSupportedPrintProviderClassName();
            argsClass = new Class[]{ViewPanel.class, File.class, Integer.class};
            args = new Object[]{this.viewPanel, this.tserFile, this.tserMolcount};
        }
        if (className != null) {
            try {
                Class<?> cl = Class.forName(className);
                if (argsClass == null) {
                    pp = (PrintProvider)cl.newInstance();
                } else {
                    Constructor<?> mthd = cl.getConstructor(argsClass);
                    pp = (PrintProvider)mthd.newInstance(args);
                }
            }
            catch (Exception ex) {
                throw new InstantiationException(ex.getMessage());
            }
        }
        if (className == null) {
            throw new InstantiationException("PrintProvider extended class is not found.");
        }
        return pp;
    }
}

