/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.print;

import chemaxon.marvin.common.swing.MolButton;
import chemaxon.marvin.modules.print.PrintProvider;
import chemaxon.marvin.view.swing.ViewCanvas;
import chemaxon.marvin.view.swing.ViewPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.JTableHeader;

class SinglePageTable
implements PrintProvider {
    private ViewPanel viewPanel;
    private int previousPage = -1;
    private VisibleComponentRenderer vcr = null;

    public SinglePageTable(ViewPanel viewPanel) {
        this.viewPanel = viewPanel;
    }

    @Override
    public boolean hasMorePages() {
        return this.previousPage == -1;
    }

    @Override
    public boolean isMultiPageSupported() {
        return false;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        if (pageIndex == this.previousPage) {
            return 1;
        }
        this.previousPage = pageIndex;
        Dimension d = new Dimension();
        d.setSize(pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        if (this.viewPanel.getViewHandler().getNameAndArgs().startsWith("SpreadsheetView")) {
            this.getVisibleComponentRenderer().printJScrollPane((Graphics2D)graphics, pageFormat);
        } else {
            this.getVisibleComponentRenderer().printVisibleComponents((Graphics2D)graphics, d);
        }
        return 0;
    }

    private VisibleComponentRenderer getVisibleComponentRenderer() {
        if (this.vcr == null) {
            this.vcr = new VisibleComponentRenderer();
        }
        return this.vcr;
    }

    private class VisibleComponentRenderer {
        private VisibleComponentRenderer() {
        }

        private boolean isSkipComponent(Component c) {
            return c instanceof JScrollBar || c instanceof Scrollbar || c instanceof JProgressBar;
        }

        void printJScrollPane(Graphics2D g, PageFormat pageFormat) {
            double scaleY;
            double scaleX;
            JScrollPane scrollpane = null;
            JTableHeader theader = null;
            if (SinglePageTable.this.viewPanel.getComponent(0) instanceof JScrollPane) {
                scrollpane = (JScrollPane)SinglePageTable.this.viewPanel.getComponent(0);
                if (scrollpane.getViewport().getComponent(0) instanceof JTable) {
                    theader = ((JTable)scrollpane.getViewport().getComponent(0)).getTableHeader();
                }
            } else {
                return;
            }
            double pageWidth = pageFormat.getImageableWidth();
            double pageHeight = pageFormat.getImageableHeight();
            Rectangle viewportRect = scrollpane.getViewportBorderBounds();
            double thh = 0.0;
            if (theader != null) {
                thh = theader.getHeight();
            }
            double scale = (scaleX = pageWidth / (double)viewportRect.width) > (scaleY = pageHeight / ((double)viewportRect.height + thh)) ? scaleY : scaleX;
            double dx = pageWidth - (double)viewportRect.width * scale;
            double dy = pageHeight - ((double)viewportRect.height + thh) * scale;
            double offsetX = dx > 0.0 ? dx / 2.0 : 0.0;
            double offsetY = dy > 0.0 ? dy / 2.0 : 0.0;
            Color c = g.getColor();
            g.setColor(Color.white);
            g.fillRect(0, 0, (int)pageWidth, (int)pageHeight);
            g.setColor(c);
            g.translate(offsetX, offsetY);
            if (theader != null) {
                g.scale(scale, scale);
                g.setClip(new Rectangle(0, 0, (int)Math.ceil(viewportRect.width), (int)Math.ceil(thh)));
                theader.paint(g);
                g.scale(1.0 / scale, 1.0 / scale);
            }
            g.scale(scale, scale);
            g.setClip(viewportRect);
            scrollpane.paint(g);
            g.scale(1.0 / scale, 1.0 / scale);
        }

        void printVisibleComponents(Graphics2D g, Dimension image) {
            Dimension margin = new Dimension(0, 0);
            Dimension d = SinglePageTable.this.viewPanel.getSize();
            Component[] comps = SinglePageTable.this.viewPanel.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!this.isSkipComponent(comps[i])) continue;
                if (comps[i].getSize().width > comps[i].getSize().height) {
                    d.height -= comps[i].getSize().height;
                    continue;
                }
                d.width -= comps[i].getSize().width;
            }
            double realScaleX = (double)image.width / (double)d.width;
            double realScaleY = (double)image.height / (double)d.height;
            double realScale = realScaleX < realScaleY ? realScaleX : realScaleY;
            Point offset = new Point(margin.width, margin.height);
            if (realScaleX < realScaleY) {
                if (realScaleY > 1.0) {
                    offset.y = (int)Math.ceil(((double)image.height - (double)d.height * realScale) / 2.0) + margin.height;
                }
            } else if (realScaleX > 1.0) {
                offset.x = (int)Math.ceil(((double)image.width - (double)d.width * realScale) / 2.0) + margin.width;
            }
            g.fillRect(offset.x, offset.y, (int)Math.ceil((double)d.width * realScale) + 3, (int)Math.ceil((double)d.height * realScale) + 3);
            Rectangle fullrect = new Rectangle(offset.x, offset.y, (int)Math.ceil((double)d.width * realScale), (int)Math.ceil((double)d.height * realScale));
            g.setClip(fullrect);
            for (int i = 0; i < comps.length; ++i) {
                Dimension d0;
                if (this.isSkipComponent(comps[i])) continue;
                Dimension compDefSize = comps[i].getSize();
                Point p = comps[i].getLocation();
                Font defFont = null;
                Image img = null;
                String label = null;
                int fontSize = -1;
                if (comps[i] instanceof ViewCanvas) {
                    if (compDefSize.height == 1) {
                        comps[i].setSize((int)Math.ceil((double)compDefSize.width * realScale), 1);
                    } else if (compDefSize.width == 1) {
                        comps[i].setSize(1, (int)Math.ceil((double)compDefSize.height * realScale));
                    } else {
                        comps[i].setSize((int)Math.ceil((double)compDefSize.width * realScale), (int)Math.ceil((double)compDefSize.height * realScale));
                    }
                } else if (comps[i] instanceof MolButton) {
                    label = ((MolButton)comps[i]).getText();
                    if (label != null) {
                        defFont = ((MolButton)comps[i]).getFont();
                        fontSize = (int)Math.ceil((double)defFont.getSize() * realScale);
                    } else {
                        img = comps[i].createImage(compDefSize.width, compDefSize.height);
                        comps[i].print(img.getGraphics());
                    }
                    comps[i].setSize((int)Math.ceil((double)compDefSize.width * realScale), (int)Math.ceil((double)compDefSize.height * realScale));
                } else if (comps[i] instanceof JLabel || comps[i] instanceof JTextArea) {
                    String string = label = comps[i] instanceof JLabel ? ((JLabel)comps[i]).getText() : ((JTextArea)comps[i]).getText();
                    if (label != null) {
                        defFont = comps[i] instanceof JLabel ? ((JLabel)comps[i]).getFont() : ((JTextArea)comps[i]).getFont();
                        fontSize = (int)Math.floor((double)defFont.getSize() * realScale);
                        comps[i].setFont(defFont.deriveFont((float)fontSize));
                    }
                    comps[i].setSize((int)Math.ceil((double)compDefSize.width * realScale), (int)Math.ceil((double)compDefSize.height * realScale));
                } else if (comps[i] instanceof JScrollPane) {
                    comps[i].invalidate();
                    comps[i].setSize((int)Math.ceil((double)compDefSize.width * realScale), (int)Math.ceil((double)compDefSize.height * realScale));
                }
                int a = (int)Math.ceil((double)p.x * realScale) + offset.x;
                int b = (int)Math.ceil((double)p.y * realScale) + offset.y;
                if (!(comps[i] instanceof MolButton || (comps[i] instanceof JLabel || comps[i] instanceof JTextArea) && label != null)) {
                    g.translate(a, b);
                    comps[i].print(g);
                    comps[i].setSize(compDefSize);
                    g.translate(-a, -b);
                } else if (label != null) {
                    d0 = comps[i].getSize();
                    Color defColor = g.getColor();
                    g.setClip(a, b, d0.width, d0.height);
                    g.setColor(Color.black);
                    g.setFont(defFont.deriveFont((float)fontSize));
                    if (comps[i] instanceof JTextArea) {
                        StringTokenizer textrows = new StringTokenizer(label, "\n");
                        b += fontSize;
                        while (textrows.hasMoreTokens()) {
                            label = textrows.nextToken();
                            g.drawString(label, a, b);
                            b += fontSize;
                        }
                    } else {
                        g.drawString(label, a, b + fontSize);
                    }
                    g.setClip(fullrect);
                    g.setColor(defColor);
                } else {
                    d0 = comps[i].getSize();
                    g.setClip(a, b, d0.width, d0.height);
                    g.drawImage(img, a, b, d0.width, d0.height, null);
                    img.flush();
                    g.setClip(fullrect);
                }
                if (label != null) {
                    comps[i].setFont(defFont);
                }
                comps[i].setSize(compDefSize);
            }
        }
    }
}

