/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.win.emf;

import chemaxon.marvin.modules.win.emf.EMFExporter;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;

public class WinEMFExporter
implements EMFExporter {
    private static final String PROGID = "CXNEmfExporter.EmfExporter";
    private boolean usable = true;
    private Dispatch obj = null;
    private String fmt = null;
    private String mol = null;
    private String param = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] exportToEMFBinary() {
        this.ensureDispatch();
        if (this.isUsable()) {
            Variant v = null;
            try {
                this.prepareDispatch();
                v = Dispatch.call((Dispatch)this.obj, (String)"exportToEMFBinary");
                if (v != null && !v.isNull()) {
                    byte[] byArray = v.toSafeArray().toByteArray();
                    return byArray;
                }
            }
            catch (Throwable e) {
                this.usable = false;
                this.param = null;
                this.mol = null;
                this.fmt = null;
            }
            finally {
                if (v != null) {
                    v.safeRelease();
                    v = null;
                }
            }
        }
        return new byte[0];
    }

    @Override
    public void exportToFile(String fileName) {
        this.ensureDispatch();
        if (this.isUsable()) {
            try {
                this.prepareDispatch();
                Dispatch.call((Dispatch)this.obj, (String)"exportToFile", (Object)fileName);
            }
            catch (Throwable e) {
                this.usable = false;
                this.param = null;
                this.mol = null;
                this.fmt = null;
            }
        }
    }

    @Override
    public boolean isUsable() {
        return this.usable;
    }

    @Override
    public void release() {
        if (this.obj != null) {
            this.obj.safeRelease();
            this.obj = null;
        }
    }

    @Override
    public void setFormat(String format2) {
        this.fmt = format2;
    }

    @Override
    public void setMolecule(String molStr) {
        this.mol = molStr;
    }

    @Override
    public void setParams(String params) {
        this.param = params;
    }

    private void ensureDispatch() {
        if (this.obj == null && this.isUsable()) {
            try {
                this.obj = new Dispatch(PROGID);
            }
            catch (Throwable e) {
                this.usable = false;
            }
        }
    }

    private void prepareDispatch() {
        if (this.isUsable()) {
            Dispatch.put((Dispatch)this.obj, (String)"format", (Object)this.fmt);
            Dispatch.put((Dispatch)this.obj, (String)"molecule", (Object)this.mol);
            Dispatch.put((Dispatch)this.obj, (String)"params", (Object)this.param);
        }
    }
}

