/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.win.ole;

import chemaxon.marvin.modules.win.ole.OLEDocument;
import com.jacob.com.Dispatch;
import com.jacob.com.SafeArray;
import com.jacob.com.Variant;

public class WinOLEDocument
implements OLEDocument {
    private static final String PROGID = "MarvinOLE.Document";
    private boolean usable = true;
    private String emfData = null;
    private byte[] emfStream = null;
    private String mrvStr = null;
    private String molStr = null;

    @Override
    public boolean isUsable() {
        return this.usable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String oleFromClipboard() {
        Variant v = null;
        Dispatch obj = null;
        String retval = null;
        try {
            obj = new Dispatch(PROGID);
            v = Dispatch.call((Dispatch)obj, (String)"oleFromClipboard");
            if (v != null && !v.isNull()) {
                retval = v.getString();
            }
        }
        catch (Throwable ex) {
            this.usable = false;
        }
        finally {
            if (v != null) {
                v.safeRelease();
                v = null;
            }
            if (obj != null) {
                obj.safeRelease();
                obj = null;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void oleToClipboard() {
        Dispatch obj = null;
        Variant v = null;
        SafeArray ar = null;
        try {
            obj = new Dispatch(PROGID);
            if (this.emfStream != null) {
                ar = new SafeArray(17, this.emfStream.length);
                ar.fromByteArray(this.emfStream);
                v = new Variant();
                v.putSafeArray(ar);
                Dispatch.call((Dispatch)obj, (String)"setEMFPictureStream", (Object)ar);
            } else {
                Dispatch.call((Dispatch)obj, (String)"setEMFDatas", (Object)this.emfData);
            }
            Dispatch.call((Dispatch)obj, (String)"setMOLData", (Object)this.molStr);
            Dispatch.call((Dispatch)obj, (String)"setMrvData", (Object)this.mrvStr);
            Dispatch.call((Dispatch)obj, (String)"oleToClipboard");
        }
        catch (Throwable ex) {
            this.usable = false;
        }
        finally {
            if (ar != null) {
                ar.safeRelease();
            }
            if (v != null) {
                v.safeRelease();
            }
            if (obj != null) {
                obj.safeRelease();
                obj = null;
            }
            this.mrvStr = null;
            this.molStr = null;
            this.emfData = null;
            this.emfStream = null;
        }
    }

    @Override
    public void setEMFDatas(String imgData) {
        this.emfData = imgData;
    }

    @Override
    public void setEMFPictureStream(byte[] imgStream) {
        this.emfStream = imgStream;
    }

    @Override
    public void setMOLData(String molStr) {
        this.molStr = molStr;
    }

    @Override
    public void setMrvData(String mrvStr) {
        this.mrvStr = mrvStr;
    }
}

