/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal;

import chemaxon.marvin.paint.DispOptConsts;
import chemaxon.marvin.paint.internal.ColorCollection;
import chemaxon.marvin.paint.internal.Shades;
import chemaxon.marvin.paint.internal.util.GraphicsUtil;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.graphics.MFont;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MolPainterCommon
implements DispOptConsts,
Serializable {
    private static final long serialVersionUID = 9050050555856708244L;
    public static final Font DEFAULT_BASE_FONT;
    private static final Font DEFAULT_BASE_BOLD_FONT;
    private static final Font DEFAULT_BASE_ITALIC_FONT;
    private static final Font DEFAULT_BASE_SMALL_FONT;
    private static final Font DEFAULT_BASE_LABEL_FONT;
    private static final Font DEFAULT_BASE_BIG_BOLD_FONT;
    public static final int BASE_FONT_SIZE = 12;
    static final int BASE_SMALL_FONT_SIZE = 10;
    static final int BASE_LABEL_FONT_SIZE = 10;
    public static final int BASE_BIG_FONT_SIZE = 18;
    public static final double DEFAULT_BOND_SPACING = 0.18;
    public static final double DEFAULT_WIRE_THICKNESS = 0.064;
    public static final double DEFAULT_STICK_THICKNESS = 0.1;
    public static final double DEFAULT_BALL_RADIUS = 0.5;
    public static final int DEFAULT_COLOR_SCHEME = 64;
    public static final int NO_FOG = 0;
    public static final int WEAK_FOG = 33;
    public static final int MEDIUM_FOG = 66;
    public static final int STRONG_FOG = 100;
    private Font baseFont;
    private Font baseBoldFont;
    private Font baseItalicFont;
    private Font baseSmallFont;
    private Font baseLabelFont;
    private Font baseBigBoldFont;
    Color[][] atomSetColors;
    Color[][] bondSetColors;
    Map<Color, ColorCollection> colorCollectionMap;
    private Color multipageMarginColor;
    private boolean errorVisible = false;
    private boolean valenceErrorVisible = true;
    private Font[] atomSetFonts;
    private double[] bondSetLineThickness;
    private transient MarvinModule threedim = null;
    private double bondSpacing = 0.18;
    private double ballRadius = 0.5;
    private double wireThickness = 0.064;
    private double stickThickness = 0.1;
    private int fogFactor = 66;
    private boolean attachmentPointsVisible = true;
    private boolean onButton = false;
    private Color[] extraLabelSetColors;
    private boolean valenceErrorVisibleInView = false;
    List<MolAtom> tmpAttachpts = new ArrayList<MolAtom>();
    DPoint3[] tmpPoints = new DPoint3[5];
    double[] tmpBondWeights = new double[3];
    private int dispopts = 343933270;
    private int dispoptsExt = 192;
    public long invisibleSets = 0L;

    public MolPainterCommon() {
        this.baseFont = DEFAULT_BASE_FONT;
        this.baseBoldFont = DEFAULT_BASE_BOLD_FONT;
        this.baseItalicFont = DEFAULT_BASE_ITALIC_FONT;
        this.baseSmallFont = DEFAULT_BASE_SMALL_FONT;
        this.baseLabelFont = DEFAULT_BASE_LABEL_FONT;
        this.baseBigBoldFont = DEFAULT_BASE_BIG_BOLD_FONT;
        this.atomSetFonts = new Font[64];
        this.bondSetLineThickness = new double[64];
        for (int i = 0; i < this.tmpPoints.length; ++i) {
            this.tmpPoints[i] = new DPoint3();
        }
        this.atomSetColors = ColorCollection.ALL_ATOMSET_COLORS;
        this.bondSetColors = ColorCollection.ALL_BONDSET_COLORS;
        this.multipageMarginColor = Color.lightGray;
        this.colorCollectionMap = new HashMap<Color, ColorCollection>();
    }

    public MolPainterCommon(MolPainterCommon common) {
        int i;
        this.baseFont = common.baseFont;
        this.baseBoldFont = common.baseBoldFont;
        this.baseItalicFont = common.baseItalicFont;
        this.baseSmallFont = common.baseSmallFont;
        this.baseLabelFont = common.baseLabelFont;
        this.baseBigBoldFont = common.baseBigBoldFont;
        this.atomSetFonts = new Font[common.atomSetFonts.length];
        this.bondSetLineThickness = new double[common.bondSetLineThickness.length];
        System.arraycopy(common.bondSetLineThickness, 0, this.bondSetLineThickness, 0, common.bondSetLineThickness.length);
        this.atomSetColors = new Color[common.atomSetColors.length][];
        for (i = 0; i < common.atomSetColors.length; ++i) {
            this.atomSetColors[i] = new Color[common.atomSetColors[i].length];
            System.arraycopy(common.atomSetColors[i], 0, this.atomSetColors[i], 0, common.atomSetColors[i].length);
        }
        this.bondSetColors = new Color[common.bondSetColors.length][];
        for (i = 0; i < common.bondSetColors.length; ++i) {
            this.bondSetColors[i] = new Color[common.bondSetColors[i].length];
            System.arraycopy(common.bondSetColors[i], 0, this.bondSetColors[i], 0, common.bondSetColors[i].length);
        }
        for (i = 0; i < common.tmpPoints.length; ++i) {
            this.tmpPoints[i] = new DPoint3(common.tmpPoints[i]);
        }
        this.multipageMarginColor = common.multipageMarginColor;
        this.colorCollectionMap = new HashMap<Color, ColorCollection>();
        for (Color key : common.colorCollectionMap.keySet()) {
            ColorCollection colors = common.colorCollectionMap.get(key);
            this.colorCollectionMap.put(key, colors);
        }
    }

    public Object clone() {
        return new MolPainterCommon(this);
    }

    public Color getAtomSetColor(int id, MDocument doc, ColorCollection colors) {
        Color c = null;
        if (doc != null) {
            if (doc.getAtomSetColorMode(id) == 2) {
                return null;
            }
            c = doc.getAtomSetColor(id);
        }
        int t = colors.isLight() ? 1 : 0;
        return c != null ? c : this.atomSetColors[t][id % this.atomSetColors[t].length];
    }

    public Font getAtomSetFont(int id, MDocument doc) {
        MFont f = null;
        if (doc != null) {
            f = doc.getAtomSetFont(id);
        }
        return f != null ? f.getAWTFont() : this.atomSetFonts[id % this.atomSetFonts.length];
    }

    public synchronized void setAtomSetFont(int id, Font font) {
        Font[] fonts = this.atomSetFonts;
        Font[] fonts2 = new Font[fonts.length];
        System.arraycopy(fonts, 0, fonts2, 0, fonts2.length);
        fonts = fonts2;
        this.atomSetFonts = fonts2;
        fonts[id] = font;
    }

    public double getBondSetLineThickness(int id, MDocument doc) {
        double lt = 0.0;
        if (doc != null) {
            lt = doc.getBondSetThickness(id);
        }
        return lt != 0.0 ? lt : this.bondSetLineThickness[id % this.bondSetLineThickness.length];
    }

    public synchronized void setBondSetLineThickness(int id, double lt) {
        double[] t = this.bondSetLineThickness;
        double[] t2 = new double[t.length];
        System.arraycopy(t, 0, t2, 0, t2.length);
        t = t2;
        this.bondSetLineThickness = t2;
        t[id] = lt;
    }

    public boolean setAtomSetColor(int id, Color color) {
        if (this.atomSetColors == ColorCollection.ALL_ATOMSET_COLORS) {
            int n = this.bondSetColors[0].length;
            Color[][] arr2 = new Color[2][n];
            System.arraycopy(this.atomSetColors[0], 0, arr2[0], 0, n);
            System.arraycopy(this.atomSetColors[1], 0, arr2[1], 0, n);
            this.atomSetColors = arr2;
        }
        boolean changed = this.isChanged(color, id);
        this.atomSetColors[0][id] = color;
        this.atomSetColors[1][id] = color;
        return changed;
    }

    private boolean isChanged(Color color, int id) {
        return (this.atomSetColors[0][id] != null ? !this.atomSetColors[0][id].equals(color) : color != null) || (this.atomSetColors[1][id] == null ? color != null : !this.atomSetColors[1][id].equals(color));
    }

    public boolean setBondSetColor(int id, Color color) {
        if (this.bondSetColors == ColorCollection.ALL_BONDSET_COLORS) {
            int n = this.bondSetColors[0].length;
            Color[][] arr2 = new Color[2][n];
            System.arraycopy(this.bondSetColors[0], 0, arr2[0], 0, n);
            System.arraycopy(this.bondSetColors[1], 0, arr2[1], 0, n);
            this.bondSetColors = arr2;
        }
        boolean changed = this.isChanged(color, id);
        this.bondSetColors[0][id] = color;
        this.bondSetColors[1][id] = color;
        return changed;
    }

    public Color getBondSetColor(int id, MDocument doc, ColorCollection colors) {
        Color c = null;
        if (doc != null) {
            if (doc.getBondSetColorMode(id) == 2) {
                return null;
            }
            c = doc.getBondSetColor(id);
        }
        int t = colors.isLight() ? 1 : 0;
        return c != null ? c : this.bondSetColors[t][id % this.bondSetColors.length];
    }

    public synchronized void setExtraLabelSetColors(int id, Color color) {
        Color[] c = this.extraLabelSetColors;
        c[id] = color;
    }

    public Color getColor(MolAtom a, MDocument doc, ColorCollection colors) {
        int seq;
        Color c;
        if (a == null) {
            return colors.elemColors[0];
        }
        if (this.isSetColoringEnabled() && (c = this.getAtomSetColor(seq = a.getSetSeq(), doc, colors)) != null) {
            return c;
        }
        int scheme = this.dispopts & 0xC0;
        if (scheme == 64) {
            return colors.getElemColor(a.getAtno());
        }
        if (scheme == 128) {
            return colors.getResidueTypeColor(a.getResidueType());
        }
        if (scheme == 192) {
            return colors.getResidueSeqColor(a.getResidueSeq());
        }
        return colors.elemColors[0];
    }

    public Shades getShades(MolAtom a, MDocument doc, ColorCollection colors) {
        return colors.getShades(this.getColor(a, doc, colors));
    }

    public Shades getShades(MolBond b, MDocument doc, ColorCollection colors) {
        int seq;
        Color c;
        if (this.isSetColoringEnabled() && (c = this.getBondSetColor(seq = b.getSetSeq(), doc, colors)) != null) {
            return colors.getShades(c);
        }
        if (b == null) {
            return colors.getShades(colors.elemColors[0]);
        }
        return this.getShades(b.getAtom1(), doc, colors);
    }

    public void fillUnsetSetPaletteInDoc(Molecule mol, Color bg) {
        int cmode;
        Color c;
        int i;
        MDocument doc = mol.getDocument();
        if (doc == null) {
            if (mol.hasAtomSet() || mol.hasBondSet()) {
                doc = new MDocument(mol);
            } else {
                return;
            }
        }
        int t = ColorCollection.isLight(bg) ? 1 : 0;
        for (i = 0; i < this.atomSetColors.length; ++i) {
            c = this.atomSetColors[t][i];
            cmode = doc.getAtomSetColorMode(i);
            if (c == null || cmode != 0) continue;
            doc.setAtomSetRGB(i, c.getRGB() & 0xFFFFFF);
        }
        for (i = 0; i < this.bondSetColors.length; ++i) {
            c = this.bondSetColors[t][i];
            cmode = doc.getBondSetColorMode(i);
            if (c == null || cmode != 0) continue;
            doc.setBondSetRGB(i, c.getRGB() & 0xFFFFFF);
        }
    }

    public int getRenderingStyle() {
        return this.dispopts & 0xE0000;
    }

    public boolean isErrorVisible() {
        return this.errorVisible;
    }

    public void setErrorVisible(boolean c) {
        this.errorVisible = c;
    }

    public void setOnButton(boolean v) {
        this.onButton = v;
    }

    public boolean isOnButton() {
        return this.onButton;
    }

    public double getBondSpacing() {
        return this.bondSpacing;
    }

    public void setBaseFont(Font f) {
        String name = f.getFamily();
        this.baseFont = new Font(name, 0, 12);
        this.baseBoldFont = new Font(name, 1, 12);
        this.baseItalicFont = new Font(name, 2, 12);
        this.baseSmallFont = new Font(name, 0, 10);
        this.baseLabelFont = new Font(name, 0, 10);
        this.baseBigBoldFont = new Font(name, 1, 18);
    }

    public void setBaseFont(Font f, boolean withBaseFont) {
        if (withBaseFont) {
            this.setBaseFont(f);
        } else {
            String name = f.getFamily();
            int type = f.getStyle();
            int size = f.getSize();
            this.baseFont = new Font(name, type, size);
            this.baseBoldFont = new Font(name, 1, size);
            this.baseItalicFont = new Font(name, 2, size);
            this.baseSmallFont = new Font(name, type, (int)((double)size / 1.3));
            this.baseLabelFont = new Font(name, type, (int)((double)size / 1.3));
            this.baseBigBoldFont = new Font(name, 1, (int)((double)size * 1.5));
        }
    }

    public Font getBaseFont() {
        return this.baseFont;
    }

    public Font getBaseBoldFont() {
        return this.baseBoldFont;
    }

    public Font getBaseItalicFont() {
        return this.baseItalicFont;
    }

    public Font getBaseSmallFont() {
        return this.baseSmallFont;
    }

    public Font getBaseLabelFont() {
        return this.baseLabelFont;
    }

    public Font getBaseBigBoldFont() {
        return this.baseBigBoldFont;
    }

    public void setBondSpacing(double w) {
        this.bondSpacing = w;
    }

    public double getWireThickness() {
        return this.wireThickness;
    }

    public void setWireThickness(double w) {
        this.wireThickness = w;
    }

    public double getStickThickness() {
        return this.stickThickness;
    }

    public void setStickThickness(double w) {
        this.stickThickness = w;
    }

    public double getBallRadius() {
        return this.ballRadius;
    }

    public void setBallRadius(double r) {
        this.ballRadius = r;
    }

    public int getDispopts() {
        return this.dispopts;
    }

    public void setDispopts(int f) {
        this.dispopts = f;
    }

    public synchronized void setDispopts(int f, int mask) {
        this.setDispopts(this.dispopts & ~mask | f & mask);
    }

    public int getDispoptsExt() {
        return this.dispoptsExt;
    }

    public void setDispoptsExt(int dispoptsExt) {
        this.dispoptsExt = dispoptsExt;
    }

    public void setDispoptsExt(int dispoptsExt, int mask) {
        this.setDispoptsExt(dispoptsExt & ~mask | dispoptsExt & mask);
    }

    public boolean isAtomSymbolsVisible3D() {
        return (this.dispopts & 0x400) != 0;
    }

    public boolean isImplicitHEnabled() {
        int opts = this.dispopts;
        return (opts & 0xE0000) <= 262144;
    }

    public boolean isImplicitHEnabledWhenCarbon() {
        int opts = this.dispopts;
        return (opts & 0x30000000) > 0;
    }

    public String getImplicitH() {
        return IMPLICITH_LEVELS[this.dispopts & 3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImplicitH(String s) {
        int i = MolPainterCommon.getImplicitHFlagsOf(s);
        MolPainterCommon molPainterCommon = this;
        synchronized (molPainterCommon) {
            this.dispopts = this.dispopts & 0xFFFFFFFC | i;
        }
    }

    public String getColorScheme() {
        return COLOR_SCHEMES[(this.dispopts & 0xC0) >> 6];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorScheme(String s) {
        for (int k = COLOR_SCHEMES.length - 1; k >= 0; --k) {
            if (!s.equals(COLOR_SCHEMES[k])) continue;
            MolPainterCommon molPainterCommon = this;
            synchronized (molPainterCommon) {
                this.dispopts = this.dispopts & 0xFFFFFF3F | k << 6;
            }
            return;
        }
        if (!s.equals("atomset")) {
            throw new IllegalArgumentException("setColorScheme(\"" + s + "\"): bad argument");
        }
        this.dispopts = this.dispopts & 0xFFFFFF3F | 0x100;
    }

    public boolean isSetColoringEnabled() {
        return (this.dispopts & 0x100) != 0;
    }

    public synchronized void setSetColoringEnabled(boolean v) {
        this.dispopts = v ? (this.dispopts |= 0x100) : (this.dispopts &= 0xFFFFFEFF);
    }

    public boolean isAbsLabelVisible() {
        return (this.dispopts & 0x2000000) != 0;
    }

    public synchronized void setAbsLabelVisible(boolean v) {
        this.dispopts = v ? (this.dispopts |= 0x2000000) : (this.dispopts &= 0xFDFFFFFF);
    }

    public boolean isRLogicVisible() {
        return (this.dispoptsExt & 0x10) != 0;
    }

    public synchronized void setRLogicVisible(boolean v) {
        this.dispoptsExt = v ? (this.dispoptsExt |= 0x10) : (this.dispoptsExt &= 0xFFFFFFEF);
    }

    public String getRendering() {
        return RENDERING_STYLES[(this.dispopts & 0xE0000) >> 17];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRendering(String s) {
        int f = MolPainterCommon.getRenderingFlagsOf(s);
        MolPainterCommon molPainterCommon = this;
        synchronized (molPainterCommon) {
            this.dispopts = this.dispopts & 0xFFF1FFFF | f;
        }
    }

    public int getDispQuality() {
        return (this.dispopts & 0x800000) >> 23;
    }

    public synchronized void setDispQuality(int k) {
        this.dispopts = this.dispopts & 0xFF7FFFFF | k << 23;
    }

    public synchronized String getDownWedge() {
        return DOWNWEDGE_MODES[(this.dispopts & 0x100000) >> 20];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDownWedge(String s) {
        int k;
        for (k = DOWNWEDGE_MODES.length - 1; k > 0 && !s.equals(DOWNWEDGE_MODES[k]); --k) {
        }
        MolPainterCommon molPainterCommon = this;
        synchronized (molPainterCommon) {
            this.dispopts = this.dispopts & 0xFFEFFFFF | k << 20;
        }
    }

    public boolean isValenceErrorVisible() {
        return this.valenceErrorVisible;
    }

    public void setValenceErrorVisible(boolean v) {
        this.valenceErrorVisible = v;
    }

    public boolean isValenceErrorVisibleInView() {
        return this.valenceErrorVisibleInView;
    }

    public void setValenceErrorVisibleInView(boolean v) {
        this.valenceErrorVisibleInView = v;
    }

    public boolean isAtomNumbersVisible() {
        return (this.dispopts & 0x800) != 0;
    }

    public synchronized void setAtomNumbersVisible(boolean v) {
        this.dispopts = v ? this.dispopts | 0x800 : this.dispopts & 0xFFFFF7FF;
    }

    public boolean isAtomPropertiesVisible() {
        return (this.dispoptsExt & 8) != 0;
    }

    public synchronized void setAtomPropertiesVisible(boolean v) {
        this.dispoptsExt = v ? this.dispoptsExt | 8 : this.dispoptsExt & 0xFFFFFFF7;
    }

    public boolean isAtomMappingVisible() {
        return (this.dispopts & 0x1000) != 0;
    }

    public synchronized void setAtomMappingVisible(boolean v) {
        this.dispopts = v ? this.dispopts | 0x1000 : this.dispopts & 0xFFFFEFFF;
    }

    public boolean areLonePairsVisible() {
        return (this.dispopts & 0x1000000) != 0;
    }

    public boolean isBondLengthVisible() {
        return (this.dispopts & 0x2000) != 0;
    }

    public synchronized void setLonePairsVisible(boolean v) {
        this.dispopts = v ? this.dispopts | 0x1000000 : this.dispopts & 0xFEFFFFFF;
    }

    public void setBondLengthVisible(boolean v) {
        this.dispopts = v ? this.dispopts | 0x2000 : this.dispopts & 0xFFFFDFFF;
    }

    public boolean areLonePairsAutoCalc() {
        return (this.dispopts & 0x8000000) != 0;
    }

    public synchronized void setLonePairsAutoCalc(boolean v) {
        this.dispopts = v ? this.dispopts | 0x8000000 : this.dispopts & 0xF7FFFFFF;
    }

    public boolean isGrinvVisible() {
        return (this.dispopts & 0x200) != 0;
    }

    public synchronized void setGrinvVisible(boolean v) {
        this.dispopts = v ? this.dispopts | 0x200 : this.dispopts & 0xFFFFFDFF;
    }

    public String getAnyBond() {
        return ANYBOND_STYLES[(this.dispopts & 0x600000) >> 21];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnyBond(String s) {
        int f = MolPainterCommon.getAnyBondFlagsOf(s);
        MolPainterCommon molPainterCommon = this;
        synchronized (molPainterCommon) {
            this.dispopts = this.dispopts & 0xFF9FFFFF | f;
        }
    }

    public String getCarbonVisibility() {
        return CARBON_VIS_STYLES[(this.dispopts & 0x30000000) >> 28];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCarbonVisibility(String s) {
        int f = MolPainterCommon.getCarbonVisibilityFlagsOf(s);
        MolPainterCommon molPainterCommon = this;
        synchronized (molPainterCommon) {
            this.dispopts = this.dispopts & 0xCFFFFFFF | f;
        }
    }

    public boolean isSetVisible(int id) {
        return (this.invisibleSets & (long)(1 << id)) == 0L;
    }

    public int getChiralitySupport() {
        return (this.dispopts & 0xC000) >> 14;
    }

    public synchronized void setChiralitySupport(int l) {
        this.dispopts = this.dispopts & 0xFFFF3FFF | l << 14;
    }

    public boolean isEzVisible() {
        return (this.dispopts & 0x10000) != 0;
    }

    public void setEzVisible(boolean value) {
        this.dispopts = value ? this.dispopts | 0x10000 : this.dispopts & 0xFFFEFFFF;
    }

    public boolean isRgDefinitionVisible() {
        return (this.dispopts & 0x4000000) != 0;
    }

    public void setRgDefinitionVisible(boolean v) {
        this.dispopts = v ? this.dispopts | 0x4000000 : this.dispopts & 0xFBFFFFFF;
    }

    public boolean areAttachmentPointsVisible() {
        return this.attachmentPointsVisible;
    }

    public void setAttachmentPointsVisible(boolean v) {
        this.attachmentPointsVisible = v;
    }

    synchronized void zsort(MoleculeGraph mol, DPoint3[] screenCoords, int nobjs, Object[] objs, CTransform3D tscr) {
        if (this.threedim == null) {
            this.threedim = (MarvinModule)MarvinModule.load("Threedim", null);
        }
        Object[] args = new Object[]{mol, screenCoords, new Integer(nobjs), objs, tscr};
        this.threedim.modfunc(args);
    }

    public void setAntialiasing(Graphics2D g, boolean v) {
        int q = (this.dispopts & 0x800000) >> 23;
        GraphicsUtil.setAntialias(g, v &= q > 0);
    }

    public static int getImplicitHFlagsOf(String s) throws IllegalArgumentException {
        String[] strs = IMPLICITH_LEVELS;
        for (int i = 0; i < strs.length; ++i) {
            if (!strs[i].equals(s)) continue;
            return i;
        }
        throw new IllegalArgumentException("Illegal implicitH argument \"" + s + "\"");
    }

    public static int getAnyBondFlagsOf(String s) throws IllegalArgumentException {
        String[] strs = ANYBOND_STYLES;
        for (int i = 0; i < strs.length; ++i) {
            if (!strs[i].equals(s)) continue;
            return i << 21;
        }
        throw new IllegalArgumentException("Illegal anyBond style \"" + s + "\"");
    }

    public static int getCarbonVisibilityFlagsOf(String s) throws IllegalArgumentException {
        String[] strs = CARBON_VIS_STYLES;
        for (int i = 0; i < strs.length; ++i) {
            if (!strs[i].equals(s)) continue;
            return i << 28;
        }
        throw new IllegalArgumentException("Illegal carbonVisibility style \"" + s + "\"");
    }

    public static int getRenderingFlagsOf(String s) throws IllegalArgumentException {
        for (int i = RENDERING_STYLES.length - 1; i >= 0; --i) {
            if (!s.equals(RENDERING_STYLES[i])) continue;
            return i << 17;
        }
        throw new IllegalArgumentException("Illegal rendering mode \"" + s + "\"");
    }

    public static int getDownWedgeOption(Object name) {
        for (int i = 0; i < DOWNWEDGE_MODES.length; ++i) {
            if (!DOWNWEDGE_MODES[i].equals(name)) continue;
            return i << 20 & 0x100000;
        }
        return 0;
    }

    public void clearSetPalette() {
        int i;
        for (i = 0; i < this.atomSetFonts.length; ++i) {
            this.atomSetFonts[i] = null;
        }
        for (i = 0; i < this.bondSetLineThickness.length; ++i) {
            this.bondSetLineThickness[i] = 0.0;
        }
        this.atomSetColors = ColorCollection.ALL_ATOMSET_COLORS;
        this.bondSetColors = ColorCollection.ALL_BONDSET_COLORS;
    }

    public Color getMultipageMarginColor() {
        return this.multipageMarginColor;
    }

    public void setMultipageMarginColor(Color multipageMarginColor) {
        this.multipageMarginColor = multipageMarginColor;
    }

    ColorCollection reuseColorCollection(Color bg) {
        ColorCollection colors = this.colorCollectionMap.get(bg);
        if (colors == null) {
            colors = new ColorCollection(bg);
            this.colorCollectionMap.put(bg, colors);
        }
        colors.registerPainter();
        return colors;
    }

    void freeColorCollection(ColorCollection colors) {
        colors.unregisterPainter();
        if (!colors.isUsed()) {
            this.colorCollectionMap.remove(colors.getBackground());
        }
    }

    public static int getLigandOrderVisibilityFlagsOf(String s) throws IllegalArgumentException {
        for (int i = 0; i < LIGAND_ORDER_STYLES.length; ++i) {
            if (!LIGAND_ORDER_STYLES[i].equals(s)) continue;
            return i;
        }
        throw new IllegalArgumentException("Illegal ligandOrderVisibility style \"" + s + "\"");
    }

    public String getLigandOrderVisibility() {
        return LIGAND_ORDER_STYLES[this.dispoptsExt & 3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLigandOrderVisibility(String s) {
        int f = MolPainterCommon.getLigandOrderVisibilityFlagsOf(s);
        MolPainterCommon molPainterCommon = this;
        synchronized (molPainterCommon) {
            this.dispoptsExt = this.dispoptsExt & 0xFFFFFFFC | f;
        }
    }

    public boolean isAutomaticFogEnabled() {
        return false;
    }

    public void setAutomaticFogEnabled(boolean v) {
        this.dispoptsExt = v ? this.dispoptsExt | 0x20 : this.dispoptsExt & 0xFFFFFFDF;
    }

    public boolean isDepthCueEnabled() {
        return (this.dispoptsExt & 0x20) != 0;
    }

    public void setDepthCueEnabled(boolean v) {
        this.setAutomaticFogEnabled(v);
        if (!v) {
            this.setFogFactor(0);
        }
    }

    public int getFogFactor() {
        return this.fogFactor;
    }

    public void setFogFactor(int factor) {
        this.fogFactor = factor;
    }

    public boolean isValencePropertyVisible() {
        return (this.dispoptsExt & 0x40) != 0;
    }

    public synchronized void setValencePropertyVisible(boolean v) {
        this.dispoptsExt = v ? this.dispoptsExt | 0x40 : this.dispoptsExt & 0xFFFFFFBF;
    }

    public boolean isLigandErrorVisible() {
        return (this.dispoptsExt & 0x80) != 0;
    }

    public synchronized void setLigandErrorVisible(boolean v) {
        this.dispoptsExt = v ? this.dispoptsExt | 0x80 : this.dispoptsExt & 0xFFFFFF7F;
    }

    public synchronized String getCoordinateBondStyle() {
        return COORDINATE_BOND_STYLES[(this.dispoptsExt & 0x200) >> 9];
    }

    public synchronized void setCoordinateBondStyle(String s) {
        int k;
        for (k = COORDINATE_BOND_STYLES.length - 1; k > 0 && !s.equals(COORDINATE_BOND_STYLES[k]); --k) {
        }
        this.dispoptsExt = this.dispoptsExt & 0xFFFFFDFF | k << 9;
    }

    public synchronized String getCoordinateBondStyleAtMulticenter() {
        return COORDINATE_BOND_AT_MULTICENTER_STYLES[(this.dispoptsExt & 0x100) >> 8];
    }

    public synchronized void setCoordinateBondStyleAtMulticenter(String s) {
        int k;
        for (k = COORDINATE_BOND_AT_MULTICENTER_STYLES.length - 1; k > 0 && !s.equals(COORDINATE_BOND_AT_MULTICENTER_STYLES[k]); --k) {
        }
        this.dispoptsExt = this.dispoptsExt & 0xFFFFFEFF | k << 8;
    }

    static {
        String jver = System.getProperty("java.version");
        String f = jver.startsWith("1.0") || jver.equals("1.1.2") ? "Helvetica" : "SansSerif";
        DEFAULT_BASE_FONT = new Font(f, 0, 12);
        DEFAULT_BASE_BOLD_FONT = new Font(f, 1, 12);
        DEFAULT_BASE_ITALIC_FONT = new Font(f, 2, 12);
        DEFAULT_BASE_SMALL_FONT = new Font(f, 0, 10);
        DEFAULT_BASE_LABEL_FONT = new Font(f, 0, 10);
        DEFAULT_BASE_BIG_BOLD_FONT = new Font(f, 1, 18);
    }
}

