/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal.graphics;

import chemaxon.marvin.paint.internal.graphics.MPointPainter;
import chemaxon.marvin.paint.internal.util.GraphicsUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MolAtom;
import chemaxon.struc.graphics.MAtomSetPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;

public class MAtomSetPointPainter
extends MPointPainter {
    @Override
    public void paint(MObject mo, Graphics2D g, CTransform3D t, int f, Color c, Color selc, Color focusc) {
        MAtomSetPoint asp = (MAtomSetPoint)mo;
        MolAtom[] atoms = asp.getAtoms();
        if (atoms.length == 2) {
            double ey;
            double d = 0.2 * t.getScale();
            if ((f & 1) != 0) {
                GraphicsUtil.setAntialias(g, true);
            }
            DPoint3 p1 = atoms[0].getLocation();
            DPoint3 p2 = atoms[1].getLocation();
            t.transform(p1);
            t.transform(p2);
            double x12 = p2.x - p1.x;
            double y12 = p2.y - p1.y;
            double r12 = Math.sqrt(x12 * x12 + y12 * y12);
            double ex = x12 / r12;
            double nx = ey = y12 / r12;
            double ny = -ex;
            GeneralPath gp = new GeneralPath();
            gp.moveTo((float)(p1.x - nx * d), (float)(p1.y - ny * d));
            gp.lineTo((float)(p2.x - nx * d), (float)(p2.y - ny * d));
            gp.lineTo((float)(p2.x + nx * d), (float)(p2.y + ny * d));
            gp.lineTo((float)(p1.x + nx * d), (float)(p1.y + ny * d));
            gp.lineTo((float)(p1.x - nx * d), (float)(p1.y - ny * d));
            Color old = g.getColor();
            Stroke oldstroke = g.getStroke();
            g.setColor(Color.white);
            g.setStroke(new BasicStroke(2.0f, 2, 0));
            g.draw(gp);
            g.setColor(asp.isSelected() ? selc : (c != null ? c : old));
            g.setStroke(new BasicStroke(1.0f, 2, 0));
            g.draw(gp);
            g.setColor(old);
            g.setStroke(oldstroke);
            if ((f & 1) != 0) {
                GraphicsUtil.setAntialias(g, false);
            }
        } else {
            super.paint(asp, g, t, f, c, selc, focusc);
        }
    }
}

