/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal.graphics;

import chemaxon.marvin.paint.internal.LinePainter;
import chemaxon.marvin.paint.internal.graphics.MPolylinePainter;
import chemaxon.marvin.paint.internal.util.GraphicsUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRArrow;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class MRArrowPainter
extends MPolylinePainter {
    @Override
    protected void connect(MPolyline mo, Graphics2D g, CTransform3D t, int i1, int i2, DPoint3 p1, DPoint3 p2, Stroke arrowstroke, double strokew) {
        MRArrow mra = (MRArrow)mo;
        MPoint mp1 = mra.getPoint(i1);
        mp1.getLocation(p1, t);
        MPoint mp2 = mra.getPoint(i2);
        mp2.getLocation(p2, t);
        double[] arw = new double[2];
        double scale = Math.abs(t.getScale());
        double[] skips = null;
        if (mra.getSkip(0) != 0.0 || mra.getSkip(1) != 0.0) {
            skips = new double[2];
            for (int i = 0; i < 2; ++i) {
                skips[i] = mra.getSkip(i) * scale;
            }
        }
        DPoint3 p1orig = p1;
        DPoint3 p2orig = p2;
        double sign = t.determinant2D() > 0.0 ? -1.0 : 1.0;
        double angle = sign * mra.getArcAngle();
        DPoint3[] q1 = new DPoint3[2];
        DPoint3[] q2 = new DPoint3[2];
        double[] angle1 = new double[1];
        double[] ct = new double[2];
        DPoint3[] p12new = this.calcArrowHeads(mra, p1orig, p2orig, scale, angle, q1, q2, arw, angle1, ct);
        angle = angle1[0];
        p1 = p12new[0];
        p2 = p12new[1];
        double[][] tmpx = new double[2][];
        double[][] tmpy = new double[2][];
        Stroke oldstroke = g.getStroke();
        g.setStroke(arrowstroke);
        for (int i = 0; i < 2; ++i) {
            int arf;
            DPoint3 pfront;
            tmpx[i] = new double[4];
            tmpy[i] = new double[4];
            DPoint3 pback = q1 != null ? q1[i] : null;
            DPoint3 dPoint3 = pfront = q2 != null ? q2[i] : null;
            if (skips != null) {
                double d = MRArrowPainter.shiftEndPoint(mra, skips[i], p1orig, p2orig, p1, p2, i, pfront, pback, sign);
                angle -= d;
            }
            if (arw[i] == 0.0) continue;
            if ((mra.getArrowFlags(i) & MPolyline.ARROW_BACK_FLAG) != 0) {
                DPoint3 tmp = pfront;
                pfront = pback;
                pback = tmp;
                arf = this.getMirroredArrowFlags(mra, i);
            } else {
                arf = mra.getArrowFlags(i);
            }
            if (mra.getType() == 3 || mra.getType() == 2) {
                LinePainter.calculateArrowHead(pback, pfront, ct[i], tmpx[i], tmpy[i], arf);
                continue;
            }
            LinePainter.drawArrowHead(g, pback, pfront, ct[i], tmpx[i], tmpy[i], arf);
        }
        BasicStroke stroke = new BasicStroke((float)strokew, 0, 0);
        g.setStroke(stroke);
        if (angle == 0.0) {
            switch (mra.getType()) {
                case 3: {
                    GraphicsUtil.drawLine(g, tmpx[0][1], tmpy[0][1], tmpx[1][2], tmpy[1][2]);
                    GraphicsUtil.drawLine(g, tmpx[0][2], tmpy[0][2], tmpx[1][1], tmpy[1][1]);
                    GraphicsUtil.drawLine(g, tmpx[1][1] + 4.0 * (tmpx[1][1] - tmpx[1][3]), tmpy[1][1] + 4.0 * (tmpy[1][1] - tmpy[1][3]), tmpx[1][1], tmpy[1][1]);
                    GraphicsUtil.drawLine(g, tmpx[0][1] + 4.0 * (tmpx[0][1] - tmpx[0][3]), tmpy[0][1] + 4.0 * (tmpy[0][1] - tmpy[0][3]), tmpx[0][1], tmpy[0][1]);
                    break;
                }
                case 2: {
                    GraphicsUtil.drawLine(g, tmpx[0][1], tmpy[0][1], tmpx[1][2], tmpy[1][2]);
                    GraphicsUtil.drawLine(g, tmpx[0][2], tmpy[0][2], tmpx[1][1], tmpy[1][1]);
                    GraphicsUtil.drawLine(g, tmpx[1][2] + 3.0 * (tmpx[1][2] - tmpx[1][3]), tmpy[1][2] + 3.0 * (tmpy[1][2] - tmpy[1][3]), tmpx[1][3], tmpy[1][3]);
                    GraphicsUtil.drawLine(g, tmpx[1][1] + 3.0 * (tmpx[1][1] - tmpx[1][3]), tmpy[1][1] + 3.0 * (tmpy[1][1] - tmpy[1][3]), tmpx[1][3], tmpy[1][3]);
                    break;
                }
                case 0: 
                case 1: {
                    GraphicsUtil.drawLine(g, p1.x, p1.y, p2.x, p2.y);
                }
            }
        } else {
            GraphicsUtil.drawArc(g, p1, p2, angle);
        }
        g.setStroke(oldstroke);
    }
}

