/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal.util;

import chemaxon.marvin.util.Environment;
import chemaxon.struc.DPoint3;
import chemaxon.struc.graphics.MPolyline;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class GraphicsUtil {
    public static void setAntialias(Graphics2D g, boolean v) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, v ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, v ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    public static Object beginPureStrokeControl(Graphics2D g) {
        RenderingHints rh = g.getRenderingHints();
        if (rh.containsKey(RenderingHints.KEY_STROKE_CONTROL)) {
            Object oldsc = g.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            return oldsc;
        }
        g.addRenderingHints(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
        return g.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
    }

    public static void endPureStrokeControl(Graphics2D g, Object oldsc) {
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldsc);
    }

    public static void drawArc(Graphics2D g, DPoint3 p1, DPoint3 p2, double angle) {
        DPoint3 p0 = MPolyline.getArcCenter(p1, p2, angle);
        double r = p0.distance2D(p1);
        double startAngle = Math.atan2(p0.y - p2.y, p2.x - p0.x);
        g.draw(new Arc2D.Double(p0.x - r, p0.y - r, 2.0 * r, 2.0 * r, startAngle * 180.0 / Math.PI, angle, 0));
    }

    public static void fillPolygon(Graphics2D g, double[] pxs, double[] pys) {
        int n = pxs.length == pys.length ? pxs.length : 0;
        Object oldsc = GraphicsUtil.beginPureStrokeControl(g);
        GeneralPath gp = new GeneralPath();
        gp.moveTo((float)pxs[0], (float)pys[0]);
        for (int i = 1; i < n; ++i) {
            gp.lineTo((float)pxs[i], (float)pys[i]);
        }
        g.fill(gp);
        GraphicsUtil.endPureStrokeControl(g, oldsc);
    }

    public static void drawLine(Graphics2D g, double x1, double y1, double x2, double y2) {
        BasicStroke bstroke;
        float thickness;
        Stroke oldstroke;
        Object aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object oldsc = GraphicsUtil.beginPureStrokeControl(g);
        boolean shortline = (int)x1 == (int)x2 && (int)y1 == (int)y2 || Math.round(x1) == Math.round(x2) && Math.round(y1) == Math.round(y2);
        Stroke stroke = oldstroke = g.getStroke();
        if (aa == RenderingHints.VALUE_ANTIALIAS_OFF && shortline && stroke != null && stroke instanceof BasicStroke && (thickness = (bstroke = (BasicStroke)stroke).getLineWidth()) <= 1.0f) {
            int cap = bstroke.getEndCap();
            int join = bstroke.getLineJoin();
            float miterlimit = bstroke.getMiterLimit();
            float[] dash = bstroke.getDashArray();
            float phase = bstroke.getDashPhase();
            stroke = new BasicStroke(1.000001f, cap, join, miterlimit, dash, phase);
            g.setStroke(stroke);
        }
        if (shortline && Environment.MACOS) {
            try {
                g.fill(stroke.createStrokedShape(new Line2D.Double(x1, y1, x2, y2)));
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        } else {
            g.draw(new Line2D.Double(x1, y1, x2, y2));
        }
        if (stroke != oldstroke) {
            g.setStroke(oldstroke);
        }
        GraphicsUtil.endPureStrokeControl(g, oldsc);
    }

    public static void setColor(Graphics2D g, Color c, Color background, double screenCoordZ, double minZ, double maxZ, double strongness) {
        Color color = c;
        if (strongness != 0.0) {
            color = GraphicsUtil.applyFog(c, background, GraphicsUtil.calcFogFactor(screenCoordZ, minZ, maxZ, strongness));
        }
        g.setColor(color);
    }

    public static double calcFogFactor(double screenCoordZ, double minZ, double maxZ, double strongness) {
        double factor = maxZ - minZ != 0.0 ? (maxZ - screenCoordZ) / (maxZ - minZ) : 0.0;
        return factor * strongness * 0.9;
    }

    public static Color applyFog(Color c, Color bg, double factor) {
        return new Color((int)((1.0 - factor) * (double)c.getRed() + factor * (double)bg.getRed()), (int)((1.0 - factor) * (double)c.getGreen() + factor * (double)bg.getGreen()), (int)((1.0 - factor) * (double)c.getBlue() + factor * (double)bg.getBlue()));
    }
}

