/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal.util.clip;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;

public class QuadTree {
    private Node root;

    public QuadTree(Rectangle2D bounds) {
        this.root = new Node(bounds);
    }

    public void add(Shape shape) {
        this.root.add(new Area(shape));
    }

    public Area calculate(Shape originalClip) {
        return this.root.calculate(new Area(originalClip));
    }

    private static class Node {
        private static final int MAX_SHAPE_COUNT = 16;
        private static final double MIN_SIZE = 10.0;
        private Rectangle2D bounds;
        private Node northEast;
        private Node northWest;
        private Node southWest;
        private Node southEast;
        private Collection<Area> areas;

        public Node(Rectangle2D bounds) {
            this.bounds = bounds;
            this.areas = new ArrayList<Area>();
        }

        public void add(Area area) {
            if (!area.intersects(this.bounds)) {
                return;
            }
            if (this.isLeaf()) {
                this.addToLeaf(area);
            } else {
                this.addToChild(area);
            }
        }

        private void addToLeaf(Area area) {
            this.areas.add(area);
            if (this.areas.size() > 16) {
                this.split();
            }
        }

        private void addToChild(Area area) {
            this.northWest.add(area);
            this.northEast.add(area);
            this.southWest.add(area);
            this.southEast.add(area);
        }

        private void split() {
            if (this.bounds.getWidth() < 10.0 || this.bounds.getHeight() < 10.0) {
                return;
            }
            double h = this.bounds.getHeight() / 2.0;
            double w = this.bounds.getWidth() / 2.0;
            this.northWest = new Node(new Rectangle2D.Double(this.bounds.getX(), this.bounds.getY(), w, h));
            this.northEast = new Node(new Rectangle2D.Double(this.bounds.getX() + w, this.bounds.getY(), w, h));
            this.southWest = new Node(new Rectangle2D.Double(this.bounds.getX(), this.bounds.getY() + h, w, h));
            this.southEast = new Node(new Rectangle2D.Double(this.bounds.getX() + w, this.bounds.getY() + h, w, h));
            for (Area area : this.areas) {
                this.addToChild(area);
            }
            this.areas.clear();
        }

        public Area calculate(Area area) {
            Area localArea = this.intersect(area);
            return this.isLeaf() ? this.calculateShapes(localArea) : this.calculateRegions(localArea);
        }

        private Area calculateRegions(Area area) {
            Area result = new Area();
            result.add(this.northWest.calculate(area));
            result.add(this.northEast.calculate(area));
            result.add(this.southWest.calculate(area));
            result.add(this.southEast.calculate(area));
            return result;
        }

        private Area intersect(Area area) {
            Area result = new Area(area);
            result.intersect(new Area(this.bounds));
            return result;
        }

        private Area calculateShapes(Area area) {
            for (Area shape : this.areas) {
                area.subtract(new Area(shape));
            }
            return area;
        }

        private boolean isLeaf() {
            return this.northEast == null;
        }
    }
}

