/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.PluginMDocSource;
import chemaxon.marvin.util.Environment;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.util.FindCodeBase;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class CalculatorPlugin
implements Licensable {
    public static final String PLUGIN_DIR = "/xjars";
    public static final String PLUGIN_CLASS_KEY = "Plugin-Class";
    private static Hashtable pluginClassLoaderTable = new Hashtable();
    protected static final String CRITICAL_ERROR_MSG = "Inconsistent molecular structure.";
    protected static final String INCORRECT_AROMATIC_NITROGEN_REMARK = "Aromatic nitrogen is not specified correctly.";
    protected static final String INSTABLE_TAUTOMERIC_FORM_REMARK = "Instable tautomeric form.";
    protected static final String COVALENT_HYDRATION_ERROR_REMARK = "Covalent hydration occurred.";
    protected String licenseEnvironment = "";
    public static final int RED = 0xFF0000;
    public static final int BLUE = 255;
    protected static final int CALCRGB_OFF = 32;
    public static final int ATOM = 1;
    public static final int MOLECULE = 2;
    public static final int MOLECULES = 4;
    protected static final Double NAN = new Double(Double.NaN);
    public static final double EPSILON = 0.1;
    private ClassLoader classLoader = null;
    private int dim = -1;
    private Molecule origmol = null;
    private Molecule calcmol = null;
    private boolean om = true;
    private boolean aromatic = false;
    private DecimalFormat df = new DecimalFormat();
    private int precision = 2;
    private int[] atomIndexMap = null;
    private int atomCount = 0;

    public static URL getPluginResource(String path) {
        String cbdir = FindCodeBase.getCodeBaseDir();
        if (Environment.APPLET) {
            try {
                URL cbdirUrl = new URL(cbdir);
                URL u = new URL(cbdirUrl, "plugins/" + path);
                return u;
            }
            catch (MalformedURLException muex) {
                muex.printStackTrace();
            }
        } else if (!Environment.JAVAWEBSTART && cbdir != null && !FindCodeBase.isURL(cbdir)) {
            File cbf = new File(cbdir);
            File f = new File(cbf, "plugins/" + path);
            if (!f.exists()) {
                cbf = cbf.getParentFile();
                f = new File(cbf, "plugins/" + path);
            }
            if (!f.exists()) {
                return null;
            }
            try {
                URL u = f.toURL();
                return u;
            }
            catch (MalformedURLException muex) {
                muex.printStackTrace();
            }
        }
        return null;
    }

    public static String readAttribute(String attribute, String jar) throws PluginException {
        try {
            URL url = CalculatorPlugin.getPluginResource(jar);
            String jarFile = url.getFile();
            Manifest manifest = new JarFile(jarFile).getManifest();
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue(attribute);
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
    }

    public static CalculatorPlugin create(String clname, String jar) throws PluginException {
        URLClassLoader pluginClassLoader;
        Class<?> cl;
        block16: {
            if (clname == null) {
                if (jar == null) {
                    throw new PluginException("No plugin class name and no plugin JAR specified.");
                }
                clname = CalculatorPlugin.readAttribute(PLUGIN_CLASS_KEY, jar);
                if (clname == null) {
                    throw new PluginException("No plugin class name specified.");
                }
            }
            cl = null;
            pluginClassLoader = null;
            try {
                cl = Class.forName(clname);
            }
            catch (ClassNotFoundException e) {
                URL url;
                if (jar == null || (url = CalculatorPlugin.getPluginResource(jar)) == null) break block16;
                boolean hasClassLoader = pluginClassLoaderTable.containsKey(url);
                if (hasClassLoader) {
                    pluginClassLoader = (URLClassLoader)pluginClassLoaderTable.get(url);
                } else {
                    ClassLoader parentClassLoader = CalculatorPlugin.class.getClassLoader();
                    pluginClassLoader = URLClassLoader.newInstance(new URL[]{url}, parentClassLoader);
                }
                try {
                    cl = pluginClassLoader.loadClass(clname);
                    if (!hasClassLoader) {
                        pluginClassLoaderTable.put(url, pluginClassLoader);
                    }
                }
                catch (ClassNotFoundException f) {
                    // empty catch block
                }
            }
        }
        if (cl == null) {
            throw new PluginException("Plugin class not found: " + clname);
        }
        CalculatorPlugin plugin = null;
        try {
            plugin = (CalculatorPlugin)cl.newInstance();
        }
        catch (InstantiationException e) {
            throw new PluginException(e);
        }
        catch (IllegalAccessException e) {
            throw new PluginException(e);
        }
        catch (SecurityException e) {
            throw new PluginException(e);
        }
        catch (ClassCastException e) {
            throw new PluginException(e);
        }
        plugin.classLoader = pluginClassLoader;
        return plugin;
    }

    public final Class loadClass(String clname) throws PluginException {
        Class<?> cl;
        block4: {
            cl = null;
            try {
                cl = Class.forName(clname);
            }
            catch (ClassNotFoundException e) {
                if (this.classLoader == null) break block4;
                try {
                    cl = this.classLoader.loadClass(clname);
                }
                catch (ClassNotFoundException f) {
                    cl = null;
                }
            }
        }
        return cl;
    }

    protected static boolean isRgrouped(Molecule mol) {
        if (mol instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)mol;
            if (rgmol.getRgroupCount() > 0) {
                return true;
            }
            for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
                if (rgmol.getAtom(i).getAtno() != 134) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean containsPseudoAtom(Molecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            if (!mol.getAtom(i).isPseudo()) continue;
            return true;
        }
        return false;
    }

    protected static boolean containsMulticenterSgroup(Molecule mol) {
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            if (mol.getSgroup(i).getType() != 14) continue;
            return true;
        }
        return false;
    }

    protected static boolean containsSRUSgroup(Molecule mol) {
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            if (mol.getSgroup(i).getType() != 2) continue;
            return true;
        }
        return false;
    }

    protected static boolean containsCoordinateBond(MoleculeGraph mol) {
        for (int i = 0; i < mol.getBondCount(); ++i) {
            if (mol.getBond(i).getType() != 9) continue;
            return true;
        }
        return false;
    }

    protected static void dehydrogenize(Molecule mol) {
        mol.implicitizeHydrogens(2047);
    }

    protected static String removeWhitespace(String str) {
        StringBuffer s = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            s.append(c);
        }
        return new String(s);
    }

    public static MDocument getDocument(Molecule structure) {
        MDocument doc = structure.getDocument();
        if (doc == null) {
            doc = new MDocument(structure);
        }
        return doc;
    }

    public CalculatorPlugin() {
        this.setDoublePrecision(this.precision);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed(this.getProductName(), this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    protected final void checkLicense() {
        LicenseHandler.getInstance().checkLicense(this.getProductName(), this.licenseEnvironment);
    }

    public abstract String getProductName();

    protected void checkType(String type, String[] typerange) throws PluginException {
        for (int i = 0; i < typerange.length; ++i) {
            if (!type.equalsIgnoreCase(typerange[i])) continue;
            return;
        }
        throw new PluginException("Invalid type: " + type);
    }

    public final int getDoublePrecision() {
        return this.precision;
    }

    protected final void setDoublePrecision(String pr) {
        this.df.setGroupingUsed(false);
        if (pr != null) {
            try {
                if (!pr.equals("inf")) {
                    int p = Integer.parseInt(pr);
                    this.setDoublePrecision(p, true);
                } else {
                    this.setDoublePrecision(10, false);
                }
            }
            catch (NumberFormatException e) {
                System.err.println(e);
                e.printStackTrace();
            }
        }
    }

    public final void setDoublePrecision(int precision) {
        this.setDoublePrecision(precision, true);
    }

    public final void setDoublePrecision(int precision, boolean pad) {
        this.df.setGroupingUsed(false);
        this.precision = precision;
        if (precision > 0) {
            StringBuffer s = new StringBuffer("###0.");
            char c = pad ? (char)'0' : '#';
            for (int i = 0; i < precision; ++i) {
                s.append(c);
            }
            this.df.applyPattern(new String(s));
        } else {
            this.df.applyPattern("###0");
        }
    }

    public final String format(double x) {
        return Double.isNaN(x) ? "" : this.df.format(x);
    }

    public final String format(double x, int intlen) {
        String result = this.format(x);
        int t = result.indexOf(".");
        if (t == -1) {
            t = result.length();
        }
        StringBuffer s = new StringBuffer();
        for (int i = t; i < intlen; ++i) {
            s.append(' ');
        }
        s.append(result);
        return new String(s);
    }

    public final StringBuffer format(double x, StringBuffer s) {
        return Double.isNaN(x) ? s : this.df.format(x, s, new FieldPosition(0));
    }

    public final String format(double[][] t, int intlen) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < t[0].length; ++i) {
            if (i > 0) {
                b.append("\n");
            }
            b.append(this.format(t[0][i], intlen) + "\t" + this.format(t[1][i], intlen));
        }
        return new String(b);
    }

    public void setProgressMonitor(MProgressMonitor pmon) {
    }

    public final Molecule setMolecule(Molecule mol) throws PluginException {
        return this.setMolecule(mol, true);
    }

    public Molecule setMolecule(Molecule mol, boolean st) throws PluginException {
        return this.setMolecule(mol, st, true);
    }

    public Molecule setMolecule(Molecule mol, boolean st, boolean om) throws PluginException {
        int i;
        this.aromatic = false;
        for (int i2 = 0; !this.aromatic && i2 < mol.getAtomCount(); ++i2) {
            this.aromatic |= mol.getAtom(i2).hasAromaticBond();
        }
        Molecule cmol = mol.cloneMoleculeWithDocument();
        int n = cmol.getAtomCount();
        Vector<MolAtom> v = null;
        if (om) {
            v = new Vector<MolAtom>(n);
            for (i = 0; i < n; ++i) {
                v.addElement(cmol.getAtom(i));
            }
        }
        if (st) {
            cmol = this.createStandardizedMolecule(cmol);
            cmol.clearExtraLabels();
            cmol.setAtomSetSeqs(0);
            cmol.setBondSetSeqs(0);
        }
        if (om) {
            this.atomCount = n;
            this.atomIndexMap = new int[n];
            for (i = 0; i < n; ++i) {
                MolAtom atom = (MolAtom)v.elementAt(i);
                this.atomIndexMap[i] = cmol.indexOf(atom);
            }
        }
        cmol = this.createModifiedInputMolecule(cmol);
        cmol = this.getMainMolecule(cmol);
        if (!om) {
            this.atomCount = cmol.getAtomCount();
            this.atomIndexMap = null;
        }
        this.setInputMolecule(cmol);
        this.dim = cmol.getDim();
        this.om = om;
        this.calcmol = cmol;
        this.origmol = om ? mol : cmol;
        return this.origmol;
    }

    protected Molecule createModifiedInputMolecule(Molecule mol) throws PluginException {
        return mol;
    }

    public int getInputMolDim() {
        return this.dim;
    }

    public Molecule getCalcMolecule() {
        return this.calcmol;
    }

    protected Molecule createStandardizedMolecule(Molecule mol, boolean om) throws PluginException {
        return this.createStandardizedMolecule(mol);
    }

    protected Molecule createStandardizedMolecule(Molecule mol) throws PluginException {
        if (!this.handlesMultiFragmentMolecules() && mol.getFragCount() > 1) {
            MoleculeGraph[] frags = mol.findFrags(mol.getClass());
            MoleculeGraph frag = frags[0];
            int m = frag.getAtomCount();
            for (int i = 1; i < frags.length; ++i) {
                if (frags[i].getAtomCount() <= m) continue;
                frag = frags[i];
                m = frag.getAtomCount();
            }
            mol = (Molecule)frag;
        }
        this.standardize(mol);
        return mol;
    }

    protected Molecule getMainMolecule(Molecule mol) throws PluginException {
        return mol;
    }

    protected Molecule getDisplayMolecule() throws PluginException {
        Molecule mol = this.origmol.cloneMoleculeWithDocument();
        mol.clearProperties();
        if (!this.om && !this.aromatic) {
            mol.dearomatize();
        }
        return mol;
    }

    public boolean handlesMultiFragmentMolecules() {
        return false;
    }

    protected boolean isMsCalc() {
        return false;
    }

    public void setParameters(Properties params) throws PluginException {
    }

    public double getpH() {
        return Double.NaN;
    }

    public void checkMolecule(Molecule mol) throws PluginException {
        if (mol.isQuery()) {
            throw new PluginException(CalculatorPlugin.getQueryMoleculeErrorMessage(mol));
        }
        if (CalculatorPlugin.containsPseudoAtom(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with pseudo atoms.");
        }
        if (CalculatorPlugin.containsSRUSgroup(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with SRU S-groups.");
        }
        if (CalculatorPlugin.containsMulticenterSgroup(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with multicenter S-groups.");
        }
        if (CalculatorPlugin.containsCoordinateBond(mol)) {
            throw new PluginException("Calculation result is not defined for molecules with coordinate bonds.");
        }
    }

    protected static String getQueryMoleculeErrorMessage(Molecule mol) {
        String f = mol.getInputFormat();
        if (f != null && f.equals("xyz")) {
            return "Calculation result is not defined for XYZ input without bond information.";
        }
        try {
            return "Calculation result is not defined for query molecules: " + mol.toFormat("cxsmarts:u");
        }
        catch (IllegalArgumentException e) {
            return "Calculation result is not defined for query molecules: " + mol.toFormat("mrv");
        }
    }

    protected abstract void setInputMolecule(Molecule var1) throws PluginException;

    public abstract boolean run() throws PluginException;

    public boolean isOK() {
        return this.getErrorMessage().length() == 0 && this.getWarningMessage().length() == 0;
    }

    public String getErrorMessage() {
        return "";
    }

    public String getWarningMessage() {
        return "";
    }

    public final String getResultMessage() {
        String msg = this.getErrorMessage();
        if (msg.length() == 0) {
            msg = this.getWarningMessage();
        }
        return msg;
    }

    public String getRemark() {
        return null;
    }

    public Object[] getResultTypes() {
        return null;
    }

    public String getTypeString(Object type) {
        return type.toString();
    }

    public int getResultDomain(Object type) {
        return 2;
    }

    public boolean canRepeat() {
        return this.getResultDomain() != 4;
    }

    public int getResultCount(Object type) {
        return 1;
    }

    public Object getResult(Object type, int index) throws PluginException {
        return null;
    }

    public String getResultAsString(Object type, int index, Object result) throws PluginException {
        return null;
    }

    public String getResultsAsString(Object type, int index, Object result) throws PluginException {
        return this.getResultAsString(type, index, result);
    }

    public int getResultAsRGB(Object type, int index, Object result) throws PluginException {
        return 0;
    }

    public long getResultsAsRGB(Object type, int index, Object result) throws PluginException {
        return this.getResultAsRGB(type, index, result);
    }

    public boolean isNegligibleResult(Object type, int index, Object result) throws PluginException {
        return false;
    }

    public Object getResult(Object type, String arg) throws PluginException {
        int index = arg != null ? Integer.parseInt(arg) : 0;
        return this.getResult(type, index);
    }

    public Molecule getResultMolecule() throws PluginException {
        return null;
    }

    public Molecule[] getResultMolecules() throws PluginException {
        return null;
    }

    public PluginMDocSource getResultSource() throws PluginException {
        return null;
    }

    public int getResultDomain() {
        return this.getResultDomain(this.getResultTypes()[0]);
    }

    public int getResultCount() {
        return this.getResultCount(this.getResultTypes()[0]);
    }

    public Object getResult(int index) throws PluginException {
        return this.getResult(this.getResultTypes()[0], index);
    }

    public Object getResult(String arg) throws PluginException {
        return this.getResult(this.getResultTypes()[0], arg);
    }

    public String getResultAsString(int index, Object result) throws PluginException {
        return this.getResultAsString(this.getResultTypes()[0], index, result);
    }

    public String getResultsAsString(int index, Object result) throws PluginException {
        return this.getResultAsString(index, result);
    }

    public int getResultAsRGB(int index, Object result) throws PluginException {
        return this.getResultAsRGB(this.getResultTypes()[0], index, result);
    }

    public long getResultsAsRGB(int index, Object result) throws PluginException {
        return this.getResultAsRGB(index, result);
    }

    public final int getAtomCount() {
        return this.atomCount;
    }

    public final int getAtomIndex(int index) {
        return this.atomIndexMap == null ? index : this.atomIndexMap[index];
    }

    public final boolean isInputMoleculeAromatized() {
        return this.aromatic;
    }

    public void standardize(Molecule mol) {
        mol.dearomatize();
        CalculatorPlugin.standardizeIonicGroups(mol);
        mol.aromatize(1);
    }

    protected static void standardizeIonicGroups(Molecule mol) {
        block0: for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = mol.getAtom(i);
            if (a.getAtno() == 7 && a.getCharge() == 1) {
                int radical = a.getRadical();
                if (radical == 2 || radical == 6 || radical == 10) continue;
                for (int j = a.getBondCount() - 1; j >= 0; --j) {
                    MolBond b;
                    MolAtom o = a.getLigand(j);
                    if (o.getAtno() != 8 || (b = a.getBond(j)).getType() != 1 || o.getCharge() != -1) continue;
                    CalculatorPlugin.transformIonic(mol, a, o, b);
                    continue block0;
                }
                continue;
            }
            if (a.getAtno() != 16 || a.getCharge() != 1) continue;
            int sc = 0;
            MolBond b1 = null;
            MolAtom o1 = null;
            for (int j = a.getBondCount() - 1; j >= 0; --j) {
                MolBond b;
                MolAtom o = a.getLigand(j);
                if (o.getAtno() == 8) {
                    b = a.getBond(j);
                    if (b.getType() != 1 || o.getCharge() != -1) continue;
                    b1 = b;
                    o1 = o;
                    continue;
                }
                if (o.getAtno() != 6 || (b = a.getBond(j)).getType() != 1 || o.getCharge() != 0) continue;
                ++sc;
            }
            if (b1 == null || sc < 2) continue;
            CalculatorPlugin.transformIonic(mol, a, o1, b1);
        }
    }

    private static void transformIonic(Molecule mol, MolAtom a1, MolAtom a2, MolBond b) {
        MolAtom a = a1.getCharge() > 0 ? a1 : a2;
        int type = 2;
        if (a.getImplicitHcount() > 0) {
            type = 1;
        } else {
            for (int i = a.getBondCount() - 1; i >= 0; --i) {
                MolAtom ligand = a.getLigand(i);
                if (!ligand.isImplicitizableH(0)) continue;
                mol.removeAtom(ligand);
                type = 1;
                break;
            }
        }
        b.setType(type);
        a1.setCharge(0);
        a2.setCharge(0);
        a1.valenceCheck();
        a2.valenceCheck();
    }

    protected static void standardizeNeutralGroups(Molecule mol) {
        block0: for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = mol.getAtom(i);
            if (a.getAtno() == 7 && a.getCharge() == 0) {
                for (int j = a.getBondCount() - 1; j >= 0; --j) {
                    MolAtom o = a.getLigand(j);
                    if (o.getAtno() != 8 || o.getCharge() != 0) continue;
                    MolBond b = a.getBond(j);
                    int type = b.getType();
                    if (type != 1 && type != 2) continue block0;
                    CalculatorPlugin.transformNeutral(mol, a, o, b);
                    continue block0;
                }
                continue;
            }
            if (a.getAtno() != 16 || a.getCharge() != 0) continue;
            int sc = 0;
            MolBond b1 = null;
            MolAtom o1 = null;
            for (int j = a.getBondCount() - 1; j >= 0; --j) {
                MolBond b;
                MolAtom o = a.getLigand(j);
                if (o.getAtno() == 8) {
                    b = a.getBond(j);
                    if (b.getType() != 2 || o.getCharge() != 0) continue;
                    b1 = b;
                    o1 = o;
                    continue;
                }
                if (o.getAtno() != 6 || (b = a.getBond(j)).getType() != 1 || o.getCharge() != 0) continue;
                ++sc;
            }
            if (b1 == null || sc < 2) continue;
            CalculatorPlugin.transformNeutral(mol, a, o1, b1);
        }
    }

    private static void transformNeutral(Molecule mol, MolAtom a1, MolAtom a2, MolBond b) {
        if (b.getType() == 1) {
            for (int i = a2.getBondCount() - 1; i >= 0; --i) {
                MolAtom ligand = a2.getLigand(i);
                if (!ligand.isImplicitizableH(0)) continue;
                mol.removeAtom(ligand);
                break;
            }
        } else {
            b.setType(1);
        }
        a1.setCharge(1);
        a2.setCharge(-1);
        a1.valenceCheck();
        a2.valenceCheck();
    }

    public boolean isMultiThreadedRunEnabled() {
        return true;
    }
}

