/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.ParameterPanelHandler;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.PluginFactory;
import chemaxon.marvin.plugin.gui.ResultView;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.text.NameConverter;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.DPoint3;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class CalculatorPluginDisplay {
    protected static final int CELLSIZE = 380;
    protected static final int NONE = 0;
    protected static final int LABEL = 1;
    protected static final int TEXT = 2;
    protected static final int HTML = 3;
    protected static final String WORD_SEPARATORS = "- ";
    protected static final int MAX_LINE_LENGTH = 50;
    private CalculatorPlugin plugin = null;
    protected Component parent = null;
    protected String title = null;
    protected int icell = 0;
    protected boolean displayInMarvinSpace = false;
    private ParameterPanelHandler parameterPanel = null;
    protected ArrayList resultMolList = null;
    protected ArrayList resultValues = null;
    protected DPoint3[] reactionArrow = null;

    public synchronized void setPlugin(CalculatorPlugin plugin) {
        this.plugin = plugin;
    }

    protected final CalculatorPlugin getPlugin() {
        return this.plugin;
    }

    public final synchronized void setParent(Component parent) {
        this.parent = parent;
    }

    final synchronized Component getParent() {
        return this.parent;
    }

    public final synchronized void setCellIndex(int icell) {
        this.icell = icell;
    }

    public void setParameters(Properties params) {
        if (params.get("mspace") != null) {
            this.displayInMarvinSpace = Boolean.valueOf((String)params.get("mspace"));
        }
    }

    public synchronized void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setReactionArrow(DPoint3[] reactionArrow) {
        this.reactionArrow = reactionArrow;
    }

    public MProgressMonitor getProgressMonitor(Component parent) {
        return null;
    }

    public final synchronized ParameterPanelHandler getParameterPanel() throws PluginException {
        if (this.parameterPanel == null) {
            this.parameterPanel = this.createParameterPanel();
        }
        return this.parameterPanel;
    }

    void setParameterPanel(ParameterPanelHandler parameterPanel) {
        this.parameterPanel = parameterPanel;
    }

    protected ParameterPanelHandler createParameterPanel() throws PluginException {
        return PluginFactory.createDefaultParameterPanel(this.plugin.getClass(), this.plugin.getClass().getName(), this.parent);
    }

    public boolean isMultipleDisplay() {
        return true;
    }

    public void pop() {
        if (this.resultMolList != null && this.resultMolList.size() > 0) {
            this.resultMolList.remove(this.resultMolList.size() - 1);
        }
        if (this.resultValues != null && this.resultValues.size() > 0) {
            this.resultValues.remove(this.resultValues.size() - 1);
        }
        this.reactionArrow = null;
    }

    public void clear() {
        if (this.resultMolList != null) {
            this.resultMolList.clear();
        }
        if (this.resultValues != null) {
            this.resultValues.clear();
        }
        this.reactionArrow = null;
    }

    public void store() throws PluginException {
        Molecule mol = this.plugin.getResultMolecule();
        if (mol != null) {
            if (this.resultMolList == null) {
                this.resultMolList = new ArrayList();
                this.resultValues = new ArrayList();
            }
            this.resultMolList.add(mol);
        }
        if (!this.displayInMarvinSpace) {
            return;
        }
        this.storeResults(mol);
    }

    private void storeResults(Molecule mol) throws PluginException {
        Object[] resultTypes = this.plugin.getResultTypes();
        boolean atomic = false;
        for (int t = 0; t < resultTypes.length; ++t) {
            if (this.plugin.getResultDomain(resultTypes[t]) != 1) continue;
            atomic = true;
            int count1 = mol.getAtomCount();
            ArrayList<Float> a = new ArrayList<Float>();
            if (mol.getImplicitHcount() == 0) {
                for (int i = 0; i < count1; ++i) {
                    Object result = this.plugin.getResult(resultTypes[t], i);
                    if (result instanceof Number) {
                        a.add(new Float(((Number)result).floatValue()));
                        continue;
                    }
                    a.add(new Float(0.0f));
                }
                this.resultValues.add(a);
                return;
            }
            Molecule m = mol.cloneMolecule();
            m.hydrogenize(true);
            int count2 = m.getAtomCount();
            for (int i = 0; i < count2; ++i) {
                if (i >= count1 && m.getAtom(i).getAtno() == 1) {
                    int ai = m.indexOf(m.getAtom(i).getLigand(0));
                    Object result = this.getHResult(ai);
                    if (result instanceof Number) {
                        double x = ((Number)result).doubleValue() / (double)mol.getAtom(ai).getImplicitHcount();
                        a.add(new Float(x));
                        continue;
                    }
                    a.add(new Float(0.0f));
                    continue;
                }
                Object result = this.plugin.getResult(resultTypes[t], i);
                if (result instanceof Number) {
                    a.add(new Float(((Number)result).floatValue()));
                    continue;
                }
                a.add(new Float(0.0f));
            }
            this.resultValues.add(a);
        }
        if (!atomic) {
            this.resultValues.add(new ArrayList());
        }
    }

    protected Object getHResult(int i) throws PluginException {
        return this.plugin.getResult((Object)"implh", i);
    }

    public Component getResultComponent() throws PluginException {
        if (this.resultMolList == null || this.resultMolList.isEmpty()) {
            return null;
        }
        Molecule[] mols = new Molecule[this.resultMolList.size()];
        this.resultMolList.toArray(mols);
        return this.displayInMarvinSpace ? this.createSpacePanel(mols) : this.createViewPanel(mols);
    }

    protected ResultView createResultView(String title, MolPanel mpan) throws PluginException {
        Component rparent;
        for (rparent = this.getParameterPanel().getComponent(); rparent != null && !(rparent instanceof Window); rparent = rparent.getParent()) {
        }
        ResultView rview = rparent instanceof Dialog ? new ResultView((Dialog)rparent, title, mpan) : new ResultView((Frame)rparent, title, mpan);
        rview.setLocationRelativeTo(rparent);
        return rview;
    }

    protected CallbackIface createMolsFrame() throws PluginException {
        Component rparent;
        for (rparent = this.getParameterPanel().getComponent(); rparent != null && !(rparent instanceof Window); rparent = rparent.getParent()) {
        }
        try {
            if (rparent instanceof Dialog) {
                return (CallbackIface)MarvinModule.load("view.swing.MolsFrame", new Class[]{Dialog.class}, new Object[]{(Dialog)rparent}, (MolPanel)this.parent);
            }
            return (CallbackIface)MarvinModule.load("view.swing.MolsFrame", new Class[]{Frame.class}, new Object[]{(Frame)rparent}, (MolPanel)this.parent);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Component getErrorComponent() throws PluginException {
        String msg = this.plugin.getErrorMessage();
        if (msg.length() == 0) {
            msg = this.plugin.getWarningMessage();
        }
        if (msg.length() == 0) {
            return null;
        }
        return new JOptionPane(msg, 2);
    }

    public String getRemark() throws PluginException {
        return this.plugin.getRemark();
    }

    protected ViewPanel createViewPanel(Molecule[] mols) throws PluginException {
        if (mols == null || mols.length == 0) {
            return null;
        }
        for (int i = 0; i < mols.length; ++i) {
            if (mols[i].getPropertyCount() <= 0) continue;
            String text = this.getPropertyText(mols[i]);
            return this.createViewPanel(mols, 1, 1, 380, NameConverter.containsSuperscript(text) ? 3 : 2);
        }
        Molecule mol = mols[0].cloneMoleculeWithDocument();
        for (int i = 1; i < mols.length; ++i) {
            mol.fuse(mols[i].cloneMoleculeWithDocument());
        }
        if (this.reactionArrow != null) {
            RxnMolecule rxn = new RxnMolecule();
            rxn.setDim(mol.getDim());
            rxn.setReactionArrow(this.reactionArrow);
            rxn.fuse(mol);
            mol = rxn;
        }
        return this.createViewPanel(new Molecule[]{mol}, 1, 1, 380, 0);
    }

    protected ViewPanel createViewPanel(Molecule[] mols, int rows, int cols, int size, int propertyDisplayType) {
        if (mols == null || mols.length == 0) {
            return null;
        }
        int dim = mols[0].getDim();
        Color bgcolor = dim == 3 ? Color.black : Color.white;
        String bgstr = dim == 3 ? "#000000" : "#ffffff";
        String rendering = dim == 3 ? "ballstick" : "wireframe";
        int nrows = (mols.length + (cols - 1)) / cols;
        rows = Math.min(rows, nrows);
        ViewPanel vp = new ViewPanel(null, dim, null);
        Properties viewProps = new Properties();
        viewProps.put("rendering", rendering);
        viewProps.put("extrabonds", "arom,wedge");
        viewProps.put("molbg", bgstr);
        viewProps.put("viewmolbg2d", bgstr);
        viewProps.put("viewmolbg3d", bgstr);
        viewProps.put("rows", "" + nrows);
        viewProps.put("cols", "" + cols);
        viewProps.put("visibleCols", "" + cols);
        if (!Double.isNaN(this.plugin.getpH()) && propertyDisplayType == 0) {
            propertyDisplayType = 1;
        }
        String layout = null;
        String param = null;
        if (nrows > rows) {
            switch (propertyDisplayType) {
                case 1: {
                    layout = ":2:1:M:0:0:1:1:c:b:1:1:L:1:0:1:1:c:n:0:1";
                    param = ":M:" + size + ":" + size + ":L:12b";
                    break;
                }
                case 2: {
                    layout = ":2:1:M:0:0:1:1:c:b:1:1:T:1:0:1:1:w:n:0:1";
                    param = ":M:" + size + ":" + size + ":T:12b";
                    break;
                }
                case 3: {
                    layout = ":2:1:M:0:0:1:1:c:b:1:1:T:1:0:1:1:w:n:0:1";
                    param = ":M:" + size + ":" + size + ":T:12b:0";
                    break;
                }
                default: {
                    layout = ":1:1:M:0:0:1:1:c:b:1:1";
                    param = ":M:" + size + ":" + size;
                }
            }
            viewProps.put("visibleRows", "" + rows);
        } else {
            switch (propertyDisplayType) {
                case 1: {
                    layout = ":2:1:M:1:0:1:1:c:b:1:1:L:0:0:1:1:c:n:0:1";
                    param = ":M:" + size + ":" + size + ":L:12b";
                    break;
                }
                case 2: {
                    layout = ":2:1:M:1:0:1:1:c:b:1:1:T:0:0:1:1:w:h:0:1";
                    param = ":M:" + size + ":" + size + ":T:12b";
                    break;
                }
                case 3: {
                    layout = ":2:1:M:1:0:1:1:c:b:1:1:T:0:0:1:1:w:n:0:1";
                    param = ":M:" + size + ":" + size + ":T:12b:0";
                    break;
                }
                default: {
                    layout = ":1:1:M:0:0:1:1:c:b:1:1";
                    param = ":M:" + size + ":" + size;
                }
            }
        }
        viewProps.put("layout", layout);
        viewProps.put("param", param);
        vp.setProperties(viewProps);
        vp.setBorderWidth(1);
        if (propertyDisplayType == 1) {
            vp.setBackground(new Color(0xCCCCCC));
        } else {
            vp.setBackground(bgcolor);
        }
        vp.setMolbg(bgcolor);
        vp.setEditable(0);
        vp.setDetachable(false);
        for (int i = 0; i < mols.length; ++i) {
            Molecule mol = mols[i];
            if (propertyDisplayType != 0) {
                String text = null;
                text = this.getPropertyText(mol);
                if ((text = this.appendpHText(text)) != null) {
                    switch (propertyDisplayType) {
                        case 1: {
                            vp.setL(i, text);
                            break;
                        }
                        case 2: {
                            vp.setT(i, text);
                            break;
                        }
                        case 3: {
                            vp.setT(i, NameConverter.convertToSuperscriptedString(text));
                        }
                    }
                }
            }
            vp.molLoaded(new Molecule[]{mol}, i);
        }
        return vp;
    }

    protected String getPropertyText(Molecule mol) {
        String text = null;
        String[] keys = mol.properties().getKeys();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String type = this.plugin.getTypeString(key);
            if (type == null) continue;
            String result = mol.getProperty(key);
            result = StringUtil.convertToMultiLine(result, WORD_SEPARATORS, 50);
            text = text == null ? "" : text + "\n";
            text = text + type;
            if (result.length() <= 0) continue;
            text = text + " = " + result;
        }
        return text;
    }

    protected String appendpHText(String text) {
        double pH = this.plugin.getpH();
        if (Double.isNaN(pH)) {
            return text;
        }
        String pHstr = this.plugin.format(pH);
        text = text == null ? " pH = " + pHstr : text + "\n at pH " + pHstr;
        return text;
    }

    protected boolean isMSpaceDisplayLabelOnlyOnHeavyAtoms() {
        return false;
    }

    public final String[] getLabels(double[] values) {
        String[] labels = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            labels[i] = this.plugin.format(values[i], 3);
        }
        return labels;
    }

    protected final String getTableText(String header, String[] labels, double[][] values) {
        StringBuffer b = new StringBuffer();
        StringTokenizer st = new StringTokenizer(header, String.valueOf(header.charAt(0)));
        for (int j = -1; j < values.length && st.hasMoreTokens(); ++j) {
            int t;
            String vstr = j == -1 ? labels[0] : this.plugin.format(values[j][0], 3);
            int len = vstr.length();
            String token = st.nextToken();
            if (j >= 0) {
                b.append('\t');
            }
            for (t = 0; t < len && (vstr.charAt(t) == ' ' || vstr.charAt(t) == '-'); ++t) {
                b.append(' ');
            }
            b.append(token);
            t += token.length();
            while (t < len) {
                b.append(' ');
                ++t;
            }
        }
        for (int i = 0; i < labels.length; ++i) {
            b.append("\n");
            b.append(labels[i]);
            for (int j = 0; j < values.length; ++j) {
                b.append("\t");
                b.append(this.plugin.format(values[j][i], 3));
            }
        }
        return b.toString();
    }

    protected Component createSpacePanel(Molecule[] mols) throws PluginException {
        if (mols == null || mols.length == 0) {
            return null;
        }
        try {
            Class.forName("chemaxon.marvin.space.gui.MSpace");
        }
        catch (ClassNotFoundException cne) {
            this.displayInMarvinSpace = false;
            return new JOptionPane("MarvinSpace is not available", 0);
        }
        try {
            Class.forName("com.sun.opengl.impl.NativeLibLoader");
        }
        catch (ClassNotFoundException cne) {
            this.displayInMarvinSpace = false;
            return new JOptionPane("Jogl is not available", 0);
        }
        Class<?> MSpacePluginDisplayClass = null;
        CallbackIface mspd = null;
        try {
            MSpacePluginDisplayClass = Class.forName("chemaxon.marvin.space.MSpacePluginDisplay");
            mspd = (CallbackIface)MSpacePluginDisplayClass.getConstructor(Boolean.TYPE, URL.class).newInstance(Boolean.TRUE, null);
        }
        catch (Throwable t) {
            this.displayInMarvinSpace = false;
            return new JOptionPane("Error opening MarvinSpace", 0);
        }
        mspd.callback("setTitle", this.title);
        mspd.callback("setMolecules", mols);
        mspd.callback("setResultValues", this.resultValues);
        mspd.callback("setPrecision", new Integer(this.plugin.getDoublePrecision()));
        mspd.callback("setPalette", "Red to Blue");
        String[] propertyTexts = new String[mols.length];
        for (int i = 0; i < mols.length; ++i) {
            propertyTexts[i] = this.getPropertyText(mols[i]);
        }
        mspd.callback("setPropertyTexts", propertyTexts);
        mspd.callback("setDisplayLabelOnlyOnHeavyAtoms", this.isMSpaceDisplayLabelOnlyOnHeavyAtoms());
        return (Component)mspd.callback("getMSpaceDialog", this.getParameterPanel().getComponent());
    }
}

