/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin;

import chemaxon.marvin.Calculator;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.CalculatorPluginCachedResults;
import chemaxon.marvin.plugin.CalculatorResultAccess;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class CalculatorPluginOutput
implements CalculatorResultAccess {
    protected CalculatorPlugin plugin = null;
    protected Properties params = null;
    protected String separator = "\t";
    private Throwable throwable = null;

    public CalculatorPluginOutput() {
    }

    public CalculatorPluginOutput(CalculatorPlugin plugin) {
        this.setPlugin(plugin);
    }

    public final void setPlugin(CalculatorPlugin plugin) {
        this.plugin = plugin;
    }

    public final CalculatorPlugin getPlugin() {
        return this.plugin;
    }

    public final void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    @Override
    public final Throwable getThrowable() {
        return this.throwable;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setParameters(Properties params) throws PluginException {
        this.params = params;
    }

    public Properties getPluginParameters() throws PluginException {
        return this.params;
    }

    public void setOutputParameters(Object[] types) throws PluginException {
    }

    public boolean isMolecular() {
        return false;
    }

    public boolean isStreamOutput() {
        return false;
    }

    public void setOutputStream(OutputStream os) throws IOException {
    }

    public void close() throws IOException {
        this.close(1);
    }

    public void close(int opts) throws IOException {
    }

    public final CalculatorPluginCachedResults getCachedResults(Molecule target, boolean stringResult) throws PluginException {
        return new CalculatorPluginCachedResults(stringResult ? this.getHeader() : null, stringResult ? this.getResult(target) : null, stringResult ? this.getResultMolecules(target) : null, stringResult ? null : this.getResultMolecule(target), this.getResultMessage(), this.getRemark(), this.getThrowable(), this.isOK());
    }

    @Override
    public final String getResultMessage() {
        return this.plugin.getResultMessage();
    }

    @Override
    public String getRemark() {
        return this.plugin.getRemark();
    }

    @Override
    public boolean isOK() {
        return this.plugin.isOK();
    }

    @Override
    public String getHeader() {
        StringBuffer s = new StringBuffer();
        Object[] types = this.plugin.getResultTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                s.append(this.separator);
            }
            s.append(this.plugin.getTypeString(types[i]));
        }
        return new String(s);
    }

    @Override
    public String getResult(Molecule target) throws PluginException {
        StringBuffer s = new StringBuffer();
        Object[] types = this.plugin.getResultTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                s.append(this.separator);
            }
            s.append(this.getResults(types[i]));
        }
        return new String(s).trim();
    }

    protected String getResults(Object type) throws PluginException {
        StringBuffer s = new StringBuffer();
        int r = this.plugin.getResultCount(type);
        for (int j = 0; j < r; ++j) {
            if (j > 0) {
                s.append(";");
            }
            Object result = this.plugin.getResult(type, j);
            String rtext = this.plugin.getResultAsString(type, j, result);
            s.append(rtext);
        }
        return new String(s);
    }

    @Override
    public Molecule getResultMolecule(Molecule target) throws PluginException {
        return this.plugin.getResultMolecule();
    }

    @Override
    public Molecule[] getResultMolecules(Molecule target) throws PluginException {
        return null;
    }

    public int getResultDomain() {
        return this.plugin.getResultDomain();
    }

    public double getSpecResult(Molecule target, String arg) throws PluginException {
        int index = 0;
        if (arg != null) {
            try {
                index = Integer.parseInt(arg);
            }
            catch (NumberFormatException e) {
                throw new PluginException("Argument string format error: " + arg);
            }
        }
        if ((this.getResultDomain() & 1) != 0 && !this.plugin.handlesMultiFragmentMolecules() && target.getFragCount() > 1) {
            target = target.cloneMoleculeWithDocument();
            MolAtom atom = target.getAtom(index);
            Molecule mol = new Molecule();
            target.findFrag(index, mol);
            target = mol;
            index = target.indexOf(atom);
        }
        Calculator.runPlugin(this.plugin, target);
        Object result = this.plugin.getResult(index);
        try {
            return ((Number)result).doubleValue();
        }
        catch (ClassCastException e) {
            throw new PluginException("Result is not a number: " + result);
        }
    }
}

