/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin;

import chemaxon.calculator.CalculatorFormatter;
import chemaxon.formats.MolExporter;
import chemaxon.marvin.plugin.CalculatorPluginOutput;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ServiceOutput
extends CalculatorPluginOutput {
    private String header = "";
    private String result = "";
    private List<Molecule> mols;
    private String format;

    public ServiceOutput(String header, Object result) {
        this.setHeader(header);
        this.setResult(result);
    }

    protected void setHeader(String header) {
        this.header = header;
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    protected void setResult(Object result) {
        if (result instanceof Molecule) {
            try {
                this.result = MolExporter.exportToFormat((Molecule)result, "smiles");
            }
            catch (Exception e) {
                this.result = "This molecule cannot be converted to smiles.";
            }
        } else if (result instanceof Double && (Double)result != 0.0) {
            DecimalFormat formatter = new DecimalFormat("0.00");
            this.result = formatter.format((Double)result);
        } else if (result instanceof String[]) {
            String[] strRes = (String[])result;
            this.result = strRes[0];
            for (int i = 1; i < strRes.length; ++i) {
                this.result = this.result + " " + strRes[i];
            }
        } else if (result instanceof CalculatorFormatter.FormattedResult[]) {
            CalculatorFormatter.FormattedResult[] forms = (CalculatorFormatter.FormattedResult[])result;
            this.format = forms[0].getResultFormat();
            this.mols = new ArrayList<Molecule>();
            String[] strings = new String[forms.length];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = forms[i].getResult();
                if (!forms[i].isMoleculeResult()) continue;
                this.mols.addAll(Arrays.asList(forms[i].getResultMolecules()));
            }
            this.setResult(strings);
        } else {
            this.result = result.toString();
        }
    }

    public String getResult() {
        return this.result;
    }

    @Override
    public String getResult(Molecule target) throws PluginException {
        return this.getResult();
    }

    @Override
    public boolean isOK() {
        return true;
    }

    @Override
    public String getRemark() {
        return null;
    }

    @Override
    public Molecule getResultMolecule(Molecule target) throws PluginException {
        return target;
    }

    @Override
    public Molecule[] getResultMolecules(Molecule target) throws PluginException {
        return this.getResultMolecules();
    }

    public Molecule[] getResultMolecules() throws PluginException {
        return this.mols.toArray(new Molecule[0]);
    }

    public String getResultFormat() {
        return this.format;
    }
}

