/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin.gui;

import chemaxon.marvin.plugin.gui.Choice;
import chemaxon.marvin.plugin.gui.ParameterItemUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CheckList
extends JPanel {
    private MCheckBox[] checkboxes = null;

    CheckList(Choice[] choices) {
        this.setLayout(new GridLayout(1, 1));
        JPanel panel = new JPanel();
        JScrollPane scrollpanel = new JScrollPane(panel);
        this.add(scrollpanel);
        panel.setBackground(Color.white);
        GridBagLayout panellayout = new GridBagLayout();
        panel.setLayout(panellayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        this.checkboxes = new MCheckBox[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            this.checkboxes[i] = new MCheckBox();
            this.checkboxes[i].setText(choices[i].getText());
            this.checkboxes[i].setBackground(Color.white);
            this.checkboxes[i].setToolTipText(choices[i].getToolTipText());
            panel.add((Component)this.checkboxes[i], gbc);
            ++gbc.gridy;
        }
        Dimension d = scrollpanel.getPreferredSize();
        scrollpanel.setPreferredSize(new Dimension(d.width + 10, d.height + 10));
    }

    public void addSelectionListener(ActionListener l) {
        for (int i = 0; i < this.checkboxes.length; ++i) {
            this.checkboxes[i].addActionListener(l);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.checkboxes.length; ++i) {
            this.checkboxes[i].setEnabled(enabled);
        }
    }

    public void setSelectedIndices(int[] indices) {
        int i;
        for (i = 0; i < this.checkboxes.length; ++i) {
            this.checkboxes[i].setSelected(false);
        }
        for (i = 0; i < indices.length; ++i) {
            this.checkboxes[indices[i]].setSelected(true);
        }
    }

    public int[] getSelectedIndices() {
        int n = 0;
        for (int i = 0; i < this.checkboxes.length; ++i) {
            if (!this.checkboxes[i].isSelected()) continue;
            ++n;
        }
        int[] indices = new int[n];
        int k = 0;
        for (int i = 0; i < this.checkboxes.length; ++i) {
            if (!this.checkboxes[i].isSelected()) continue;
            indices[k++] = i;
        }
        return indices;
    }

    public Object[] getSelectedValues() {
        int[] indices = this.getSelectedIndices();
        Object[] values = new Object[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            values[i] = this.checkboxes[indices[i]].getText();
        }
        return values;
    }

    protected JCheckBox getCheckBox(String label) {
        for (int i = 0; i < this.checkboxes.length; ++i) {
            if (!this.checkboxes[i].getText().equals(label)) continue;
            return this.checkboxes[i];
        }
        return null;
    }

    private class MCheckBox
    extends JCheckBox {
        private MCheckBox() {
        }

        @Override
        public void setToolTipText(String text) {
            super.setToolTipText(ParameterItemUtil.convertToMultiLineHtmlString(text));
        }
    }
}

