/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin.gui;

import chemaxon.edu.stanford.ejalbert.BrowserLauncher;
import chemaxon.marvin.plugin.gui.ParameterItem;
import java.awt.Component;
import java.awt.SystemColor;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class LabelItem
extends ParameterItem {
    private String text = null;

    public LabelItem(String text, String tooltip) {
        super(null);
        this.text = text;
        this.tooltip = tooltip;
        JPanel contentPanel = new JPanel();
        if (text.trim().startsWith("<html>") && text.trim().endsWith("</html>")) {
            JEditorPane editorPane = new JEditorPane();
            editorPane.setContentType("text/html");
            editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            editorPane.setOpaque(false);
            editorPane.setEditable(false);
            editorPane.setText(text);
            editorPane.setBackground(SystemColor.window);
            LabelItem.addHyperlinkListener(editorPane);
            contentPanel.add(editorPane);
        } else {
            JLabel jlabel = new JLabel(text);
            contentPanel.add(jlabel);
        }
        contentPanel.setToolTipText(this.getTolTipText());
        this.components = new Component[]{contentPanel};
    }

    private static void addHyperlinkListener(JEditorPane editorPane) {
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        BrowserLauncher.openURL(e.getURL().toString());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return this.components[0].isEnabled();
    }

    @Override
    public String getValue() {
        return this.text;
    }

    @Override
    public void save() {
    }

    @Override
    public void reload() {
    }

    @Override
    public void restoreDefault() {
    }
}

