/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin.gui;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.plugin.gui.CheckList;
import chemaxon.marvin.plugin.gui.Choice;
import chemaxon.marvin.plugin.gui.ParameterItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;

public class MultipleSelectionItem
extends ParameterItem {
    public static final char DELIMITER = ',';
    String label = null;
    CheckList checklist = null;
    Choice[] choices = null;
    int[] indices = null;
    int[] defval = null;
    boolean verifySelection = true;

    MultipleSelectionItem(String key, String label, String tooltip) {
        super(key);
        this.label = label;
        this.tooltip = tooltip;
        JLabel jlabel = new JLabel(label);
        jlabel.setToolTipText(this.getTolTipText());
        this.components = new Component[]{jlabel, null};
    }

    void setVerifySelection(boolean verifySelection) {
        this.verifySelection = verifySelection;
    }

    void setChoices(Choice[] choices) {
        this.choices = choices;
        IntVector sel = new IntVector(choices.length);
        IntVector def = new IntVector(choices.length);
        for (int i = 0; i < choices.length; ++i) {
            if (choices[i].isSelected()) {
                sel.add(i);
            }
            if (!choices[i].isDefval()) continue;
            def.add(i);
        }
        this.indices = sel.toArray();
        this.defval = def.toArray();
        this.checklist = new CheckList(choices);
        this.checklist.setSelectedIndices(this.indices);
        this.components[1] = this.checklist;
        this.checklist.addSelectionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleSelectionItem.this.notifyListeners();
            }
        });
    }

    @Override
    public String getValue() {
        int[] inds = this.checklist.getSelectedIndices();
        String value = ",";
        for (int i = 0; i < inds.length; ++i) {
            value = value + this.choices[inds[i]].getValue() + ',';
        }
        return value;
    }

    @Override
    public void save() {
        this.indices = this.checklist.getSelectedIndices();
    }

    @Override
    public void reload() {
        this.checklist.setSelectedIndices(this.indices);
    }

    @Override
    public void restoreDefault() {
        this.checklist.setSelectedIndices(this.defval);
    }

    @Override
    public String verify() {
        if (this.verifySelection && this.checklist.getSelectedIndices().length == 0) {
            return this.label + ": no selection";
        }
        return null;
    }

    @Override
    public boolean isValueInRange(String range) {
        char delim = ',';
        range = delim + range + delim;
        int[] inds = this.checklist.getSelectedIndices();
        for (int i = 0; i < inds.length; ++i) {
            int k = range.indexOf(delim + this.choices[inds[i]].getValue() + delim);
            if (k == -1) continue;
            return true;
        }
        return false;
    }
}

