/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin.gui;

import chemaxon.marvin.plugin.gui.Choice;
import chemaxon.marvin.plugin.gui.ParameterItem;
import chemaxon.util.StringUtil;
import java.util.StringTokenizer;

class ParameterItemUtil {
    ParameterItemUtil() {
    }

    static String convertToMultiLineHtmlString(String str) {
        return ParameterItemUtil.convertToMultiLineHtmlString(str, ParameterItem.TOOLTIP_LINE_LENGTH);
    }

    private static String convertToMultiLineHtmlString(String str, int lineLength) {
        if (str == null) {
            return null;
        }
        if (str.trim().startsWith("<html>") && str.trim().endsWith("</html>")) {
            return str;
        }
        StringTokenizer st = new StringTokenizer(str, "\n");
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            line = line.length() > lineLength ? StringUtil.convertToMultiLine(line, " ", "<br>", lineLength) + "<br>" : line + "<br>";
            sb.append(line);
        }
        return "<html>" + sb.toString() + "</html>";
    }

    static String removeHtmlTags(String str) {
        if (str == null) {
            return str;
        }
        if (str.trim().startsWith("<html>")) {
            str.replaceFirst("<html>", "");
        }
        if (str.trim().endsWith("</html>")) {
            str = str.substring(0, str.lastIndexOf("</html>"));
        }
        return str;
    }

    static String getChoiceHelpAsHtmlList(String listHeader, Choice[] choices) {
        StringBuilder sb = new StringBuilder();
        if (listHeader != null) {
            sb.append(StringUtil.convertToMultiLine(ParameterItemUtil.removeHtmlTags(listHeader), " ", "<br>", ParameterItem.TOOLTIP_LINE_LENGTH) + "<br>");
        }
        if (choices != null && ParameterItemUtil.hasToolTip(choices)) {
            sb.append("<ul>");
            for (Choice choice : choices) {
                if (choice.getText() == null || choice.getToolTipText() == null) continue;
                sb.append("<li>" + StringUtil.convertToMultiLine(ParameterItemUtil.removeHtmlTags(choice.getText()) + ": " + ParameterItemUtil.removeHtmlTags(choice.getToolTipText()), " ", "<br>", ParameterItem.TOOLTIP_LINE_LENGTH) + "</li>");
            }
            sb.append("</ul>");
        }
        return sb.length() == 0 ? null : "<html>" + sb.toString() + "</html>";
    }

    private static boolean hasToolTip(Choice[] choices) {
        for (Choice choice : choices) {
            if (!choice.hasToolTip()) continue;
            return true;
        }
        return false;
    }
}

