/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin.gui;

import chemaxon.marvin.plugin.gui.Choice;
import chemaxon.marvin.plugin.gui.ParameterItem;
import chemaxon.marvin.plugin.gui.ParameterItemUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SingleSelectionItem
extends ParameterItem {
    private static final String EMPTY_CHOICE = "";
    JComboBox combo = null;
    Choice[] choices = null;
    int index = 0;
    int defval = 0;
    private JLabel comboLabel = null;

    protected SingleSelectionItem(String key, String label, String tooltip) {
        super(key);
        this.tooltip = tooltip;
        this.comboLabel = new JLabel(label);
        this.components = new Component[]{this.comboLabel, null};
    }

    protected SingleSelectionItem(String key, String label, String tooltip, String choiceListReaderJavaMethod) {
        this(key, label, tooltip);
        ArrayList<Choice> choiceList = new ArrayList<Choice>();
        int classMethodSeparatorDotIndex = choiceListReaderJavaMethod.lastIndexOf(".");
        String className = choiceListReaderJavaMethod.substring(0, classMethodSeparatorDotIndex);
        String methodName = choiceListReaderJavaMethod.substring(classMethodSeparatorDotIndex + 1);
        String[] traningIds = null;
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod(methodName, null);
            traningIds = (String[])method.invoke(null, (Object[])null);
        }
        catch (ClassNotFoundException e) {
            traningIds = null;
        }
        catch (NoSuchMethodException e) {
            traningIds = null;
        }
        catch (SecurityException e) {
            traningIds = null;
        }
        catch (IllegalArgumentException e) {
            traningIds = null;
        }
        catch (IllegalAccessException e) {
            traningIds = null;
        }
        catch (InvocationTargetException e) {
            traningIds = null;
        }
        if (traningIds != null && traningIds.length != 0) {
            for (int i = 0; i < traningIds.length; ++i) {
                Choice choice = new Choice(traningIds[i], traningIds[i], null, i == 0, i == 0);
                choiceList.add(choice);
                this.setChoices(choiceList.toArray(new Choice[choiceList.size()]));
            }
        } else {
            this.setChoices(new Choice[]{new Choice(EMPTY_CHOICE, EMPTY_CHOICE, null, false, true)});
            this.setEnabled(false);
        }
    }

    protected void setChoices(Choice[] choices) {
        this.choices = choices;
        String[] items = new String[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            items[i] = choices[i].getText();
            if (choices[i].isSelected()) {
                this.index = i;
            }
            if (!choices[i].isDefval()) continue;
            this.defval = i;
        }
        this.combo = new JComboBox<String>(items);
        this.comboLabel.setToolTipText(this.getTolTipText());
        this.combo.setSelectedIndex(this.index);
        this.components[1] = this.combo;
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleSelectionItem.this.notifyListeners();
            }
        });
    }

    protected Choice[] getChoices() {
        return this.choices;
    }

    @Override
    public String getValue() {
        int i = this.combo.getSelectedIndex();
        return this.choices[i].getValue();
    }

    @Override
    public String getTolTipText() {
        return ParameterItemUtil.getChoiceHelpAsHtmlList(this.tooltip, this.choices);
    }

    @Override
    public void save() {
        this.index = this.combo.getSelectedIndex();
    }

    @Override
    public void reload() {
        this.combo.setSelectedIndex(this.index);
    }

    @Override
    public void restoreDefault() {
        this.combo.setSelectedIndex(this.defval);
    }

    @Override
    public boolean isValueInRange(String range) {
        char delim = ',';
        int k = (range = range + delim + range + delim).indexOf(delim + this.getValue() + delim);
        return k != -1;
    }
}

