/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin.gui;

import chemaxon.marvin.plugin.gui.ParameterItem;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextItem
extends ParameterItem {
    protected String label = null;
    protected JTextField textfield = null;
    protected String text = null;
    protected String defval = null;

    TextItem(String key, String label, String tooltip, String text, String defval) {
        super(key);
        this.label = label;
        this.tooltip = tooltip;
        this.text = text;
        this.defval = defval;
        JLabel jlabel = new JLabel(label);
        jlabel.setToolTipText(this.getTolTipText());
        this.setTextField(text);
        this.components = new Component[]{jlabel, this.textfield};
    }

    protected void setTextField(String text) {
        this.textfield = text != null ? new JTextField(text, 8) : new JTextField(8);
        this.textfield.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextItem.this.notifyListeners();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextItem.this.notifyListeners();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextItem.this.notifyListeners();
            }
        });
    }

    @Override
    public String getValue() {
        return this.textfield.getText();
    }

    @Override
    public void save() {
        this.text = this.textfield.getText();
    }

    @Override
    public void reload() {
        this.textfield.setText(this.text);
    }

    @Override
    public void restoreDefault() {
        this.textfield.setText(this.defval);
    }
}

