/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services;

import chemaxon.jep.CTFactory;
import chemaxon.jep.ChemContext;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.Evaluator;
import chemaxon.jep.context.MolContext;
import chemaxon.jep.context.ReactionContext;
import chemaxon.marvin.services.DynamicArgument;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;

public class ChemicalTermsArgument<T>
extends DynamicArgument<Molecule, T> {
    public ChemicalTermsArgument() {
        this(null);
    }

    public ChemicalTermsArgument(String expression) {
        this(expression, null);
    }

    public ChemicalTermsArgument(String expression, Class<T> type) {
        super(expression);
        this.setType(type);
    }

    @Override
    public T evaluate(Molecule context) throws IllegalArgumentException {
        Object result = null;
        try {
            Evaluator evaluator = CTFactory.createEvaluator();
            ChemContext chemContext = null;
            if (context.isReaction()) {
                RxnMolecule reaction = (RxnMolecule)context;
                chemContext = new ReactionContext();
                ((ReactionContext)chemContext).setReactants(reaction.getReactants());
                ((ReactionContext)chemContext).setProducts(reaction.getProducts());
            } else {
                chemContext = CTFactory.createMolContext();
                ((MolContext)chemContext).setMolecule(context);
            }
            ChemJEP jep = evaluator.compile(this.getExpression(), chemContext.getClass());
            result = jep.evaluate(chemContext);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)result;
    }

    @Override
    public boolean isValid() {
        if (super.isValid()) {
            boolean valid = true;
            try {
                CTFactory.createEvaluator().compile(this.getExpression());
            }
            catch (ParseException e) {
                valid = false;
            }
            return valid;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("Chemical Terms ");
        if (this.getExpression() != null) {
            builder.append("expression: ");
            builder.append(this.getExpression());
        }
        builder.append(" as ");
        builder.append(this.getType() == null ? "null" : String.valueOf(this.getType().getName()));
        return builder.toString();
    }

    @Override
    public String getPlaceholderText() {
        return "<Chemical Terms>";
    }
}

