/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services;

public class ServiceArgument<T> {
    protected Class<T> type = null;
    protected T value = null;
    protected final boolean constant;
    protected String name = "Unnamed";
    protected String alias = null;

    public static <T> ServiceArgument<T> createArgument(T value) {
        return ServiceArgument.createArgument("Unnamed", value);
    }

    public static <T> ServiceArgument<T> createArgument(String name, T value) {
        ServiceArgument argument = new ServiceArgument(value.getClass(), value, true);
        argument.setName(name);
        return argument;
    }

    public static <T> ServiceArgument<T> createArgumentAs(T value, Class<T> type) {
        return ServiceArgument.createArgumentAs("Unnamed", value, type);
    }

    public static <T> ServiceArgument<T> createArgumentAs(String name, T value, Class<T> type) {
        ServiceArgument<T> argument = new ServiceArgument<T>(type, value, true);
        argument.setName(name);
        return argument;
    }

    protected ServiceArgument(Class<T> type, T value) {
        this(type, value, value != null);
    }

    protected ServiceArgument(Class<T> type, T value, boolean constant) {
        this.type = type;
        this.value = value;
        this.constant = constant;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> argumentType) {
        this.type = argumentType;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean isValid() {
        return this.getType() != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(String.valueOf(this.getValue()));
        builder.append(" as ");
        builder.append(this.getType() == null ? "null" : String.valueOf(this.getType().getName()));
        return builder.toString();
    }

    public static ServiceArgument<?> createConstantFromString(String value, Class<?> argumentClass) {
        ServiceArgument<Object> argument = null;
        if (value != null) {
            if (String.class.equals(argumentClass)) {
                argument = ServiceArgument.createArgumentAs(value, String.class);
            } else if (Integer.class.equals(argumentClass)) {
                Integer i = new Integer(0);
                try {
                    i = Integer.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                argument = ServiceArgument.createArgumentAs(i, Integer.class);
            } else if (Long.class.equals(argumentClass)) {
                Long l = new Long(0L);
                try {
                    l = Long.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                argument = ServiceArgument.createArgumentAs(l, Long.class);
            } else if (Float.class.equals(argumentClass)) {
                Float f = new Float(0.0f);
                try {
                    f = Float.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                argument = ServiceArgument.createArgumentAs(f, Float.class);
            } else if (Double.class.equals(argumentClass)) {
                Double d = new Double(0.0);
                try {
                    d = Double.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                argument = ServiceArgument.createArgumentAs(d, Double.class);
            } else if (Boolean.class.equals(argumentClass)) {
                argument = ServiceArgument.createArgumentAs(Boolean.valueOf(value), Boolean.class);
            }
        }
        return argument;
    }
}

