/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services;

import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.services.ServiceHandler;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class ServiceDescriptor {
    public static final String NAME = "name";
    public static final String ALIAS = "alias";
    public static final String DESCRIPTION = "description";
    public static final String ARGUMENTS = "arguments";
    public static final String METHOD = "method";
    public static final String URL = "url";
    protected PropertyChangeSupport propertyChangeSupport = new SwingPropertyChangeSupport(this);
    private final Map<String, String> properties = new HashMap<String, String>();
    private List<ServiceArgument<?>> arguments = new ArrayList();
    private static final Icon serviceIcon = new ImageIcon(ServiceDescriptor.class.getResource("/chemaxon/icons/marvin/services/service.png"));

    protected ServiceDescriptor() {
        this.properties.put(NAME, "Unnamed");
    }

    public void setProperty(String key, String value) {
        String oldValue = this.getProperty(key);
        this.properties.put(key, value);
        this.propertyChangeSupport.firePropertyChange(key, oldValue, value);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String[] getPropertyKeys() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public String getName() {
        return this.getProperty(NAME);
    }

    public void setName(String name) {
        this.setProperty(NAME, name);
    }

    public String getAlias() {
        return this.getProperty(ALIAS);
    }

    public void setAlias(String alias) {
        this.setProperty(ALIAS, alias);
    }

    public String getURL() {
        return this.getProperty(URL);
    }

    public void setURL(String url) {
        this.setProperty(URL, url);
    }

    public String getMethodName() {
        return this.getProperty(METHOD);
    }

    public void setMethodName(String methodName) {
        this.setProperty(METHOD, methodName);
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public List<ServiceArgument<?>> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public int getArgumentCount() {
        return this.arguments.size();
    }

    public ServiceArgument<?> getArgument(int index) {
        return this.arguments.get(index);
    }

    public void addArgument(ServiceArgument<?> argument) {
        List<ServiceArgument<?>> oldValue = this.getArguments();
        this.arguments.add(argument);
        this.propertyChangeSupport.firePropertyChange(ARGUMENTS, oldValue, this.getArguments());
    }

    public void setArgument(int index, ServiceArgument<?> argument) {
        List<ServiceArgument<?>> oldValue = this.getArguments();
        this.arguments.set(index, argument);
        this.propertyChangeSupport.firePropertyChange(ARGUMENTS, oldValue, this.getArguments());
    }

    public ServiceArgument<?> removeArgument(int index) {
        List<ServiceArgument<?>> oldValue = this.getArguments();
        ServiceArgument<?> removed = this.arguments.remove(index);
        this.propertyChangeSupport.firePropertyChange(ARGUMENTS, oldValue, this.getArguments());
        return removed;
    }

    public Icon getIcon() {
        return serviceIcon;
    }

    public void setDescription(String description) {
        this.setProperty(DESCRIPTION, description);
    }

    public String getDescription() {
        if (this.properties.containsKey(DESCRIPTION)) {
            return this.getProperty(DESCRIPTION);
        }
        StringBuilder builder = new StringBuilder("<html><body><b>");
        builder.append(this.getSimpleName());
        builder.append("</b><br>");
        ArrayList<String> keyList = new ArrayList<String>(Arrays.asList(this.getPropertyKeys()));
        keyList.remove(ALIAS);
        keyList.remove(NAME);
        keyList.remove("descriptor");
        Collections.sort(keyList);
        for (String key : keyList) {
            if (!this.properties.containsKey(key) || this.getProperty(key).trim().length() <= 0) continue;
            builder.append("<b>");
            builder.append(key.toLowerCase());
            builder.append(":</b> ");
            builder.append(this.getProperty(key));
            builder.append("<br>");
        }
        builder.append("</body></html>");
        return builder.toString();
    }

    public String getSimpleName() {
        return "Service";
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder(this.getSimpleName());
        builder.append(" [");
        String[] keys = this.getPropertyKeys();
        for (i = 0; i < keys.length; ++i) {
            builder.append(keys[i]);
            builder.append("=\"");
            builder.append(this.getProperty(keys[i]));
            builder.append("\", ");
        }
        builder.append("arguments=[");
        for (i = 0; i < this.getArgumentCount(); ++i) {
            builder.append(this.getArgument(i));
            if (i + 1 >= this.getArgumentCount()) continue;
            builder.append(", ");
        }
        builder.append("]]");
        return builder.toString();
    }

    public boolean isAvailable() {
        return true;
    }

    public abstract ServiceHandler<? extends ServiceDescriptor> getServiceHandler();
}

