/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.config;

import chemaxon.marvin.services.DynamicArgument;
import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.services.ServiceDescriptor;
import chemaxon.marvin.services.ServiceDescriptorReader;
import chemaxon.marvin.services.config.UnavailableService;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLBasedServiceDescriptorReader
implements ServiceDescriptorReader {
    public static final String DEFAULT_CONFIGURATION_SCHEMA = "/chemaxon/marvin/services/config/resources/serviceconfiguration.xsd";

    @Override
    public List<ServiceDescriptor> readServiceDescriptors(InputStream input) {
        final ArrayList<ServiceDescriptor> descriptorList = new ArrayList<ServiceDescriptor>();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        URL schemaURL = this.getClass().getResource(DEFAULT_CONFIGURATION_SCHEMA);
        try {
            if (schemaURL != null) {
                Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaURL);
                try {
                    factory.setSchema(schema);
                }
                catch (UnsupportedOperationException e) {}
            } else {
                throw new SAXException("Could not find XSD Schema at location: /chemaxon/marvin/services/config/resources/serviceconfiguration.xsd");
            }
            SAXParser parser = factory.newSAXParser();
            parser.parse(input, new DefaultHandler(){
                private ServiceDescriptor descriptor = null;
                private Class<?> argumentClass = null;
                private String argumentValue = null;
                private Class<?> evaluatorClass = null;
                private String evaluatorValue = null;
                private String argumentName = null;
                private String argumentAlias = null;

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw new SAXException(e);
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw new SAXException(e);
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("Service".equals(qName)) {
                        Class descriptorClass = XMLBasedServiceDescriptorReader.classForName(attributes.getValue("descriptor"));
                        if (descriptorClass != null) {
                            try {
                                this.descriptor = (ServiceDescriptor)descriptorClass.newInstance();
                            }
                            catch (Exception e) {
                                this.descriptor = new UnavailableService();
                            }
                        } else {
                            this.descriptor = new UnavailableService();
                        }
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            this.descriptor.setProperty(attributes.getQName(i), attributes.getValue(i));
                        }
                    } else if ("Argument".equals(qName)) {
                        this.argumentClass = XMLBasedServiceDescriptorReader.classForName(attributes.getValue("class"));
                        this.argumentName = attributes.getValue("name");
                        this.argumentAlias = attributes.getValue("alias");
                        this.argumentValue = attributes.getValue("value");
                    } else if ("Evaluate".equals(qName)) {
                        this.evaluatorClass = XMLBasedServiceDescriptorReader.classForName(attributes.getValue("class"));
                        this.evaluatorValue = attributes.getValue("expression");
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if ("Service".equals(qName)) {
                        if (this.descriptor != null) {
                            descriptorList.add(this.descriptor);
                        }
                        this.descriptor = null;
                    } else if ("Argument".equals(qName)) {
                        if (this.descriptor != null && this.argumentClass != null) {
                            if (this.evaluatorClass != null) {
                                ServiceArgument argument = XMLBasedServiceDescriptorReader.createEvaluationArgument(this.argumentClass, this.evaluatorClass, this.evaluatorValue);
                                if (argument != null) {
                                    argument.setName(this.argumentName);
                                    argument.setAlias(this.argumentAlias);
                                    this.descriptor.addArgument(argument);
                                }
                            } else {
                                ServiceArgument argument = XMLBasedServiceDescriptorReader.createArgument(this.argumentClass, this.argumentValue);
                                argument.setName(this.argumentName);
                                argument.setAlias(this.argumentAlias);
                                this.descriptor.addArgument(argument);
                            }
                        }
                        this.argumentClass = null;
                        this.evaluatorClass = null;
                        this.evaluatorValue = null;
                        this.argumentName = null;
                        this.argumentAlias = null;
                    }
                }
            });
        }
        catch (Exception e) {
            descriptorList.clear();
            e.printStackTrace();
        }
        return descriptorList;
    }

    private static Class<?> classForName(String className) {
        Class<?> argumentClass = null;
        try {
            argumentClass = Class.forName(className, false, XMLBasedServiceDescriptorReader.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return argumentClass;
    }

    private static ServiceArgument<?> createEvaluationArgument(Class<?> argumentClass, Class<?> evaluatorClass, String expression) throws SAXException {
        try {
            Object arg = evaluatorClass.newInstance();
            if (arg instanceof DynamicArgument) {
                ((DynamicArgument)arg).setExpression(expression);
                ((DynamicArgument)arg).setType(argumentClass);
                return (ServiceArgument)arg;
            }
            throw new SAXException("Not a " + DynamicArgument.class.getName() + " instance: " + evaluatorClass.getName());
        }
        catch (Exception e) {
            throw new SAXException("Could not create dynamic argument.", e);
        }
    }

    private static ServiceArgument<?> createArgument(Class<?> argumentClass, String value) {
        ServiceArgument<Object> argument = null;
        if (Integer.class.equals(argumentClass)) {
            Integer i = null;
            if (!"".equals(value)) {
                try {
                    i = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            argument = ServiceArgument.createArgumentAs(i, Integer.class);
        } else if (Float.class.equals(argumentClass)) {
            Float f = null;
            if (!"".equals(value)) {
                try {
                    f = Float.valueOf(Float.parseFloat(value));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            argument = ServiceArgument.createArgumentAs(f, Float.class);
        } else if (Double.class.equals(argumentClass)) {
            Double d = null;
            if (!"".equals(value)) {
                try {
                    d = Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            argument = ServiceArgument.createArgumentAs(d, Double.class);
        } else if (Long.class.equals(argumentClass)) {
            Long l = null;
            if (!"".equals(value)) {
                try {
                    l = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            argument = ServiceArgument.createArgumentAs(l, Long.class);
        } else if (Boolean.class.equals(argumentClass)) {
            argument = ServiceArgument.createArgumentAs(Boolean.parseBoolean(value), Boolean.class);
        } else {
            String s = value == null ? null : value.toString();
            argument = ServiceArgument.createArgumentAs(s, String.class);
        }
        return argument;
    }
}

